/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.nazuna;

import java.util.Map;
import org.seasar.nazuna.Expression;
import org.seasar.nazuna.RuleContext;
import org.seasar.util.Assertion;
import org.seasar.util.EMap;
import org.seasar.util.SMap;
import org.seasar.util.SeasarException;

public abstract class AbstractExecuteExp
implements Expression {
    private final Expression _pathExp;
    private final EMap _parameterExps;

    public AbstractExecuteExp(Expression pathExp, EMap parameterExps) {
        Assertion.assertNotNull("pathExp", pathExp);
        Assertion.assertNotNull("parameterExps", parameterExps);
        this._pathExp = pathExp;
        this._parameterExps = parameterExps;
    }

    public Object evaluateValue(RuleContext ruleContext) throws SeasarException {
        SMap parameters = new SMap();
        for (int i = 0; i < this._parameterExps.size(); ++i) {
            Expression exp = (Expression)this._parameterExps.get(i);
            Object value = exp.evaluateValue(ruleContext);
            parameters.put(this._parameterExps.getKey(i), value);
        }
        String path = (String)this._pathExp.evaluateValue(ruleContext);
        return this.doExecute(path, parameters);
    }

    protected abstract Object doExecute(String var1, Map var2) throws SeasarException;
}

