/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.naming;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.Map;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import org.seasar.message.MessageFormatter;
import org.seasar.naming.NamingContext;
import org.seasar.naming.NamingParser;
import org.seasar.naming.NamingServerMBean;
import org.seasar.util.EMap;

public final class NamingServer
implements NamingServerMBean,
Externalizable {
    static final long serialVersionUID = -489094459554022028L;
    private transient Map _nameMap = new EMap();
    private transient Name _prefix;
    private transient NamingContext _namingContext;

    public NamingServer() throws NamingException {
        this(null);
    }

    public NamingServer(Name prefix) throws NamingException {
        this._prefix = prefix == null ? NamingParser.getInstance().parse("") : prefix;
        this._namingContext = new NamingContext(null, this._prefix, this);
    }

    public NamingContext getNamingContext() {
        return this._namingContext;
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.checkName(name);
        if (name.size() > 1) {
            this.bindByChild(name, obj);
        } else {
            this.bindBySelf(name, obj);
        }
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.checkName(name);
        if (name.size() > 1) {
            this.rebindByChild(name, obj);
        } else {
            this.add(name, obj);
        }
    }

    public void unbind(Name name) throws NamingException {
        this.checkName(name);
        if (name.size() > 1) {
            this.unbindByChild(name);
        } else {
            this.unbindBySelf(name);
        }
    }

    public Object lookup(Name name) throws NamingException {
        if (name.isEmpty() || name.get(0).equals("")) {
            return this._namingContext;
        }
        if (name.size() > 1) {
            return this.lookupByChild(name);
        }
        return this.resolveIfChild(this.get(name));
    }

    public Map getNameMap(Name name) throws NamingException {
        if (name.isEmpty() || name.get(0).equals("")) {
            return this.getNameMapBySelf(name);
        }
        return this.getNameMapByChild(name);
    }

    public NamingContext createSubcontext(Name name) throws NamingException {
        this.checkName(name);
        if (name.size() > 1) {
            return this.createSubcontextByChild(name);
        }
        return this.createSubcontextBySelf(name);
    }

    public void destroySubcontext(Name name) throws NamingException {
        if (name.isEmpty() || name.get(0).equals("")) {
            this.destroy();
        } else if (name.size() > 1) {
            this.destroySubcontextByChild(name);
        } else {
            this.destroySubcontextBySelf(name);
        }
    }

    public void writeExternal(ObjectOutput s) throws IOException {
        s.writeObject(this._nameMap);
        s.writeObject(this._prefix);
        s.writeObject(this._namingContext);
    }

    public void readExternal(ObjectInput s) throws IOException, ClassNotFoundException {
        this._nameMap = (Map)s.readObject();
        this._prefix = (Name)s.readObject();
        this._namingContext = (NamingContext)s.readObject();
    }

    void destroy() {
        Iterator i = this._nameMap.values().iterator();
        while (i.hasNext()) {
            Object child = i.next();
            if (!(child instanceof NamingServer)) continue;
            ((NamingServer)child).destroy();
        }
        this._nameMap.clear();
    }

    private synchronized void add(Name name, Object obj) throws NamingException {
        this._nameMap.put(name.get(0), obj);
    }

    private Object get(Name name) throws NamingException {
        Object obj = this._nameMap.get(name.get(0));
        if (obj == null) {
            throw new NameNotFoundException(this._namingContext.getAbsoluteName(name).toString());
        }
        return obj;
    }

    private boolean contains(Name name) {
        return this._nameMap.containsKey(name.get(0));
    }

    private synchronized void remove(Name name) throws NamingException {
        if (this._nameMap.remove(name.get(0)) == null) {
            throw new NameNotFoundException(MessageFormatter.getMessage("ESSR0001", new Object[]{this._namingContext.getAbsoluteName(name).toString()}));
        }
    }

    private Object resolveIfChild(Object obj) {
        if (obj instanceof NamingServer) {
            return ((NamingServer)obj).getNamingContext();
        }
        return obj;
    }

    private void bindByChild(Name name, Object obj) throws NamingException {
        Object child;
        if (!this.contains(name)) {
            this.createSubcontextBySelf(name.getPrefix(1));
        }
        if (!((child = this.get(name)) instanceof NamingServer)) {
            throw new NotContextException();
        }
        ((NamingServer)child).bind(name.getSuffix(1), obj);
    }

    private void bindBySelf(Name name, Object obj) throws NamingException {
        if (this.contains(name)) {
            throw new NameAlreadyBoundException(this._namingContext.getAbsoluteName(name).toString());
        }
        this.add(name, obj);
    }

    private void rebindByChild(Name name, Object obj) throws NamingException {
        Object child;
        if (!this.contains(name)) {
            this.createSubcontextBySelf(name.getPrefix(1));
        }
        if (!((child = this.get(name)) instanceof NamingServer)) {
            throw new NotContextException();
        }
        ((NamingServer)child).rebind(name.getSuffix(1), obj);
    }

    private void unbindByChild(Name name) throws NamingException {
        Object child = this.get(name);
        if (!(child instanceof NamingServer)) {
            throw new NotContextException();
        }
        ((NamingServer)child).unbind(name.getSuffix(1));
    }

    private void unbindBySelf(Name name) throws NamingException {
        Object child = this.get(name);
        if (child instanceof NamingServer) {
            throw new NamingException(MessageFormatter.getMessage("ESSR0334", new Object[]{this._namingContext.getAbsoluteName(name).toString()}));
        }
        this.remove(name);
    }

    private Object lookupByChild(Name name) throws NamingException {
        Object child = this.get(name);
        if (child instanceof NamingServer) {
            return ((NamingServer)child).lookup(name.getSuffix(1));
        }
        throw new NotContextException();
    }

    private Map getNameMapByChild(Name name) throws NamingException {
        Object child = this.get(name);
        if (child instanceof NamingServer) {
            return ((NamingServer)child).getNameMap(name.getSuffix(1));
        }
        throw new NotContextException();
    }

    private Map getNameMapBySelf(Name name) throws NamingException {
        EMap nm = new EMap();
        Iterator i = this._nameMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            Object obj = this.resolveIfChild(e.getValue());
            nm.put(e.getKey(), obj);
        }
        return nm;
    }

    private NamingContext createSubcontextByChild(Name name) throws NamingException {
        Object child;
        if (!this.contains(name)) {
            this.createSubcontextBySelf(name.getPrefix(1));
        }
        if ((child = this.get(name)) instanceof NamingServer) {
            return ((NamingServer)child).createSubcontext(name.getSuffix(1));
        }
        throw new NotContextException();
    }

    private NamingContext createSubcontextBySelf(Name name) throws NamingException {
        Name childName = (Name)this._prefix.clone();
        childName.addAll(name);
        NamingServer child = new NamingServer(childName);
        this.add(name, child);
        return child.getNamingContext();
    }

    private void destroySubcontextByChild(Name name) throws NamingException {
        Object child = this.get(name);
        if (!(child instanceof NamingServer)) {
            throw new NotContextException();
        }
        ((NamingServer)child).destroySubcontext(name.getSuffix(1));
    }

    private void destroySubcontextBySelf(Name name) throws NamingException {
        Object child = this.get(name);
        if (!(child instanceof NamingServer)) {
            throw new NotContextException();
        }
        ((NamingServer)child).destroy();
        this.remove(name);
    }

    private void checkName(Name name) throws NamingException {
        if (name.isEmpty() || name.get(0).equals("")) {
            throw new InvalidNameException(this._namingContext.getAbsoluteName(name).toString());
        }
    }
}

