/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.naming;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.spi.ObjectFactory;
import org.seasar.naming.NamingEnumerationImpl;
import org.seasar.naming.NamingParser;
import org.seasar.naming.NamingServer;
import org.seasar.naming.NamingServerMBean;
import org.seasar.naming.NamingServerManager;
import org.seasar.naming.NamingUtil;
import org.seasar.util.Reflector;

public final class NamingContext
implements Context,
Externalizable {
    static final long serialVersionUID = -4711790340772057976L;
    private transient Hashtable _env;
    private transient Name _prefix;
    private transient NamingServerMBean _naming;

    public NamingContext() {
    }

    public NamingContext(Hashtable env, Name prefix) throws NamingException {
        this(env, prefix, null);
    }

    public NamingContext(Hashtable env, Name prefix, NamingServer naming) throws NamingException {
        this._env = env != null ? (Hashtable)env.clone() : new Hashtable();
        this._prefix = prefix != null ? prefix : NamingParser.getInstance().parse("");
        this._naming = naming != null ? naming : NamingServerManager.getNamingServer(env);
    }

    public static ObjectFactory getObjectFactoryFromReference(Reference ref) throws NamingException {
        try {
            String factoryName = ref.getFactoryClassName();
            if (factoryName != null) {
                try {
                    return (ObjectFactory)Thread.currentThread().getContextClassLoader().loadClass(factoryName).newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        catch (Exception e) {
            NamingContext.handleException(e);
        }
        return null;
    }

    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(this.getNameParser(name).parse(name), obj);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this._naming.rebind(this.getAbsoluteName(name), obj);
    }

    public void bind(String name, Object obj) throws NamingException {
        this.bind(this.getNameParser(name).parse(name), obj);
    }

    public void bind(Name name, Object obj) throws NamingException {
        this._naming.bind(this.getAbsoluteName(name), obj);
    }

    public Object lookup(String name) throws NamingException {
        return this.lookup(this.getNameParser(name).parse(name));
    }

    public Object lookup(Name name) throws NamingException {
        if (name.isEmpty()) {
            return this;
        }
        return this.resolveObject(name, this._naming.lookup(this.getAbsoluteName(name)));
    }

    public void unbind(String name) throws NamingException {
        this.unbind(this.getNameParser(name).parse(name));
    }

    public void unbind(Name name) throws NamingException {
        this._naming.unbind(this.getAbsoluteName(name));
    }

    public void rename(String oldname, String newname) throws NamingException {
        this.rename(this.getNameParser(oldname).parse(oldname), this.getNameParser(newname).parse(newname));
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        this.bind(newName, this.lookup(oldName));
        this.unbind(oldName);
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(this.getNameParser(name).parse(name));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        Map nm = this._naming.getNameMap(this.getAbsoluteName(name));
        ArrayList<NameClassPair> list = new ArrayList<NameClassPair>(nm.size());
        Iterator i = nm.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            list.add(this.getNameClassPair((String)e.getKey(), e.getValue()));
        }
        return new NamingEnumerationImpl(list);
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(this.getNameParser(name).parse(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        Map nm = this._naming.getNameMap(this.getAbsoluteName(name));
        ArrayList<Binding> list = new ArrayList<Binding>(nm.size());
        Iterator i = nm.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            list.add(this.getBinding((String)e.getKey(), e.getValue()));
        }
        return new NamingEnumerationImpl(list);
    }

    public String composeName(String name, String prefix) throws NamingException {
        return this.composeName(NamingParser.getInstance().parse(name), NamingParser.getInstance().parse(prefix)).toString();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return NamingParser.getInstance();
    }

    public NameParser getNameParser(String name) throws NamingException {
        return NamingParser.getInstance();
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(this.getNameParser(name).parse(name));
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.resolveNamingContext(this._naming.createSubcontext(this.getAbsoluteName(name)));
    }

    public Object addToEnvironment(String key, Object value) throws NamingException {
        return this._env.put(key, value);
    }

    public Object removeFromEnvironment(String key) throws NamingException {
        return this._env.remove(key);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this._env;
    }

    public void close() throws NamingException {
        this._env = null;
        this._prefix = null;
        this._naming = null;
    }

    public String getNameInNamespace() throws NamingException {
        return this._prefix.toString();
    }

    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(this.getNameParser(name).parse(name));
    }

    public void destroySubcontext(Name name) throws NamingException {
        this._naming.destroySubcontext(this.getAbsoluteName(name));
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookupLink(this.getNameParser(name).parse(name));
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    public void writeExternal(ObjectOutput s) throws IOException {
        s.writeObject(this._env);
        s.writeObject(this._prefix);
        s.writeObject(this._naming);
    }

    public void readExternal(ObjectInput s) throws IOException, ClassNotFoundException {
        this._env = (Hashtable)s.readObject();
        this._prefix = (Name)s.readObject();
        this._naming = (NamingServerMBean)s.readObject();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof NamingContext)) {
            return false;
        }
        NamingContext other = (NamingContext)o;
        return this._prefix.equals(other._prefix);
    }

    public String toString() {
        return this._prefix.toString();
    }

    Name getAbsoluteName(Name n) throws NamingException {
        if (n.isEmpty()) {
            throw new InvalidNameException();
        }
        if (n.get(0).toString().equals("")) {
            return n.getSuffix(1);
        }
        return this.composeName(n, this._prefix);
    }

    private static void handleException(Exception e) throws NamingException {
        throw NamingUtil.convertNamingException(e);
    }

    private NameClassPair getNameClassPair(String name, Object obj) throws NamingException {
        return new NameClassPair(name, this.getClassName(obj), true);
    }

    private Binding getBinding(String name, Object obj) throws NamingException {
        return new Binding(name, this.getClassName(obj), this.resolveObject(this.getNameParser(name).parse(name), obj), true);
    }

    private String getClassName(Object obj) throws NamingException {
        String className = obj.getClass().getName();
        Reference ref = null;
        if (obj instanceof Referenceable) {
            ref = ((Referenceable)obj).getReference();
        } else if (obj instanceof Reference) {
            ref = (Reference)obj;
        }
        if (ref != null) {
            className = ref.getClassName();
        }
        return className;
    }

    private Object resolveObject(Name name, Object obj) throws NamingException {
        if (obj instanceof NamingContext) {
            return this.resolveNamingContext((NamingContext)obj);
        }
        if (obj instanceof LinkRef) {
            return this.resolveLinkRef((LinkRef)obj);
        }
        if (obj instanceof Reference || obj instanceof Referenceable) {
            return this.getObjectInstance(name, obj);
        }
        return obj;
    }

    private NamingContext resolveNamingContext(NamingContext ctx) throws NamingException {
        Iterator i = this._env.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            ctx.addToEnvironment((String)e.getKey(), e.getValue());
        }
        ctx._naming = this._naming;
        return ctx;
    }

    private Object resolveLinkRef(LinkRef linkRef) throws NamingException {
        String linkName = linkRef.getLinkName();
        if (linkName.startsWith("./")) {
            return this.lookup(linkName.substring(2));
        }
        return this.lookup(linkName);
    }

    private Object getObjectInstance(Name name, Object obj) throws NamingException {
        Reference ref = null;
        if (obj instanceof Reference) {
            ref = (Reference)obj;
        } else if (obj instanceof Referenceable) {
            ref = ((Referenceable)obj).getReference();
        }
        if (ref != null) {
            String className;
            ObjectFactory factory = NamingContext.getObjectFactoryFromReference(ref);
            if (factory != null) {
                try {
                    return factory.getObjectInstance(ref, this.getAbsoluteName(name), this, this._env);
                }
                catch (Exception e) {
                    NamingContext.handleException(e);
                }
            }
            if ((className = ref.getClassName()) != null) {
                return Reflector.newInstance(className);
            }
        }
        return obj;
    }
}

