/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.message;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class MessageFormatter {
    private static final String SEASAR_MESSAGES = "org.seasar.message.SSRMessages";
    private static String _configFile = "message-config";
    private static Map _messagesMap = new HashMap();

    private MessageFormatter() {
    }

    public static void setConfigFile(String configFile) {
        _configFile = configFile;
    }

    public static ResourceBundle getConfig() {
        return ResourceBundle.getBundle(_configFile);
    }

    public static String getSubSystem(String messageCode) {
        return messageCode.substring(1, Math.min(4, messageCode.length()));
    }

    public static ResourceBundle getMessages(String subSystem) {
        return (ResourceBundle)_messagesMap.get(subSystem);
    }

    public static String getPattern(String messageCode) {
        try {
            ResourceBundle resourceBundle = MessageFormatter.getMessages(MessageFormatter.getSubSystem(messageCode));
            if (resourceBundle != null) {
                return resourceBundle.getString(messageCode);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String getNoPatternMessage(Object[] arguments) {
        if (arguments == null || arguments.length == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < arguments.length; ++i) {
            buffer.append(arguments[i] + ", ");
        }
        buffer.setLength(buffer.length() - 2);
        return buffer.toString();
    }

    public static String getSimpleMessage(String messageCode, Object[] arguments) {
        String pattern = MessageFormatter.getPattern(messageCode);
        if (pattern != null) {
            return MessageFormat.format(pattern, arguments);
        }
        return MessageFormatter.getNoPatternMessage(arguments);
    }

    public static String getMessage(String messageCode, Object[] arguments) {
        return "[" + messageCode + "]" + MessageFormatter.getSimpleMessage(messageCode, arguments);
    }

    public static void setup() {
        ResourceBundle config = MessageFormatter.getConfig();
        Enumeration<String> e = config.getKeys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            String resourceName = config.getString(key);
            _messagesMap.put(key, ResourceBundle.getBundle(resourceName));
        }
    }

    public static void clear() {
        _messagesMap.clear();
    }

    static {
        try {
            MessageFormatter.setup();
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (_messagesMap.size() == 0) {
            _messagesMap.put("SSR", ResourceBundle.getBundle(SEASAR_MESSAGES));
        }
    }
}

