/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mbean;

import java.util.ArrayList;
import java.util.List;
import org.seasar.log.Logger;
import org.seasar.mbean.MBeanFacade;
import org.seasar.mbean.NotificationListenerFacade;
import org.seasar.mbean.RemoteNotificationListenerFacade;
import org.seasar.system.Lifecycle;
import org.seasar.util.ElementHandler;
import org.seasar.util.ResourceUtil;
import org.seasar.util.SeasarException;
import org.seasar.util.XMLHandler;
import org.seasar.util.XMLHandlerParser;
import org.seasar.util.XMLHandlerRule;
import org.xml.sax.Attributes;

public final class MBeanService
implements Lifecycle {
    private static final String XML_FILE_NAME = "/mbean-config.xml";
    private static final Logger _logger = Logger.getLogger(class$org$seasar$mbean$MBeanService == null ? (class$org$seasar$mbean$MBeanService = MBeanService.class$("org.seasar.mbean.MBeanService")) : class$org$seasar$mbean$MBeanService);
    private static XMLHandlerRule _xmlHandlerRule = new XMLHandlerRule();
    private static List _facades = new ArrayList();
    static /* synthetic */ Class class$org$seasar$mbean$MBeanService;

    public static Object getContainer(int index) {
        return _facades.get(index);
    }

    public void start() throws SeasarException {
        for (int i = 0; i < _facades.size(); ++i) {
            try {
                ((Lifecycle)_facades.get(i)).start();
                continue;
            }
            catch (Throwable t) {
                _logger.log(t);
            }
        }
    }

    public void stop() throws SeasarException {
        for (int i = _facades.size() - 1; i >= 0; --i) {
            try {
                ((Lifecycle)_facades.get(i)).stop();
                continue;
            }
            catch (Throwable t) {
                _logger.log(t);
            }
        }
    }

    private static void configure() {
        if (ResourceUtil.isExist(XML_FILE_NAME)) {
            MBeanService.setupXMLHandlerRule();
            XMLHandlerParser.parse(XML_FILE_NAME, _xmlHandlerRule);
        }
    }

    private static void setupXMLHandlerRule() {
        _xmlHandlerRule.addElementHandler("/mbeanService/mbeans/mbean", new ElementHandler(){

            public void start(XMLHandler xmlHandler, Attributes attributes) {
                try {
                    String className = attributes.getValue("className");
                    String name = attributes.getValue("name");
                    MBeanFacade facade = new MBeanFacade(className, name);
                    _facades.add(facade);
                    xmlHandler.push(facade);
                }
                catch (Throwable t) {
                    _logger.log(t);
                    xmlHandler.push(t);
                }
            }

            public void end(XMLHandler xmlHandler, String body) {
                xmlHandler.pop();
            }
        });
        _xmlHandlerRule.addElementHandler("/mbeanService/mbeans/mbean/properties/property", new ElementHandler(){

            public void start(XMLHandler xmlHandler, Attributes attributes) {
                Object o = xmlHandler.peek();
                if (o instanceof MBeanFacade) {
                    MBeanFacade facade = (MBeanFacade)o;
                    String name = attributes.getValue("name");
                    String value = attributes.getValue("value");
                    facade.setProperty(name, value);
                }
            }
        });
        _xmlHandlerRule.addElementHandler("/mbeanService/notificationListeners/notificationListener", new ElementHandler(){

            public void start(XMLHandler xmlHandler, Attributes attributes) {
                try {
                    String className = attributes.getValue("className");
                    String targetName = attributes.getValue("targetName");
                    NotificationListenerFacade facade = new NotificationListenerFacade(className, targetName);
                    _facades.add(facade);
                    xmlHandler.push(facade);
                }
                catch (Throwable t) {
                    _logger.log(t);
                    xmlHandler.push(t);
                }
            }

            public void end(XMLHandler xmlHandler, String body) {
                xmlHandler.pop();
            }
        });
        _xmlHandlerRule.addElementHandler("/mbeanService/notificationListeners/notificationListener/properties/property", new ElementHandler(){

            public void start(XMLHandler xmlHandler, Attributes attributes) {
                Object o = xmlHandler.peek();
                if (o instanceof NotificationListenerFacade) {
                    NotificationListenerFacade facade = (NotificationListenerFacade)o;
                    String name = attributes.getValue("name");
                    String value = attributes.getValue("value");
                    facade.setProperty(name, value);
                }
            }
        });
        _xmlHandlerRule.addElementHandler("/mbeanService/remoteNotificationListeners/remoteNotificationListener", new ElementHandler(){

            public void start(XMLHandler xmlHandler, Attributes attributes) {
                try {
                    String className = attributes.getValue("className");
                    String targetName = attributes.getValue("targetName");
                    String seasarContextName = attributes.getValue("seasarContextName");
                    RemoteNotificationListenerFacade facade = new RemoteNotificationListenerFacade(className, targetName, seasarContextName);
                    _facades.add(facade);
                    xmlHandler.push(facade);
                }
                catch (Throwable t) {
                    _logger.log(t);
                    xmlHandler.push(t);
                }
            }

            public void end(XMLHandler xmlHandler, String body) {
                xmlHandler.pop();
            }
        });
        _xmlHandlerRule.addElementHandler("/mbeanService/remoteNotificationListeners/remoteNotificationListener/properties/property", new ElementHandler(){

            public void start(XMLHandler xmlHandler, Attributes attributes) {
                Object o = xmlHandler.peek();
                if (o instanceof RemoteNotificationListenerFacade) {
                    RemoteNotificationListenerFacade facade = (RemoteNotificationListenerFacade)o;
                    String name = attributes.getValue("name");
                    String value = attributes.getValue("value");
                    facade.setProperty(name, value);
                }
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        MBeanService.configure();
    }
}

