/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.mbean;

import java.util.Properties;
import org.seasar.log.Logger;
import org.seasar.naming.NamingContext;
import org.seasar.naming.NamingService;
import org.seasar.system.JMXService;
import org.seasar.system.JMXUtil;
import org.seasar.system.Lifecycle;
import org.seasar.system.MBeanProxy;
import org.seasar.util.Reflector;
import org.seasar.util.SeasarRuntimeException;
import org.seasar.util.StringUtil;

public final class MBeanFacade
implements Lifecycle {
    private static final Logger _logger = Logger.getLogger(class$org$seasar$mbean$MBeanFacade == null ? (class$org$seasar$mbean$MBeanFacade = MBeanFacade.class$("org.seasar.mbean.MBeanFacade")) : class$org$seasar$mbean$MBeanFacade);
    private String _className;
    private String _name;
    private Properties _properties = new Properties();
    private Object _mbean;
    private Object _mbeanProxy;
    static /* synthetic */ Class class$org$seasar$mbean$MBeanFacade;

    public MBeanFacade(String className, String name) {
        if (className == null) {
            throw new SeasarRuntimeException("ESSR0007", new Object[]{"className"});
        }
        this._className = className;
        this._name = name != null ? name : StringUtil.getLastToken(className, '.');
    }

    public void setProperty(String name, String value) {
        this._properties.setProperty(name, value);
    }

    public Object getMBean() {
        return this._mbean;
    }

    public Object getMBeanProxy() {
        return this._mbeanProxy;
    }

    public void start() {
        try {
            this._mbean = Reflector.newInstance(this._className);
            Reflector.setProperties(this._mbean, this._properties);
            if (this._mbean instanceof Lifecycle) {
                ((Lifecycle)this._mbean).start();
            }
            JMXService.registerMBean(this._mbean, JMXUtil.getMBeanName(this._name));
            this._mbeanProxy = MBeanProxy.create(JMXUtil.getMBeanInterface(this._mbean.getClass()), JMXUtil.getMBeanName(this._name));
            NamingContext ctx = NamingService.getNamingServer().getNamingContext();
            ctx.bind(JMXUtil.getJNDIName(this._name), this._mbeanProxy);
        }
        catch (Throwable t) {
            _logger.log(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            NamingContext ctx = NamingService.getNamingServer().getNamingContext();
            ctx.unbind(JMXUtil.getJNDIName(this._name));
            JMXService.unregisterMBean(JMXUtil.getMBeanName(this._name));
            if (this._mbean instanceof Lifecycle) {
                ((Lifecycle)this._mbean).stop();
            }
        }
        catch (Throwable t) {
            _logger.log(t);
        }
        finally {
            this._mbeanProxy = null;
            this._mbean = null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

