/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.log;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;
import org.seasar.message.MessageFormatter;

public final class Logger {
    private static Map _loggerMap = new HashMap();
    private Category _category;

    private Logger(Class clazz) {
        this._category = Category.getInstance((Class)clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Logger getLogger(Class clazz) {
        Logger logger = (Logger)_loggerMap.get(clazz);
        if (logger == null) {
            Map map = _loggerMap;
            synchronized (map) {
                if (logger == null) {
                    logger = new Logger(clazz);
                    _loggerMap.put(clazz, logger);
                }
            }
        }
        return logger;
    }

    public final boolean isDebugEnabled() {
        return this._category.isDebugEnabled();
    }

    public final void debug(Object message, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this._category.debug(message, throwable);
        }
    }

    public final void debug(Object message) {
        if (this.isDebugEnabled()) {
            this._category.debug(message);
        }
    }

    public final boolean isInfoEnabled() {
        return this._category.isInfoEnabled();
    }

    public final void info(Object message, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this._category.info(message, throwable);
        }
    }

    public final void info(Object message) {
        if (this.isInfoEnabled()) {
            this._category.info(message);
        }
    }

    public final void warn(Object message, Throwable throwable) {
        this._category.warn(message, throwable);
    }

    public final void warn(Object message) {
        this._category.warn(message);
    }

    public final void error(Object message, Throwable throwable) {
        this._category.error(message, throwable);
    }

    public final void error(Object message) {
        this._category.error(message);
    }

    public final void error(Throwable throwable) {
        this._category.error((Object)throwable.getMessage(), throwable);
    }

    public final void fatal(Object message, Throwable throwable) {
        this._category.fatal(message, throwable);
    }

    public final void fatal(Object message) {
        this._category.fatal(message);
    }

    public final void log(Priority priority, Object message) {
        this._category.log(priority, message);
    }

    public final void log(Priority priority, Object message, Throwable throwable) {
        this._category.log(priority, message, throwable);
    }

    public final void log(Throwable throwable) {
        this.error(throwable.getMessage(), throwable);
    }

    public final void log(String messageCode, Object[] arguments) {
        this.log(messageCode, arguments, null);
    }

    public final void log(String messageCode, Object[] arguments, Throwable throwable) {
        Priority priority = Logger.getPriority(messageCode.charAt(0));
        if (this._category.isEnabledFor(priority)) {
            String message = MessageFormatter.getMessage(messageCode, arguments);
            this.log(priority, message, throwable);
        }
    }

    private static Priority getPriority(char messageType) {
        switch (messageType) {
            case 'D': {
                return Priority.DEBUG;
            }
            case 'I': {
                return Priority.INFO;
            }
            case 'W': {
                return Priority.WARN;
            }
            case 'E': {
                return Priority.ERROR;
            }
            case 'F': {
                return Priority.FATAL;
            }
        }
        throw new IllegalArgumentException(MessageFormatter.getMessage("ESSR0022", new Object[]{String.valueOf(messageType)}));
    }
}

