/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jetty;

import org.seasar.jetty.Jetty;
import org.seasar.log.Logger;
import org.seasar.system.Lifecycle;
import org.seasar.util.ResourceUtil;
import org.seasar.util.SeasarException;
import org.seasar.util.ThrowableUtil;

public final class JettyService
implements Lifecycle {
    private String _configPath = "jetty.xml";
    private Jetty _jetty;

    public final String getConfigPath() {
        return this._configPath;
    }

    public final void setConfigPath(String configPath) {
        this._configPath = configPath;
    }

    public final void start() throws SeasarException {
        try {
            this._jetty = new Jetty(ResourceUtil.getResource(this._configPath));
            this._jetty.start();
        }
        catch (Exception ex) {
            this._jetty = null;
            Throwable t = ThrowableUtil.getCause(ex);
            throw SeasarException.convertSeasarException(t);
        }
    }

    public final void stop() {
        if (this._jetty == null) {
            return;
        }
        try {
            this._jetty.stop();
        }
        catch (InterruptedException e) {
            Logger.getLogger(this.getClass()).log(e);
        }
        this._jetty = null;
    }

    public final boolean isStarted() {
        return this._jetty != null;
    }

    public final boolean isStopped() {
        return this._jetty == null;
    }
}

