/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.hsqldb;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.seasar.hsqldb.HsqldbStarter;
import org.seasar.log.Logger;
import org.seasar.system.Lifecycle;
import org.seasar.timer.TimeoutManager;
import org.seasar.timer.TimeoutTarget;
import org.seasar.timer.TimeoutTask;
import org.seasar.util.SeasarException;
import org.seasar.util.ThreadUtil;

public final class HsqldbService
implements Lifecycle,
TimeoutTarget {
    private String _database = "test";
    private int _port = 9001;
    private boolean _trace = false;
    private boolean _silent = true;
    private boolean _compact = false;
    private int _retryCount = 10;
    private int _checkpointInterval = 0;
    private TimeoutTask _timeoutTask;
    static /* synthetic */ Class class$org$seasar$hsqldb$HsqldbService;

    public final String getDatabase() {
        return this._database;
    }

    public final void setDatabase(String database) {
        this._database = database;
    }

    public final int getPort() {
        return this._port;
    }

    public final void setPort(int port) {
        this._port = port;
    }

    public final boolean isTrace() {
        return this._trace;
    }

    public final void setTrace(boolean trace) {
        this._trace = trace;
    }

    public final boolean isSilent() {
        return this._silent;
    }

    public final void setSilent(boolean silent) {
        this._silent = silent;
    }

    public final boolean isCompact() {
        return this._compact;
    }

    public final void setCompact(boolean compact) {
        this._compact = compact;
    }

    public final int getRetryCount() {
        return this._retryCount;
    }

    public final void setRetryCount(int retryCount) {
        this._retryCount = retryCount;
    }

    public final int getCheckpointInterval() {
        return this._checkpointInterval;
    }

    public final void setCheckpointInterval(int checkpointInterval) {
        this._checkpointInterval = checkpointInterval;
    }

    public final String[] createArgs() {
        String[] args = new String[]{"-database", System.getProperty("seasar.home") + File.separator + "data" + File.separator + this._database, "-port", String.valueOf(this._port), "-trace", String.valueOf(this._trace), "-silent", String.valueOf(this._silent), "-no_system_exit", String.valueOf(true)};
        return args;
    }

    public void start() throws SeasarException {
        new HsqldbStarter(this.createArgs()).start();
        for (int i = 0; i < this._retryCount; ++i) {
            ThreadUtil.sleep(500L);
            try {
                this.execute("COMMIT");
                break;
            }
            catch (SQLException sQLException) {
                continue;
            }
        }
        if (this._checkpointInterval > 0) {
            this._timeoutTask = TimeoutManager.getInstance().addTimeoutTarget(this, this._checkpointInterval, true);
        }
    }

    public void stop() {
        try {
            Connection connection = this.getConnection();
            if (this._compact) {
                this.execute(connection, "SHUTDOWN COMPACT");
            } else {
                this.execute(connection, "SHUTDOWN");
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(this.getClass()).log(ex);
        }
        this.stopCheckpoint();
    }

    public void expired() {
        try {
            this.execute("CHECKPOINT");
            Logger.getLogger(this.getClass()).debug("HSQLDB CHECKPOINT");
        }
        catch (SQLException e) {
            Logger.getLogger(this.getClass()).log(e);
            this.stopCheckpoint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(String sql) throws SQLException {
        Connection connection = this.getConnection();
        try {
            this.execute(connection, sql);
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(Connection connection, String sql) throws SQLException {
        Statement statement = connection.createStatement();
        try {
            statement.execute(sql);
        }
        finally {
            statement.close();
        }
    }

    private Connection getConnection() throws SQLException {
        String url = "jdbc:hsqldb:hsql://localhost:" + this._port;
        return DriverManager.getConnection(url, "sa", "");
    }

    private void stopCheckpoint() {
        if (this._timeoutTask != null) {
            this._timeoutTask.stop();
            this._timeoutTask = null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            Class.forName("org.hsqldb.jdbcDriver");
        }
        catch (Throwable t) {
            Logger.getLogger(class$org$seasar$hsqldb$HsqldbService == null ? (class$org$seasar$hsqldb$HsqldbService = HsqldbService.class$("org.seasar.hsqldb.HsqldbService")) : class$org$seasar$hsqldb$HsqldbService).log(t);
        }
    }
}

