/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.gpss.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jp.wda.gpss.AttributeException;
import jp.wda.gpss.Progress;
import jp.wda.gpss.SocketProcessor;
import jp.wda.gpss.Socklet;
import jp.wda.gpss.system.AttributeContainer;
import jp.wda.gpss.util.Finder;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class SimpleXMLCreator
implements AttributeContainer {
    private Hashtable attr;
    private LinkedList children;
    private String text;
    private Socklet socklet;
    private String name = null;

    public SimpleXMLCreator(String name) {
        this(name, null);
    }

    public SimpleXMLCreator(String name, Socklet socklet) {
        this.setName(name);
        this.setText("");
        this.socklet = socklet;
        this.attr = new Hashtable();
        this.children = new LinkedList();
    }

    public Socklet getSocklet() {
        return this.socklet;
    }

    public void setSocklet(Socklet s) {
        this.socklet = s;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
    }

    public final void setAttribute(Object key, Object value) {
        this.attr.put(key, value);
    }

    public final Object getAttribute(Object key) {
        return this.attr.get(key);
    }

    public Set getAttributes() {
        return this.attr.entrySet();
    }

    public boolean containsAttributeKey(Object key) {
        return this.attr.containsKey(key);
    }

    public Set getAttributeKeys() {
        return this.attr.keySet();
    }

    public Object removeAttribute(Object key) {
        return this.attr.remove(key);
    }

    public final void setAttribute(Object key, int value) {
        this.attr.put(key, new Integer(value));
    }

    public final int getAttributeInt(Object key) throws AttributeException {
        Object ret = this.attr.get(key);
        if (ret instanceof Integer) {
            return (Integer)ret;
        }
        throw new AttributeException("\u6307\u5b9a\u3055\u308c\u305f\u5c5e\u6027(" + key + ")\u306fint\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
    }

    public final void setAttribute(Object key, long value) {
        this.attr.put(key, new Long(value));
    }

    public final long getAttributeLong(Object key) throws AttributeException {
        Object ret = this.attr.get(key);
        if (ret instanceof Long) {
            return (Long)ret;
        }
        throw new AttributeException("\u6307\u5b9a\u3055\u308c\u305f\u5c5e\u6027(" + key + ")\u306flong\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
    }

    public final void setAttribute(Object key, double value) {
        this.attr.put(key, new Double(value));
    }

    public final double getAttributeDouble(Object key) throws AttributeException {
        Object ret = this.attr.get(key);
        if (ret instanceof Double) {
            return (Double)ret;
        }
        throw new AttributeException("\u6307\u5b9a\u3055\u308c\u305f\u5c5e\u6027(" + key + ")\u306fdouble\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
    }

    public final void setAttribute(Object key, boolean value) {
        this.attr.put(key, new Boolean(value));
    }

    public final boolean getAttributeBoolean(Object key) throws AttributeException {
        Object ret = this.attr.get(key);
        if (ret instanceof Boolean) {
            return (Boolean)ret;
        }
        throw new AttributeException("\u6307\u5b9a\u3055\u308c\u305f\u5c5e\u6027(" + key + ")\u306fboolean\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
    }

    public SimpleXMLCreator addChild(String name) {
        SimpleXMLCreator child = new SimpleXMLCreator(name, this.socklet);
        this.children.add(child);
        return child;
    }

    public void addChild(SimpleXMLCreator child) {
        this.children.add(child);
    }

    public void removeChild(SimpleXMLCreator child) {
        this.children.remove(child);
    }

    public void removeChild(String name) {
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            SimpleXMLCreator child = (SimpleXMLCreator)it.next();
            if (!child.getName().equals(name)) continue;
            it.remove();
            return;
        }
    }

    public void removeChildren(String name) {
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            SimpleXMLCreator child = (SimpleXMLCreator)it.next();
            if (!child.getName().equals(name)) continue;
            it.remove();
        }
    }

    public void removeChildren() {
        this.children = new LinkedList();
    }

    public List getChildren() {
        return new LinkedList(this.children);
    }

    public List getChildren(String name) {
        LinkedList<SimpleXMLCreator> list = new LinkedList<SimpleXMLCreator>();
        for (SimpleXMLCreator child : this.children) {
            if (!child.getName().equals(name)) continue;
            list.add(child);
        }
        return list;
    }

    public int sizeOfChildren() {
        return this.children.size();
    }

    public SimpleXMLCreator getChild(int idx) {
        if (idx >= this.children.size()) {
            return null;
        }
        return (SimpleXMLCreator)this.children.get(idx);
    }

    public SimpleXMLCreator getChild(String name) {
        for (SimpleXMLCreator child : this.children) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    public void setText(String textNode) {
        this.text = textNode;
    }

    public String getText() {
        return this.text;
    }

    public void send() {
        if (this.socklet == null) {
            return;
        }
        this.socklet.sendToAllClients(this.toString());
    }

    public void send(Finder finder) {
        if (this.socklet == null) {
            return;
        }
        this.socklet.sendToClients(this.toString(), finder);
    }

    public void send(String condition) {
        if (this.socklet == null) {
            return;
        }
        this.socklet.sendToClients(this.toString(), condition);
    }

    public void send(SocketProcessor client) {
        if (client == null) {
            return;
        }
        client.send(this.toString());
    }

    public String toString() {
        StringBuffer ret = new StringBuffer("<");
        ret.append(this.name);
        Set attributes = this.getAttributes();
        for (Map.Entry entry : attributes) {
            Object value = entry.getValue();
            value = this.convertEntity(value);
            ret.append(' ');
            ret.append(entry.getKey());
            ret.append("=\"");
            ret.append(value);
            ret.append("\"");
        }
        if (this.children.size() == 0 && this.text == "") {
            ret.append(" />");
            return ret.toString();
        }
        ret.append('>');
        ret.append(this.convertEntity(this.text));
        int i = 0;
        while (i < this.children.size()) {
            ret.append(this.children.get(i));
            ++i;
        }
        ret.append("</");
        ret.append(this.name);
        ret.append('>');
        return ret.toString();
    }

    private Object convertEntity(Object text) {
        if (text == null || !(text instanceof String)) {
            return text;
        }
        String str = (String)text;
        StringBuffer buf = new StringBuffer(str.length() + 20);
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            switch (c) {
                case '<': {
                    buf.append("&lt;");
                    break;
                }
                case '>': {
                    buf.append("&gt;");
                    break;
                }
                case '\'': {
                    buf.append("&apos;");
                    break;
                }
                case '\"': {
                    buf.append("&quot;");
                    break;
                }
                case '&': {
                    buf.append("&amp;");
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static SimpleXMLCreator parse(String xml, Socklet socklet) {
        reader = new StringReader(xml);
        doc = null;
        try {
            try {
                doc = new SAXBuilder().build((Reader)reader);
            }
            catch (JDOMException e) {
                if (socklet != null) {
                    socklet.log("\u6307\u5b9a\u3055\u308c\u305fXML\u306f\u89e3\u6790\u3067\u304d\u307e\u305b\u3093\u3002\r\nXML:" + xml, Progress.ERROR, e);
                } else {
                    System.out.println("\u6307\u5b9a\u3055\u308c\u305fXML\u306f\u89e3\u6790\u3067\u304d\u307e\u305b\u3093\u3002\r\nXML:" + xml);
                    System.out.println(e.getMessage());
                }
lbl13:
                // 4 sources

                while (true) {
                    reader.close();
                    return null;
                }
            }
            catch (IOException e) {
                block14: {
                    if (socklet == null) break block14;
                    socklet.log("\u6307\u5b9a\u3055\u308c\u305fXML\u89e3\u6790\u4e2d\u306bIO\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\r\nXML:" + xml, Progress.ERROR, e);
                    ** GOTO lbl13
                }
                System.out.println("\u6307\u5b9a\u3055\u308c\u305fXML\u89e3\u6790\u4e2d\u306bIO\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\r\nXML:" + xml);
                System.out.println(e.getMessage());
                ** continue;
            }
        }
        finally {
            reader.close();
        }
        if (doc == null) {
            if (socklet != null) {
                socklet.log("XML\u306e\u89e3\u6790\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\r\nXML:" + xml, Progress.ERROR, null);
            } else {
                System.out.println("XML\u306e\u89e3\u6790\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002\r\nXML:" + xml);
            }
            return null;
        }
        root = doc.getRootElement();
        ret = new SimpleXMLCreator(root.getName(), socklet);
        SimpleXMLCreator.setXMLElements(ret, root);
        return ret;
    }

    public static SimpleXMLCreator parse(String xml) {
        return SimpleXMLCreator.parse(xml, null);
    }

    private static void setXMLElements(SimpleXMLCreator xml, Element element) {
        xml.setText(element.getTextTrim());
        List attrs = element.getAttributes();
        int i = 0;
        while (i < attrs.size()) {
            Attribute attr = (Attribute)attrs.get(i);
            xml.setAttribute((Object)attr.getName(), attr.getValue());
            ++i;
        }
        List children = element.getChildren();
        int i2 = 0;
        while (i2 < children.size()) {
            Element child = (Element)children.get(i2);
            SimpleXMLCreator childxml = xml.addChild(child.getName());
            SimpleXMLCreator.setXMLElements(childxml, child);
            ++i2;
        }
    }

    public static void main(String[] args) {
        SimpleXMLCreator node = new SimpleXMLCreator("node");
        node.setAttribute((Object)"attr", "<Test>=\"value\"");
        System.out.println(node);
    }
}

