/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.gpss.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import jp.wda.gpss.util.FinderBase;
import jp.wda.gpss.util.FinderConditionInterpreter;
import jp.wda.gpss.util.FinderCreatingException;
import jp.wda.gpss.util.FinderElement;

public abstract class Finder
extends FinderBase {
    protected LinkedList group = new LinkedList();
    protected FinderElement firstelement = null;

    public Finder() {
        this.and = true;
    }

    public boolean equals(Object elem) {
        boolean ret = true;
        for (FinderBase next : this.group) {
            ret = next.connect(ret, next.equals(elem));
        }
        return ret;
    }

    public void addGroup(boolean and, Finder finder) {
        finder.isAND(and);
        this.group.add(finder);
    }

    public void addFinder(boolean and, Finder finder) {
        FinderElement next = finder.firstelement;
        if (next == null) {
            return;
        }
        next.isAND(and);
        this.group.add(next);
    }

    public void addFinder(boolean and, FinderElement finder) {
        finder.isAND(and);
        this.group.add(finder);
    }

    public void addFinder(String connector, String condition) throws FinderCreatingException {
        FinderConditionInterpreter.interpret(this, connector, condition);
    }

    public List getList(List list) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Object elem : list) {
            if (!this.equals(elem)) continue;
            ret.add(this.getReturnValue(elem));
        }
        return ret;
    }

    public Object get(List list) {
        for (Object elem : list) {
            if (!this.equals(elem)) continue;
            return this.getReturnValue(elem);
        }
        return null;
    }

    protected Finder createNewFinder() {
        return null;
    }

    protected void setNextFinder(boolean con, boolean not, String column, String value) {
    }

    protected void setCondition(String condition) {
        Finder.setNextCondition(this, new Condition(condition));
    }

    private static Finder setNextCondition(Finder ret, Condition condition) {
        if (ret == null) {
            return null;
        }
        boolean con = true;
        boolean not = true;
        StringBuffer column = new StringBuffer();
        StringBuffer value = null;
        boolean findersw = false;
        while (condition.hasNext()) {
            char next = condition.next();
            if (next == '(') {
                ret.addGroup(con, Finder.setNextCondition(ret.createNewFinder(), condition));
                continue;
            }
            if ((next == '=' || next == '!') && condition.hasNext()) {
                if (condition.next() != '=') continue;
                not = next != '!';
                value = new StringBuffer();
                continue;
            }
            if (next == ' ' || next == '&' || next == '|' || next == ')') {
                if (value != null && value.length() > 0) {
                    ret.setNextFinder(con, not, column.toString(), value.toString());
                    column = new StringBuffer();
                    value = null;
                    con = true;
                    not = true;
                }
                if (next == ')') break;
                if (next == '&') {
                    con = true;
                }
                if (next != '|') continue;
                con = false;
                continue;
            }
            if (value != null) {
                value.append(next);
                continue;
            }
            column.append(next);
        }
        if (value != null && value.length() > 0) {
            ret.setNextFinder(con, not, column.toString(), value.toString());
            column = new StringBuffer();
            value = null;
            con = true;
        }
        return ret;
    }

    public abstract Object getReturnValue(Object var1);

    private static class Condition {
        String condition;
        int idx = 0;

        Condition(String cond) {
            this.condition = cond;
            this.idx = 0;
        }

        char next() {
            if (this.idx == this.condition.length()) {
                return '\u0000';
            }
            return this.condition.charAt(this.idx++);
        }

        boolean hasNext() {
            return this.idx < this.condition.length();
        }
    }
}

