/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.gpss.system;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.net.SocketException;
import java.util.Vector;
import jp.wda.gpss.system.Main;
import jp.wda.gpss.system.SocketProcessorBase;

final class SocketProcessorImpl
extends SocketProcessorBase
implements Runnable {
    private Socket socket;
    private BufferedReader in;
    private PrintWriter out;
    private boolean sendingstatus = true;
    private MessageSender sender;
    private boolean terminated = true;

    public SocketProcessorImpl(Main server, Socket socket, String encoding, int buffersize) throws IOException {
        super(server, encoding, buffersize, socket.getInetAddress().getHostAddress());
        this.socket = socket;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block63: {
            block62: {
                char[] c = new char[1];
                try {
                    StringBuffer sb;
                    this.in = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), this.getEncoding()));
                    this.out = new PrintWriter((Writer)new OutputStreamWriter(this.socket.getOutputStream(), this.getEncoding()), true);
                    this.sender = new MessageSender(this);
                    if (this.in.read(c, 0, 1) != -1) {
                        sb = new StringBuffer(4096);
                        while (c[0] != '\u0000') {
                            sb.append(c[0]);
                            this.in.read(c, 0, 1);
                        }
                        this.getProgress().log("debuglogger", "connection:" + sb + " [" + this.getClientID() + "]");
                        this.doInitialCommand(sb.toString());
                    }
                    if (this.getApplication() == null) break block62;
                    this.sendingstatus = false;
                    if (!this.getApplication().checkConnection(this)) break block62;
                    this.terminated = false;
                    this.socket.setSoTimeout(this.getApplication().getTimeout());
                    block40: while (this.in.read(c, 0, 1) != -1) {
                        sb = new StringBuffer(4096);
                        while (true) {
                            if (c[0] == '\u0000') {
                                this.getProgress().log("debuglogger", "command:" + sb + " [" + this.getClientID() + "]");
                                this.sendingstatus = false;
                                if (this.getApplication().doCommand(this, sb.toString())) continue block40;
                                break block62;
                            }
                            sb.append(c[0]);
                            this.in.read(c, 0, 1);
                        }
                    }
                    break block63;
                }
                catch (SocketException ioe) {
                    this.getProgress().errlog(String.valueOf(ioe.getMessage()) + ":" + this.getClientID());
                }
                catch (Throwable ioe) {
                    this.getProgress().errlog("\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + this.getClientID(), ioe);
                }
            }
            this.terminated = true;
            if (this.sendingstatus) {
                SocketProcessorImpl socketProcessorImpl = this;
                synchronized (socketProcessorImpl) {
                    try {
                        this.wait(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            this.getProgress().log("debuglogger", "disconnect [" + this.getClientID() + "]");
            this.server.getSecurityController().exit(this);
            try {
                if (this.sender != null && !this.sender.isTeminated()) {
                    this.sender.terminate();
                }
                if (this.getApplication() != null) {
                    this.getApplication().preRemoveClient(this);
                    this.getApplication().removeClient(this);
                    this.notifyToSystemCommandSocklet();
                }
            }
            catch (Throwable e) {
                this.getProgress().errlog("\u7d42\u4e86\u51e6\u7406\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + this.getClientID(), e);
                e.printStackTrace();
            }
            if (this.out != null) {
                this.out.close();
            }
            try {
                if (this.in != null) {
                    this.in.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                if (this.socket != null) {
                    this.socket.close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            this.out = null;
            this.in = null;
            this.socket = null;
            return;
            catch (Throwable throwable) {
                this.terminated = true;
                if (this.sendingstatus) {
                    SocketProcessorImpl e = this;
                    synchronized (e) {
                        try {
                            this.wait(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                this.getProgress().log("debuglogger", "disconnect [" + this.getClientID() + "]");
                this.server.getSecurityController().exit(this);
                try {
                    if (this.sender != null && !this.sender.isTeminated()) {
                        this.sender.terminate();
                    }
                    if (this.getApplication() != null) {
                        this.getApplication().preRemoveClient(this);
                        this.getApplication().removeClient(this);
                        this.notifyToSystemCommandSocklet();
                    }
                }
                catch (Throwable e) {
                    this.getProgress().errlog("\u7d42\u4e86\u51e6\u7406\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + this.getClientID(), e);
                    e.printStackTrace();
                }
                if (this.out != null) {
                    this.out.close();
                }
                try {
                    if (this.in != null) {
                        this.in.close();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                try {
                    if (this.socket != null) {
                        this.socket.close();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                this.out = null;
                this.in = null;
                this.socket = null;
                throw throwable;
            }
        }
        this.terminated = true;
        if (this.sendingstatus) {
            SocketProcessorImpl e = this;
            synchronized (e) {
                try {
                    this.wait(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.getProgress().log("debuglogger", "disconnect [" + this.getClientID() + "]");
        this.server.getSecurityController().exit(this);
        try {
            if (this.sender != null && !this.sender.isTeminated()) {
                this.sender.terminate();
            }
            if (this.getApplication() != null) {
                this.getApplication().preRemoveClient(this);
                this.getApplication().removeClient(this);
                this.notifyToSystemCommandSocklet();
            }
        }
        catch (Throwable e) {
            this.getProgress().errlog("\u7d42\u4e86\u51e6\u7406\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002" + this.getClientID(), e);
            e.printStackTrace();
        }
        if (this.out != null) {
            this.out.close();
        }
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.out = null;
        this.in = null;
        this.socket = null;
    }

    public boolean send(String message) {
        if (this.sender.isTeminated()) {
            return false;
        }
        return this.sender.send(message);
    }

    private boolean sendAndWait(String message) {
        if (this.out == null) {
            this.getProgress().errlog("\u30e9\u30a4\u30bf\u3092\u55aa\u5931\u3057\u307e\u3057\u305f\u3002" + this.getClientID());
            this.isSending(false);
            return false;
        }
        this.out.print(String.valueOf(message) + "\u0000");
        if (this.out.checkError()) {
            this.getProgress().errlog("\u9001\u4fe1\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + this.getClientID() + "\n" + message);
            this.isSending(false);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void isSending(boolean sw) {
        this.sendingstatus = sw;
        if (!sw) {
            Runnable runnable = this;
            synchronized (runnable) {
                this.notifyAll();
            }
            if (this.sender != null) {
                runnable = this.sender;
                synchronized (runnable) {
                    this.sender.notifyAll();
                }
            }
        }
    }

    public synchronized void terminate() {
        if (this.socket != null && !this.socket.isClosed()) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                this.getProgress().errlog("Shutdown failure : " + this.getClientID(), e);
            }
        }
    }

    public synchronized void terminate(String message) {
        this.sendAndWait(message);
        this.terminate();
    }

    static /* synthetic */ boolean access$1(SocketProcessorImpl socketProcessorImpl, String string) {
        return socketProcessorImpl.sendAndWait(string);
    }

    private class MessageSender
    implements Runnable {
        private SocketProcessorImpl parent;
        private Vector messages;
        private Thread thisThread;
        private boolean terminate = false;

        private MessageSender(SocketProcessorImpl socket) {
            this.parent = socket;
            this.messages = new Vector();
            this.thisThread = new Thread((Runnable)this, "sender-" + this.parent.getClientID());
            this.thisThread.start();
        }

        public boolean isTeminated() {
            return this.terminate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean send(String message) {
            if (this.messages == null) {
                return false;
            }
            this.messages.add(message);
            if (this.messages.size() > this.parent.getMessagesBufferSize()) {
                System.out.println("\u30d0\u30c3\u30d5\u30a1\u306b\u6e9c\u3081\u3066\u7f6e\u3051\u308b\u30e1\u30c3\u30bb\u30fc\u30b8\u6570\u306e\u6700\u5927\u5024\u3092\u8d85\u3048\u307e\u3057\u305f\u3002");
                return false;
            }
            this.parent.isSending(true);
            MessageSender messageSender = this;
            synchronized (messageSender) {
                this.notify();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void terminate() {
            this.messages = null;
            this.terminate = true;
            MessageSender messageSender = this;
            synchronized (messageSender) {
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            ** GOTO lbl23
            {
                if (!SocketProcessorImpl.access$1(this.parent, (String)this.messages.remove(0))) {
                    this.terminateParent();
                    return;
                }
                do {
                    if (this.messages != null && this.messages.size() > 0) continue block5;
                    SocketProcessorImpl.access$0(this.parent, false);
                    if (this.terminate) {
                        return;
                    }
                    var1_1 = this;
                    synchronized (var1_1) {
                        try {
                            this.wait();
                        }
                        catch (Exception e) {
                            SocketProcessorImpl.this.getProgress().errlog("\u9001\u4fe1\u7528\u30b9\u30ec\u30c3\u30c9\u306e\u4f11\u6b62\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
                            this.terminateParent();
                            return;
                        }
                    }
lbl23:
                    // 2 sources

                } while (!this.terminate);
            }
        }

        private void terminateParent() {
            this.terminate = true;
            this.parent.terminate();
        }
    }
}

