/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.gpss.system;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Constructor;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Iterator;
import jp.wda.gpss.Progress;
import jp.wda.gpss.Socklet;
import jp.wda.gpss.SockletDeployInfo;
import jp.wda.gpss.SockletDeployingException;
import jp.wda.gpss.system.Configuration;
import jp.wda.gpss.system.ConfigurationError;
import jp.wda.gpss.system.ExecutableBase;
import jp.wda.gpss.system.ScriptInfo;
import jp.wda.gpss.system.ScriptSocklet;
import jp.wda.gpss.system.SocketProcessorBase;
import jp.wda.gpss.system.SocketProcessorImpl;
import jp.wda.gpss.system.SockletLoader;
import jp.wda.gpss.system.SystemCommandSocklet;

public class Main
extends ExecutableBase {
    private boolean terminator = false;

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage : ");
            System.out.println("  java jp.wda.gpss.system.Main config.xml");
            System.out.println("    config.xml - \u521d\u671f\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb");
            return;
        }
        File configfile = new File(args[0]);
        if (!configfile.exists()) {
            System.out.println("\u521d\u671f\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
            System.out.println("File : " + configfile.getAbsolutePath());
            return;
        }
        try {
            Configuration conf = new Configuration(configfile);
            conf.loadConfig();
            Class mainClass = conf.getExecutable();
            Constructor mainConstructor = mainClass.getConstructor(Configuration.class);
            mainConstructor.newInstance(conf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Main(Configuration config) {
        super(config);
    }

    protected void finalize() {
        if (this.terminator) {
            return;
        }
        Iterator it = this.getSocklets();
        while (it.hasNext()) {
            Socklet app = (Socklet)it.next();
            app.destroy();
        }
    }

    public void accept() {
        System.out.println("Starting server...");
        ServerSocket svsocket = null;
        try {
            try {
                svsocket = new ServerSocket(this.getPort());
                while (true) {
                    Socket socket = svsocket.accept();
                    if (this.terminator) {
                        break;
                    }
                    this.createSocketProcessor(socket);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        finally {
            if (svsocket != null) {
                try {
                    svsocket.close();
                }
                catch (Exception exception) {}
            }
            this.terminator = false;
        }
    }

    private void createSocketProcessor(Socket socket) {
        this.getProgress().syslog("Create Client... " + socket.getInetAddress().getHostAddress());
        SocketProcessorBase client = null;
        try {
            socket.setSoTimeout(this.getInitialTimeout());
            client = new SocketProcessorImpl(this, socket, this.getEncoding(), this.getMessagesBufferSize());
        }
        catch (InterruptedIOException e) {
            this.getProgress().errlog("\u30bf\u30a4\u30e0\u30a2\u30a6\u30c8\u8a2d\u5b9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002:" + client.getClientID(), e);
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        if (!this.getSecurityController().enter(client)) {
            this.getProgress().syslog("Connection Rejected... " + client.getIPAddress());
            this.getSecurityController().exit(client);
            ((SocketProcessorImpl)client).terminate();
            return;
        }
        if (client != null) {
            new Thread((Runnable)((Object)client), "ID:" + client.getClientID()).start();
            this.getProgress().syslog("Welcome " + client.getIPAddress() + "! (ID:" + client.getClientID() + ")");
        }
    }

    void shutdown(SystemCommandSocklet sys) {
        if (!this.checkSystemCommandSocklet(sys)) {
            return;
        }
        this.getProgress().syslog("Shutdown server...");
        Iterator it = this.getSocklets();
        while (it.hasNext()) {
            Socklet app = (Socklet)it.next();
            app.disconnectAllClients("Good by...");
            app.destroy();
        }
        this.terminator = true;
        Socket socket = null;
        try {
            try {
                socket = new Socket("localhost", this.getPort());
            }
            catch (Throwable throwable) {}
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.getProgress().syslog("Shutdown successfully!");
    }

    void restart(SystemCommandSocklet sys) {
        if (!this.checkSystemCommandSocklet(sys)) {
            return;
        }
        this.setRestartAfterShutdown();
        this.shutdown(sys);
    }

    boolean restartSocklet(SystemCommandSocklet sys, String name) {
        if (!this.checkSystemCommandSocklet(sys)) {
            return false;
        }
        this.getProgress().syslog("Restart socklet \"" + name + "\"");
        Socklet socklet = this.getSocklet(name);
        SockletDeployInfo info = null;
        String scriptExt = null;
        File scriptFile = null;
        SockletLoader loader = null;
        if (socklet != null && socklet instanceof ScriptSocklet) {
            scriptExt = ((ScriptSocklet)socklet).getExtention();
            scriptFile = ((ScriptSocklet)socklet).getScriptFile();
            ScriptInfo scrinfo = this.getScriptInfomation(scriptExt);
            if (scrinfo != null && scriptFile != null && scriptFile.exists()) {
                info = this.getScriptSockletInformation(name);
                info.addInitParam("source", scriptFile.getAbsolutePath());
                info.addInitParam("sourceEncoding", scrinfo.getEncoding());
                info.setClassname(scrinfo.getJSClass().getName());
            }
            loader = this.scriptLoader;
        } else {
            info = this.getSockletInformation(name);
        }
        if (info == null) {
            this.getProgress().syslog("Socket \"" + name + "\"'s infomation is not found.", Progress.ERROR);
            return false;
        }
        this.terminateSocklet(socklet, "Good by...");
        this.getProgress().syslog("Socklet\"" + info.getName() + "\"(" + info.getClassname() + ")\u3092\u914d\u5099\u3057\u307e\u3059\u3002");
        try {
            socklet = this.deployNewSocklet(info, "BySystemServer", loader);
            if (socklet instanceof ScriptSocklet) {
                ((ScriptSocklet)socklet).setExtention(scriptExt);
                ((ScriptSocklet)socklet).setScriptFile(scriptFile);
            }
        }
        catch (SockletDeployingException e) {
            this.getProgress().errlog("Socklet\u306e\u914d\u5099\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
            return false;
        }
        return true;
    }

    boolean reloadConfig(SystemCommandSocklet sys) {
        if (!this.checkSystemCommandSocklet(sys)) {
            return false;
        }
        System.out.println("Reload config...");
        try {
            this.loadConfig();
        }
        catch (ConfigurationError e) {
            this.getProgress().errlog("\u521d\u671f\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u518d\u8aad\u8fbc\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002", e);
            return false;
        }
        this.reloadSystemCommandInfo();
        System.out.println("Reload config successfully!");
        return true;
    }
}

