/*
 * Decompiled with CFR 0.152.
 */
package jp.moja.socklet.util.security;

import java.util.ArrayList;
import jp.moja.socklet.util.security.ClientChecker;
import jp.wda.gpss.SocketProcessor;

public class AccessController {
    private ArrayList checkerChain = new ArrayList();

    public synchronized AccessController regist(ClientChecker checker) {
        this.checkerChain.add(checker);
        return this;
    }

    public synchronized boolean enter(SocketProcessor client) {
        for (ClientChecker checker : this.checkerChain) {
            int result = checker.enter(client);
            if (result == ClientChecker.ACCEPT) {
                return true;
            }
            if (result != ClientChecker.REJECT) continue;
            return false;
        }
        return true;
    }

    public synchronized void exit(SocketProcessor client) {
        for (ClientChecker checker : this.checkerChain) {
            checker.exit(client);
        }
    }
}

