/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.g2.util;

import java.io.StringReader;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import jp.wda.g2.SocketProcessor;
import jp.wda.g2.exception.GPSSException;
import jp.wda.g2.exception.XMLAttributeException;
import jp.wda.g2.exception.XMLParseException;
import jp.wda.gpss.util.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleXMLCreator {
    private Hashtable<Object, Object> attr;
    private LinkedList<SimpleXMLCreator> children;
    private String text;
    private String name = null;

    public SimpleXMLCreator(String name) {
        this.setName(name);
        this.setText("");
        this.attr = new Hashtable();
        this.children = new LinkedList();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
    }

    public final void setAttribute(Object key, Object value) {
        this.attr.put(key, value);
    }

    public final Object getAttribute(Object key) {
        return this.attr.get(key);
    }

    public Set getAttributes() {
        return this.attr.entrySet();
    }

    public boolean containsAttributeKey(Object key) {
        return this.attr.containsKey(key);
    }

    public Set getAttributeKeys() {
        return this.attr.keySet();
    }

    public Object removeAttribute(Object key) {
        return this.attr.remove(key);
    }

    public final void setAttribute(Object key, int value) {
        this.attr.put(key, new Integer(value));
    }

    public final int getAttributeInt(Object key) throws XMLAttributeException {
        Object ret = this.attr.get(key);
        if (ret instanceof Integer) {
            return (Integer)ret;
        }
        throw new XMLAttributeException("\u6307\u5b9a\u3055\u308c\u305f\u5c5e\u6027(" + key + ")\u306fint\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
    }

    public final void setAttribute(Object key, long value) {
        this.attr.put(key, new Long(value));
    }

    public final long getAttributeLong(Object key) throws XMLAttributeException {
        Object ret = this.attr.get(key);
        if (ret instanceof Long) {
            return (Long)ret;
        }
        throw new XMLAttributeException("\u6307\u5b9a\u3055\u308c\u305f\u5c5e\u6027(" + key + ")\u306flong\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
    }

    public final void setAttribute(Object key, double value) {
        this.attr.put(key, new Double(value));
    }

    public final double getAttributeDouble(Object key) throws XMLAttributeException {
        Object ret = this.attr.get(key);
        if (ret instanceof Double) {
            return (Double)ret;
        }
        throw new XMLAttributeException("\u6307\u5b9a\u3055\u308c\u305f\u5c5e\u6027(" + key + ")\u306fdouble\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
    }

    public final void setAttribute(Object key, boolean value) {
        this.attr.put(key, new Boolean(value));
    }

    public final boolean getAttributeBoolean(Object key) throws XMLAttributeException {
        Object ret = this.attr.get(key);
        if (ret instanceof Boolean) {
            return (Boolean)ret;
        }
        throw new XMLAttributeException("\u6307\u5b9a\u3055\u308c\u305f\u5c5e\u6027(" + key + ")\u306fboolean\u578b\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
    }

    public SimpleXMLCreator addChild(String name) {
        SimpleXMLCreator child = new SimpleXMLCreator(name);
        this.children.add(child);
        return child;
    }

    public void addChild(SimpleXMLCreator child) {
        this.children.add(child);
    }

    public void removeChild(SimpleXMLCreator child) {
        this.children.remove(child);
    }

    public void removeChild(String name) {
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            SimpleXMLCreator child = (SimpleXMLCreator)it.next();
            if (!child.getName().equals(name)) continue;
            it.remove();
            return;
        }
    }

    public void removeChildren(String name) {
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            SimpleXMLCreator child = (SimpleXMLCreator)it.next();
            if (!child.getName().equals(name)) continue;
            it.remove();
        }
    }

    public void removeChildren() {
        this.children = new LinkedList();
    }

    public List<SimpleXMLCreator> getChildren() {
        return new LinkedList<SimpleXMLCreator>(this.children);
    }

    public List getChildren(String name) {
        LinkedList<SimpleXMLCreator> list = new LinkedList<SimpleXMLCreator>();
        for (SimpleXMLCreator child : this.children) {
            if (!child.getName().equals(name)) continue;
            list.add(child);
        }
        return list;
    }

    public int sizeOfChildren() {
        return this.children.size();
    }

    public SimpleXMLCreator getChild(int idx) {
        if (idx >= this.children.size()) {
            return null;
        }
        return this.children.get(idx);
    }

    public SimpleXMLCreator getChild(String name) {
        for (SimpleXMLCreator child : this.children) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    public void setText(String textNode) {
        this.text = textNode;
    }

    public String getText() {
        return this.text;
    }

    public void send(SocketProcessor client) {
        if (client == null) {
            return;
        }
        client.send(this.toString());
    }

    public String toString() {
        StringBuffer ret = new StringBuffer("<");
        ret.append(this.name);
        Set attributes = this.getAttributes();
        for (Map.Entry entry : attributes) {
            Object value = entry.getValue();
            value = this.convertEntity(value);
            ret.append(' ');
            ret.append(entry.getKey());
            ret.append("=\"");
            ret.append(value);
            ret.append("\"");
        }
        if (this.children.size() == 0 && this.text == "") {
            ret.append(" />");
            return ret.toString();
        }
        ret.append('>');
        ret.append(this.convertEntity(this.text));
        int i = 0;
        while (i < this.children.size()) {
            ret.append(this.children.get(i));
            ++i;
        }
        ret.append("</");
        ret.append(this.name);
        ret.append('>');
        return ret.toString();
    }

    private Object convertEntity(Object text) {
        if (text == null || !(text instanceof String)) {
            return text;
        }
        String str = (String)text;
        StringBuffer buf = new StringBuffer(str.length() + 20);
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            switch (c) {
                case '<': {
                    buf.append("&lt;");
                    break;
                }
                case '>': {
                    buf.append("&gt;");
                    break;
                }
                case '\'': {
                    buf.append("&apos;");
                    break;
                }
                case '\"': {
                    buf.append("&quot;");
                    break;
                }
                case '&': {
                    buf.append("&amp;");
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static SimpleXMLCreator parse(String xml) throws GPSSException {
        Logger syslog = Logger.getLogger("jp.wda.g2.systemlog");
        InputSource src = new InputSource(new StringReader(xml));
        Document doc = null;
        try {
            DocumentBuilderFactory dbfactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbfactory.newDocumentBuilder();
            doc = builder.parse(src);
        }
        catch (Throwable ex) {
            syslog.error("command:" + xml);
            syslog.fatalmessage(ex);
            throw new XMLParseException(ex.getMessage());
        }
        if (doc == null) {
            throw new XMLParseException("doc is null.");
        }
        Element root = doc.getDocumentElement();
        SimpleXMLCreator ret = new SimpleXMLCreator(root.getTagName());
        SimpleXMLCreator.setXMLElements(ret, root);
        return ret;
    }

    private static void setXMLElements(SimpleXMLCreator xml, Element element) {
        NamedNodeMap attrs = element.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Node attr = attrs.item(i);
            xml.setAttribute((Object)attr.getNodeName(), attr.getNodeValue());
            ++i;
        }
        NodeList children = element.getChildNodes();
        int i2 = 0;
        while (i2 < children.getLength()) {
            Node node = children.item(i2);
            if (node instanceof Text) {
                xml.setText(((Text)node).getWholeText());
            } else if (node instanceof Element) {
                Element child = (Element)node;
                SimpleXMLCreator childxml = xml.addChild(child.getTagName());
                SimpleXMLCreator.setXMLElements(childxml, child);
            }
            ++i2;
        }
    }

    public static void main(String[] args) {
        SimpleXMLCreator node = new SimpleXMLCreator("node");
        node.setAttribute((Object)"attr", "<Test>=\"value\"");
        System.out.println(node);
        String xml = "<TagTest name=\"name dayo\" value=\"value dayo\"><test>aiueo</test><test></test></TagTest>";
        try {
            SimpleXMLCreator creator = SimpleXMLCreator.parse(xml);
            System.out.println(creator.getName());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

