/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.g2.system;

import jp.wda.g2.SocketProcessor;
import jp.wda.g2.security.AccessController;
import jp.wda.g2.security.ClientChecker;
import jp.wda.g2.security.IPAddressChecker;
import jp.wda.g2.system.AbstractSocklet;
import jp.wda.g2.system.SockletLinkage;

public abstract class AccessControledSocklet
extends AbstractSocklet {
    private AccessController securityController = new AccessController();

    public void registerClientChecker(ClientChecker checker) {
        this.securityController.register(checker);
    }

    public void acceptFrom(String ipaddr) {
        if (ipaddr == null || ipaddr.length() == 0) {
            return;
        }
        this.securityController.register(new IPAddressChecker(ipaddr, ClientChecker.ACCEPT, ClientChecker.CHAIN));
    }

    public void rejectFrom(String ipaddr) {
        if (ipaddr == null || ipaddr.length() == 0) {
            return;
        }
        this.securityController.register(new IPAddressChecker(ipaddr, ClientChecker.REJECT, ClientChecker.CHAIN));
    }

    public final boolean checkConnection(SocketProcessor client, SockletLinkage linkage) {
        if (!this.securityController.enter(client)) {
            this.syslog.error("Connection Rejected..." + client.getIPAddress());
            this.securityController.exit(client);
            return this.denied(client, linkage);
        }
        return this.accept(client, linkage);
    }

    public final void preRemoveClient(SocketProcessor client, SockletLinkage linkage) {
        this.securityController.exit(client);
        this.desert(client, linkage);
    }

    public abstract boolean accept(SocketProcessor var1, SockletLinkage var2);

    public abstract boolean denied(SocketProcessor var1, SockletLinkage var2);

    public abstract void desert(SocketProcessor var1, SockletLinkage var2);
}

