/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.g2.system;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import jp.wda.g2.Socklet;
import jp.wda.g2.exception.SockletNotFoundException;
import jp.wda.g2.system.SockletContainer;
import jp.wda.gpss.util.Logger;
import org.seasar.framework.container.S2Container;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSocklet
implements Socklet {
    protected final Logger syslog = Logger.getLogger("jp.wda.g2.systemlog");
    private List<SockletContainer> children = new CopyOnWriteArrayList<SockletContainer>();
    private ConcurrentMap<String, SockletContainer> childrenMap = new ConcurrentHashMap<String, SockletContainer>();
    private S2Container container = null;

    public void setS2Container(S2Container s) {
        this.container = s;
    }

    protected Object registerComponent(String name, Class clazz) {
        this.container.register(clazz, name);
        this.container.init();
        return this.container.getComponent((Object)name);
    }

    public List<SockletContainer> getChildren() {
        return this.children;
    }

    public void addChild(String name) {
        this.addChild(name, (Socklet)this.container.getComponent((Object)name));
    }

    public Socklet addChild(String name, String className) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            this.syslog.errormessage("EGSS00003", new Object[]{name, className});
            return null;
        }
        return this.addChild(name, clazz);
    }

    public Socklet addChild(String name, Class clazz) {
        Socklet socklet = (Socklet)this.registerComponent(name, clazz);
        this.addChild(name, socklet);
        return socklet;
    }

    public void addChild(String name, Socklet socklet) {
        SockletContainer container = new SockletContainer(name, socklet);
        this.childrenMap.put(name, container);
        this.children.add(container);
    }

    public SockletContainer getChild(String name) throws SockletNotFoundException {
        SockletContainer container = (SockletContainer)this.childrenMap.get(name);
        if (container == null) {
            throw new SockletNotFoundException(name);
        }
        return container;
    }

    public boolean hasChild(String name) {
        return this.childrenMap.containsKey(name);
    }

    @Override
    public final void destroyAllSocklets() {
        this.destroy();
        int i = 0;
        while (i < this.children.size()) {
            this.children.get(i).getSocklet().destroyAllSocklets();
            ++i;
        }
    }
}

