/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.g2.extention.nio.handler;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import jp.wda.g2.Connection;
import jp.wda.g2.SocketProcessor;
import jp.wda.g2.SocketReactor;
import jp.wda.g2.extention.nio.handler.CommandHandler;
import jp.wda.gpss.util.Logger;

public class ReadHandler
implements Runnable,
Connection {
    private final Logger logger = Logger.getLogger((String)"jp.wda.g2.systemlog");
    private SelectionKey key;
    private ByteBuffer buffer;
    private ByteBufferList messageBuffer;
    private static final int BUFFER_SIZE = 1024;
    private long lastAct;
    private SocketReactor reactor = null;
    private SocketChannel channel;
    private SocketProcessor client;

    public ReadHandler(SocketChannel channel, SocketReactor reactor) {
        this.channel = channel;
        this.reactor = reactor;
        this.buffer = ByteBuffer.allocateDirect(1024);
        this.messageBuffer = new ByteBufferList(1024);
    }

    void register(Selector selector) throws IOException {
        this.key = this.channel.register(selector, 1);
        this.recordActive();
        this.key.attach(this);
    }

    private void recordActive() {
        this.lastAct = System.currentTimeMillis();
    }

    public SocketReactor getReactor() {
        return this.reactor;
    }

    public SocketChannel getSocketChannel() {
        return this.channel;
    }

    public SocketProcessor getClient() {
        return this.client;
    }

    public void setClient(SocketProcessor s) {
        this.client = s;
    }

    /*
     * Loose catch block
     */
    public void run() {
        int length = -1;
        Throwable th = null;
        try {
            try {
                length = this.readChannel();
            }
            catch (ClosedChannelException e) {
                this.logger.error((Object)"\u30bd\u30b1\u30c3\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059\u3002", (Throwable)e);
                th = e;
                if (!(length >= 0 && th == null || this.client.isTerminated())) {
                    this.client.terminate();
                }
                return;
            }
            catch (IOException ioe) {
                this.logger.error((Object)"\u5165\u529b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", (Throwable)ioe);
                th = ioe;
                if (!(length >= 0 && th == null || this.client.isTerminated())) {
                    this.client.terminate();
                }
                return;
            }
            catch (Throwable e) {
                this.logger.error((Object)"\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", e);
                th = e;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                if (!(length >= 0 && th == null || this.client.isTerminated())) {
                    this.client.terminate();
                }
                return;
            }
        }
        finally {
            if (!(length >= 0 && th == null || this.client.isTerminated())) {
                this.client.terminate();
            }
        }
    }

    private int readChannel() throws IOException {
        int length = -1;
        this.buffer.clear();
        while (!this.client.isTerminated() && (length = this.channel.read(this.buffer)) > 0) {
            this.recordActive();
            this.buffer.flip();
            while (this.buffer.hasRemaining()) {
                byte b = this.buffer.get();
                if (b == 0) {
                    CommandHandler command = new CommandHandler(this.client, this.messageBuffer.toByteBuffer());
                    this.reactor.execute((Runnable)command);
                    this.messageBuffer.clear();
                    continue;
                }
                this.messageBuffer.put(b);
            }
            this.buffer.clear();
        }
        return length;
    }

    public boolean send(String message) {
        if (this.client.isTerminated()) {
            return false;
        }
        if (this.channel == null) {
            this.logger.error((Object)("\u30e9\u30a4\u30bf\u3092\u55aa\u5931\u3057\u307e\u3057\u305f\u3002" + this.client.getClientID()));
            this.client.terminate();
            return false;
        }
        ByteBuffer buffer = Charset.forName(this.client.getEncoding()).encode(String.valueOf(message) + "\u0000");
        try {
            this.channel.write(buffer);
            return true;
        }
        catch (Exception e) {
            this.logger.error((Object)("\u9001\u4fe1\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + this.client.getClientID() + "\n" + message), (Throwable)e);
            this.client.terminate();
            return false;
        }
    }

    public void closeConnection() {
        if (this.channel != null) {
            try {
                this.channel.finishConnect();
                this.channel.close();
                this.key.cancel();
            }
            catch (Throwable e) {
                this.logger.error((Object)("\u30c1\u30e3\u30f3\u30cd\u30eb\u7d42\u4e86\u51e6\u7406\u4e2d\u306b\u4f8b\u5916\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002\uff1a" + this.client.getClientID()), e);
            }
        }
        this.channel = null;
    }

    public void terminateIfInactive() {
        if (this.isInactive() && !this.client.isTerminated()) {
            this.client.terminate("Connection timeout..");
        }
    }

    public boolean isInactive() {
        if (this.client.isTerminated()) {
            return false;
        }
        long timeout = this.client.getTimeout();
        if (timeout <= 0L) {
            return false;
        }
        return System.currentTimeMillis() > timeout + this.lastAct;
    }

    private class ByteBufferList {
        private ArrayList<ByteBuffer> list = new ArrayList();
        private ByteBuffer current;
        private int bufferLength;

        public ByteBufferList(int length) {
            this.bufferLength = length;
            this.current = null;
        }

        public void put(byte b) {
            if (this.current == null || this.current.position() == this.current.limit()) {
                this.current = ByteBuffer.allocate(this.bufferLength);
                this.list.add(this.current);
            }
            this.current.put(b);
        }

        public void put(ByteBuffer bb) {
            while (bb.hasRemaining()) {
                this.put(bb.get());
            }
        }

        public ByteBuffer toByteBuffer() {
            ByteBuffer buf = ByteBuffer.allocate(this.bufferLength * this.list.size());
            for (ByteBuffer tmpBuf : this.list) {
                tmpBuf.flip();
                buf.put(tmpBuf);
            }
            buf.flip();
            return buf;
        }

        public void clear() {
            this.list.clear();
            this.current = null;
        }
    }
}

