/*
 * Decompiled with CFR 0.152.
 */
package jp.wda.g2.extention.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import jp.wda.g2.SocketProcessor;
import jp.wda.g2.SocketReactor;
import jp.wda.g2.Socklet;
import jp.wda.g2.exception.AccessDeniedException;
import jp.wda.g2.exception.GPSSException;
import jp.wda.g2.extention.nio.SleeperSweeper;
import jp.wda.g2.extention.nio.handler.AcceptHandler;
import jp.wda.g2.system.AbstractSocketReactor;
import jp.wda.g2.system.AccessControledSocklet;
import jp.wda.g2.system.SockletContainer;
import jp.wda.g2.system.SockletLinkage;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.util.StringUtil;

public class NioSocketReactor
extends AbstractSocketReactor {
    private ServerSocketChannel serverChannel;
    private Selector selector;
    private boolean terminator = false;
    private boolean terminated = false;
    private ExecutorService executor = Executors.newCachedThreadPool();
    private S2Container container = null;
    private long sweeperDelay = 10000L;
    private SystemCommandSocklet systemcommand = new SystemCommandSocklet();

    public ExecutorService getPool() {
        return this.executor;
    }

    public void execute(Runnable r) {
        this.executor.execute(r);
    }

    public void notifyAcceptance(SockletContainer container, SocketProcessor client) {
        super.notifyAcceptance(container, client);
    }

    public void notifyDesertion(SockletContainer container, SocketProcessor client) {
        super.notifyDesertion(container, client);
    }

    public void setContainer(S2Container s) {
        this.container = s;
    }

    public void setSweeperDelay(long s) {
        this.sweeperDelay = s;
    }

    public void accept() {
        block21: {
            try {
                this.openChannel();
            }
            catch (IOException ex) {
                this.syslog.errormessage("EGSS00001", (Throwable)ex);
                return;
            }
            this.syslog.infomessage("IGSS00001");
            ScheduledExecutorService sweeperExecutor = Executors.newSingleThreadScheduledExecutor();
            sweeperExecutor.scheduleWithFixedDelay(new SleeperSweeper(this.selector), this.sweeperDelay, this.sweeperDelay, TimeUnit.MILLISECONDS);
            block14: while (true) {
                while (true) {
                    if (this.terminator) {
                        break block21;
                    }
                    try {
                        this.select();
                        continue block14;
                    }
                    catch (ClosedSelectorException cse) {
                        this.syslog.errormessage("EGSS00002", (Throwable)cse);
                        break block21;
                    }
                    catch (IOException ioe) {
                        this.syslog.errormessage("EGSS90001", (Throwable)ioe);
                        break block21;
                    }
                    catch (RuntimeException re) {
                        this.syslog.errormessage("EGSS90002", (Throwable)re);
                        continue;
                    }
                    catch (Throwable e) {
                        this.syslog.fatalmessage(e);
                        break block21;
                    }
                    break;
                }
            }
            finally {
                try {
                    if (this.serverChannel != null) {
                        this.serverChannel.close();
                    }
                    if (this.selector != null) {
                        this.selector.close();
                    }
                }
                catch (Exception exception) {}
                if (sweeperExecutor != null) {
                    sweeperExecutor.shutdown();
                }
                if (this.executor != null) {
                    this.executor.shutdownNow();
                }
                this.syslog.infomessage("IGSS00002");
                this.container.destroy();
                this.terminator = false;
                this.terminated = true;
            }
        }
    }

    private void openChannel() throws IOException {
        this.serverChannel = ServerSocketChannel.open();
        this.serverChannel.configureBlocking(false);
        ServerSocket serverSocket = this.serverChannel.socket();
        serverSocket.bind(new InetSocketAddress(this.getPort()));
        this.selector = Selector.open();
        SelectionKey acceptKey = this.serverChannel.register(this.selector, 16);
        acceptKey.attach(new AcceptHandler(acceptKey, (SocketReactor)this));
    }

    private void select() throws IOException {
        int n = this.selector.select(1000L);
        if (n == 0) {
            return;
        }
        Iterator<SelectionKey> it = this.selector.selectedKeys().iterator();
        while (it.hasNext()) {
            SelectionKey key = it.next();
            it.remove();
            this.dispatch(key);
        }
    }

    private void dispatch(SelectionKey key) {
        Runnable handler = (Runnable)key.attachment();
        if (handler == null) {
            return;
        }
        try {
            handler.run();
        }
        catch (Throwable e) {
            this.syslog.error((Object)"", e);
        }
    }

    public synchronized void shutdown() {
        if (this.terminator) {
            return;
        }
        this.getDefaultSocklet().destroyAllSocklets();
        SocketProcessor[] allclients = this.getDefaultSockletContainer().getAllClients();
        int i = 0;
        while (i < allclients.length) {
            allclients[i].terminate();
            ++i;
        }
        this.terminator = true;
        this.selector.wakeup();
    }

    public Socklet getSystemCommandSocklet() {
        return this.systemcommand;
    }

    public void systemCommandAcceptFrom(String ipaddr) {
        this.systemcommand.acceptFrom(ipaddr);
    }

    public void systemCommandRejectFrom(String ipaddr) {
        this.systemcommand.rejectFrom(ipaddr);
    }

    private class SystemCommandSocklet
    extends AccessControledSocklet {
        public static final String RESTART = "restart";
        public static final String SHUTDOWN = "shutdown";
        public static final String RELOAD = "reload";
        public static final String GETLIST = "getSockletsList";

        SystemCommandSocklet() {
        }

        public boolean accept(SocketProcessor client, SockletLinkage linkage) {
            client.setAttributes((Object)new Boolean(true));
            client.send("+OK");
            return true;
        }

        public boolean denied(SocketProcessor client, SockletLinkage linkage) {
            client.setAttributes((Object)new Boolean(false));
            client.send("-Your connection is not allowed.");
            return false;
        }

        public void desert(SocketProcessor client, SockletLinkage linkage) {
        }

        public void destroy() {
        }

        private boolean getAllowFlag(SocketProcessor client) {
            Boolean result = (Boolean)client.getAttributes();
            return result == null ? false : result;
        }

        public Object doCommand(SocketProcessor client, ByteBuffer command, SockletLinkage linkage) throws GPSSException {
            if (!this.getAllowFlag(client)) {
                throw new AccessDeniedException();
            }
            String cmd = Charset.forName(client.getEncoding()).decode(command).toString();
            if (StringUtil.isEmpty((String)cmd)) {
                client.terminate("+Good bye...");
                return null;
            }
            if (cmd.equals(SHUTDOWN)) {
                client.terminate();
                NioSocketReactor.this.shutdown();
                return null;
            }
            if (cmd.equals(RESTART)) {
                String config = NioSocketReactor.this.container.getPath();
                client.terminate();
                NioSocketReactor.this.shutdown();
                while (!NioSocketReactor.this.terminated) {
                }
                NioSocketReactor.startServer((String)config);
                return null;
            }
            client.send("-" + cmd + " is not found.");
            return null;
        }
    }
}

