#------------------------------------------------------------------------------
#    59bbs, blog like bulletin board system.
#    Copyright (C) 2007-2009 Kaga, Hiroaki
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#------------------------------------------------------------------------------

package Lib::User;

use strict;
use warnings;

use constant {
    LOCK_SH => 1,
    LOCK_EX => 2,
    LOCK_NB => 4,
    LOCK_UN => 8,
};

# コンストラクタ
sub new {
    my $self = {};

    use Lib::App::Conf;
    my $conf = Lib::App::Conf->new();

    $self->{system_dir} = $conf->get_system_dir();

    $self->{userid} = '';      # ユーザーID
    $self->{password} = '';    # パスワード
    $self->{mailaddr} = '';    # メールアドレス
    $self->{hpurl} = '';       # ホームページURL
    $self->{userename} = '';   # ユーザー名
    $self->{auth} = 1;         # 権限 0:管理者 1:編集者
    $self->{status} = 0;       # ステータス 0:無効 1:有効
    $self->{ad1} = '';         # ユーザーの広告コード1（記事上）
    $self->{ad2} = '';         # ユーザーの広告コード2（記事下）
    $self->{ad3} = '';         # ユーザーの広告コード3（サイドバー）
    $self->{parts} = '';       # ブログパーツ
    $self->{feedurl} = '';     # フィードURL
    $self->{amazonid} = '';    # AmazonアソシエイトID
    $self->{bookmarekid} = ''; # ブックマークID

    bless($self);
    return $self;
}

# ユーザーIDの取得
sub get_userid {
    my $self = shift;
    return $self->{userid};
}

# ユーザーIDの設定
sub set_userid {
    my $self = shift;
    $self->{userid} = shift;
}

# パスワードの取得
sub get_password {
    my $self = shift;
    return $self->{password};
}

# パスワードの設定
sub set_password {
    my $self = shift;
    $self->{password} = shift;
}

# メールアドレスの取得
sub get_mailaddr {
    my $self = shift;
    return $self->{mailaddr};
}

# メールアドレスの設定
sub set_mailaddr {
    my $self = shift;
    $self->{mailaddr} = shift;
}

# ホームページURLの取得
sub get_hpurl {
    my $self = shift;
    return $self->{hpurl};
}

# ホームページURLの設定
sub set_hpurl {
    my $self = shift;
    $self->{hpurl} = shift;
}

# ユーザー名の取得
sub get_username {
    my $self = shift;
    return $self->{username};
}

# ユーザー名の設定
sub set_username {
    my $self = shift;
    $self->{username} = shift;
}

# 権限の取得
sub get_auth {
    my $self = shift;
    return $self->{auth};
}

# 権限の設定
sub set_auth {
    my $self = shift;
    $self->{auth} = shift;
}

# ステータスの取得
sub get_status {
    my $self = shift;
    return $self->{status};
}

# ステータスの設定
sub set_status {
    my $self = shift;
    $self->{status} = shift;
}

# 広告コード1（記事上）の取得
sub get_ad1 {
    my $self = shift;
    return $self->{ad1};
}

# 広告コード1（記事上）の設定
sub set_ad1 {
    my $self = shift;
    $self->{ad1} = shift;
}

# 広告コード2（記事下）の取得
sub get_ad2 {
    my $self = shift;
    return $self->{ad2};
}

# 広告コード2（記事下）の設定
sub set_ad2 {
    my $self = shift;
    $self->{ad2} = shift;
}

# 広告コード3（サイドバー）の取得
sub get_ad3 {
    my $self = shift;
    return $self->{ad3};
}

# 広告コード3（サイドバー）の設定
sub set_ad3 {
    my $self = shift;
    $self->{ad3} = shift;
}

# ブログパーツの取得
sub get_parts {
    my $self = shift;
    return $self->{parts};
}

# ブログパーツの設定
sub set_parts {
    my $self = shift;
    $self->{parts} = shift;
}

# フィードURLの取得
sub get_feedurl {
    my $self = shift;
    return $self->{feedurl};
}

# フィードURLの設定
sub set_feedurl {
    my $self = shift;
    $self->{feedurl} = shift;
}

# AmazonアソシエイトIDの取得
sub get_amazonid {
    my $self = shift;
    return $self->{amazonid};
}

# AmazonアソシエイトIDの設定
sub set_amazonid {
    my $self = shift;
    $self->{amazonid} = shift;
}

# ブックマークIDの取得
sub get_bookmarekid {
    my $self = shift;
    return $self->{bookmarekid};
}

# ブックマークIDの設定
sub set_bookmarekid {
    my $self = shift;
    $self->{bookmarekid} = shift;
}

# ユーザーの追加
sub add {
    my $self = shift;
    my $result = 1;

    # ユーザーディレクトリを作成
    my $user_dir = "$self->{system_dir}/user/$self->{userid}";
    mkdir $user_dir, 0777;

    # ユーザーデータ更新
    $result = $self->update();

    return $result;
}

# 指定されたユーザーIDの情報を取得
sub load {
    my $self = shift;
    my $userid = shift;

    my $userfile = "$self->{system_dir}/user/$userid/profile.txt";
    open my $userfh, '<', $userfile;
    my $data = <$userfh>;
    chop($data);
    ($self->{userid},
     $self->{password},
     $self->{mailaddr},
     $self->{hpurl},
     $self->{username},
     $self->{auth},
     $self->{status},
     $self->{ad1},
     $self->{ad2},
     $self->{ad3},
     $self->{parts},
     $self->{feedurl},
     $self->{amazonid},
     $self->{bookmarekid}) = split(/\,/, $data);
    close $userfh;

    $self->{hpurl} =~ s/enc_conma/,/g;
    $self->{username} =~ s/enc_conma/,/g;
    $self->{ad1} =~ s/enc_conma/,/g;
    $self->{ad2} =~ s/enc_conma/,/g;
    $self->{ad3} =~ s/enc_conma/,/g;
    $self->{parts} =~ s/enc_conma/,/g;

    $self->{ad1} =~ s/enc_crlf/\n/g;
    $self->{ad2} =~ s/enc_crlf/\n/g;
    $self->{ad3} =~ s/enc_crlf/\n/g;
    $self->{parts} =~ s/enc_crlf/\n/g;
}

# 更新
sub update {
    my $self = shift;
    my $result = 1;

    $self->{hpurl} =~ s/,/enc_conma/g; 
    $self->{username} =~ s/,/enc_conma/g; 
    $self->{ad1} =~ s/,/enc_conma/g; 
    $self->{ad2} =~ s/,/enc_conma/g; 
    $self->{ad3} =~ s/,/enc_conma/g; 
    $self->{parts} =~ s/,/enc_conma/g;

    $self->{ad1} =~ s/\r?\n/enc_crlf/g;
    $self->{ad2} =~ s/\r?\n/enc_crlf/g;
    $self->{ad3} =~ s/\r?\n/enc_crlf/g;
    $self->{parts} =~ s/\r?\n/enc_crlf/g;

    my $line = "$self->{userid},$self->{password},$self->{mailaddr},$self->{hpurl},";
    $line .= "$self->{username},$self->{auth},$self->{status},";
    $line .= "$self->{ad1},$self->{ad2},$self->{ad3},$self->{parts},";
    $line .= "$self->{feedurl},$self->{amazonid},$self->{bookmarekid}\n";

    my $userfile = "$self->{system_dir}/user/$self->{userid}/profile.txt";
    open my $userfh, '>', $userfile;
    flock $userfh, LOCK_EX;
    print {$userfh} $line;
    flock $userfh, LOCK_UN;
    close $userfh;

    return $result;
}

# 有効なアカウントかどうかチェック(API用)
sub check_account {
    my $self = shift;
    my ($userid, $password) = @_;

    $self->load($userid);
    if (($password eq $self->{password}) && $self->{status}) {
        return 1;
    }
    return 0;
}

# 有効な新規ユーザーIDかどうかチェック
sub check_valid {
    my $self = shift;
    my $userid = shift;

    my $userfile = "$self->{system_dir}/user/$userid/profile.txt";
    if (-f $userfile) {
        return 0;
    }
    return 1;
}

# 管理者権限の有無をチェック
sub is_admin {
    my $self = shift;
    my ($userid) = @_;

    # ユーザーデータをロード
    $self->load($userid);
    if (($self->{auth} == 0) && $self->{status}) {
        return 1;
    }
    return 0;
}

# 編集者権限の有無をチェック
sub is_editor {
    my $self = shift;
    my ($userid) = @_;

    # ユーザーデータをロード
    $self->load($userid);
    if (($self->{auth} == 1) && $self->{status}) {
        return 1;
    }
    return 0;
}

# ユーザー認証"OK"の場合クッキーに使用するためのセッションIDを返す
sub login {
    my $self = shift;
    my ($userid, $password, $ipaddr) = @_;
    my $sessionid = 0;

    # ユーザーデータをロード
    $self->load($userid);

    if (($password eq $self->{password}) && $self->{status}) {

        # 10000 ～ 99999 のセッションIDを生成
        my $sessionfile;
        while (1) {
            $sessionid = int(rand(89999)) + 10000;
            $sessionfile = "$self->{system_dir}/session/$sessionid.txt";
            last if (!(-f $sessionfile));
        }

        # セッションファイルを作成
        open my $sessionfh, '>', $sessionfile;
        flock $sessionfh, LOCK_EX;
        print {$sessionfh} "$userid,$ipaddr\n";
        flock $sessionfh, LOCK_UN;
        close $sessionfh;

        # ファイルのパーミッションを変更
        chmod 0766, $sessionfile;
    }

    return $sessionid;
}

# ログアウト(セッションの明示的な終了)
sub logout {
    my $self = shift;
    my $sessionid = shift;

    my $sessionfile = "$self->{system_dir}/session/$sessionid.txt";
    unlink $sessionfile;
}

# セッションが有効かチェックする
sub check_session {
    my $self = shift;
    my $sessionid = shift;	# クッキーのセッションID
    my $userid = '';

    my $sessionfile = "$self->{system_dir}/session/$sessionid.txt";

    if (-f $sessionfile) { # ファイルが存在する場合
        open my $sessionfh, '<', $sessionfile;
        my $data = <$sessionfh>;
        chop($data);
        ($userid) = (split(/\,/, $data))[0];
        close $sessionfh;
    }

    return $userid;
}

1;
# End of Lib::User.pm
