// 極楽画像計測（Gokuraku_measure）用可視化プログラム(Gokuraku_visualize)
// Created by Tatsuya Shirai
// National Institute of Technology, Suzuka college
// Mechanical Department
//
// Ver. 1.0 : 2022.06.08
// Ver. 2.2 : チラツキの防止，静止画像の種類を変更可能に．Define_stickの指定なし時にscaleが有効になっていなかった．visualizer -> visualize
// Ver. 3.0 : 2023.03.02 : クリックしたデータ数に加えてスキップ数もmerged.txtに含まれるが無視する，メニューの色分け
// Ver. 3.4 : 2023.03.20 : クイックメジャーモードの追加，言語パック対応
// Ver. 3.4.1 : 2023.03.04 : クイックメジャーのショートメッセージ表示にΔx, Δyを追加，桁数を揃えて表示がバタつかないようにする．
// Ver. 3.5 : カラーピッカー機能追加

Data               data;
CurrentImage       ci;
ImportFile         im_file;
ExportFile         ex_file;
MenuScreen         menuScreen;
Get_string         gs;          // 言語パック

final boolean Quick_measure_mode = true;

final int Scr_w = 800;
final int Scr_h = 760;

enum Menu_status {main, setting, sizeinputing, delayinputing, linewidthinputing, filenameinputing, calibrationinputing, calunitinputing};
Menu_status menu_status;

void setup() {
  data          = new Data();
  im_file       = new ImportFile();
  ci            = new CurrentImage();
  ex_file       = new ExportFile();
  shortMessage  = new ShortMessage();
  inputInteger  = new InputInteger();
  inputFloat    = new InputFloat();    // 使わないのだが，初期化しないとNull pointer assignmentが発生する 
  inputFilename = new InputFilename();
  inputString   = new InputString();
  keyStatus     = new KeyStatus();
  menuScreen    = new MenuScreen(8, 48, 150, 40);
  menu_status   = Menu_status.main;
  gs            = new Get_string(Lang);
  set_strings();  // 言語パックの読み込み

  //画面位置を変更する
  surface.setLocation(Init_PosX, Init_PosY);

  // 日本語フォントを使用する
  PFont font = createFont(JapaneseFont, 50);
  textFont(font);

  drop_init();
}

void draw(){
  menuScreen.reset();
  shortMessage.set_autoclear(true);  // 再生中以外はショートメッセージの自動消去を有効にする

  noStroke();
  if (ci.preview.playing != PreviewMode.stop) {
    menuScreen.fill_color(menuScreen.thema.picbg);
    ci.play(data);
    menuScreen.y = height - 16;
    shortMessage.set_autoclear(false);  // 再生中はショートメッセージの自動消去を無効にする

    // Quick measureモード
    if (ci.preview.playing == PreviewMode.pause) {
      ci.qm.plot(ci.qm.guideline);
      // マウス座標のリアルタイム表示
      if (ci.qm.mousepoint_realtime) ci.qm.mousepoint_realtime_display(ci.img);
    }
  } else {
    // 画面消去
    surface.setSize(Scr_w, Scr_h);
    menuScreen.cls();
//  background(72, 72, 72);
  
    menuScreen.display_title("Gokuraku visualize");
  
    // メニュー表示
    menuScreen.text_color(TextColor.normal);
    if (menu_status == Menu_status.sizeinputing) {
      menuScreen.display_keyInputPrompt(get_str("plot_size"));
    } else if (menu_status == Menu_status.delayinputing) {
      menuScreen.display_keyInputPrompt(get_str("delayperimage"));
    } else if (menu_status == Menu_status.linewidthinputing) {
      menuScreen.display_keyInputPrompt(get_str("line_width"));
    } else if (menu_status == Menu_status.filenameinputing) {
      menuScreen.display_keyInputPrompt(get_str("image_filename"));
    } else if (menu_status == Menu_status.calibrationinputing) {
      menuScreen.display_keyInputPrompt(get_str("calibration_coefficient"));
    } else if (menu_status == Menu_status.calunitinputing) {
      menuScreen.display_keyInputPrompt(get_str("unit"));
    } else if (menu_status == Menu_status.main) {
      String str;
      menuScreen.dx = 150;
      menuScreen.text_color(TextColor.input);
      menuScreen.display_menu("[I]", get_str("importamergeddatafilefromfolder"));
      menuScreen.display_menu(get_str("right_click"), get_str("importamergeddatafile"));
      menuScreen.text_color(TextColor.option);
      menuScreen.display_menu("[S]", get_str("open_submenu"));
      menuScreen.display_menu("[D]", get_str("showdatalist"));
      menuScreen.display_menu("[L]", get_str("import_define_stick", (ci.stick.define_stick.length == 0 ? "none" : "defined")));
      menuScreen.text_color(TextColor.normal);
      menuScreen.display_menu("[P]", get_str("previewimages", "ESC:" + get_str("halt") + " / " + get_str("SPC") + ":" + get_str("pause")));
      menuScreen.display_menu("", "  (←, →, +SHIFT, +CTRL)");
      menuScreen.display_menu("[F]", get_str("selectexportfolder"));
      menuScreen.display_menu("[E]", get_str("exportimagefiles"));
      menuScreen.text_color(TextColor.option);
      if (ci.qm.is_colorpicker()) str = get_str("colorpicker");
        else                      str = get_str("quickmeasure");
      menuScreen.display_menu("[M]", get_str("change_mode",      str));
      menuScreen.display_menu("[G]", get_str("toggleguideline", ci.qm.guideline));
      menuScreen.display_menu("[R]", get_str("togglerealtimedisplay", ci.qm.mousepoint_realtime));
      menuScreen.display_menu("[ESC]", get_str("exit"));

      menuScreen.y += 16;
      menuScreen.display_note(get_str("path") + " : " + ex_file.fullpathname);
      str = get_str("imported") + " ";
      if (data.num > 0) str += data.num + " " + get_str("files");
      else              str += get_str("nodata");
      menuScreen.display_note(str);
      menuScreen.y += menuScreen.dy;
    } else if (menu_status == Menu_status.setting) {
      menuScreen.dx = 64;
      menuScreen.display_menu("[1]", get_str("changebackgroundcolor", color2str(BG_color[ci.bg_color][0], BG_color[ci.bg_color][1], BG_color[ci.bg_color][2])));
      menuScreen.display_menu("[2]", get_str("changeplottype", ci.plotMark.get_shape()));
      menuScreen.display_menu("[3]", get_str("changeplotcolor", ci.plotMark.color_str()));
      menuScreen.display_menu("[4]", get_str("inputplotsize", ci.plotMark.size));
      menuScreen.display_menu("[5]", get_str("inputlinewidth", ci.plotMark.lineWidth)); 
      menuScreen.display_menu("[6]", get_str("toggledisplaylinesegment", ci.stick.enable_stick));
      menuScreen.display_menu("[7]", get_str("inputcalibrationparam", ci.qm.calibration) + ":" + get_str("00ispixel"));
      menuScreen.display_menu("[8]", get_str("inputunitstring", "[" + ci.qm.cal_unit + "]"));
      menuScreen.text_color(TextColor.input);
      menuScreen.display_menu("[I]", get_str("displayimagewithplot", ci.preview.enable_image));
      menuScreen.display_menu("[S]", get_str("changewindowsizeaccordingtoscale", ci.enable_scale));
      menuScreen.display_menu("[C]", get_str("donotconvertinputdatabyscale", im_file.noConversion));
      menuScreen.text_color(TextColor.normal);
      menuScreen.display_menu("[D]", get_str("inputdelayperimage", nf(ci.preview.delay_per_image) + "[ms], > 1)"));
      menuScreen.display_menu("[N]", get_str("inputimagefilename", ex_file.image_filename));
      menuScreen.display_menu("[E]", get_str("changeimagetype", Image_type_ext[ex_file.image_type]));
      menuScreen.text_color(TextColor.option);
      menuScreen.display_menu("[V]", get_str("toggleguithema",  menuScreen.thema.dark));
      menuScreen.display_menu("[Q]", get_str("quit_submenu"));
    }
  }
  shortMessage.display_short_message(menuScreen.x, menuScreen.y);
}

void mousePressed()
{
  if (mouseButton == RIGHT) {    // 右クリック時
    if (ci.img == null) {
      selectInput(get_str("selectacombinedfile"), "fileSelected");
    } else {
      if (ci.preview.playing == PreviewMode.pause) {
        // Quick measureモード
        if ((ci.qm.status == 0 || ci.qm.status == 1)) {
          ci.qm.clicked(mouseX, mouseY, true);
        }
      }
    }
  } else if (mouseButton == LEFT) {  // 左クリック時
    if (ci.img != null) {
      if (ci.preview.playing == PreviewMode.pause) ci.qm.clicked(mouseX, mouseY, false);
    }
  }
  mouseButton = 0; // なぜか誤動作して，右クリックしても左クリックが反応する場合があるので．
}

void keyReleased()
{
  keyStatus.release(keyCode);
}

void keyPressed()
{
  keyStatus.push(keyCode);
  File   fp;
  int    num;
  String str;
  if (menu_status == Menu_status.sizeinputing) {
    // plot_size を修正時
    if (inputInteger.keyin(key) == false) {
      if (inputInteger.halt != true) {
        if ((num = inputInteger.value) >= 1) ci.plotMark.size = num;
        shortMessage.set_message("Change plot size to " + ci.plotMark.size);
      }        
      menu_status = Menu_status.setting;
      key = 0;
      return;
    }
  } else if (menu_status == Menu_status.delayinputing) {
    // delay_per_image を修正時
    if (inputInteger.keyin(key) == false) {
      if (inputInteger.halt != true) {
        if ((num = inputInteger.value) >= 2) ci.preview.delay_per_image = num;
        shortMessage.set_message("Change delay per image to " + ci.preview.delay_per_image + "[ms]");
      }        
      menu_status = Menu_status.setting;
      key = 0;
      return;
    }
  } else if (menu_status == Menu_status.linewidthinputing) {
    // lineWidth を修正時
    if (inputInteger.keyin(key) == false) {
      if (inputInteger.halt != true) {
        if ((num = inputInteger.value) >= 1) ci.plotMark.lineWidth = num;
        shortMessage.set_message("Change line width to " + ci.plotMark.lineWidth);
      }        
      menu_status = Menu_status.setting;
      key = 0;
      return;
    }
  } else if (menu_status == Menu_status.filenameinputing) {
    // 画像ファイルのファイル名(ex_file.image_filename） を修正時
    if (inputFilename.keyin(key) == false) {
      if (inputFilename.halt != true) {
        if ((str = inputFilename.value).length() > 0) {
          ex_file.image_filename = str;
          ex_file.set_export_information(null);
        }        
        shortMessage.set_message("Change image filename to " + ex_file.image_filename);
      }        
      menu_status = Menu_status.setting;
      key = 0;
      return;
    }
  } else if (menu_status == Menu_status.calibrationinputing) {  // calibration を修正時
    if (inputFloat.keyin(key) == false) {
      if (inputFloat.halt != true) {
        ci.qm.calibration = float(inputFloat.value);
        shortMessage.set_message("Change calibration to " + ci.qm.calibration);
      }        
      menu_status = Menu_status.setting;
      key = 0;
      return;
    }
  } else if (menu_status == Menu_status.calunitinputing) {  // cal_unit を修正時
    if (inputString.keyin(key) == false) {
      if (inputString.halt != true) {
        if ((str = inputString.value).length() >= 0) ci.qm.cal_unit = str;
        shortMessage.set_message("Change calibration unit to [" + ci.qm.cal_unit + "]");
      }        
      menu_status = Menu_status.setting;
      key = 0;
      return;
    }
  } else if (menu_status == Menu_status.main) {
    switch (keyCode) {
      case ESC :
        if (ci.preview.playing != PreviewMode.stop) {
          if (ci.preview.export_enable) {
            shortMessage.set_message("Halt: exported image file : " + (ci.preview.count) + " files");
          }
          ci.preview.stop_preview();
          key = 0;
        }
        break;
      case RIGHT :  // プレビューを一時停止中にコマを移動（進む）
        if ((ci.preview.playing == PreviewMode.pause) && (ci.preview.export_enable == false)) {
          if (keyStatus.shift )    ci.preview.last_image();    // SHIFT同時押しで最終コマへ
          else if (keyStatus.ctrl) ci.preview.next_image(Skip_frame_plus);  // CTRL同時押しでコマを進める
          else                     ci.preview.next_image();
        }
        break;
      case LEFT :   // プレビューを一時停止中にコマを移動（戻る）
        if ((ci.preview.playing == PreviewMode.pause) && (ci.preview.export_enable == false)) {
          if (keyStatus.shift)     ci.preview.first_image();   // SHIFT同時押しで最初のコマへ
          else if (keyStatus.ctrl) ci.preview.prev_image(Skip_frame_minus);  // CTRL同時押しでコマを戻す
          else                     ci.preview.prev_image();
        }
        break;
      case ' ' :
        if (ci.preview.playing == PreviewMode.playing) {       // 再生中ならば一時停止
          ci.preview.playing = PreviewMode.pause;
        } else if (ci.preview.playing == PreviewMode.pause) {  // 一時停止中ならば再生
          ci.preview.playing = PreviewMode.playing;
        }
        break;
      case 'I' : 
        // 結合データファイルのフォルダーからの読み込み
        fp = new File(im_file.import_folder);
        selectFolder(get_str("selectaimportfolder"), "imfolderSelected", fp);
        break;
      case 'S' :
        // 設定のサブメニューに移動
        menu_status = Menu_status.setting;
        break;
      case 'D' :
        data.show_data_list();
        break;
      case 'L' :
        fp = new File(im_file.import_folder);
        selectInput(get_str("selectadefinestickfile"), "stickSelected", fp);
        break;
      case 'P' :
        ci.preview.start_preview();
        break;
      case 'F' :
        // エクスポートするフォルダーの選択
        fp = new File(ex_file.export_folder);
        selectFolder("Select a folder to export:", "folderSelected", fp);
        break;
      case 'E' : 
        // 画像ファイルの出力
        ex_file.start_export();
        break;
      case 'M' :
        // 計測モードの切り替え（クイックメジャー ←→ カラーピッカー）
        String s = "Change measure mode to ";
        ci.qm.colorpicker = ci.qm.colorpicker ? false : true; 
        if (ci.qm.is_colorpicker())        s += "Color picker";
         else                              s += "Quick measure";
        s += " mode";
        shortMessage.set_message(s);
        break;
      case 'G' :
        // ガイドライン表示のON/OFF
        ci.qm.switch_guide_line();
        shortMessage.set_message("Toggled guide line : " + ci.qm.guideline);
        break;
      case 'R' :
        // リアルタイム表示のON/OFF
        ci.qm.switch_mousepoint_realtime();
        shortMessage.set_message("Toggled mousepoint realtime : " + ci.qm.mousepoint_realtime);
        break;
    }
  } else if (menu_status == Menu_status.setting) {
    switch (keyCode) {
      case '1' :
      case 97  :
        ci.change_bg();
        shortMessage.set_message("Change background color to " + color2str(BG_color[ci.bg_color][0], BG_color[ci.bg_color][1], BG_color[ci.bg_color][2]));
        break;
      case '2' :
      case 98  :
        ci.plotMark.change_shape();
        shortMessage.set_message("Change plot type to " + ci.plotMark.get_shape());
        break;
      case '3' :
      case 99  :
        ci.plotMark.change_color();
        shortMessage.set_message("Change plot color to " + ci.plotMark.color_str());
        break;
      case '4' :
      case 100 :
        inputInteger.start(ci.plotMark.size);
        menu_status = Menu_status.sizeinputing;
        break;
      case '5' :
      case 101 :
        inputInteger.start(ci.plotMark.lineWidth);
        menu_status = Menu_status.linewidthinputing;
        break;
      case '6' :
      case 102 :
        ci.stick.switch_enable_stick();
        shortMessage.set_message("Toggled enable line segment : " + ci.stick.enable_stick);
        break;
      case '7' :
      case 103 :
        inputFloat.start(nf(ci.qm.calibration));
        menu_status = Menu_status.calibrationinputing;
        break;
      case '8' :
      case 104 :
        inputString.start(ci.qm.cal_unit);
        menu_status = Menu_status.calunitinputing;
        break;
      case 'I' :
        ci.preview.switch_enable_image();
        shortMessage.set_message("Display image with plot : " + ci.preview.enable_image);
        break;
      case 'S' :
        ci.switch_enable_scale();
        shortMessage.set_message("Change window size according to scale : " + ci.enable_scale);
        break;
      case 'C' :
        im_file.switch_noConversion();
        shortMessage.set_message("Do not convert input data by scale :" + im_file.noConversion);
        break;
      case 'D' :
        inputInteger.start(ci.preview.delay_per_image);
        menu_status = Menu_status.delayinputing;
        break;
      case 'N' :
        inputFilename.start(ex_file.image_filename);
        menu_status = Menu_status.filenameinputing;
        break;
      case 'E' :
        ex_file.change_image_type();
        shortMessage.set_message("Change image type to " + Image_type_ext[ex_file.image_type]);
        break;
      case 'V' :
        menuScreen.thema.switch_thema();
        shortMessage.set_message("Toggled thema to " + (menuScreen.thema.dark ? get_str("darkthema") : get_str("lightthema")));
        break;
      case 'Q' :
        menu_status = Menu_status.main;
        break;
    }
    key = 0;
  }
}

// 結合ファイル選択後の処理
void fileSelected(File selection) 
{
  if (selection == null) return;
  im_file.read(selection.getAbsolutePath());
  im_file.import_folder = selection.getAbsolutePath();
}
// Stick定義ファイル選択後の処理
void stickSelected(File selection) 
{
  if (selection == null) {
    ci.stick.clearDefineStick();
    return;
  }
  ci.stick.readDefineStick(selection.getAbsolutePath());
}

// インポートフォルダー選択後の処理
void imfolderSelected(File selection) {
  if (selection == null) return;
  im_file.import_folder = selection.getAbsolutePath();
  im_file.open_files(selection.listFiles());
}
// エクスポートするフォルダーの選択
void folderSelected(File selection) {
  if (selection == null) return;  // キャンセル時
  ex_file.set_export_information(selection.getAbsolutePath());
  shortMessage.set_message("User select folder = " + ex_file.export_folder);
}

//// ドラッグ＆ドロップ関係
// ドロップされたファイルの処理
void fileSelected(List<File> fs) {
  File [] fileList = {};
  for(File f:fs){ //<>//
    // ドラッグ＆ドロップされたリストの中にフォルダーが含まれていた場合は，その層までは自動的に読み込む
    if (f.isDirectory()) {
      for (File sf:f.listFiles()) {
        if (sf.isFile()) fileList = (File [])append(fileList, sf);  // ListからArrayへ変更
      }
    }
    fileList = (File [])append(fileList, f);  // ListからArrayへ変更
  }
  if (fileList.length == 0) return;
  im_file.open_files(fileList);
}
