// 極楽画像計測（Gokuraku_measure）用データファイル結合プログラム(Gokuraku_merge)
// Created by Tatsuya Shirai
// National Institute of Technology, Suzuka college
// Mechanical Department
//
// Ver. 1.0 : 2022.06.08
// Ver. 2.0 : テキストファイル名の代わりに画像ファイル名を記録する（パス無し）
// Ver. 2.2 : データを読み込まずにエクスポートフォルダーを設定しよとするとバグる．Ｉコマンドをファイル読み込みではなくフォルダーからの読み込みに変更
//            ソーティング機能を実装，dataが単方向リストなのを配列に変更する．
// Ver. 3.0 : 2023.03.02 : クリックしたデータ数に加えてスキップ数を出力，メニューの色分け
// Ver. 3.4 : 2023.03.20 : 言語パック対応

// commonの互換性のためだけに宣言（不使用）
final boolean Quick_measure_mode  = false;              // 起動時の測定モードをQuick measureとする場合はtrueに変更
final boolean Colorpicker_mode    = false;              // 起動時の測定モードをカラーピッカーモードとする場合はtrueに変更(クイックメジャーよりも優先）
final float   Calibration         = 0.0;                // 単位ピクセル当たりの長さ．0.0の時は無効（pixel）．あくまでQuick measureの距離表示のみ
final String  Cal_unit            = "mm";               // 距離表示の単位．単なる文字列なので，m, cm, inchなど，なんでもＯＫ 
final boolean Guide_line          = true;               // ガイドライン表示（通常，QuickMeasure共通）
final boolean Mousepoint_realtime = true;               // マウスポインターのx, y座標をリアルタイム表示して欲しくない場合はfalseに変更

Data               data;
ImportFile         im_file;
ExportFile         ex_file;
Sorting            sorting;
MenuScreen         menuScreen;
Get_string         gs;          // 言語パック

final int Scr_w = 800;
final int Scr_h = 460;

enum Menu_status {main, sorting};
Menu_status menu_status;

void setup() {
  data          = new Data();
  sorting       = new Sorting();
  im_file       = new ImportFile();
  ex_file       = new ExportFile();
  shortMessage  = new ShortMessage();
  menuScreen    = new MenuScreen(16, 40, 150, 40);
  menu_status   = Menu_status.main;
  ci            = new CurrentImage(); // 互換性
  gs            = new Get_string(Lang);
  set_strings();  // 言語パックの読み込み

  // 画面位置を変更する
  surface.setSize(Scr_w, Scr_h);
  surface.setLocation(Init_PosX, Init_PosY);

  // 日本語フォントを使用する
  PFont font = createFont(JapaneseFont, 50);
  textFont(font);

  drop_init();
}

void draw(){
  menuScreen.reset();
  
  // 画面消去
  menuScreen.cls();

  // タイトル表示
  menuScreen.display_title("Gokuraku merge");

  // メニュー表示
  textSize(24);
  menuScreen.text_color(TextColor.normal);
  if (menu_status == Menu_status.main) {
    menuScreen.dx = 150;
    menuScreen.text_color(TextColor.input);
    menuScreen.display_menu("[I]", get_str("importmeasureddatafilesfromfolder"));
    menuScreen.display_menu(get_str("right_click"), get_str("importamesureddatafile"));
    menuScreen.text_color(TextColor.option);
    menuScreen.display_menu("[C]", get_str("cleardata"));
    menuScreen.display_menu("[S]", get_str("open_submenu"));
    menuScreen.text_color(TextColor.normal);
    menuScreen.display_menu("[F]", get_str("selectexportfolder"));
    menuScreen.display_menu("[E]", get_str("exportmergeddatafile"));
    menuScreen.text_color(TextColor.option);
    menuScreen.display_menu("[ESC]", get_str("exit"));

    menuScreen.y += 16;
    String str = get_str("folder") + ": ";
    if (ex_file.export_folder == "") str += get_str("notselected");             
    else                             str += ex_file.export_folder;
    menuScreen.display_note(str);
    str = get_str("imported") + ": ";
    if (data.num > 0)                str += data.num + " " + get_str("files");
    else                             str += get_str("nofiles");
    menuScreen.display_note(str);
  } else if (menu_status == Menu_status.sorting) {
    menuScreen.dx = 64;
    menuScreen.text_color(TextColor.normal);
    menuScreen.display_menu("[N]", get_str("sortbyfilename"));
    menuScreen.display_menu("[T]", get_str("sortbytime"));
    menuScreen.text_color(TextColor.option);
    menuScreen.display_menu("[C]", get_str("donotconvertbyscale", im_file.noConversion));
    menuScreen.display_menu("[V]", get_str("toggleguithema",  menuScreen.thema.dark));
    menuScreen.display_menu("[Q]", get_str("quit_submenu")); 

    String str;
    str  = get_str("orderconditionbyfilename") + " : " + (sorting.checkByFilename() ? "OK" : "NG");
    str += " / line: " + (sorting.line < 0 ? get_str("nodata") : sorting.line + 1);
    menuScreen.display_note(str);
    str  = get_str("orderconditionbytime")     + " : " + (sorting.checkByTime()     ? "OK" : "NG");
    str += " / line: " + (sorting.line < 0 ? get_str("nodata") : sorting.line + 1);
    menuScreen.display_note(str);
  }
  menuScreen.y += menuScreen.dy;
  shortMessage.display_short_message(menuScreen.x, menuScreen.y);
}

void mousePressed()
{
  if (mouseButton == RIGHT) open_fileselector();
}

void keyPressed()
{
  File fp;
  if (menu_status == Menu_status.main) {
    switch (keyCode) {
      case 'I' :
        fp = new File(im_file.import_folder);
        selectFolder("Select a import folder:", "imfolderSelected", fp);
        break;
      case 'F' :
        // エクスポートするフォルダーの選択
        fp = new File(ex_file.export_folder);
        selectFolder("Select a export folder:", "exfolderSelected", fp);
        break;
      case 'C' : 
        // 全データ消去
        data.allclear();
        shortMessage.set_message("Clear all data");
        break;
      case 'S' :
        // ソーティングのサブメニューに移動
        sorting.refreshCheck();
        menu_status = Menu_status.sorting;
        break;
      case 'E' : 
        // 全データのファイルへの出力
        ex_file.export_alldata(data);
        break;
    }
  } else if (menu_status == Menu_status.sorting) {
    switch (keyCode) {
      case 'N' :
        if (data.num <= 0) break;
        sorting.sortByFilename();
        shortMessage.set_message("Sort by Filename: " + data.num + " data");
        break;
      case 'T' :
        if (data.num <= 0) break;
        sorting.sortByTime();
        shortMessage.set_message("Sort by Time: " + data.num + " data");
        break;
      case 'C' :
        im_file.noConversion = im_file.noConversion ? false : true;
        shortMessage.set_message("Change no conversion to " + im_file.noConversion);
        break;
      case 'V' :
        menuScreen.thema.switch_thema();
        shortMessage.set_message("Toggled thema to " + (menuScreen.thema.dark ? get_str("darkthema") : get_str("lightthema")));
        break;
      case 'Q' :
        menu_status = Menu_status.main;
        break;
    }
    key = 0;
  }
}

// ファイル選択ダイアログボックスの呼び出し
void open_fileselector()
{
  selectInput("Select a measured data file:", "fileSelected");
}
// ファイル選択後の処理
void fileSelected(File selection) 
{
  if (selection == null) return; //<>//
  im_file.read_and_store(selection.getAbsolutePath(), data);
  im_file.import_folder = selection.getAbsolutePath();
}
// インポートフォルダー選択後の処理
void imfolderSelected(File selection) {
  if (selection == null) return;
  im_file.import_folder = selection.getAbsolutePath();
  im_file.open_files(selection.listFiles());
}

// エクスポートするフォルダーの選択
void exfolderSelected(File selection) {
  if (selection == null) return;  // キャンセル時
  ex_file.set_export_folder(selection.getAbsolutePath());
  shortMessage.set_message("User select folder = " + ex_file.export_folder);
}

//// ドラッグ＆ドロップ関係
// 上記URL参照
// ドロップされたファイルの処理
void fileSelected(List<File> fs) {
  File [] fileList = {};
  for(File f:fs){
    // ドラッグ＆ドロップされたリストの中にフォルダーが含まれていた場合は，その層までは自動的に読み込む
    if (f.isDirectory()) {
      for (File sf:f.listFiles()) {
        if (sf.isFile()) fileList = (File [])append(fileList, sf);  // ListからArrayへ変更
      }
    }
    fileList = (File [])append(fileList, f);  // ListからArrayへ変更
  }
  if (fileList.length == 0) return;
  im_file.open_files(fileList);
}

// ライブラリー互換性のための宣言（mergeでは使用しない機能）
final int Define_stick[][] = {};
class Preview {
  boolean enable_scale = false;
  Preview() {
  }
}
class CurrentImage {
  boolean  enable_scale;
  Plot     plotMark;
  Preview  preview;
  PImage   img;
  CurrentImage() {
    enable_scale = false;
    plotMark     = new Plot();
    preview      = new Preview();
    img          = null;
  }
}
CurrentImage ci;
final int    Plot_size        = 5;                  // ターゲットマーカーのサイズ
final int    Plot_color[][]   = {{255,  80,  80},   // ターゲットマーカーの色 : 赤，白，黒 
                                 {255, 255, 255},
                                 {0, 0, 0}};  
