// 計測する画像に関するクラス
class CurrentImage {
  PImage        img;
  int           max_measure;              // 最大計測点数（この数値の数だけ計測が完了したら自動終了（次のファイルを選択），0の場合は意図的に終了するまで計測を続ける
  int           filter_no;                // -1 : なし，0 : GRAY, 1 : INVERT
  final boolean enable_scale = true;      // ライブラリ互換性のため（不使用）
  
  // クラス
  OneData      data;      // 計測データ
  Plot         plotMark;  // マーカー表示
  Stick        stick;     // 線分表示
  QuickMeasure qm;        // Quick measure
  
  // コンストラクター
  CurrentImage() {
    img                =  null;
    max_measure        =  Max_measure;
    filter_no          = -1;
    
    // プロットの初期化
    plotMark = new Plot();
    // 線分の初期化
    stick    = new Stick();
    // 計測データの初期化
    data     = new OneData();
    // Quick measure機能
    qm       = new QuickMeasure(plotMark);
    
  }
  // ファイルから読み込んだ画像を適用
  PImage loading(PImage img0, boolean reload) {
    // 計測データの初期化（倍率のみ保存：Ver.3.0以降）
    if (! reload) data.all_clear();

    img = img0;
    // フィルターが選択されている場合は先に適用する
    apply_filter();
    // 元画像のサイズを保存
    data.org_width  = img.width;
    data.org_height = img.height;
    // 画像を拡大する場合
    if (data.scale != 1.0) {
      img.resize((int)(img.width * data.scale), (int)(img.height * data.scale));
    }
//  surface.setSize(img.width, img.height + 40);
//  surface.setVisible(true); // Processing4.2でリサイズ後にキー操作その他を受け付けなくなる障害に対する無根拠な対策（効果あり）
    return img;
  }
  // 計測データの格納
  int measure(int x, int y) {
    // 画像外（画像の下のショートメッセージ領域）をクリックしてしまった場合
    if (x + y * img.width >= img.pixels.length) return data.num;
    
    boolean skip = false;
    if ((x == -1) && (y == -1)) skip = true;  // 計測スキップ時のフラグ
    if ((max_measure > 0) && (data.num >= max_measure)) return data.num;  // 異常な状態

    // 計測データの追加
    data.add_point(x, y);
    // クリップボードにコピー
    CopyToClipboard(ci.data.filename + "\t" + ci.data.num + "\t" + x + "\t" + y);

    if (! skip) data.get_color(img, x, y);
    if (skip) shortMessage.set_message(data.num + " : Skipped");
    else      shortMessage.set_message(data.num + " : (" + x + ", " + y + ")=" + data.col2str(data.num - 1));  
    if ((max_measure > 0) && (data.num >= max_measure)) {  // 最大計測数に達した場合
      ex_file.flush_data();
      if (im_file.folder_mode) {
        // フォルダーモードの場合の
        if (im_file.next_image() == null) im_file.quit_folder_mode (); // もう画像がフォルダー内に無いならば終了
      } else {
        // 単体画像モードの場合はファイル選択ダイアログボックスを表示
        open_fileselector();
      }
    }
    return data.num;
  }
  // 計測取り消し
  int back() {
    if (--data.num <= 0) data.points_clear();
    else                 data.delete_point();
    shortMessage.set_message("Back to " + (data.num + 1));
    return data.num;
  }
  // 計測のスキップ
  int skip() {
    return measure(-1, -1);
  }
  // 画像の拡大率変更
  void rescale(double rate) {
    double pre_scale = data.scale;
    if (rate == 0.0) {
      if (data.scale == Initial_scale) return;  // 初期値で変更なしの場合
      else data.scale = Initial_scale;          // 初期化
    } else {
      data.scale *= rate;
    }
    // 既に計測済みの場合はスケールを変換する
    if (data.num > 0) {
      int n;
      for (n = 0; n < data.num; n++) {
        data.px[n] = (int)(data.px[n] / pre_scale * data.scale);
        data.py[n] = (int)(data.py[n] / pre_scale * data.scale);
      }
    }
    shortMessage.set_message("Change scale " + floorN((float)pre_scale, 4) + " -> " + floorN((float)data.scale, 4));
    im_file.reload();  // 画像の再読み込み
  }
  // フィルターの変更
  void change_filter() {
    if (++filter_no >= filter_type.length) filter_no = -1;  //（-1はフィルターなし）
    if (ci.img != null) im_file.reload();
  }
  // フィルターの適用
  void apply_filter() {
    if (filter_no >= filter_type.length) filter_no = -1;  // 無いはずだが念のため（-1はフィルターなし）

    if (ci.img == null) return;
    if (filter_no >= 0) img.filter(filter_type[filter_no]);
  }
}

// ファイルの入力関係 //<>//
class ImportImageFile {
  String  fullpathname;            // 開いている画像ファイルのフルパス名
  boolean folder_mode;             // フォルダーモード時，true;
  String  folder_mode_folder;      // フォルダーモード時のフォルダー
  File[]  files;                   // フォルダーモード：ファイルリスト
  int     f_no;                    // フォルダーモード時の読みだし位置
  SortingFileList sortingFileList; // ファイルリスト選択時のリストのソーティング
  // コンストラクター
  ImportImageFile() {
    // フォルダーモード関係
    fullpathname       =  null;
    folder_mode        =  false;
    files              =  null;
    f_no               =  0;
    folder_mode_folder = "";
  }
  
  // 画像ファイルの読み込み
  PImage load(String path) {
    boolean reload = false;
    PImage img0;
    if (path == null) reload = true;
    if (! reload) fullpathname = path;
    if ((img0 = loadImage(fullpathname)) == null) return null;  // 読み込み失敗時

    // 読み込み完了
    File fp = new File(fullpathname);
    ci.data.filename = fp.getName();
    ci.qm.init(ci.data.filename);  // QuickMeasureを初期化
    img0 = ci.loading(img0, reload);
    if (reload != true) shortMessage.set_message("Loaded image: " + fullpathname + "(" + ci.data.org_width + "," + ci.data.org_height + ")=" + aspect_ratio(ci.data.org_width, ci.data.org_height));
    if ((Force_update == false) && (reload != true)) {
      // 計測済みデータが存在するならば読み込む
      ImportMeasuredFile imt_file;
      imt_file = new ImportMeasuredFile();
      OneData  onedata;
      if ((onedata = imt_file.read(fullpathname + Export_ext)) != null) {
        ci.data  = onedata;
/*
        for (int i = 0; i < onedata.num; i++) {
          onedata.px[i] = (int)(onedata.px[i] * onedata.scale);
          onedata.py[i] = (int)(onedata.py[i] * onedata.scale);
        }
*/
        reload();
/*
      } else {
        File fp = new File(fullpathname);
        ci.data.filename = fp.getName();
        ci.qm.init(ci.data.filename);                        // QuickMeasureを初期化
*/
      }
    }
    return img0;
  }
  // 再読み込み
  PImage reload() {
    if (fullpathname == null) return null;  // 異常な状態
    return load(null);
  }
  // ファイルリストに基づく連続処理
  void open_files(File [] f) {
    f_no  = 0;
    folder_mode = true;

    // ファイルリストのソーティング
    sortingFileList    = new SortingFileList(f, extensionListOfImage);
    files = sortingFileList.sort();

    // 計測中だったならば計測済みデータを書き出す
    ex_file.flush_data();
    // 次の画像を読み込む
    if (next_image(true) == null) quit_folder_mode(); // 次の画像ファイルが存在しなかった場合
  }
  // フォルダーモード
  void folderSelected(File selection) {
    if (selection == null) return;  // キャンセル時

    folder_mode_folder = selection.getAbsolutePath();
    shortMessage.set_message("User select folder = " + folder_mode_folder);
    open_files(selection.listFiles());
  }
  // 次の画像を表示（フォルダーモード）
  PImage next_image() {
    return next_image(false);
  }
  PImage next_image(boolean firsttime) {
    PImage ret = null;
    if (! firsttime) f_no++;  // 初回以外は最初にカウントアップする：次の画像だから
    for (; f_no < files.length; f_no++) {
      if (files[f_no].getPath().endsWith(Export_ext)) continue;  // データファイルは読み飛ばす（ワーニングが少しは減る）
      if (files[f_no].isDirectory())                  continue;  // フォルダーは読み飛ばす
      if ((ret = loadImage(files[f_no].getAbsolutePath())) != null) break;
    }
    if (ret == null) return null;  // 最後のファイルに到達（存在しない）
    ret = load(files[f_no].getAbsolutePath());
    return ret;
  }
  // 一つ前の画像を表示（リトライ）
  void retry_image() {
    if (folder_mode == true && f_no >= 1) {
      if (f_no == 1) {
        f_no = 0;
        next_image(true);
      } else {
        f_no -= 2;
        next_image(false);
      }
    }
  }
  // 一つ先の画像を表示（スキップする）
  void skip_image() {
    if (folder_mode == true && f_no <= files.length - 2) {
      next_image(false);
    }
  }
  // フォルダーモード終了
  void quit_folder_mode() {
    folder_mode = false;
    ci.img      = null;
  }
}

 //<>//
// ファイル出力関係
class ExportFile {
  String  dest_filename;
  PrintWriter output;
  
  // ファイル出力時の意図的な遅延
  boolean recording;
  int     delay_rectime;

  ExportFile() {
    dest_filename = "";
    output        = null;
  }
  // プレビューかつエクスポート開始
  void start_recording() {
    recording     = true;
    delay_rectime = millis();
  }
  // エクスポート中
  boolean recording_now() {
    if (millis() - delay_rectime > Delay_rectime) recording = false;  // 計測終了 → 次の動作までの遅延
    return recording;
  }
  // ファイルへ出力
  void export_data() {
    int     cnt = 0;
    if (ci.qm.enable) return;  // Quick measureモードの場合は記録済みデータを保護する（保存を行わない）
    dest_filename = im_file.fullpathname + Export_ext;  // 拡張子の分解は面倒くさいので，単純に拡張子を追加する
    output = createWriter(dest_filename);
    if (output != null) {
      File fp = new File(im_file.fullpathname);
      String dateString;
      dateString = year() + nf(month(),2) + nf(day(), 2) + nf(hour(), 2) + nf(minute(), 2) + nf(second(), 2);
      // 倍率，横幅，縦幅，ファイル名，計測日時，計測データ数，スキップ数
      output.print(ci.data.scale + "\t" + ci.data.org_width +"\t" + ci.data.org_height + "\t" + fp.getName() + "\t" + dateString); //<>//
      output.println("\t" + ci.data.num + "\t" + ci.data.countSkip());  // Ver. 3.0以降
      for (cnt = 0; cnt < ci.data.num; cnt++) {
        output.print(cnt + "\t" + ci.data.px[cnt] + "\t" + ci.data.py[cnt]);
        output.println("\t" + ci.data.col_R[cnt] + "\t" + ci.data.col_G[cnt] + "\t" + ci.data.col_B[cnt]);
      }
      output.flush();
      output.close();
      shortMessage.set_message("Completed exporting all data to " + dest_filename);
      // 配列の廃棄
      ci.data.all_clear();
      start_recording();  // 意図的な遅延タイマースタート
    } else shortMessage.set_message("Error: Can't output data to file =" + dest_filename);
  }
  // 計測済みデータの出力
  void flush_data() {
    if (ci.img != null && ci.data.num > 0) export_data();  // 中断して次のファイルを選択した際に，計測済みのデータを出力する
    ci.img = null;
  }
}
