/** includes **/
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <linux/ioctl.h>

/** prototypes **/
int parseArgument(char *data);
int parseNumber(char *data);

/*
 *   ioctl user parameter
 */
struct bc9_leds_onoff_t {
       int led1_onoff;
       int led2_onoff;
       int led3_onoff;
       int led4_onoff;
};

/*
 *  ioctl command mapping.
 */
#define BC9_LEDS_IOCTL_MAGIC 0xF7
#define BC9_LEDS_IOCTL_ONOFF _IOW(BC9_LEDS_IOCTL_MAGIC, 1, void *)
#define BC9_LEDS_IOCTL_READ  _IOR(BC9_LEDS_IOCTL_MAGIC, 2, int)

/**
 *   BC9LED : BC9 LED Check Program
 *
 */
int main(int argc, char **argv)
{
    struct bc9_leds_onoff_t  ledControl;

    memset(&ledControl, 0x00, sizeof(ledControl));

    if (argc != 5)
    {
        fprintf(stdout, "Usage : %s LED1 LED2 LED3 LED4 (LEDx:ON/OFF)\n", *argv);
        return (0);
    }

    /** OPEN DEVICE FILE **/
    int flags = O_RDWR;
    int fd = open("/dev/bc9_leds", O_RDWR);
    if (fd <= 0)
    {
        /** open error (but never occurred) **/
        fprintf(stderr, "OPEN ERR>open(%s,%d) %d (errno:%d)\n", "/dev/bc9_leds", O_RDWR, fd, errno);
        return (fd);
    }

    /** LED1 **/
    argv++;
    ledControl.led1_onoff = parseArgument(*argv);

    /** LED2 **/
    argv++;
    ledControl.led2_onoff = parseArgument(*argv);

    /** LED3 **/
    argv++;
    ledControl.led3_onoff = parseArgument(*argv);

    /** LED4 **/
    argv++;
    ledControl.led4_onoff = parseArgument(*argv);

    /** ISSUE IOCTL **/
    int ret = ioctl(fd, BC9_LEDS_IOCTL_ONOFF, &ledControl);
    fprintf(stdout, "INF>ioctl(%d, BC9_LEDS_IOCTL_ONOFF, &led) RET:%d(errno:%d)\n", fd, ret, errno);
    fprintf(stdout, "    LED1:%d LED2:%d LED3:%d LED4:%d\n\n", 
            ledControl.led1_onoff,
            ledControl.led2_onoff,
            ledControl.led3_onoff,
            ledControl.led4_onoff);

    ret = close(fd);
    if (ret < 0)
    {
        /** close error **/
        fprintf(stderr, "CLOSE ERR>%d (errno:%d)\n\n", ret, errno);
        return (ret);
    }
    return (0);
}

/*
 *
 */
int parseArgument(char *data)
{
    int number = 0;
    if ((data[0] >= '0')&&(data[0] <= '9'))
    {
        return (parseNumber(data));
    }

    if (strstr(data, "ON") != 0x00)
    { 
        return (1);
    }

    if (strstr(data, "on") != 0x00)
    { 
        return (1);
    }

    if (strstr(data, "On") != 0x00)
    { 
        return (1);
    }

    if (strstr(data, "OFF") != 0x00)
    { 
        return (0);
    }

    if (strstr(data, "off") != 0x00)
    { 
        return (0);
    }

    if (strstr(data, "Off") != 0x00)
    { 
        return (1);
    }

    return (number);
}

/*
 *
 */
int parseNumber(char *data)
{
    char *ptr;
    int number = 0;
    int radix = 10;

    /** CHECK RADIX **/
    if ((data[0] == '0')&&((data[1] == 'x')||(data[1] == 'X')))
    {
        ptr = &data[2];
        radix = 16;
    }
    else if (data[0] == '0')
    {
        ptr = &data[1];
        radix = 8;
    }
    else if ((data[0] >= '1')&&(data[0] <= '9'))
    {
        ptr = &data[0];
        radix = 10;
    }
    else
    {
        /* PARSE ERROR */
        return (-1);
    }

    while (*ptr != 0x00)
    {
        number = number * radix;
        switch (*ptr)
        {
          case '0':
            number = number + 0;
            break;

          case '1':
            number = number + 1;
            break;

          case '2':
            number = number + 2;
            break;

          case '3':
            number = number + 3;
            break;

          case '4':
            number = number + 4;
            break;

          case '5':
            number = number + 5;
            break;

          case '6':
            number = number + 6;
            break;

          case '7':
            number = number + 7;
            break;

          case '8':
            number = number + 8;
            break;

          case '9':
            number = number + 9;
            break;

          case 'a':
          case 'A':
            number = number + 10;
            break;

          case 'b':
          case 'B':
            number = number + 11;
            break;

          case 'c':
          case 'C':
            number = number + 12;
            break;

          case 'd':
          case 'D':
            number = number + 13;
            break;

          case 'e':
          case 'E':
            number = number + 14;
            break;

          case 'f':
          case 'F':
            number = number + 15;
            break;

          default:
            /* Wrong character */
            return (number);
            break;
        }  /**  switch (*ptr)  **/
        ptr++;
    }   /** while (*ptr != 0x00) **/
    return (number);
}
