use utf8;
use constant TRUE  => 1;
use constant FALSE => 0;
use URI::file;

my $gnDebug_module = 5;

sub gnGetgnIconPixbuf {
   # gnviewのアイコンイメージを取得する関数
   #
   # 引数: なし
   # 返り値: Gtk2::Gdk::Pixbuf(アイコンイメージ)
   my $gnIconTheme = Gtk2::IconTheme->get_default;
   my $gnIconPixbuf;
   $gnIconPixbuf = $gnIconTheme->load_icon($gnGnname, 48, 'no-svg');
   if($gnIconPixbuf) {
      if ($gnDebugFlag >4) { print "icon is set from fredesktop searchpath\n"; }
   }else{
         $gnIconTheme=Gtk2::StatusIcon->new_from_file($gnIconfn);
         $gnIconPixbuf=$gnIconTheme->get_pixbuf;
      if($gnIconPixbuf) {
         if ($gnDebugFlag>2) { print "icon is set from gnview's lib: $gnIconfn\n"; }
      }else{
         $gnIconTheme = Gtk2::IconTheme->get_default;
         $gnIconPixbuf = $gnIconTheme->load_icon("gtk-dialog-warning", 48, 'no-svg');
         if ($gnDebugFlag>2) { print "icon not found\n"; }
      }
   }
         return($gnIconPixbuf);
}

sub gnGetPersonalCfgPath {
   # 設定ファイルパスをチェック
   #
   # 引数:      なし
   # 返り値: 1: 設定ディレクトリへのフルパス
   
   my $gnCfgPath;
   my $gnChkPathOK = "false";
   if ($^O eq "MSWin32") {
      # "perl -V"の"osname"がMSWin32の場合は
      # 実行環境がWindowsであると判断
      $gnCfgPath = &gnGetEnvVal('APPDATA') . "\\gnview\\";
   }else{
      # Windowsでない場合はFreedesktop.org Specification準拠に従って
      # 設定ディレクトリパスを探索する。
      # ヒットした時点でreturn。
      # ただし環境変数HOMEは必ずあるという前提
      if(&gnGetEnvVal('XDG_CONFIG_HOME')) {
            $gnCfgPath = &gnGetEnvVal('XDG_CONFIG_HOME') . "\/gnview\/";
            if(-d $gnCfgPath) {
               return($gnCfgPath);
              }
      }else{
            $gnCfgPath = &gnGetEnvVal('HOME') . "\/.config\/gnview\/";
            if(-d $gnCfgPath) {
               return($gnCfgPath);
              }
      }
      
      # 0.8.12以前のバージョン互換のための処理
      $gnCfgPath = &gnGetEnvVal('HOME') . "\/.gnview\/";
      if(-d $gnCfgPath) {
            return($gnCfgPath);
      }

   }
      return($gnCfgPath);
   
}

sub gnGetTmpDir {
   # テンポラリディレクトリ取得用関数
   # Windowsでは環境変数から取得。それ以外(Linux/*NIXを想定)では決め打ちで/tmpを使用
   # 引数：なし
   # 返り値：文字列(ディレクトリのフルパス)
   
   if($^O eq 'MSWin32') {
      # "perl -V"の"osname"がMSWin32の場合は
      # 実行環境がWindowsであると判断し、環境変数TEMPからテンポラリディレクトリを取得
      # Windows以外(Linuxを想定)の場合は/tmpを決め打ち
      return(&gnGetEnvVal('TEMP'));
   }else{
      return("/tmp");
   }
   
}

sub gnGetCacheDir {
   # キャッシュ保管ディレクトリ取得用関数
   # Windowsでは環境変数から取得。それ以外(Linux/*NIXを想定)では決め打ちで/tmpを使用
   # 引数：なし
   # 返り値：文字列(ディレクトリのフルパス)
   
   if($^O eq 'MSWin32') {
      # "perl -V"の"osname"がMSWin32の場合は
      # 実行環境がWindowsであると判断し、環境変数TEMPからテンポラリディレクトリを取得
      # Windows以外(Linuxを想定)の場合は/tmpを決め打ち
      return(&gnGetEnvVal('TEMP'));
   }else{
      # Windowsでない場合はFreedesktop.org Specification準拠に従って
      # ライブラリパスを探索する。
      # ヒットした時点でreturn。
      my $gnCachePath;
      if(&gnGetEnvVal('XDG_CACHE_HOME')) {
         $gnCachePath = &gnGetEnvVal('XDG_CACHE_HOME') . "\/gnview\/";
         if(&gnCheckPath($gnCachePath)) {
            if($gnDebugFlag) { print "Your gnview cache dir is $gnCachePath from XDG_CACHE_HOME environment valiables\n";}
            return($gnCachePath);
         }
      }

      $gnCachePath = &gnGetEnvVal('HOME') . "\/.cache\/gnview\/";
      if(&gnCheckPath($gnCachePath)) {
         if($gnDebugFlag>2) { print "Your gnview cache dir is $gnCachePath from HOME environment valiables\n";}
         return($gnCachePath);
      }

      $gnCachePath = &gnGetEnvVal('HOME') . "\/.gnview\/cache\/";
      if(&gnCheckPath($gnCachePath)) {
         if($gnDebugFlag>2) { print "Your gnview cache dir is $gnCachePath. This dir is deprecated.\n";}
         return($gnCachePath);
      }
      
      $gnCachePath = "\/tmp\/";
      if(&gnCheckPath($gnCachePath)) {
         if($gnDebugFlag>2) { print "Your gnview cache dir is $gnCachePath. This dir is deprecated.\n";}
         return($gnCachePath);
      }
   }
   
}

sub gnOpenLocal {
   # open関数のラッパー関数(ローカルアクセス専用)
   # やること：
   #   1. 受け取った文字列(utf8フラグ付き)を環境変数LANGに従ってEncode::encodeする
   #   2. ファイルパスが存在するかどうかを確認する
   #   3. 書き込み用にopenされるのであればそのファイルをロックする
   #   4. ファイルをopenし、ファイルハンドルを返す
   #
   # 引数１：文字列(ファイルパス。UTF-8フラグ付き)
   # 引数２：文字列(openする種別。"r" = read, "w" = Overwrite, "a" = append)
   # 返り値：成功の場合はファイルハンドル、失敗の場合はundef
   my $fpath    = $_[0];
   my $flg      = $_[1];
   my $flgN = "";
   my $fpathN = &gnFnEncode($fpath);
   
   if($flg eq "r") {
      if(!(&gnCheckPath($fpath))) {
         print STDERR "File not found: $fpath\n";
         return(undef);
      }
   }
   
   my $fh;
   
   if($flg eq "r") {
       if(open($fh, "$fpathN")) {
          $gnFH{$fpath} = $fh;
          if ($main::gnDebugFlag>2) { print STDERR "File open for read succeed: ${fpathN}\n"; }
          return($gnFH{$fpath});
       }else{
          print STDERR "File open for read failed: ${fpathN}\nReason: $!\n";
       }
   }elsif($flg eq "w") {
       if(open($fh, ">$fpathN")) {
          if(!(flock($fh, LOCK_EX))) {
             print STDERR "File lock failed\(but operation continues...\): ${fpathN}\nReason: $!\n";
          }
          if ($main::gnDebugFlag>2) { print STDERR "File open for write succeed: ${fpathN}\n"; }
          $gnFH{$fpath} = $fh;
          return($gnFH{$fpath});
       }else{
          print STDERR "File open for write failed: ${fpathN}\nReason: $!\n";
       }
   }elsif($flg eq "a") {
       if(open($fh, ">>$fpathN")) {
          if(!(flock($fh, LOCK_EX))) {
             print STDERR "File lock failed\(but operation continues...\): ${fpathN}\nReason: $!\n";
          }
          if ($main::gnDebugFlag>2) { print STDERR "File open for append succeed: ${fpathN}\n"; }
          $gnFH{$fpath} = $fh;
          return($gnFH{$fpath});
       }else{
          print STDERR "File open for append failed: ${fpathN}\nReason: $!\n";
       }
   }else{
      print STDERR "Invalid flag is set: ${fpathN}\n";
      return(undef);
   }
   
}

sub gnCloseLocal {
   # close関数のラッパー関数(ローカルアクセス専用)
   # やること：
   #   1. 受け取った文字列(utf8フラグ付き)を環境変数LANGに従ってEncode::encodeする
   #   2. ファイルパス、開いているファイルハンドルが存在するかどうかを確認する
   #   3. そのファイルをクローズし、ファイルハンドルを管理配列から削除する
   #
   # 引数１：文字列(ファイルパス。UTF-8フラグ付き)
   # 返り値：成功の場合は0以外、失敗の場合は0が返る
   my $fn = $_[0];
   my $fnN = &gnFnEncode($fn);
   
   if(!(&gnCheckPath($fn))) {
      print STDERR "File not found: ${fnN}\n";
      return(0);
   }
   if(!(exists($gnFH{$fn}))) {
      print STDERR "No filehandle associated with: ${fnN}\n";
      return(0);
   }
   
   if(close($gnFH{$fn})) {
       delete($gnFH{$fn});
       if ($main::gnDebugFlag>2) { print STDERR "File close succeed: ${fnN}\n"; }
       return(1);
   }else{
      print STDERR "File close failed: ${fnN}\n";
      return(0);
   }
}

sub gnCheckPath {
   # ファイルやディレクトリが存在するかどうかチェックする関数
   #
   # 引数１：文字列(ファイルパス, utf8フラグ付きを想定)
   # 返り値：文字列(ない=0、ファイル=1、ディレクトリ=2、その他=3)
   my $path = $_[0];
   my $pathN = &gnFnEncode($path);
   if(!($path)) {
      if ($main::gnDebugFlag>2) { print STDERR "gnCheckPath NOT Found: $pathN\n"; }
      return(0);
   }
   if(-e $pathN) {
      if(-f $pathN) {
         if ($main::gnDebugFlag>2) { print STDERR "gnCheckPath Found\(Simple File\): $pathN\n"; }
         return(1);
      }elsif(-d $pathN) {
         if ($main::gnDebugFlag>2) { print STDERR "gnCheckPath Found\(Directory\): $pathN\n"; }
         return(2);
      }else{
         if ($main::gnDebugFlag>2) { print STDERR "gnCheckPath Found\(Unknown File\): $pathN\n"; }
         return(3);
      }
   }
}

sub gnMakeDir {
   # mkpath関数のラッパー関数(ローカルアクセス専用)
   # やること：
   #   1. 受け取った文字列(utf8フラグ付き)を環境変数LANGに従ってEncode::encodeする
   #   2. ファイルパスが存在するかどうかを確認する
   #   3. 存在しなければmkpathする
   #   4. パーミッション指定があればそれを、なければデフォルトのパーミッションをセットする
   #
   # 引数１：文字列(ファイルパス。UTF-8フラグ付き)
   # 引数２：文字列(パーミッション。書式はFile::Pathと同じ。任意。)
   # 返り値：指定したディレクトリは既に存在する=-1、それ以外の失敗=0、成功=1
   my $path = $_[0];
   my $perm;
   if($_[1]) {
      $perm = $_[1];
   }else{
      $perm = 0711;
   }
   my $pathN = &gnFnEncode($path);
   
   my $perr;
   if(!(&gnCheckPath($path))) {
      mkpath(( $pathN ), { verbose => 1, mode => $perm, error => \$perr});
      
      my $flg = 0;
      foreach my $diag (@$perr) {
         my ($errfile, $errstr) = each %$diag;
         if($errfile ne '') {
            $flg = 1;
            print STDERR "mkdir failed reason: $errfile\nReason: $errstr\n";
          }
       }
       if($flg) {
          return(0);
       }else{
          if ($main::gnDebugFlag>2) { print STDERR "gnMakeDir success: $pathN\n"; }
          return(1);
       }
   }else{
      print STDERR "mkdir failed: $pathN\nReason: Directory already exists\n";
      return(-1);
   }
   
}

sub gnFCopy {
   # File::Copyモジュールのcopy関数のラッパー関数
   # やること：
   #   1. 受け取った文字列(utf8フラグ付き)を環境変数LANGに従ってEncode::encodeする
   #   2. コピー元のファイルパスが存在するかどうかを確認する
   #   3. 存在したらコピー元をコピー先にコピーする
   #
   # 引数１：文字列(ファイルパス。UTF-8フラグ付き)
   # 引数２：文字列(ファイルパス。UTF-8フラグ付き)
   # 返り値：失敗=0、成功=1
   my $from = $_[0];
   my $to = $_[1];
   
   my $fromN = &gnFnEncode($from);
   my $toN = &gnFnEncode($to);

   if(!(&gnCheckPath($from))) {
      print STDERR "gnFCopy failed: $fromN\nReason: no source file\n";
      return(0);
   }
   
   if(copy($fromN, $toN)) {
      if ($main::gnDebugFlag>2) { print STDERR "gnFCopy success: ${fromN} \=\> ${toN}\n"; }
      return(1);
   }else{
      print STDERR "gnFCopy failed: Source Filename: ${fromN}\nDest Filename: ${toN}\nreason: $!\n";
      return(0);
   }
   
}

sub gnFMove {
   # File::Copyモジュールのcopy関数を使用したmove関数の独自実装
   # ファイルシステムを跨いだmoveができる
   # やること：
   #   1. 受け取った文字列(utf8フラグ付き)を環境変数LANGに従ってEncode::encodeする
   #   2. 移動元を移動先にコピーする
   #   3. 成功したら移動元を削除する
   #
   # 引数１：文字列(ファイルパス。UTF-8フラグ付き)
   # 引数２：文字列(ファイルパス。UTF-8フラグ付き)
   # 返り値：失敗=0、成功=1
   my $from = $_[0];
   my $to = $_[1];
   
   if(&gnFCopy($from, $to)) {
      if(&gnUnlink($from)) {
         if ($main::gnDebugFlag>2) { print STDERR "gnFMove success: ${from} \=\> ${to}\n"; }
         return(1);
      }else{
         print STDERR "gnFMove failed: Source Filename: ${from}\nDest Filename: ${to}\nreason: gnUnlink failed\n";
         return(0);
      }
   }else{
      print STDERR "gnFMove failed: Source Filename: ${from}\nDest Filename: ${to}\nreason: gnFCopy failed\n";
      return(0);
   }

}

sub gnUnlink {
   # unlink関数のラッパー関数(ローカルアクセス専用)
   # やること：
   #   1. 受け取った文字列(utf8フラグ付き)を環境変数LANGに従ってEncode::encodeする
   #   2. ファイルパスが存在するかどうかを確認する
   #   3. 存在したらunlinkする
   #
   # 引数１：文字列(ファイルパス。UTF-8フラグ付き)
   # 返り値：失敗=0、成功=1
   my $path = $_[0];
   my $pathN = &gnFnEncode($path);
   
   my $perr;
   if(&gnCheckPath($path)) {
      
      my $flg = unlink($pathN);
       if($flg) {
          if ($main::gnDebugFlag>2) { print STDERR "gnUnlink success: $pathN\n"; }
          return(1);
       }else{
          print STDERR "unlink failed Filename: $pathN\n";
          return(0);
       }
   }else{
      print STDERR "unlink failed reason: path not found.\nFilename: $pathN\n";
      return(0);
   }
   

}

sub gnFnEncode {
   # openに渡すファイル名の文字コードを変換するルーチン
   # 旧関数名：env_FNconv
   # 
   # 引数１：文字列(ファイルパス, utf8フラグ付きを想定)
   # 返り値：文字列(Encode::encodeされ、utf8フラグが落ちた文字列)
   
   my $myenc_os = 'utf8';
   my $myFNorg = $_[0];
   
   if($^O eq 'MSWin32') {
      # "perl -V"の"osname"がMSWin32の場合は
      # 実行環境がWindowsであると判断し、ロケールから文字エンコードを判別
      # エンコード名に従って文字列を変換する
      # Windows以外(Linuxを想定)の場合はUTF-8の文字列を
      # open関数が受け付けるので、変換しない
      $myenc_os = &env_locale_to_encstr(setlocale(LC_CTYPE));
      $myFNorg = Encode::encode($myenc_os, $myFNorg);
   }else{
      $myFNorg = Encode::encode(&env_locale_to_encstr($ENV{'LANG'}), $myFNorg);
   }
   
   return $myFNorg;

}

1;

