
use utf8;
use strict;
use constant TRUE  => 1;
use constant FALSE => 0;
use File::Copy;
use File::Path;
use File::Basename;
use URI::file;
use URI::Escape;
use URI::Find;
use Storable qw/ dclone /;
use XML::Parser;

my %gnEnvArgN;                      # 環境設定変更時の一時格納用ハッシュ配列
my $gnHoverResN = 0;                # カーソルがレス番号の上にいるときにそのレス番号を記録する変数


#sub on_gnEnv_realize {
#   # 環境設定用ハッシュ配列を一時的に変更用ハッシュ配列にコピー
#   %gnEnvArgN = %{ dclone(\%main::gnEnvArg) };
#}

sub on_gnEnvCancel_clicked {
   # 環境設定ウィンドウで"キャンセル"ボタンが押されたら
   # 単純にウィンドウを廃棄する
   my $gnEnv = $_[1];
   if($main::gnDebugFlag) { print("$main::gnEnvArg{'Cache'}{'gnCacheFolder'}\n"); }
   if($main::gnDebugFlag) { print("$gnEnvArgN{'Cache'}{'gnCacheFolder'}\n"); }
   $gnEnv->destroy;
   $gnEnv = undef;
}

sub on_gnEnvOk_clicked {
   # 環境設定ウィンドウで"OK"ボタンが押されたら
   # 配列gnEnvArgNの内容を内部配列main::gnEnvArgに反映して、
   # ウィンドウを廃棄する
   my $gnEnv = $_[1];
   
   if($main::gnDebugFlag) { print("$main::gnEnvArg{'Cache'}{'gnCacheFolder'}\n"); }
   if($main::gnDebugFlag) { print("$gnEnvArgN{'Cache'}{'gnCacheFolder'}\n"); }
   if($main::gnEnvArg{'Cache'}{'gnCacheFolder'} ne $gnEnvArgN{'Cache'}{'gnCacheFolder'}) {
      my $retval1 = &gnYesNo("キャッシュフォルダが変更されました。\nキャッシュファイルを新しいフォルダに移行しますか？\n\n注意！:\nキャッシュファイルを移行する前にキャッシュファイル\($main::gnEnvArg{'Cache'}{'gnCacheFolder'}\)とキャッシュテーブルファイル\($main::gnCacheTblFile\)のバックアップをとることをおすすめします。この操作はやり直せません\n\nはい\=キャッシュファイルを移行\nいいえ\=キャッシュファイル移行せずに、キャッシュフォルダ設定のみ変更\(いままでキャッシュされたファイルは変更前のキャッシュフォルダから読み出されます。新規にキャッシュされるファイルは変更後のキャッシュフォルダ内に保存されます\)");
      my $execcachemove = "true";
         # 変更先ディレクトリチェック
         my $str = "";
         if (!(&gnCheckPath($gnEnvArgN{'Cache'}{'gnCacheFolder'}))) {
            # 変更先ディレクトリが存在しない場合は作成
            print "a";
            my $errfile;
            my $errstr;
            my $perr;
            my $rst = &gnMakeDir($gnEnvArgN{'Cache'}{'gnCacheFolder'}, "0711");

            if($rst < 1) {
               $str = "変更後フォルダ名: " . $gnEnvArgN{'Cache'}{'gnCacheFolder'} . "\n理由: \nフォルダの作成に失敗";
               $execcachemove = "false";
              }
         }else{
            print "c";
            # 変更後ディレクトリが存在していたら書き込み権限をチェック
            if(!(-w $gnEnvArgN{'Cache'}{'gnCacheFolder'})) {
            print "d";
               $str = "変更後フォルダ名: " . $gnEnvArgN{'Cache'}{'gnCacheFolder'} . "\n理由: \nフォルダは存在しますが書き込み権限がありません。";
               $execcachemove = "false";
            }else{
            print "e";
               $execcachemove = "true";
            }
         }
         
         if($execcachemove eq "false") {
            print "f";
            my $str2 = "変更後フォルダのチェックに失敗しました。\nキャッシュフォルダ設定を変更前に戻します。\n--\n" . $str;
            &gnWarn($str2);
            $gnEnvArgN{'Cache'}{'gnCacheFolder'} = $main::gnEnvArg{'Cache'}{'gnCacheFolder'};
         }else{
            print "g";
            if($retval1 eq "yes") {
               my $retval2 = &gnCacheMove($main::gnEnvArg{'Cache'}{'gnCacheFolder'}, $gnEnvArgN{'Cache'}{'gnCacheFolder'});
               if($retval2 >0) {
                  $str = "いくつかのキャッシュファイルの移行に問題がありましたが続行可能です。\n詳細はログを参照してください";
                  &gnWarn($str);
               }elsif($retval2 <0) {
                  $str = "いくつかのキャッシュファイルの移行に失敗しました。gnviewの続行に問題があると思われます。\n詳細はログを参照してください\nできるだけ早くgnviewを終了して問題を解決することをおすすめします。";
                  &gnWarn($str);
               }else{
                  $str = "キャッシュファイルの移行は問題なく終了しました";
                  &gnInfo($str);
               }
            }
            
         }
         
   }

   # 仮に格納していたハッシュ配列を本番の環境設定配列にコピー
   %main::gnEnvArg = %{ dclone(\%gnEnvArgN) };

   $gnEnv->destroy;
   $gnEnv = undef;

}

sub on_gnEnvLog_Winent_realize {
   # 環境設定ウィンドウ-[ログ保存]-[保存先]-[Windows]
   # 表示時にmain::gnEnvArg{'Folder'}{'LogFolder'}の値を読み込み
   if ($main::gnEnvArg{'Folder'}{'LogFolder'}) {
      $_[0]->set_text($main::gnEnvArg{'Folder'}{'LogFolder'});
   }
}

sub on_gnEnvLog_Winent_changed {
   # 環境設定ウィンドウ-[ログ保存]-[保存先]-[Windows]
   # 値が変更された時にgnEnvArgN{'Folder'}{'LogFolder'}に書き込み
   $gnEnvArgN{'Folder'}{'LogFolder'} = $_[0]->get_text;
}

sub on_gnEnvLog_WinentDB_clicked {
   # 環境設定ウィンドウ-[ログ保存]-[保存先]-[Windows] 横の
   # "選択"ボタンが押されたら、フォルダ選択ダイアログボックスを
   # 表示してフォルダを選択する。
   # 選択された値はEntry(gnEnvLog_Winent)に書き込まれる
   my $gnEnvLog_Winent = $_[1];
   
   my $gnFolderXML = Gtk2::GladeXML->new($main::gladefn, 'gnFolderChoose');
   $gnFolderXML->signal_autoconnect_from_package('main');
   my $gnFolderChoose = $gnFolderXML->get_widget('gnFolderChoose');
   
   my $retval = $gnFolderChoose->run;
   if($retval eq "ok") {
      $retval = &env_gtkstr_to_gtkstr($gnFolderChoose->get_filename);
      $gnEnvLog_Winent->set_text($retval);
      $gnFolderChoose->destroy;
      $gnFolderChoose = undef;
   }else{
      $gnFolderChoose->destroy;
      $gnFolderChoose = undef;
   }

}

sub on_gnEnvLog_Linent_realize {
   # 環境設定ウィンドウ-[ログ保存]-[保存先]-[Unix]
   # 表示時にmain::gnEnvArg{'Folder'}{'LogFolderUnix'}の値を読み込み
   $_[0]->set_text($main::gnEnvArg{'Folder'}{'LogFolderUnix'});
   if($main::gnDebugFlag) { print("realize \: $main::gnEnvArg{'Folder'}{'LogFolderUnix'}\n"); }
   if($main::gnDebugFlag) { print("realize \: $gnEnvArgN{'Folder'}{'LogFolderUnix'}\n"); }
}

sub on_gnEnvLog_Linent_changed {
   # 環境設定ウィンドウ-[ログ保存]-[保存先]-[Unix]
   # 値が変更された時にgnEnvArgN{'Folder'}{'LogFolderUnix'}に書き込み
   $gnEnvArgN{'Folder'}{'LogFolderUnix'} = $_[0]->get_text;
   my $aaa = \$main::gnEnvArg{'Folder'}{'LogFolderUnix'};
   my $bbb = \$gnEnvArgN{'Folder'}{'LogFolderUnix'};
   if($main::gnDebugFlag) { print("changed \: $main::gnEnvArg{'Folder'}{'LogFolderUnix'}\n"); }
   if($main::gnDebugFlag) { print("changed \: $aaa\n"); }
   if($main::gnDebugFlag) { print("changed \: $gnEnvArgN{'Folder'}{'LogFolderUnix'}\n"); }
   if($main::gnDebugFlag) { print("changed \: $bbb\n"); }
}

sub on_gnEnvLog_LinentDB_clicked {
   # 環境設定ウィンドウ-[ログ保存]-[保存先]-[Unix] 横の
   # "選択"ボタンが押されたら、フォルダ選択ダイアログボックスを
   # 表示してフォルダを選択する。
   # 選択された値はEntry(gnEnvLog_Linent)に書き込まれる
   my $gnEnvLog_Linent = $_[1];
   
   my $gnFolderXML = Gtk2::GladeXML->new($main::gladefn, 'gnFolderChoose');
   $gnFolderXML->signal_autoconnect_from_package('main');
   my $gnFolderChoose = $gnFolderXML->get_widget('gnFolderChoose');
   
   my $retval = $gnFolderChoose->run;
   if($retval eq "ok") {
      $retval = &env_gtkstr_to_gtkstr($gnFolderChoose->get_filename);
      $gnEnvLog_Linent->set_text($retval);

      $gnFolderChoose->destroy;
      $gnFolderChoose = undef;
   }else{
      $gnFolderChoose->destroy;
      $gnFolderChoose = undef;
   }

}

sub on_gnEnvLog_Ftp_path_realize {
   # 環境設定ウィンドウ-[ログ保存]-[保存先]-[FTP]-[パス]
   # 表示時にmain::gnEnvArg{'Folder'}{'LogFolderFTPPath'}の値を読み込み
   if ($main::gnEnvArg{'Folder'}{'LogFolderFTPPath'}) {
      $_[0]->set_text($main::gnEnvArg{'Folder'}{'LogFolderFTPPath'});
   }
}

sub on_gnEnvLog_Ftp_path_changed {
   # 環境設定ウィンドウ-[ログ保存]-[保存先]-[FTP]-[パス]
   # 値が変更された時にgnEnvArgN{'Folder'}{'LogFolderFTPPath'}に書き込み
   $gnEnvArgN{'Folder'}{'LogFolderFTPPath'} = $_[0]->get_text;
}

sub on_gnEnvLog_Ftp_user_realize {
   # 環境設定ウィンドウ-[ログ保存]-[保存先]-[FTP]-[ユーザ名]
   # 表示時にmain::gnEnvArg{'Folder'}{'LogFolderFTPUser'}の値を読み込み
   if ($main::gnEnvArg{'Folder'}{'LogFolderFTPUser'}) {
      $_[0]->set_text($main::gnEnvArg{'Folder'}{'LogFolderFTPUser'});
   }
}

sub on_gnEnvLog_Ftp_user_changed {
   # 環境設定ウィンドウ-[ログ保存]-[保存先]-[FTP]-[ユーザ名]
   # 値が変更された時にgnEnvArgN{'Folder'}{'LogFolderFTPUser'}に書き込み
   $gnEnvArgN{'Folder'}{'LogFolderFTPUser'} = $_[0]->get_text;
}

sub on_gnEnvLog_Ftp_password_realize {
   # 環境設定ウィンドウ-[ログ保存]-[保存先]-[FTP]-[パスワード]
   # 表示時にmain::gnEnvArg{'Folder'}{'LogFolderFTPPasswd'}の値を読み込み
   if ($main::gnEnvArg{'Folder'}{'LogFolderFTPPasswd'}) {
      $_[0]->set_text($main::gnEnvArg{'Folder'}{'LogFolderFTPPasswd'});
   }
}

sub on_gnEnvLog_Ftp_password_changed {
   # 環境設定ウィンドウ-[ログ保存]-[保存先]-[FTP]-[パスワード]
   # 値が変更された時にgnEnvArgN{'Folder'}{'LogFolderFTPPasswd'}に書き込み
   $gnEnvArgN{'Folder'}{'LogFolderFTPPasswd'} = $_[0]->get_text;
}

sub on_gnImgPrevSize_realize {
   # 環境設定ウィンドウ-[環境]-[画像プレビュー]
   # 表示時にmain::gnEnvArg{'Browser'}{'PreviewSize'}の値を読み込み
   $_[0]->set_value($main::gnEnvArg{'Browser'}{'PreviewSize'});
}

sub on_gnImgPrevSize_changevalue {
   # 環境設定ウィンドウ-[環境]-[画像プレビュー]
   # で値が変更されたらgnEnvArgN{'Browser'}{'PreviewSize'}に書き込み
   $gnEnvArgN{'Browser'}{'PreviewSize'} = $_[0]->get_value;
}

sub on_gnImgPrevSize_st2_realize {
   # 環境設定ウィンドウ-[環境]-[画像プレビュー]
   # 表示時にmain::gnEnvArg{'Browser'}{'PreviewSize'}の値を読み込み
   $_[0]->set_value($main::gnEnvArg{'Browser'}{'PreviewSizeSt2'});
}

sub on_gnImgPrevSize_st2_changevalue {
   # 環境設定ウィンドウ-[環境]-[画像プレビュー]
   # で値が変更されたらgnEnvArgN{'Browser'}{'PreviewSize'}に書き込み
   $gnEnvArgN{'Browser'}{'PreviewSizeSt2'} = $_[0]->get_value;
}

sub on_gnEnv_AvoidBorder_clicked {
   # 環境設定ウィンドウ-[環境]-[画像プレビュー]-[表示可能領域を設定する]ボタンを押した
   # Gtk2:Window"gnEnvAvoidBorder"を表示
   
   $main::gnEnvABXML = Gtk2::GladeXML->new($main::gladefn, 'gnEnvAvoidBorder');
   $main::gnEnvABXML->signal_autoconnect_from_package('main');

   my $gnEnvAB = $main::gnEnvABXML->get_widget('gnEnvAvoidBorder');
   if ($main::gnDebugFlag) { print Dumper($gnEnvAB) . "\n"; }

   my $gnEnv = $main::gnEnvXML->get_widget('gnEnv');
   $gnEnvAB->set_transient_for($gnEnv);
   $gnEnvAB->set_modal(TRUE);
   
   $gnEnvAB->show_all;
   
   &gnEnvAB_thumbredraw;
}

sub on_gnEnvAB_top_realize {
   # 画像ポップアップ表示可能領域を指定ウィンドウ-[上]スピンボタン
   # 表示時にmain::gnEnvArg{'Browser'}{'AvoidBorderTop'}の値を読み込み
   my $gnEnvAB_top = $_[0];
   my $gnEnvAB_topimg = $_[1];

   if ($main::gnEnvArg{'Browser'}{'AvoidBorderTop'}>0) {
      $gnEnvAB_top->set_value($main::gnEnvArg{'Browser'}{'AvoidBorderTop'});
   }else{
      $gnEnvAB_top->set_value(0);
   }
   
}

sub on_gnEnvAB_bottom_realize {
   # 画像ポップアップ表示可能領域を指定ウィンドウ-[下]スピンボタン
   # 表示時にmain::gnEnvArg{'Browser'}{'AvoidBorderBottom'}の値を読み込み
   my $gnEnvAB_bottom = $_[0];
   my $gnEnvAB_bottomimg = $_[1];
   if ($main::gnEnvArg{'Browser'}{'AvoidBorderBottom'}) {
      $gnEnvAB_bottom->set_value($main::gnEnvArg{'Browser'}{'AvoidBorderBottom'});
   }else{
      $gnEnvAB_bottom->set_value(0);
   }

}

sub on_gnEnvAB_left_realize {
   # 画像ポップアップ表示可能領域を指定ウィンドウ-[左]スピンボタン
   # 表示時にmain::gnEnvArg{'Browser'}{'AvoidBorderLeft'}の値を読み込み
   my $gnEnvAB_left = $_[0];
   my $gnEnvAB_leftimg = $_[1];
   if ($main::gnEnvArg{'Browser'}{'AvoidBorderLeft'}) {
      $gnEnvAB_left->set_value($main::gnEnvArg{'Browser'}{'AvoidBorderLeft'});
   }else{
      $gnEnvAB_left->set_value(0);
   }

}

sub on_gnEnvAB_right_realize {
   # 画像ポップアップ表示可能領域を指定ウィンドウ-[右]スピンボタン
   # 表示時にmain::gnEnvArg{'Browser'}{'AvoidBoarderRight'}の値を読み込み
   my $gnEnvAB_right = $_[0];
   my $gnEnvAB_rightimg = $_[1];
   if ($main::gnEnvArg{'Browser'}{'AvoidBorderRight'}) {
      $gnEnvAB_right->set_value($main::gnEnvArg{'Browser'}{'AvoidBorderRight'});
   }else{
      $gnEnvAB_right->set_value(0);
   }

}

sub on_gnEnvAB_top_value_changed {
   # 画像ポップアップ表示可能領域を指定ウィンドウ-[上]スピンボタン
   # 変更時
   my $gnSpnbtn = $_[0];
   
   # 下スピンボタンの値を取得
   my $gnEnvAB_bottom = $main::gnEnvABXML->get_widget('gnEnvAB_bottom');
   my $gnEnvAB_topval = $gnSpnbtn->get_value;
   my $gnEnvAB_bottomval = $gnEnvAB_bottom->get_value;
   
   # 画面全体の大きさを取得
   my $dis = Gtk2::Gdk::Display->get_default;
   my ($scr, $x, $y, $mask) = $dis->get_pointer;
   my $wid = $scr->get_width;
   my $hei = $scr->get_height;
   
   # 各スピンボタンの値とポップアップウィンドウの大きさを足した値が
   # スクリーンの描画領域を超えていたら、サムネイルの描画はキャンセルする
   if (($gnEnvAB_topval + $gnEnvAB_bottomval + $main::gnEnvArg{'Browser'}{'PreviewSize'}*100)>$hei) {
      if ($main::gnDebugFlag) { print ""; };
      $gnEnvAB_topval = $hei - ($gnEnvAB_bottomval + $main::gnEnvArg{'Browser'}{'PreviewSize'}*100);
      $gnSpnbtn->set_value($gnEnvAB_topval);
   }else{
      # サムネイルを再描画
      &gnEnvAB_thumbredraw;
   }
}

sub on_gnEnvAB_bottom_value_changed {
   # 画像ポップアップ表示可能領域を指定ウィンドウ-[下]スピンボタン
   # 変更時
   my $gnSpnbtn = $_[0];
   
   # 上スピンボタンの値を取得
   my $gnEnvAB_top = $main::gnEnvABXML->get_widget('gnEnvAB_top');
   my $gnEnvAB_bottomval = $gnSpnbtn->get_value;
   my $gnEnvAB_topval = $gnEnvAB_top->get_value;
   
   # 画面全体の大きさを取得
   my $dis = Gtk2::Gdk::Display->get_default;
   my ($scr, $x, $y, $mask) = $dis->get_pointer;
   my $wid = $scr->get_width;
   my $hei = $scr->get_height;
   
   # 各スピンボタンの値とポップアップウィンドウの大きさを足した値が
   # スクリーンの描画領域を超えていたら、サムネイルの描画はキャンセルする
   if (($gnEnvAB_topval + $gnEnvAB_bottomval + $main::gnEnvArg{'Browser'}{'PreviewSize'}*100)>$hei) {
      if ($main::gnDebugFlag) { print ""; };
      $gnEnvAB_bottomval = $hei - ($gnEnvAB_topval + $main::gnEnvArg{'Browser'}{'PreviewSize'}*100);
      $gnSpnbtn->set_value($gnEnvAB_bottomval);
   }else{
      # サムネイルを再描画
      &gnEnvAB_thumbredraw;
   }
}

sub on_gnEnvAB_left_value_changed {
   # 画像ポップアップ表示可能領域を指定ウィンドウ-[左]スピンボタン
   # 変更時
   my $gnSpnbtn = $_[0];
   
   # 右スピンボタンの値を取得
   my $gnEnvAB_right = $main::gnEnvABXML->get_widget('gnEnvAB_right');
   my $gnEnvAB_leftval = $gnSpnbtn->get_value;
   my $gnEnvAB_rightval = $gnEnvAB_right->get_value;
   
   # 画面全体の大きさを取得
   my $dis = Gtk2::Gdk::Display->get_default;
   my ($scr, $x, $y, $mask) = $dis->get_pointer;
   my $wid = $scr->get_width;
   my $hei = $scr->get_height;
   
   # 各スピンボタンの値とポップアップウィンドウの大きさを足した値が
   # スクリーンの描画領域を超えていたら、サムネイルの描画はキャンセルする
   if (($gnEnvAB_leftval + $gnEnvAB_rightval + $main::gnEnvArg{'Browser'}{'PreviewSize'}*100)>$wid) {
      if ($main::gnDebugFlag) { print ""; };
      $gnEnvAB_leftval = $wid - ($gnEnvAB_rightval + $main::gnEnvArg{'Browser'}{'PreviewSize'}*100);
      $gnSpnbtn->set_value($gnEnvAB_leftval);
   }else{
      # サムネイルを再描画
      &gnEnvAB_thumbredraw;
   }
}

sub on_gnEnvAB_right_value_changed {
   # 画像ポップアップ表示可能領域を指定ウィンドウ-[右]スピンボタン
   # 変更時
   my $gnSpnbtn = $_[0];
   
   # 左スピンボタンの値を取得
   my $gnEnvAB_left = $main::gnEnvABXML->get_widget('gnEnvAB_left');
   my $gnEnvAB_rightval = $gnSpnbtn->get_value;
   my $gnEnvAB_leftval = $gnEnvAB_left->get_value;
   
   # 画面全体の大きさを取得
   my $dis = Gtk2::Gdk::Display->get_default;
   my ($scr, $x, $y, $mask) = $dis->get_pointer;
   my $wid = $scr->get_width;
   my $hei = $scr->get_height;
   
   # 各スピンボタンの値とポップアップウィンドウの大きさを足した値が
   # スクリーンの描画領域を超えていたら、サムネイルの描画はキャンセルする
   if (($gnEnvAB_leftval + $gnEnvAB_rightval + $main::gnEnvArg{'Browser'}{'PreviewSize'}*100)>$wid) {
      if ($main::gnDebugFlag) { print ""; };
      $gnEnvAB_rightval = $wid - ($gnEnvAB_leftval + $main::gnEnvArg{'Browser'}{'PreviewSize'}*100);
      $gnSpnbtn->set_value($gnEnvAB_rightval);
   }else{
      # サムネイルを再描画
      &gnEnvAB_thumbredraw;
   }
}

sub on_gnEnvAB_all_value_changed {
   # 画像ポップアップ表示可能領域を指定ウィンドウ-[共通]スピンボタン
   # 変更時
   my $gnSpnbtn = $_[0];
   my $gnSpnbtnval = $gnSpnbtn->get_value;
   
   # 上下左右スピンボタンの値を取得
   my $gnEnvAB_top = $main::gnEnvABXML->get_widget('gnEnvAB_top');
   my $gnEnvAB_bottom = $main::gnEnvABXML->get_widget('gnEnvAB_bottom');
   my $gnEnvAB_left = $main::gnEnvABXML->get_widget('gnEnvAB_left');
   my $gnEnvAB_right = $main::gnEnvABXML->get_widget('gnEnvAB_right');
   $gnEnvAB_top->set_value($gnSpnbtnval);
   $gnEnvAB_bottom->set_value($gnSpnbtnval);
   $gnEnvAB_left->set_value($gnSpnbtnval);
   $gnEnvAB_right->set_value($gnSpnbtnval);
   
   # もう一回各スピンボタンの値を取得
   # 各値の最小値を出して、各スピンボタンと自分自身に適用
   my $gnEnvAB_topval = $gnEnvAB_top->get_value;
   my $gnEnvAB_bottomval = $gnEnvAB_bottom->get_value;
   my $gnEnvAB_leftval = $gnEnvAB_left->get_value;
   my $gnEnvAB_rightval = $gnEnvAB_right->get_value;
   my @gnEnvABvals = ($gnEnvAB_topval, $gnEnvAB_bottomval, $gnEnvAB_leftval, $gnEnvAB_rightval);
   my $gnEnvAB_minval = min(@gnEnvABvals);
   $gnEnvAB_top->set_value($gnEnvAB_minval);
   $gnEnvAB_bottom->set_value($gnEnvAB_minval);
   $gnEnvAB_left->set_value($gnEnvAB_minval);
   $gnEnvAB_right->set_value($gnEnvAB_minval);
   if ($gnSpnbtnval > $gnEnvAB_minval) {
      $gnSpnbtn->set_value($gnEnvAB_minval);
   }
   
}

sub gnEnvAB_thumbredraw {
   # "画像ポップアップ表示可能領域を指定"ウィンドウ-サムネイル
   # １ドットのイメージファイルを読み込んで当てはめる
   #
   if ($main::gnDebugFlag) { print "redraw execute.\n"; };
   
   # 上下左右のスピンボタンの値を取得
   my $gnEnvAB_top = $main::gnEnvABXML->get_widget('gnEnvAB_top');
   my $gnEnvAB_bottom = $main::gnEnvABXML->get_widget('gnEnvAB_bottom');
   my $gnEnvAB_left = $main::gnEnvABXML->get_widget('gnEnvAB_left');
   my $gnEnvAB_right = $main::gnEnvABXML->get_widget('gnEnvAB_right');
   my $gnEnvAB_topval = $gnEnvAB_top->get_value;
   my $gnEnvAB_bottomval = $gnEnvAB_bottom->get_value;
   my $gnEnvAB_leftval = $gnEnvAB_left->get_value;
   my $gnEnvAB_rightval = $gnEnvAB_right->get_value;
   
   # ウィンドウ内の描画領域の大きさを取得
   my $gnEnvAB_imgtable = $main::gnEnvABXML->get_widget('gnEnvAB_imgtable');
   my $gnEnvAB_imgtablealoc = $gnEnvAB_imgtable->allocation;
   my $gnEnvAB_imgtablewidth = $gnEnvAB_imgtablealoc->width;
   my $gnEnvAB_imgtableheight = $gnEnvAB_imgtablealoc->height;
   ##  Gtk2::Table のサイズがallocationされない場合には
   ##  親ウィジェットのGtk2::Vboxからサイズを取得(初回表示のみの強烈なworkaround)
   if ($gnEnvAB_imgtablewidth<2) {
      $gnEnvAB_imgtable = $main::gnEnvABXML->get_widget('vbox27');
      $gnEnvAB_imgtablealoc = $gnEnvAB_imgtable->allocation;
      $gnEnvAB_imgtablewidth = $gnEnvAB_imgtablealoc->width * 0.75;
      $gnEnvAB_imgtableheight = $gnEnvAB_imgtablealoc->height;
   }
   
   if ($main::gnDebugFlag) { print "Table Size\: $gnEnvAB_imgtablewidth, $gnEnvAB_imgtableheight\n";};

   # 画面全体の大きさを取得
   my $dis = Gtk2::Gdk::Display->get_default;
   my ($scr, $x, $y, $mask) = $dis->get_pointer;
   my $wid = $scr->get_width;
   my $hei = $scr->get_height;
   
   if ($main::gnDebugFlag) { print "Screen Size\: $wid, $hei\n";};
      
   # 画面の大きさに対する描画領域の比率を取得
   # 画面幅だけで計算し、高さはその比率に合わせて大きくする
   my $gnEnvABratio = $gnEnvAB_imgtablewidth / $wid;
   my $imgtop = int($gnEnvAB_topval*$gnEnvABratio);
   if ($imgtop<1) {
      $imgtop = 1;
   };
   my $imgbottom = int($gnEnvAB_bottomval*$gnEnvABratio);
   if ($imgbottom<1) {
      $imgbottom = 1;
   };
   my $imgleft = int($gnEnvAB_leftval*$gnEnvABratio);
   if ($imgleft<1) {
      $imgleft = 1;
   };
   my $imgright = int($gnEnvAB_rightval*$gnEnvABratio);
   if ($imgright<1) {
      $imgright = 1;
   };
   
   # 「上」を描画
   my $gnEnvABtopimgBuf;
   eval { $gnEnvABtopimgBuf = Gtk2::Gdk::Pixbuf->new_from_file_at_scale($main::gnEnvABimgfn,
                                                                              $gnEnvAB_imgtablewidth,
                                                                              $imgtop,
                                                                              FALSE);
         };
   my $gnEnvAB_topimg = $main::gnEnvABXML->get_widget('gnEnvAB_topimg');
   $gnEnvAB_topimg->set_from_pixbuf($gnEnvABtopimgBuf);
   
   # 「下」を描画
   my $gnEnvABbottomimgBuf;
   eval { $gnEnvABbottomimgBuf = Gtk2::Gdk::Pixbuf->new_from_file_at_scale($main::gnEnvABimgfn,
                                                                              $gnEnvAB_imgtablewidth,
                                                                              $imgbottom,
                                                                              FALSE);
         };
   my $gnEnvAB_bottomimg = $main::gnEnvABXML->get_widget('gnEnvAB_bottomimg');
   $gnEnvAB_bottomimg->set_from_pixbuf($gnEnvABbottomimgBuf);

   # 「左」を描画
   my $gnEnvABleftimgBuf;
   eval { $gnEnvABleftimgBuf = Gtk2::Gdk::Pixbuf->new_from_file_at_scale($main::gnEnvABimgfn,
                                                                              $imgleft,
                                                                              int($hei*$gnEnvABratio) - ($imgtop + $imgbottom),
                                                                              FALSE);
         };
   my $gnEnvAB_leftimg = $main::gnEnvABXML->get_widget('gnEnvAB_leftimg');
   $gnEnvAB_leftimg->set_from_pixbuf($gnEnvABleftimgBuf);

   # 「右」を描画
   my $gnEnvABrightimgBuf;
   eval { $gnEnvABrightimgBuf = Gtk2::Gdk::Pixbuf->new_from_file_at_scale($main::gnEnvABimgfn,
                                                                              $imgright,
                                                                              int($hei*$gnEnvABratio) - ($imgtop + $imgbottom),
                                                                              FALSE);
         };
   my $gnEnvAB_rightimg = $main::gnEnvABXML->get_widget('gnEnvAB_rightimg');
   $gnEnvAB_rightimg->set_from_pixbuf($gnEnvABrightimgBuf);
   
   # 「中央」を描画
   my $gnEnvABcenterimgBuf;
   eval { $gnEnvABcenterimgBuf = Gtk2::Gdk::Pixbuf->new_from_file_at_scale($main::gnEnvABcenterimgfn,
                                                                                 $gnEnvAB_imgtablewidth - ($imgleft + $imgright),
                                                                                 int($hei*$gnEnvABratio) - ($imgtop + $imgbottom),
                                                                                 FALSE);
         };
   my $gnEnvAB_centerimg = $main::gnEnvABXML->get_widget('gnEnvAB_centerimg');
   $gnEnvAB_centerimg->set_from_pixbuf($gnEnvABcenterimgBuf);

   
   if ($main::gnDebugFlag) { print "Top, Bottom, Left, Right\: $imgtop, $imgbottom, $imgleft, $imgright\n";};

}

sub on_gnEnvAB_ok_clicked {
   # 画像ポップアップ表示可能領域を指定ウィンドウで"キャンセル"ボタンが押されたら
   # 各スピンボタンの値をgnEnvArgN{'Browser'}{'AvoidBoarderxxxx'}に保存
   # (xxxxはTop,Bottom,Left,Right)
   my $gnEnvAB = $_[1];

   my $gnEnvAB_top = $main::gnEnvABXML->get_widget('gnEnvAB_top');
   my $gnEnvAB_bottom = $main::gnEnvABXML->get_widget('gnEnvAB_bottom');
   my $gnEnvAB_left = $main::gnEnvABXML->get_widget('gnEnvAB_left');
   my $gnEnvAB_right = $main::gnEnvABXML->get_widget('gnEnvAB_right');

   $gnEnvArgN{'Browser'}{'AvoidBorderTop'} = $gnEnvAB_top->get_value;
   $gnEnvArgN{'Browser'}{'AvoidBorderBottom'} = $gnEnvAB_bottom->get_value;
   $gnEnvArgN{'Browser'}{'AvoidBorderLeft'} = $gnEnvAB_left->get_value;
   $gnEnvArgN{'Browser'}{'AvoidBorderRight'} = $gnEnvAB_right->get_value;
   
   $gnEnvAB->destroy;
   $gnEnvAB = undef;
   
}

sub on_gnEnvAB_cancel_clicked {
   # 画像ポップアップ表示可能領域を指定ウィンドウで"キャンセル"ボタンが押されたら
   # 単純にウィンドウを廃棄する
   my $gnEnvAB = $_[1];
   $gnEnvAB->destroy;
   $gnEnvAB = undef;
}

sub on_gnEnableImgPopup_realize {
   # 環境設定ウィンドウ-[環境]-[画像プレビュー]-チェック
   # 表示時にmain::gnEnvArg{'Browser'}{'PreviewVisible'}の値を読み込み
   $_[0]->set_active($main::gnEnvArg{'Browser'}{'PreviewVisible'});
}

sub on_gnEnableImgPopup_toggled {
   # 環境設定ウィンドウ-[環境]-[画像プレビュー]-チェック
   # で値が変更されたらgnEnvArgN{'Browser'}{'PreviewVisible'}に書き込み
   $gnEnvArgN{'Browser'}{'PreviewVisible'} = $_[0]->get_active;
}

sub on_gnEnableImgPopup_st2_realize {
   # 環境設定ウィンドウ-[環境]-[画像プレビュー]-チェック
   # 表示時にmain::gnEnvArg{'Browser'}{'PreviewVisible'}の値を読み込み
      $_[0]->set_active($main::gnEnvArg{'Browser'}{'PreviewVisibleSt2'});
}

sub on_gnEnableImgPopup_st2_toggled {
   # 環境設定ウィンドウ-[環境]-[画像プレビュー]-チェック
   # で値が変更されたらgnEnvArgN{'Browser'}{'PreviewVisible'}に書き込み
   $gnEnvArgN{'Browser'}{'PreviewVisibleSt2'} = $_[0]->get_active;
   
}

sub on_gnImgPrevInterval_realize {
   # 環境設定ウィンドウ-[環境]-[画像プレビュー]-[表示までの時間]
   # 表示時にmain::gnEnvArg{'Browser'}{'PreviewWait'}の値を読み込み
   my $gnPreviewWait = $main::gnEnvArg{'Browser'}{'PreviewWait'} / 100 ;
   $_[0]->set_value($gnPreviewWait);
}

sub on_gnImgPrevInterval_value_changed {
   # 環境設定ウィンドウ-[環境]-[画像プレビュー]-[表示までの時間]
   # で値が変更されたらgnEnvArgN{'Browser'}{'PreviewWait'}に書き込み
   my $gnPreviewWait = $_[0]->get_value * 100;
   $gnEnvArgN{'Browser'}{'PreviewWait'} = $gnPreviewWait;
}

sub on_gnEnv_EnableCache_realize {
   # 環境設定ウィンドウ-[環境]-[画像プレビュー]-[キャッシュを有効にする]
   # 表示時にmain::gnEnvArg{'Cache'}{'Enable'}の値を読み込み
   my $gnCT =$_[0];
   if($main::gnDebugFlag) { print "cache:\n" . Dumper($main::gnEnvArg{'Cache'}{'Enable'}); }
   if ($main::gnEnvArg{'Cache'}{'Enable'}) {
      if ($main::gnEnvArg{'Cache'}{'Enable'} == FALSE) {
         $gnCT->set_active(FALSE);
      }else{
         $gnCT->set_active(TRUE);
      }
   }else{
      $gnCT->set_active(FALSE);
   }
}

sub on_gnEnv_EnableCache_toggled {
   # 環境設定ウィンドウ-[環境]-[画像プレビュー]-[キャッシュを有効にする]
   # トグルされたらgnEnvArgN{'Cache'}{'Enable'}へ値を書き込み
   my $gnCT =$_[0];
   if ($gnCT->get_active) {
      $gnEnvArgN{'Cache'}{'Enable'} = TRUE;
   }else{
      $gnEnvArgN{'Cache'}{'Enable'} = FALSE;
   }

}

sub on_gnEnv_CacheExpire_realize {
   # 環境設定ウィンドウ-[環境]-[画像プレビュー]-[キャッシュ有効期間]
   # 表示時にmain::gnEnvArg{'Cache'}{'Expire'}の値を読み込み
   my $gnCE = $_[0];
   if ($main::gnEnvArg{'Cache'}{'Expire'}) {
      $gnCE->set_value($main::gnEnvArg{'Cache'}{'Expire'});
   }else{
      $gnCE->set_value(0);
   }
}

sub on_gnEnv_CacheExpire_value_changed {
   # 環境設定ウィンドウ-[環境]-[画像プレビュー]-[キャッシュ有効期間]
   # 値の変更時にgnEnvArgN{'Cache'}{'Expire'}へ値を書き込み
   my $gnCE = $_[0];
   $gnEnvArgN{'Cache'}{'Expire'} = $gnCE->get_value_as_int;
}

sub on_gnEnv_CacheFolder_realize {
   # 環境設定ウィンドウ-[環境]-[画像プレビュー]-[キャッシュフォルダ]
   # 表示時にmain::gnEnvArg{'Cache'}{'gnCacheDir'}の値を読み込み
   my $widget = $_[0];
   if(!($main::gnEnvArg{'Cache'}{'gnCacheFolder'})) {
      $main::gnEnvArg{'Cache'}{'gnCacheFolder'} = $main::tmpdir;
   }
   $widget->set_text($main::gnEnvArg{'Cache'}{'gnCacheFolder'});
   if($main::gnDebugFlag) { print STDERR "realise \: $main::gnEnvArg{'Cache'}{'gnCacheFolder'}\n"; }
   if($main::gnDebugFlag) { print STDERR "realise \: $gnEnvArgN{'Cache'}{'gnCacheFolder'}\n"; }
}

sub on_gnEnv_CacheFolder_changed {
   # 環境設定ウィンドウ-[環境]-[画像プレビュー]-[キャッシュフォルダ]
   # 変更時にgnEnvArgN{'Cache'}{'gnCacheDir'}へ値を書き込み
   #my $widget = $_[0];
   $gnEnvArgN{'Cache'}{'gnCacheFolder'} = $_[0]->get_text;
   my $ret1 = $main::gnEnvArg{'Cache'}{'gnCacheFolder'};
   my $ret11 = %main::gnEnvArg;
   my $ret2 = $gnEnvArgN{'Cache'}{'gnCacheFolder'};
   my $ret21 = %gnEnvArgN;

   if($main::gnDebugFlag) { print STDERR "changed \: $ret11\n"; }
   if($main::gnDebugFlag) { print STDERR "changed \: $ret21\n"; }
}

sub on_gnEnv_CacheFolderBtn_clicked {
   # 環境設定ウィンドウ-[環境]-[画像プレビュー]-[キャッシュフォルダ] 横の
   # "選択"ボタンが押されたら、フォルダ選択ダイアログボックスを
   # 表示してフォルダを選択する。
   # 選択された値はEntry(gnEnv_CacheFolder)に書き込まれる
   my $gnEnv_CacheFolder = $_[1];
   
   my $gnFolderXML = Gtk2::GladeXML->new($main::gladefn, 'gnFolderChoose');
   $gnFolderXML->signal_autoconnect_from_package('main');
   my $gnFolderChoose = $gnFolderXML->get_widget('gnFolderChoose');
   $gnFolderChoose->set_current_folder($main::gnEnvArg{'Cache'}{'gnCacheFolder'});
   
   my $retval = $gnFolderChoose->run;
   if($retval eq "ok") {
      $retval = &env_gtkstr_to_gtkstr($gnFolderChoose->get_filename);
      $gnEnv_CacheFolder->set_text($retval);

      $gnFolderChoose->destroy;
      $gnFolderChoose = undef;
   }else{
      $gnFolderChoose->destroy;
      $gnFolderChoose = undef;
   }

}

sub on_gnEnv_ClearCacheOnExit_realize {
   # 環境設定ウィンドウ-[環境]-[画像プレビュー]-[終了時にキャッシュをクリア]
   # 表示時にmain::gnEnvArg{'Cache'}{'ClearOnExit'}の値を読み込み
   my $gnCCOE = $_[0];
   if ($main::gnEnvArg{'Cache'}{'ClearOnExit'}) {
      if ($main::gnEnvArg{'Cache'}{'ClearOnExit'} == TRUE) {
         $gnCCOE->set_active(TRUE);
      }else{
         $gnCCOE->set_active(FALSE);
      }
   }else{
      $gnCCOE->set_active(FALSE);
   }

}

sub on_gnEnv_ClearCacheOnExit_toggled {
   # 環境設定ウィンドウ-[環境]-[画像プレビュー]-[終了時にキャッシュをクリア]
   # トグルされたらgnEnvArgN{'Cache'}{'ClearOnExit'}へ値を書き込み
   my $gnCCOE =$_[0];
   if ($gnCCOE->get_active) {
      $gnEnvArgN{'Cache'}{'ClearOnExit'} = TRUE;
   }else{
      $gnEnvArgN{'Cache'}{'ClearOnExit'} = FALSE;
   }

}

sub on_gnEnv_BrowseR1_realize {
   # 環境設定ウィンドウ-[環境]-[ブラウザ]-[(Windowsのみ)既定のブラウザを使用]
   # 表示時にmain::gnEnvArg{'URLApp'}{'Select'}の値を読み込み
   my $gnBR = $_[0];
   
   if (($^O ne 'MSWin32') && ($^O ne 'darwin')) {
      $gnBR->set_sensitive(FALSE);
   }
   
   if ($main::gnEnvArg{'URLApp'}{'gnSelect'}) {
      if ($main::gnEnvArg{'URLApp'}{'gnSelect'} == 0) {
         $gnBR->set_active(TRUE);
      }
   }elsif ($main::gnEnvArg{'URLApp'}{'Select'}) {
      if ($main::gnEnvArg{'URLApp'}{'Select'} == 0) {
         $gnBR->set_active(TRUE);
      }
   }
   
}

sub on_gnEnv_BrowseR1_toggled {
   # 環境設定ウィンドウ-[環境]-[ブラウザ]-[(Windowsのみ)既定のブラウザを使用]
   # トグルされたらgnEnvArgN{'URLApp'}{'gnSelect'}へ値を書き込み
   my $gnBR = $_[0];
   
   if ($gnBR->get_active) {
      $gnEnvArgN{'URLApp'}{'gnSelect'} = 0;
   }
}

sub on_gnEnv_BrowseR2_realize {
   # 環境設定ウィンドウ-[環境]-[ブラウザ]-[(Windows以外)以下のブラウザを使用]
   # 表示時にmain::gnEnvArg{'URLApp'}{'gnSelect'}の値を読み込み
   my $gnBR = $_[0];
   
   if ($main::gnEnvArg{'URLApp'}{'gnSelect'}) {
      if ($main::gnEnvArg{'URLApp'}{'gnSelect'} == 2) {
         $gnBR->set_active(TRUE);
      }
   }
   
}

sub on_gnEnv_BrowseR2_toggled {
   # 環境設定ウィンドウ-[環境]-[ブラウザ]-[(Windows以外)以下のブラウザを使用]
   # トグルされたらgnEnvArgN{'URLApp'}{'gnSelect'}へ値を書き込み
   my $gnBR = $_[0];
   
   if ($gnBR->get_active) {
      $gnEnvArgN{'URLApp'}{'gnSelect'} = 2;
   }
   
}

sub on_gnEnv_BrowseR3_realize {
   # 環境設定ウィンドウ-[環境]-[ブラウザ]-[(Windows以外)以下のコマンドを使用]
   # 表示時にmain::gnEnvArg{'URLApp'}{'gnSelect'}の値を読み込み
   my $gnBR = $_[0];
   
   if ($main::gnEnvArg{'URLApp'}{'gnSelect'}) {
      if ($main::gnEnvArg{'URLApp'}{'gnSelect'} == 1) {
         $gnBR->set_active(TRUE);
      }
   }elsif ($main::gnEnvArg{'URLApp'}{'Select'}) {
      if ($main::gnEnvArg{'URLApp'}{'Select'} == 1) {
         $gnBR->set_active(TRUE);
      }
   }
   
}

sub on_gnEnv_BrowseR3_toggled {
   # 環境設定ウィンドウ-[環境]-[ブラウザ]-[(Windows以外)以下のブラウザを使用]
   # トグルされたらgnEnvArgN{'URLApp'}{'gnSelect'}へ値を書き込み
   my $gnBR = $_[0];
   
   if ($gnBR->get_active) {
      $gnEnvArgN{'URLApp'}{'gnSelect'} = 1;
   }
   
}

sub on_gnEnv_BrowserSel_realize {
   # 環境設定ウィンドウ-[環境]-[ブラウザ]-[(Windows以外)以下のブラウザを使用]-[使用ブラウザ]
   # 表示時にmain::gnEnvArg{'URLApp'}{'gnSelBrowser'}の値を読み込み
   my $gnBR = $_[0];
   
   if ($main::gnEnvArg{'URLApp'}{'gnSelBrowser'}) {
      $gnBR->set_active($main::gnEnvArg{'URLApp'}{'gnSelBrowser'});
   }
}

sub on_gnEnv_BrowserSel_changed {
   # 環境設定ウィンドウ-[環境]-[ブラウザ]-[(Windows以外)以下のブラウザを使用]-[使用ブラウザ]
   # トグルされたらgnEnvArgN{'URLApp'}{'gnSelect'}へ値を書き込み
   my $gnBR = $_[0];
   
   $gnEnvArgN{'URLApp'}{'gnSelBrowser'} = $gnBR->get_active;
   
}

sub on_gnEnv_BrowserCmd_realize {
   # 環境設定ウィンドウ-[環境]-[ブラウザ]-[(Windows以外)以下のブラウザを使用]-[コマンド名]
   # 表示時にmain::gnEnvArg{'URLApp'}{'gnSelBrowser'}の値を読み込み
   my $gnBR = $_[0];
   
   if ($main::gnEnvArg{'URLApp'}{'gnFile'}) {
      $gnBR->set_text($main::gnEnvArg{'URLApp'}{'gnFile'});
   }elsif ($main::gnEnvArg{'URLApp'}{'File'}) {
      $gnBR->set_text($main::gnEnvArg{'URLApp'}{'File'});
   }
}

sub on_gnEnv_BrowserCmd_changed {
   # 環境設定ウィンドウ-[環境]-[ブラウザ]-[(Windows以外)以下のブラウザを使用]-[コマンド名]
   # トグルされたらgnEnvArgN{'URLApp'}{'gnSelect'}へ値を書き込み
   my $gnBR = $_[0];
   
   $gnEnvArgN{'URLApp'}{'gnFile'} = $gnBR->get_text;
   
}

sub on_gnEnv_Proxy_none_realize {
   # 環境設定ウィンドウ-[ネットワーク]-[プロキシ]-[使用しない]
   # 表示時にmain::gnEnvArg{'ReadProxy'}{'Proxy'}の値を読み込み
   my $gnEP = $_[0];
   
   if ($main::gnEnvArg{'ReadProxy'}{'Proxy'} || $main::gnEnvArg{'WriteProxy'}{'Proxy'}) {
      if (($main::gnEnvArg{'ReadProxy'}{'Proxy'} == 0) && ($main::gnEnvArg{'WriteProxy'}{'Proxy'} == 0)) {
         $gnEP->set_active(TRUE);
      }
   }else{
         $gnEP->set_active(FALSE);
   }
}

sub on_gnEnv_Proxy_none_toggled {
   # 環境設定ウィンドウ-[ネットワーク]-[プロキシ]-[使用しない]
   # 変更時にgnEnvArgN{'ReadProxy'}{'Proxy'}, gnEnvArgN{'WriteProxy'}{'Proxy'}を無効に
   my $gnEP = $_[0];
   
   if ($gnEP->get_active) {
      if ($main::gnDebugFlag) { print "active\n";};
      my $gnRP = $main::gnEnvXML->get_widget('gnEnv_proxy_use');
      $gnRP->set_active(FALSE);
      $gnRP = $main::gnEnvXML->get_widget('gnEnv_wproxy_use');
      $gnRP->set_active(FALSE);
      $gnEnvArgN{'ReadProxy'}{'Proxy'} = 0;
      $gnEnvArgN{'WriteProxy'}{'Proxy'} = 0;
   }
}

sub on_gnEnv_Proxy_http_realize {
   # 環境設定ウィンドウ-[ネットワーク]-[プロキシ]-[HTTPプロキシ]
   # 表示時にmain::gnEnvArg{'ReadProxy'}{'Proxy'}の値を読み込み
   my $gnEP = $_[0];
   
   if ($main::gnEnvArg{'ReadProxy'}{'Proxy'} || $main::gnEnvArg{'WriteProxy'}{'Proxy'}) {
      if (($main::gnEnvArg{'ReadProxy'}{'Proxy'} == 1) || ($main::gnEnvArg{'WriteProxy'}{'Proxy'} == 1)) {
         $gnEP->set_active(TRUE);
      }
   }else{
         $gnEP->set_active(FALSE);
   }
}

sub on_gnEnv_proxy_use_realize {
   # 環境設定ウィンドウ-[ネットワーク]-[プロキシ]-[HTTPプロキシ]-[読み込み用プロキシを使用]
   # 表示時にmain::gnEnvArg{'ReadProxy'}{'Proxy'}の値を読み込み
   my $gnEP = $_[0];
   if ($main::gnEnvArg{'ReadProxy'}{'Proxy'} == 1) {
         $gnEP->set_active(TRUE);
   }else{
         $gnEP->set_active(FALSE);
   }
}

sub on_gnEnv_proxy_use_toggled {
   # 環境設定ウィンドウ-[ネットワーク]-[プロキシ]-[HTTPプロキシ]-[読み込み用プロキシを使用]
   # 変更時にgnEnvArgN{'ReadProxy'}{'Proxy'}へ値を書き込み
   my $gnEP = $_[0];
   my $val = $gnEP->get_active;
   if ($val == TRUE) {
         $gnEnvArgN{'ReadProxy'}{'Proxy'} = 1;
   }else{
         $gnEnvArgN{'ReadProxy'}{'Proxy'} = 0;
   }
}

sub on_gnEnv_proxy_url_realize {
   # 環境設定ウィンドウ-[ネットワーク]-[プロキシ]-[HTTPプロキシ]-[読み込み用プロキシを使用]-[URL]
   # 表示時にmain::gnEnvArg{'ReadProxy'}{'Address'}の値を読み込み
   my $gnEP = $_[0];
   if ($main::gnEnvArg{'ReadProxy'}{'Address'}) {
         $gnEP->set_text($main::gnEnvArg{'ReadProxy'}{'Address'});
   }
}

sub on_gnEnv_proxy_url_changed {
   # 環境設定ウィンドウ-[ネットワーク]-[プロキシ]-[HTTPプロキシ]-[読み込み用プロキシを使用]-[URL]
   # 変更時にgnEnvArgN{'ReadProxy'}{'Address'}へ値を書き込み
   my $gnEP = $_[0];
   $gnEnvArgN{'ReadProxy'}{'Address'} = $gnEP->get_text;
}

sub on_gnEnv_proxy_port_realize {
   # 環境設定ウィンドウ-[ネットワーク]-[プロキシ]-[HTTPプロキシ]-[読み込み用プロキシを使用]-[ポート番号]
   # 表示時にmain::gnEnvArg{'ReadProxy'}{'Port'}の値を読み込み
   my $gnEP = $_[0];
   if ($main::gnEnvArg{'ReadProxy'}{'Port'}) {
         $gnEP->set_text($main::gnEnvArg{'ReadProxy'}{'Port'});
   }
}

sub on_gnEnv_proxy_port_changed {
   # 環境設定ウィンドウ-[ネットワーク]-[プロキシ]-[HTTPプロキシ]-[読み込み用プロキシを使用]-[ポート番号]
   # 変更時にgnEnvArgN{'ReadProxy'}{'Port'}へ値を書き込み
   my $gnEP = $_[0];
   $gnEnvArgN{'ReadProxy'}{'Port'} = $gnEP->get_text;
}

sub on_gnEnv_proxy_username_realize {
   # 環境設定ウィンドウ-[ネットワーク]-[プロキシ]-[HTTPプロキシ]-[読み込み用プロキシを使用]-[ユーザ名]
   # 表示時にmain::gnEnvArg{'ReadProxy'}{'UserID'}の値を読み込み
   my $gnEP = $_[0];
   if ($main::gnEnvArg{'ReadProxy'}{'UserID'}) {
         $gnEP->set_text($main::gnEnvArg{'ReadProxy'}{'UserID'});
   }
}

sub on_gnEnv_proxy_username_changed {
   # 環境設定ウィンドウ-[ネットワーク]-[プロキシ]-[HTTPプロキシ]-[読み込み用プロキシを使用]-[ユーザ名]
   # 変更時にgnEnvArgN{'ReadProxy'}{'UserID'}へ値を書き込み
   my $gnEP = $_[0];
   $gnEnvArgN{'ReadProxy'}{'UserID'} = $gnEP->get_text;
}

sub on_gnEnv_proxy_password_realize {
   # 環境設定ウィンドウ-[ネットワーク]-[プロキシ]-[HTTPプロキシ]-[読み込み用プロキシを使用]-[パスワード]
   # 表示時にmain::gnEnvArg{'ReadProxy'}{'Password'}の値を読み込み
   my $gnEP = $_[0];
   if ($main::gnEnvArg{'ReadProxy'}{'Password'}) {
         $gnEP->set_text($main::gnEnvArg{'ReadProxy'}{'Password'});
   }
}

sub on_gnEnv_proxy_password_changed {
   # 環境設定ウィンドウ-[ネットワーク]-[プロキシ]-[HTTPプロキシ]-[読み込み用プロキシを使用]-[パスワード]
   # 変更時にgnEnvArgN{'ReadProxy'}{'Password'}へ値を書き込み
   my $gnEP = $_[0];
   $gnEnvArgN{'ReadProxy'}{'Password'} = $gnEP->get_text;
}

sub on_gnEnv_wproxy_use_realize {
   # 環境設定ウィンドウ-[ネットワーク]-[プロキシ]-[HTTPプロキシ]-[書き込み用プロキシを使用]
   # 表示時にmain::gnEnvArg{'WriteProxy'}{'Proxy'}の値を読み込み
   my $gnEP = $_[0];
   if ($main::gnEnvArg{'WriteProxy'}{'Proxy'} == 1) {
         $gnEP->set_active(TRUE);
   }else{
         $gnEP->set_active(FALSE);
   }
}

sub on_gnEnv_wproxy_use_toggled {
   # 環境設定ウィンドウ-[ネットワーク]-[プロキシ]-[HTTPプロキシ]-[書き込み用プロキシを使用]
   # 変更時にgnEnvArgN{'WriteProxy'}{'Proxy'}へ値を書き込み
   my $gnEP = $_[0];
   my $val = $gnEP->get_active;
   if ($val == TRUE) {
         $gnEnvArgN{'WriteProxy'}{'Proxy'} = 1;
   }else{
         $gnEnvArgN{'WriteProxy'}{'Proxy'} = 0;
   }
}

sub on_gnEnv_wproxy_url_realize {
   # 環境設定ウィンドウ-[ネットワーク]-[プロキシ]-[HTTPプロキシ]-[書き込み用プロキシを使用]-[URL]
   # 表示時にmain::gnEnvArg{'WriteProxy'}{'Address'}の値を読み込み
   my $gnEP = $_[0];
   if ($main::gnEnvArg{'WriteProxy'}{'Address'}) {
         $gnEP->set_text($main::gnEnvArg{'WriteProxy'}{'Address'});
   }
}

sub on_gnEnv_wproxy_url_changed {
   # 環境設定ウィンドウ-[ネットワーク]-[プロキシ]-[HTTPプロキシ]-[書き込み用プロキシを使用]-[URL]
   # 変更時にgnEnvArgN{'WriteProxy'}{'Address'}へ値を書き込み
   my $gnEP = $_[0];
   $gnEnvArgN{'WriteProxy'}{'Address'} = $gnEP->get_text;
}

sub on_gnEnv_wproxy_port_realize {
   # 環境設定ウィンドウ-[ネットワーク]-[プロキシ]-[HTTPプロキシ]-[書き込み用プロキシを使用]-[ポート番号]
   # 表示時にmain::gnEnvArg{'WriteProxy'}{'Port'}の値を読み込み
   my $gnEP = $_[0];
   if ($main::gnEnvArg{'WriteProxy'}{'Port'}) {
         $gnEP->set_text($main::gnEnvArg{'WriteProxy'}{'Port'});
   }
}

sub on_gnEnv_wproxy_port_changed {
   # 環境設定ウィンドウ-[ネットワーク]-[プロキシ]-[HTTPプロキシ]-[書き込み用プロキシを使用]-[ポート番号]
   # 変更時にgnEnvArgN{'WriteProxy'}{'Port'}へ値を書き込み
   my $gnEP = $_[0];
   $gnEnvArgN{'WriteProxy'}{'Port'} = $gnEP->get_text;
}

sub on_gnEnv_wproxy_username_realize {
   # 環境設定ウィンドウ-[ネットワーク]-[プロキシ]-[HTTPプロキシ]-[書き込み用プロキシを使用]-[ユーザ名]
   # 表示時にmain::gnEnvArg{'WriteProxy'}{'UserID'}の値を読み込み
   my $gnEP = $_[0];
   if ($main::gnEnvArg{'WriteProxy'}{'UserID'}) {
         $gnEP->set_text($main::gnEnvArg{'WriteProxy'}{'UserID'});
   }
}

sub on_gnEnv_wproxy_username_changed {
   # 環境設定ウィンドウ-[ネットワーク]-[プロキシ]-[HTTPプロキシ]-[書き込み用プロキシを使用]-[ユーザ名]
   # 変更時にgnEnvArgN{'WriteProxy'}{'UserID'}へ値を書き込み
   my $gnEP = $_[0];
   $gnEnvArgN{'WriteProxy'}{'UserID'} = $gnEP->get_text;
}

sub on_gnEnv_wproxy_password_realize {
   # 環境設定ウィンドウ-[ネットワーク]-[プロキシ]-[HTTPプロキシ]-[書き込み用プロキシを使用]-[パスワード]
   # 表示時にmain::gnEnvArg{'WriteProxy'}{'Password'}の値を読み込み
   my $gnEP = $_[0];
   if ($main::gnEnvArg{'WriteProxy'}{'Password'}) {
         $gnEP->set_text($main::gnEnvArg{'WriteProxy'}{'Password'});
   }
}

sub on_gnEnv_wproxy_password_changed {
   # 環境設定ウィンドウ-[ネットワーク]-[プロキシ]-[HTTPプロキシ]-[書き込み用プロキシを使用]-[パスワード]
   # 変更時にgnEnvArgN{'WriteProxy'}{'Password'}へ値を書き込み
   my $gnEP = $_[0];
   $gnEnvArgN{'WriteProxy'}{'Password'} = $gnEP->get_text;
}

sub on_gnEnv_permitPopup_Ext_realize {
   # 環境設定ウィンドウ-[文字とリンク]-[リンク]-[ポップアップする拡張子]
   # 表示時にmain::gnEnvArg{'Browser'}{'gnPermitPopupExt'}の値を読み込み
   my $gnE_PPExt = $_[0];
   if($main::gnEnvArg{'Browser'}{'gnPermitPopupExt'}) {
      $gnE_PPExt->set_text($main::gnEnvArg{'Browser'}{'gnPermitPopupExt'});
   }else{
      $gnE_PPExt->set_text("jpg,gif,bmp,tif,png");
   }
}

sub on_gnEnv_permitPopup_Ext_changed {
   # 環境設定ウィンドウ-[文字とリンク]-[リンク]-[ポップアップする拡張子]
   # 変更時にgnEnvArgN{'Browser'}{'gnPermitPopupExt'}へ値を書き込み
   my $gnE_PPExt = $_[0];
   $main::gnEnvArg{'Browser'}{'gnPermitPopupExt'} = $gnE_PPExt->get_text;
}

sub on_gnEnv_Color_notYetCached_realize {
   # 環境設定ウィンドウ-[文字とリンク]-[リンク]-[未キャッシュリンクの色]
   # 表示時にmain::gnEnvArg{'Thread'}{'gnLinkColorNotCached'}の値を読み込み
   my $gnE_C = $_[0];
   if($main::gnEnvArg{'Thread'}{'gnLinkColorNotCached'}) {
      my $gnE_C_color_red = substr($main::gnEnvArg{'Thread'}{'gnLinkColorNotCached'}, 1, 2);
      $gnE_C_color_red = hex($gnE_C_color_red) * 257;
      my $gnE_C_color_green = substr($main::gnEnvArg{'Thread'}{'gnLinkColorNotCached'}, 3, 2);
      $gnE_C_color_green = hex($gnE_C_color_green) * 257;
      my $gnE_C_color_blue = substr($main::gnEnvArg{'Thread'}{'gnLinkColorNotCached'}, 5, 2);
      $gnE_C_color_blue = hex($gnE_C_color_blue) * 257;
      
      my $gnE_C_color = Gtk2::Gdk::Color->new($gnE_C_color_red, $gnE_C_color_green, $gnE_C_color_blue);
      $gnE_C->set_color($gnE_C_color);
   }else{
      # main::gnEnvArg{'Thread'}{'gnLinkColorNotCached'}がセットされていなかったら
      # 初期値をセット
      $gnEnvArgN{'Thread'}{'gnLinkColorNotCached'} = "\#0000FF";
      my $gnE_C_color = Gtk2::Gdk::Color->new(0,0,65535);
      $gnE_C->set_color($gnE_C_color);
   }
}

sub on_gnEnv_Color_notYetCached_color_set {
   # 環境設定ウィンドウ-[文字とリンク]-[リンク]-[未キャッシュリンクの色]
   # 変更時にgnEnvArgN{'Thread'}{'gnLinkColorNotCached'}へ値を書き込み
   my $gnE_C = $_[0];
   my $gnE_C_color = $gnE_C->get_color;
   my $gnE_C_color_red = $gnE_C_color->red;
   $gnE_C_color_red = $gnE_C_color_red/257;
   $gnE_C_color_red = sprintf("%.2X", $gnE_C_color_red);
   my $gnE_C_color_green = $gnE_C_color->green;
   $gnE_C_color_green = $gnE_C_color_green/257;
   $gnE_C_color_green = sprintf("%.2X", $gnE_C_color_green);
   my $gnE_C_color_blue = $gnE_C_color->blue;
   $gnE_C_color_blue = $gnE_C_color_blue/257;
   $gnE_C_color_blue = sprintf("%.2X", $gnE_C_color_blue);
   if($main::gnDebugFlag) { print "on_gnEnv_Color_notYetCached_color_set\: \#${gnE_C_color_red}${gnE_C_color_green}${gnE_C_color_blue}\n"; }
   $gnEnvArgN{'Thread'}{'gnLinkColorNotCached'} = "\#${gnE_C_color_red}${gnE_C_color_green}${gnE_C_color_blue}";

}

sub on_gnEnv_Color_alreadyCached_realize {
   # 環境設定ウィンドウ-[文字とリンク]-[リンク]-[キャッシュ済みリンクの色]
   # 表示時にmain::gnEnvArg{'Thread'}{'gnLinkColorAlreadyCached'}の値を読み込み
   my $gnE_C = $_[0];
   if($main::gnEnvArg{'Thread'}{'gnLinkColorAlreadyCached'}) {
      my $gnE_C_color_red = substr($main::gnEnvArg{'Thread'}{'gnLinkColorAlreadyCached'}, 1, 2);
      $gnE_C_color_red = hex($gnE_C_color_red) * 257;
      my $gnE_C_color_green = substr($main::gnEnvArg{'Thread'}{'gnLinkColorAlreadyCached'}, 3, 2);
      $gnE_C_color_green = hex($gnE_C_color_green) * 257;
      my $gnE_C_color_blue = substr($main::gnEnvArg{'Thread'}{'gnLinkColorAlreadyCached'}, 5, 2);
      $gnE_C_color_blue = hex($gnE_C_color_blue) * 257;
      
      my $gnE_C_color = Gtk2::Gdk::Color->new($gnE_C_color_red, $gnE_C_color_green, $gnE_C_color_blue);
      $gnE_C->set_color($gnE_C_color);
   }else{
      # main::gnEnvArg{'Thread'}{'gnLinkColorAlreadyCached'}がセットされていなかったら
      # 初期値をセット
      $gnEnvArgN{'Thread'}{'gnLinkColorAlreadyCached'} = "\#0000FF";
      my $gnE_C_color = Gtk2::Gdk::Color->new(0,0,65535);
      $gnE_C->set_color($gnE_C_color);
   }

}

sub on_gnEnv_Color_alreadyCached_color_set {
   # 環境設定ウィンドウ-[文字とリンク]-[リンク]-[キャッシュ済みリンクの色]
   # 変更時にgnEnvArgN{'Thread'}{'gnLinkColorAlreadyCached'}へ値を書き込み
   my $gnE_C = $_[0];
   my $gnE_C_color = $gnE_C->get_color;
   my $gnE_C_color_red = $gnE_C_color->red;
   $gnE_C_color_red = $gnE_C_color_red/257;
   $gnE_C_color_red = sprintf("%.2X", $gnE_C_color_red);
   my $gnE_C_color_green = $gnE_C_color->green;
   $gnE_C_color_green = $gnE_C_color_green/257;
   $gnE_C_color_green = sprintf("%.2X", $gnE_C_color_green);
   my $gnE_C_color_blue = $gnE_C_color->blue;
   $gnE_C_color_blue = $gnE_C_color_blue/257;
   $gnE_C_color_blue = sprintf("%.2X", $gnE_C_color_blue);
   if($main::gnDebugFlag) { print "on_gnEnv_Color_alreadyCached_color_set\: \#${gnE_C_color_red}${gnE_C_color_green}${gnE_C_color_blue}\n"; }
   $gnEnvArgN{'Thread'}{'gnLinkColorAlreadyCached'} = "\#${gnE_C_color_red}${gnE_C_color_green}${gnE_C_color_blue}";
}

sub on_gnEnv_Font_useCustom_realize {
   # 環境設定ウィンドウ-[文字とリンク]-[フォント]-[システム標準のフォントを使用する]
   # 表示時にmain::gnEnvArg{'Browser'}{'gnBrowserFontUseCustom'}の値を読み込み
   my $gnEFuD = $_[0];
   my $gnEF = $main::gnEnvXML->get_widget('gnEnv_Font');
   
   if($main::gnEnvArg{'Browser'}{'gnBrowserFontUseCustom'}) {
         $gnEFuD->set_active(FALSE);
         $gnEF->sensitive(TRUE);
         if($main::gnDebugFlag) { print "on_gnEnv_Font_useDefault_realize\: env is set and trued\n"; }
   }else{
         $gnEFuD->set_active(TRUE);
         $gnEF->sensitive(FALSE);
         if($main::gnDebugFlag) { print "on_gnEnv_Font_useDefault_realize\: env is NOT set or setandfalsed\n"; }
   }
}

sub on_gnEnv_Font_useCustom_toggled {
   # 環境設定ウィンドウ-[文字とリンク]-[フォント]-[システム標準のフォントを使用する]
   # 変更時にgnEnvArgN{'Browser'}{'gnBrowserFontUseCustom'}へ値を書き込み
   my $gnEFuD = $_[0];
   my $gnEF = $main::gnEnvXML->get_widget('gnEnv_Font');
   
   my $flg = $gnEFuD->get_active;
   if($flg == TRUE) {
      $gnEnvArgN{'Browser'}{'gnBrowserFontUseCustom'} = FALSE;
      $gnEF->sensitive(FALSE);
   }else{
      $gnEnvArgN{'Browser'}{'gnBrowserFontUseCustom'} = TRUE;
      $gnEF->sensitive(TRUE);
   }
}

sub on_gnEnv_Font_realize {
   # 環境設定ウィンドウ-[文字とリンク]-[フォント]-[フォント]
   # 表示時に
   # main::gnEnvArg{'Browser'}{'BrowserFontName'}
   # main::gnEnvArg{'Browser'}{'BrowserFontBold'}
   # main::gnEnvArg{'Browser'}{'BrowserFontItalic'}
   # main::gnEnvArg{'Browser'}{'BrowserFontSize'}
   # の値を読み込み
   my $gnEF = $_[0];
   my $fntstr = "";
   if($main::gnEnvArg{'Browser'}{'BrowserFontName'}) {
      $fntstr = $main::gnEnvArg{'Browser'}{'BrowserFontName'};
   }
   if($main::gnEnvArg{'Browser'}{'BrowserFontBold'} != -1) {
      $fntstr .= " Bold";
   }
   if($main::gnEnvArg{'Browser'}{'BrowserFontItalic'} != -1) {
      $fntstr .= " Italic";
   }
   if($main::gnEnvArg{'Browser'}{'BrowserFontSize'}) {
      $fntstr .= " $main::gnEnvArg{'Browser'}{'BrowserFontSize'}";
   }
   $gnEF->set_font_name($fntstr);
}

sub on_gnEnv_Font_font_set {
   # 環境設定ウィンドウ-[文字とリンク]-[フォント]-[フォント]
   # 変更時に
   # gnEnvArgN{'Browser'}{'BrowserFontName'}
   # gnEnvArgN{'Browser'}{'BrowserFontBold'}
   # gnEnvArgN{'Browser'}{'BrowserFontItalic'}
   # gnEnvArgN{'Browser'}{'BrowserFontSize'}
   # へ値を書き込み
   my $gnEF = $_[0];
   my $fntname = "";
   my $fntbold_flg = FALSE;
   my $fntitalic_flg = FALSE;
   my $gnEF_fontname = $gnEF->get_font_name;
   my @ar = split(/ /, $gnEF_fontname);
   $gnEnvArgN{'Browser'}{'BrowserFontSize'} = pop(@ar);
   foreach my $val (@ar) {
      if($val eq "Italic") {
         $fntitalic_flg = TRUE;
      }elsif($val eq "Bold") {
         $fntbold_flg = TRUE;
      }else{
         if($fntname eq "") {
            $fntname = $val;
         }else{
            $fntname = $fntname . " " . $val;
         }
      }
      
   }
   $gnEnvArgN{'Browser'}{'BrowserFontName'} = $fntname;
   if($fntitalic_flg == TRUE) {
      $gnEnvArgN{'Browser'}{'BrowserFontItalic'} = 1;
   }else{
      $gnEnvArgN{'Browser'}{'BrowserFontItalic'} = -1;
   }
   if($fntbold_flg == TRUE) {
      $gnEnvArgN{'Browser'}{'BrowserFontBold'} = 1;
   }else{
      $gnEnvArgN{'Browser'}{'BrowserFontBold'} = -1;
   }
   if($main::gnDebugFlag) {
      &gnLogger("on_gnEnv_Font_font_set\: font_name\: $gnEnvArgN{'Browser'}{'BrowserFontName'}");
      &gnLogger("on_gnEnv_Font_font_set\: font_bold\: $gnEnvArgN{'Browser'}{'BrowserFontBold'}");
      &gnLogger("on_gnEnv_Font_font_set\: font_italic\: $gnEnvArgN{'Browser'}{'BrowserFontItalic'}");
      &gnLogger("on_gnEnv_Font_font_set\: font_size\: $gnEnvArgN{'Browser'}{'BrowserFontSize'}");
   }
}

sub on_gnEnv_Write_useQuotation_realize {
   # 環境設定ウィンドウ-[書き込み]-[「ここにレス」するときに元のレスを引用する]
   # 表示時に
   # main::gnEnvArg{'Browser'}{'gnWriteWithQuotation'}
   # の値を読み込み
   my $gnEWwQ = $_[0];
   
   if($main::gnEnvArg{'Browser'}{'gnWriteWithQuotation'}) {
         $gnEWwQ->set_active(FALSE);
         if($main::gnDebugFlag) { print "on_gnEnv_Write_useQuotation_realize\: env is set and trued\n"; }
   }else{
         $gnEWwQ->set_active(TRUE);
         if($main::gnDebugFlag) { print "on_gnEnv_Write_useQuotation_realize\: env is NOT set or setandfalsed\n"; }
   }
}

sub on_gnEnv_Write_useQuotation_toggled {
   # 環境設定ウィンドウ-[書き込み]-[「ここにレス」するときに元のレスを引用する]
   # 変更時に
   # main::gnEnvArg{'Browser'}{'gnWriteWithQuotation'}
   # へ値を書き込み
   my $gnEWwQ = $_[0];
   
   my $flg = $gnEWwQ->get_active;
   if($flg == TRUE) {
      $gnEnvArgN{'Browser'}{'gnWriteWithQuotation'} = FALSE;
   }else{
      $gnEnvArgN{'Browser'}{'gnWriteWithQuotation'} = TRUE;
   }

}

#--------------------------------------
# GUIメソッド(アクション)対応関数
#--------------------------------------

sub on_gnSI_filcl_clicked {
   # クリアボタンが押されたらスレフィルタをクリア
   my $gnSIFil = $main::gnGUIxml->get_widget('gnSI_fil');
   $gnSIFil->child->set_text('');
}

sub on_gnSI_fil_changed {
   # スレフィルタに入力、もしくはプルダウンから選択された
   my $gnSIFil = $_[0];
   my $gnItaView = $main::gnGUIxml->get_widget('gnII');
   &gnSleIchiranSelect($gnItaView,"none");

}

sub on_gnSI_fil_realize {
   # スレフィルタ初期化

   my $gnSIFil = $_[0];
   if($main::gnDebugFlag) { print "realize\:\n" . Dumper($gnSIFil)."\n"; }

   my @gnSIFilHashKeys = keys(%{$main::gnEnvArg{'SelectText'}});
   foreach my $val(@gnSIFilHashKeys) {
     if ($main::gnEnvArg{'SelectText'}{$val}) {
        $gnSIFil->append_text($main::gnEnvArg{'SelectText'}{$val});
     }
  }

}

sub on_gnSInoteChange_toggled {
    # スレ一覧とお気に入り表示を切り替えボタンをクリックした
    
    my $gnSInote = $_[0];
    my $gnSIFAnote = $main::gnGUIxml->get_widget('gnSIFAnote');
    if($gnSInote->get_active) {
        $gnSIFAnote->set_current_page(1);
    }else{
        $gnSIFAnote->set_current_page(0);
    }
    
}

sub on_gnTBS_write_clicked {
   # 書き込むボタンが押された
   &gnWrite;
}

sub on_gnMS_write_activate {
   # 書き込むボタンが押された
   &gnWrite;
}

sub on_mW_unrealize {
   # メインウィンドウが閉じたら終了
   &gnExit;
}

sub gnSureViewMouseMove {
   # UTF-8 Compliant!
   # スレ表示のTextViewの中でマウスが動いたら
   # この関数が呼び出される
   # ここから各ポップアップの呼び出しに分岐する
   my ($gnSureV, $gnEvent) = @_;

   my $gnHover = FALSE;
   my $gnLink = '';
   my ($x, $y) = $gnSureV->window_to_buffer_coords('widget', #GTK_TEXT_WINDOW_WIDGET,
                                                    $gnEvent->x, $gnEvent->y);
   
   my $gnSV_iter = $gnSureV->get_iter_at_location ($x, $y);
   
   foreach my $gnTag ($gnSV_iter->get_tags) {
      if($gnTag->{page}) {
         # タグの中に"page"タグを含んでいれば$gnHoverフラグをTRUEにして
         # ループを抜ける
         $gnLink = $gnTag->{page};
         $gnHover = TRUE;
         last;
      }
   }
   
   if($gnHover == TRUE) {
      if($main::gnHoverOverLink != $gnHover) {
         $main::gnHoverOverLink = $gnHover;
         $gnSureV->get_window('text')->set_cursor($main::gnCursor_Link);
         my $gnLinkFlg = substr($gnLink, 0, 4);
         if($gnLinkFlg eq "resn") {
                         if($main::gnDebugFlag) { print "resn: $gnLink\n"; }
                         $gnHoverResN = $gnLink;
         }elsif($gnLinkFlg eq "repl") {
                         if($main::gnDebugFlag) { print "repl\n"; }
                         # レス先をポップアップ表示
                         if($main::gnPopupText eq "") {
                            $gnLink = substr($gnLink, 10);
                            if(!($main::gnPopupTextCallback)) {
                               $main::gnPopupTextCallback = Glib::Timeout->add(100, sub {
                                                                                               $main::gnPopupText = &gnResPopup($gnLink);
                                                                                               return(0);
                                                                                             },
                                                                                    undef, 0
                                                                                   );
                            }
                            # ポップアップウィンドウの位置を調整
                            if(!($main::gnImgUpdateCallback)) {
                               $main::gnImgUpdateCallback = Glib::Timeout->add(200, sub {
                                                                               my $retval = &on_gnPopupText_check_resize($main::gnPopupText);
                                                                               return($retval);
                                                                             },
                                                                     undef, 0
                                                                    );
                            }
                            

                         }

         }elsif($gnLinkFlg eq "datl") {
                         # read.cgiを含んだリンク
                         if($main::gnDebugFlag) { print "datl\n"; }
         }elsif($gnLinkFlg eq "http") {
                         # httpの場合は別のスレをさしている場合と
                         # 画像などの場合がある
                         # 画像の場合は読み込んでポップアップ表示する
                         if($main::gnDebugFlag) { print "http\n"; }
                         
                         # 拡張子が該当のものの場合だけポップアップを表示
                         my $testptn = $main::gnEnvArg{'Browser'}{'gnPermitPopupExt'};
                         $testptn =~ s/\,/\|/g;
                         
                         my $gnPop_URLFNbuf = substr($gnLink, rindex($gnLink, "\/")+1);
                         my @URLFNbuf = split(/\./, $gnPop_URLFNbuf);
                         my $gnPop_URLFN = "";
                         my $gnPop_URLExt = pop(@URLFNbuf);
                         
                         if(($main::gnEnvArg{'Browser'}{'PreviewVisible'} != 0) && ($gnPop_URLExt =~ m/(${testptn})/i)) {
                         
                         

                            
                         # 指定の時間waitするための
                         # Gtk2のtimeout関数をセット
                         if (!($main::gnPopupCallback)) {
                            
                            
                            $main::gnPopupCallback = Glib::Timeout->add($main::gnEnvArg{'Browser'}{'PreviewWait'},
                                                  sub{ 
                                                     # ポップアップ画像の情報を作成
                                                     my $gnNoteP = $gnSureV->parent->parent->get_current_page;
                                                     my $gnDatInfo;
                                                     my $gnItaDir;
                                                     my $gnDatNo;
                                                     for my $i ( 0 .. $#main::gnSureViewInfo ) {
                                                        if ($gnNoteP == $i) {
                                                           $gnDatInfo = $main::gnSureViewInfo[$i][0];
                                                           ($gnItaDir, $gnDatNo) = split(/\//, $gnDatInfo);
                                                           last;
                                                        }
                                                     }
                                                     my $sute;
                                                     ($gnDatNo, $sute) = split(/\./, $gnDatNo);
                                                     
                                                     my ($itaname, $itaurl) = split(chr(001), $main::gnBoardTbl{$gnItaDir});
                                                     
                                                     my $gnPop_SI = $main::gnGUIxml->get_widget('gnSI');
                                                     my $gnPop_SIM = $gnPop_SI->get_model;
                                                     my $gnPop_SureName = &gnGetSureVarFromDat($gnPop_SIM, $gnDatInfo, 0);
                                                     $gnPop_SureName = substr($gnPop_SureName, index($gnPop_SureName, "\: ")+2);
                                                     $gnPop_SureName =~ s/\//_/g;
                                                     
                                                     for (my $j=0;$j<@URLFNbuf;$j++) {
                                                        $gnPop_URLFN .= $URLFNbuf[$j] . "\.";
                                                     }
                                                     chop($gnPop_URLFN);
                                                     
                                                     my $gnPop_cachetime;
                                                     my $gnPop_cachefn;
                                                     my @gnPop_cachetimear;
                                                     if($main::gnCacheTbl{'Cache'}{$gnLink}) {
                                                        ($gnPop_cachetime, $gnPop_cachefn) = split(chr(001), $main::gnCacheTbl{'Cache'}{$gnLink});
                                                     }else{
                                                        $gnPop_cachetime = 0;
                                                        $gnPop_cachefn = "";
                                                     }
                                                     @gnPop_cachetimear = localtime($gnPop_cachetime);

                                                     
                                                     if ($main::gnDebugFlag) {
                                                        print("gnSureViewMouseMove:\t$gnLink\t$itaname\t$gnItaDir\t$gnDatNo\t$gnPop_SureName\t$gnPop_URLFN\t$gnPop_URLExt\t$gnPop_cachetime\t$gnPop_cachefn\t$gnPop_cachetimear[5]\t$gnPop_cachetimear[4]\t$gnPop_cachetimear[2]\t$gnPop_cachetimear[1]\t$gnPop_cachetimear[0]\n");
                                                     }
                                                     %main::gnImgPopup_info = ('URL' => $gnLink,
                                                                           'ItaName' => $itaname,
                                                                           'ItaDir' => $gnItaDir,
                                                                           'DatNo' => $gnDatNo,
                                                                           'SureName' => $gnPop_SureName,
                                                                           'URLFN' => $gnPop_URLFN,
                                                                           'URLExt' => $gnPop_URLExt,
                                                                           'CacheTime' => $gnPop_cachetime,
                                                                           'CacheFN' => $gnPop_cachefn,
                                                                           'Year' => $gnPop_cachetimear[5]+1900,
                                                                           'Month' => sprintf("%02d", $gnPop_cachetimear[4]+1),
                                                                           'Day' => sprintf("%02d", $gnPop_cachetimear[3]),
                                                                           'Hour' => sprintf("%02d", $gnPop_cachetimear[2]),
                                                                           'Minute' => sprintf("%02d", $gnPop_cachetimear[1]),
                                                                           'Second' => sprintf("%02d", $gnPop_cachetimear[0]),
                                                                           );
                                                     if ($main::gnDebugFlag) { print Dumper(%main::gnImgPopup_info) . "\n";}
                                                     
                                                     # ポップアップを表示
                                                     my $ref = &gnImgPopup2($gnLink);
                                                     ($main::gnPopupImg, $main::gnPop2) = @$ref;
                                                     return(FALSE);
                                                  },
                                                  undef,
                                                  0);
                           # gnImgBufferUpdateを定期的に呼び出すtimeout関数をセット
                           if (!($main::gnImgUpdateCallback)) {
                           $main::gnImgUpdateCallback = Glib::Timeout->add($main::gnEnvArg{'Browser'}{'PreviewWait'},
                                                                        sub {
                                                                        my $retval;
                                                                        my $ref = &gnImgBufferUpdate($main::gnPopupImg, $main::gnPop2);
                                                                        ($main::gnPopupImg, $main::gnPop2, $retval) = @$ref;
                                                                        return($retval);
                                                                        },
                                                                        undef,
                                                                        0);
                        
                           }
                         }
                         }
                        
           }
           else {
              if($main::gnDebugFlag) { print "Unknown Code\:$gnLinkFlg\n"; }
           }
            
      }else{
         $gnSureV->get_window('text')->set_cursor($main::gnCursor_Link);
      }
   }else{
      if($main::gnHoverOverLink != $gnHover) {
         $main::gnHoverOverLink = $gnHover;
         $gnSureV->get_window('text')->set_cursor($main::gnCursor_Beam);

         # ポップアップウィンドウが出てたらdestroyする
         if($main::gnPopupText ne "") {
            $main::gnPopupText->destroy;
            $main::gnPopupText = "";
         }
         if ($main::gnPopupImg) {
            if($main::gnPopupImg ne "") {
               if($main::gnDebugFlag) { print "linkout-img2\:" . Dumper($main::gnPopupImg) . "\n"; }
               Gtk2::Object::destroy($main::gnPopupImg);
               $main::gnPop2->clear;
               $main::gnPopupImg = "";
            }
         }
            
         # 2段階ポップアップの段階をリセット
         $main::gnPopupImgSt = 1;
         
         # timeout関数をremoveする。
         # removeしないと次のポップアップが出ない
         if ($main::gnPopupCallback) {
            Glib::Source->remove($main::gnPopupCallback);
            undef($main::gnPopupCallback);
         }
         if ($main::gnPopupTextCallback) {
            Glib::Source->remove($main::gnPopupTextCallback);
            undef($main::gnPopupTextCallback);
         }
         if ($main::gnImgUpdateCallback) {
            if ($main::gnImgUpdateCallback ne "") {
               Glib::Source->remove($main::gnImgUpdateCallback);
               undef($main::gnImgUpdateCallback);
            }
         }
      }else{
         $gnSureV->get_window('text')->set_cursor($main::gnCursor_Beam);
      }
   }
   
   # 必ずget_pointerしてFALSEを返すこと
   # get_pointerしないと、Linuxではクリックしたとき(正確に言うとPRESS_AFTER)しかイベントを
   # 検出しない。
   # またFALSEを入れないとTextView内で
   # 文字の選択ができないようになってしまう
   $gnSureV->window->get_pointer;
   return FALSE;
}

sub gnSureViewLinkPress {
   # リンクをクリック(マウスダウン)したときに実行する関数
   # ポップアップウィンドウを消去する
   
   if($main::gnDebugFlag) { print "LinkClick\(button_press_event\)\n"; }
   my ($gnSureV, $gnEvent) = @_;
   
   if ($main::gnPopupCallback) {
      Glib::Source->remove($main::gnPopupCallback);
      undef($main::gnPopupCallback);
   }
   if ($main::gnImgUpdateCallback) {
      Glib::Source->remove($main::gnImgUpdateCallback);
      undef($main::gnPopupCallback);
   }
   # ポップアップウィンドウが出てたらdestroyする
   if($main::gnPopupText ne "") {
      $main::gnPopupText->destroy;
      $main::gnPopupText = "";
   }
   if ($main::gnPopupImg) {
      if($main::gnPopupImg ne "") {
         if($main::gnDebugFlag) { print "linkout-img2\:" . Dumper($main::gnPopupImg); }
         Gtk2::Object::destroy($main::gnPopupImg);
         # 2段階ポップアップの段階をリセット
         $main::gnPopupImgSt = 1;
         if ($main::gnPop2) {
            $main::gnPop2->clear;
         }
         $main::gnPopupImg = "";
      }
   }
   $gnSureV->window->get_pointer;
   return(FALSE);
}

sub gnSureViewLinkRelease {
   # リンクをクリック(マウスリリース)したときに実行する関数
   # ポップアップウィンドウを消去する
   if($main::gnDebugFlag) { print STDERR "LinkClick\(button_release_event\)\n"; }
   if($main::gnDebugFlag>1) { print Dumper(@_);}
   my ($gnSureV, $gnEvent) = @_;

   my $gnHover = FALSE;
   my $gnLink = '';
   my ($x, $y) = $gnSureV->window_to_buffer_coords('widget', #GTK_TEXT_WINDOW_WIDGET,
                                                         $gnEvent->x, $gnEvent->y);
   
   my $gnSV_iter = $gnSureV->get_iter_at_location ($x, $y);
   
   foreach my $gnTag ($gnSV_iter->get_tags) {
      if($gnTag->{page}) {
         # タグの中に"page"タグを含んでいれば$gnHoverフラグをTRUEにして
         # ループを抜ける
         $gnLink = $gnTag->{page};
         $gnHover = TRUE;
         last;
      }
   }
   
   if ($gnHover) {
      # リンクの中にあったら以下の処理をする
      $gnSureV->get_window('text')->set_cursor($main::gnCursor_Link);
      my $gnLinkFlg = substr($gnLink, 0, 4);
            
      if($gnLinkFlg eq "resn") {
                       if($main::gnDebugFlag) { print STDERR "\(PressAfter-resn\)\n"; }
                       my $gnLink_resNo = "レス番号: " . substr($gnLink, rindex($gnLink, '/')+1);
                       
                       # メニューをポップアップ
                       my $evwindow = $gnSureV->get_parent_window;
                       $main::gnTPxml = Gtk2::GladeXML->new($main::gladefn, 'gnTP');
                       $main::gnTPxml->signal_autoconnect_from_package('main');
                       my $gnTP = $main::gnTPxml->get_widget('gnTP');
                       my $gnTP_resNo = $main::gnTPxml->get_widget('gnTP_resNo');
                       $gnTP_resNo = $gnTP_resNo->get_child;

                       if($main::gnDebugFlag) { print STDERR Dumper($gnTP_resNo); }
                       $gnTP_resNo->set_label($gnLink_resNo);
                       $gnTP->popup(undef,undef,undef,undef,undef,undef);
                       $gnTP->set_parent_window($evwindow);
      }elsif($gnLinkFlg eq "repl"){
                       if($main::gnDebugFlag) { print STDERR "\(PressAfter-repl\)\n"; }
      }elsif($gnLinkFlg eq "datl") {
                       if($main::gnDebugFlag) { print STDERR "\(PressAfter-datl\)\n"; }
                       $gnLink = substr($gnLink, 7);
                       if($main::gnDebugFlag) { print "$gnLink\n"; }
                       my($buf1, $linktgt) =  split(/read\.cgi/, $gnLink);
                       $linktgt = &gnGetlinktgt($linktgt); #read.cgiの仕様違いを吸収
                       my ($ita, $datno, $sute) = split(/\//, $linktgt);
                       my ($tgtname, $tgturl) = split(chr(001), $main::gnBoardTbl{$ita});
                       
                       # 取得したdat番号がすでにFolder.idx内にあるかどうかチェック
                       my $idxfn = $main::logdir . $ita . "\/Folder.idx";
                       my $datfn = $datno . "\.dat";
                       if($main::gnDebugFlag) { print "ita=$ita, datno=$datno, sute=$sute\n"; }
                       if($main::gnDebugFlag) { print "tgtname=$tgtname, tgturl=$tgturl\n"; }
                       if($main::gnDebugFlag) { print "Folder\.idx\(fullpath\)\: $idxfn\n"; }
                       if($main::gnDebugFlag) { print "datfilename\: $datfn\n"; }
                       
                       if (!(&gnCheckPath($main::logdir . $ita))) {
                       my $dirres = &gnYesNo("Folder.idxを保管するディレクトリがないのでスレが取れません\n板名\: $tgtname\nディレクトリ\: " . $main::logdir . $ita . "\nURL\: $tgturl\nディレクトリを作成しますか？");
                          if ($dirres eq "yes") {
                             &gnMakeDir($main::logdir . $ita);
                          }else{
                             &gnLogger("スレの取得をキャンセルしました");
                             last;
                          }
                       }
                       
                       if($main::gnDebugFlag) { print "chekking Folder.idx.\(datfn=$datfn, idxfn=$idxfn\)\n"; }
                       my $gnIsDatNameAlrdyLocalFLG = &gnIsDatNameAlrdyLocal($datfn, $idxfn);
                       
                       if ($gnIsDatNameAlrdyLocalFLG) {
                          # 既にFolder.idx内にある
                          if($main::gnDebugFlag) { print "already in Folder.idx\n"; }
                          
                          my $gnSS_Genre = $main::gnGUIxml->get_widget('gnII');
                          my $gnSS_GenreM = $gnSS_Genre->get_model;
                          my ($gnSS_GenreP, $gnSS_GenreC) = $gnSS_Genre->get_cursor;
                          my $gnSS_GenreI = $gnSS_GenreM->get_iter($gnSS_GenreP);
                          my $gnSS_Genre_now = $gnSS_GenreM->get($gnSS_GenreI, 1);

                          $gnSS_Genre_now = &gnGetGenreFromURL($gnSS_Genre_now);
                          if($main::gnDebugFlag) { print "$gnSS_Genre_now\n"; }

                          if ($gnSS_Genre_now ne $ita) {
                             $gnSS_GenreM->foreach(\&gnGetItaPathFromStr, $ita);
         
                             my $gnSS_SuresNow = $main::gnGUIxml->get_widget('gnSI');
                             $gnSS_SuresNow->scroll_to_point(0, 0);
                             $gnSS_SuresNow->set_cursor(&gnSureSelectFromDat(($ita . "\/" . $datno . "\.dat")));
                          }else{
                             my $gnSS_SuresNow = $main::gnGUIxml->get_widget('gnSI');
                             $gnSS_SuresNow->scroll_to_point(0, 0);
                             my $gncursor = &gnSureSelectFromDat($ita . "\/" . $datno . "\.dat");
                             if($main::gnDebugFlag) { print Dumper($gncursor)."\n"; }
                             $gnSS_SuresNow->set_cursor($gncursor);
                          }
                          
                       }else{
                          # Folder.idxの中にはない
                          if($main::gnDebugFlag) { print "no entry in Folder.idx\n"; }
                          
                          # subject.txtを取得してFolder.idxを更新し再チェック
                          &gnLogger("対象の板の現在のスレ一覧を取得します");
                          my $idxdir = $main::logdir . $ita . "\/";
                          my $suburl = $tgturl . "subject.txt";
                          my $gnSIUFlg = &gnSureItiranUpdate($suburl, $idxdir);
                          if($gnSIUFlg == TRUE) {
                               &gnLogger("スレ一覧を更新しました");
                          }else{
                               &gnLogger("スレ一覧更新に失敗しました");
                          }
                          
                          if($main::gnDebugFlag) { print "chekking Folder.idx\(AGAIN\).\(datfn=$datfn, idxfn=$idxfn\)\n"; }
                          my $gnIsDatNameAlrdyLocalFLG2 = &gnIsDatNameAlrdyLocal($datfn, $idxfn);
                       
                          if ($gnIsDatNameAlrdyLocalFLG2) {
                             # 再取得の結果、既にFolder.idx内にある
                             if($main::gnDebugFlag) { print "\(retry\)already in Folder.idx\n"; }
                          
                             my $gnSS_Genre = $main::gnGUIxml->get_widget('gnII');
                             my $gnSS_GenreM = $gnSS_Genre->get_model;
                             my ($gnSS_GenreP, $gnSS_GenreC) = $gnSS_Genre->get_cursor;
                             my $gnSS_GenreI = $gnSS_GenreM->get_iter($gnSS_GenreP);
                             my $gnSS_Genre_now = $gnSS_GenreM->get($gnSS_GenreI, 1);
 
                             $gnSS_Genre_now = &gnGetGenreFromURL($gnSS_Genre_now);
                             if($main::gnDebugFlag) { print "$gnSS_Genre_now\n"; }

                             $gnSS_GenreM->foreach(\&gnGetItaPathFromStr, $ita);
         
                             my $gnSS_SuresNow = $main::gnGUIxml->get_widget('gnSI');
                             $gnSS_SuresNow->scroll_to_point(0, 0);
                             $gnSS_SuresNow->set_cursor(&gnSureSelectFromDat(($ita . "\/" . $datno . "\.dat")));
                          
                          }else{
                          
                             # 再取得してもFolder.idxの中にはない
                             # datを取得し
                             # Folder.idxにスレの情報を追加
                             &gnLogger("スレタイの取得が出来ませんでした。datの取得を試みます");
                             my ($gnGetDatRST, $gnGetDatRes) = &gnGetDat($tgturl, $datfn);
                             if ($gnGetDatRST eq "gn200OK") {
                                my $gnNow = time();
                                # 取得数を更新
                                my $gnDatNumRow = 0;
                                my $gnItaDatFN = $main::logdir . $ita . "\/$datfn";
                                my $gnDatF2 = &gnOpenLocal($gnItaDatFN, "r");
                                while(<$gnDatF2>) {
                                   $gnDatNumRow++;
                                }
                                &gnCloseLocal($gnItaDatFN);
                                my $gnFolderIdxUpdateFLG = "";
                                my $gnFolderIdxGetValFLG = "";
                             
                                my $gngmt = str2time($gnGetDatRes->header('Last-Modified'));
                                $gngmt += 32400;
                                my @pushvar = ($datfn,
                                                "",
                                                sprintf("%X", $gnDatNumRow),
                                                0,
                                                sprintf("%X", $gnDatNumRow),
                                                sprintf("%X", $gngmt),
                                                sprintf("%X", $gnDatNumRow),
                                                0,0,0,0,
                                                sprintf("%X", $gnDatNumRow),
                                                0,
                                                3
                                                );
                                &gnFolderIdxPush($idxfn, \@pushvar);
                                
                                # 取得したスレを表示
                                &gnItaSelect($ita);

                                my $gnSS_SuresNow = $main::gnGUIxml->get_widget('gnSI');
                                $gnSS_SuresNow->scroll_to_point(0, 0);
                                my $aaa = &gnSureSelectFromDat($ita . "\/" . $datno . "\.dat");
                                if($main::gnDebugFlag) { print "sureselectfromdat\: " . Dumper($aaa); }
                                $gnSS_SuresNow->set_cursor($aaa);
                             }else{
                                # datの取得に失敗
                             }
                          }
                       }
                       
         }elsif($gnLinkFlg eq "http") {
                       if($main::gnDebugFlag) { print STDERR "\(PressAfter-http\)\n"; }
                       &gnJumpToURL($gnLink);
         }else{
                       if($main::gnDebugFlag) { print STDERR "\(PressAfter-else\)\n"; }
         }
   }else{
      if($main::gnDebugFlag) { print STDERR "\(PressAfter-outoflink\)\n"; }
      
   }

   $gnSureV->window->get_pointer;
   return(FALSE);
}

sub gnSureViewKeyRelease {
   # キーを押した(キーリリース)したときに実行する関数
   #
   # 引数1: Gtk2::TextView
   # 引数2: Gtk2::Gdk::Event::Key
   if($main::gnDebugFlag) { print STDERR "KeyRelease\(key_release_event\)\n"; }
   if($main::gnDebugFlag>1) { print Dumper(@_);}
   my ($gnSureV, $gnEvent) = @_;
   my $gnSVKR_TextBuf = $gnSureV->get_buffer;
   
   my $keyval = $gnEvent->keyval;
   if($main::gnDebugFlag>1) { print "$keyval\n";}
   if($keyval == 65360) {
      # HOMEキー
      my $itr = $gnSVKR_TextBuf->get_start_iter;
      $gnSureV->scroll_to_iter($itr, 0, FALSE, 0, 0);
   
   }elsif($keyval == 65367) {
      # ENDキー
      my $itr = $gnSVKR_TextBuf->get_end_iter;
      $gnSureV->scroll_to_iter($itr, 0, FALSE, 0, 0);

   }
   
   $gnSureV->window->get_pointer;
   return(FALSE);
}

sub on_gnII_size_allocate {
   # カテゴリ一覧のハンドルバーが動いたら
   # 下にあるGtkHPanのハンドルバー位置を環境変数の配列に記憶
   my $gnCatHPan = $_[2];
   my $gnCatHPan_pos = $gnCatHPan->get_position;
   $main::gnEnvArg{'CategoryColumnWidth'}{'ID0'} = $gnCatHPan_pos;
}

sub on_gnSI_size_allocate {
   # 板一覧のハンドルバーが動いたら
   # 下にあるGtkVPanのハンドルバー位置を環境変数の配列に記憶
   my $gnItaVPan = $_[2];
   my $gnItaVPan_pos = $gnItaVPan->get_position;
   $main::gnEnvArg{'BoardColumnWidth'}{'ID7'} = $gnItaVPan_pos;
}

sub on_gnMH_about_activate {
   # aboutボックスの表示
   my $gnAboutxml = Gtk2::GladeXML->new($main::gladefn, 'gnAbout');
   $gnAboutxml->signal_autoconnect_from_package;
   my $gnAbout = $gnAboutxml->get_widget('gnAbout');
   my $gnAboutIcon = $gnAboutxml->get_widget('gnAboutIcon');
   $gnAboutIcon->set_from_pixbuf(&gnGetgnIconPixbuf());
   $gnAbout->show;
}

sub on_gnTB_bupdate_clicked {
   # 板更新
   &gnGetItaIchiran;
}

sub on_gnMF_bupdate_activate {
   # 板更新
   &gnGetItaIchiran;
}

sub on_gnSureUpdate_clicked {
   # スレ一覧更新
   my $gnItaView = $main::gnGUIxml->get_widget('gnII');
   &gnLogger("スレ一覧を更新します");
   &gnSleIchiranSelect($gnItaView, "force");
}

sub on_gnMS_sureitiranupdate_activate {
   # スレ一覧更新
   my $gnItaView = $main::gnGUIxml->get_widget('gnII');
   &gnLogger("スレ一覧を更新します");
   &gnSleIchiranSelect($gnItaView, "force");

}

sub on_gnME_copy_activate {
   # メニュー[編集]-[コピー]が選択された、もしくは<Ctrl>+Cキーが押された
   my $gnNote = $main::gnGUIxml->get_widget('gnNote');
   my $gnNote_nowpagenum = $gnNote->get_current_page;
   if ($gnNote_nowpagenum < 0) {
      return;
   }
   
   my $gnTxtV = $gnNote->get_nth_page($gnNote_nowpagenum);
   if($main::gnDebugFlag) { print Dumper($gnTxtV) . "\n"; }
   if (!($gnTxtV)) {
       return;
   }else{
       $gnTxtV = $gnTxtV->child;
       if($main::gnDebugFlag) { print Dumper($gnTxtV) . "\n"; }
   }
   my $gnTxtBuf = $gnTxtV->get_buffer;
   my $gnTxtClip = $gnTxtV->get_clipboard();
   $gnTxtBuf->copy_clipboard($gnTxtClip);
   
}

sub on_gnMF_quit_activate {
   # 終了処理
   &gnExit;
}

sub on_gnAB_ok_clicked {
   # Aboutダイアログの「閉じる」ボタンがクリックされたら
   # ダイアログボックスを閉じる
   my $gnAbout = $_[1];
   $gnAbout->destroy;
   $gnAbout = undef;
}

sub on_gnAbout_close {
   # ダイアログボックスを閉じる
   my $gnAbout = $_[0];
   $gnAbout->destroy;
   $gnAbout = undef;
}

sub on_gnMS_Env_activate {
   # メニューから「設定」が選択されたので
   # 環境設定ウィンドウを開く
   $main::gnEnvXML = Gtk2::GladeXML->new($main::gladefn, 'gnEnv');
   $main::gnEnvXML->signal_autoconnect_from_package('main');

   my $gnEnv = $main::gnEnvXML->get_widget('gnEnv');
   
   my $mW = $main::gnGUIxml->get_widget('mW');
   $gnEnv->set_transient_for($mW);
   $gnEnv->set_modal(TRUE);
   
#   %gnEnvArgN = %main::gnEnvArg;
   %gnEnvArgN = %{ dclone(\%main::gnEnvArg) };

   $gnEnv->show_all;
}

sub on_gnEnvNote_switch_page { } # ページが変わっても別に何もしない

sub on_eventbox2_button_release_event {
   # ポップアップウィンドウが出てたらdestroyする
   if($main::gnDebugFlag) { print "button_press_event\n"; }
   my $evwidget = $_[0];
   if($main::gnDebugFlag) { print Dumper($evwidget) . "\n"; }
   my $evbutton = $_[1];
   my $evbtnum = $evbutton->button;
   my $evwindow = $evwidget->get_parent_window;
   if($main::gnDebugFlag) { print Dumper($evwindow) . "\n"; }

   if($evwindow) {
      if($evbtnum == 3) {
         # 右クリックならポップアップメニューを表示
         
         $main::gnIPxml = Gtk2::GladeXML->new($main::gladefn, 'gnIP');
         $main::gnIPxml->signal_autoconnect_from_package('main');
         my $gnIP = $main::gnIPxml->get_widget('gnIP');
         # 【俺メモ】画像がキャッシュしきれてなければ「画像に名前をつけて保存」は
         # disableすること
         $gnIP->popup(undef,undef,undef,undef,undef,undef);
         $gnIP->set_parent_window($evwindow);
      }else{
         # 右クリック以外なら
         
         # 2段階ポップアップが無効
         # もしくは有効で今が2段目ならウィンドウを閉じる
         if (($main::gnEnvArg{'Browser'}{'PreviewVisibleSt2'} == 1) && ($main::gnPopupImgSt == 1)) {
            $main::gnPopupImgSt = 2;
            
            &gnImgBufferUpdate($main::gnPopupImg, $main::gnPop2);

         }else{
         
            $evwindow->destroy;
            $main::gnPopupImg = "";
            $main::gnPop2->clear;
            $main::gnPopupImgSt = 1;
      
            # timeout関数をremoveする。
            # removeしないと次のポップアップが出ない
            if ($main::gnPopupCallback) {
               Glib::Source->remove($main::gnPopupCallback);
               undef($main::gnPopupCallback);
            }
            if ($main::gnImgUpdateCallback) {
               Glib::Source->remove($main::gnImgUpdateCallback);
               undef($main::gnPopupCallback);
            }
         }
      }
   }

}

sub on_gnIS_pattern_changed {
  # 「画像を名前をつけて保存」ダイアログボックスで
  # 保存パターンを変更した
  my $gnIS_pattern = $_[0];
  my $gnIS_ptnstr = $gnIS_pattern->get_text;
  my @ptnar = split("\%", $gnIS_ptnstr);
  my $outbuf = "";
  foreach my $val (@ptnar) {
     my $flg = substr($val, 0, 1);
     if($flg eq "I") {
        $outbuf .= $main::gnImgPopup_info{'ItaName'};
     }elsif($flg eq "i") {
        $outbuf .= $main::gnImgPopup_info{'ItaDir'};
     }elsif($flg eq "T") {
        $outbuf .= $main::gnImgPopup_info{'SureName'};
     }elsif($flg eq "t") {
        $outbuf .= $main::gnImgPopup_info{'DatNo'};
     }elsif($flg eq "F") {
        $outbuf .= $main::gnImgPopup_info{'URLFN'};
     }elsif($flg eq "f") {
        $outbuf .= $main::gnImgPopup_info{'URLExt'};
     }elsif($flg eq "Y") {
        $outbuf .= $main::gnImgPopup_info{'Year'};
     }elsif($flg eq "M") {
        $outbuf .= $main::gnImgPopup_info{'Month'};
     }elsif($flg eq "D") {
        $outbuf .= $main::gnImgPopup_info{'Day'};
     }elsif($flg eq "h") {
        $outbuf .= $main::gnImgPopup_info{'Hour'};
     }elsif($flg eq "m") {
        $outbuf .= $main::gnImgPopup_info{'Minute'};
     }elsif($flg eq "s") {
        $outbuf .= $main::gnImgPopup_info{'Second'};
     }elsif($flg eq '/') {
        $outbuf .= '/';
     }else{
        $outbuf .= $flg;
     }
     
     if (substr($val, 1)) {
         $outbuf .= substr($val, 1);
     }
     
  }
  
  my $gnIS_fn = $main::gnISxml->get_widget('gnIS_fn');
  $gnIS_fn->set_text($outbuf);
}

sub on_gnIP_saveas_activate {
  # 画像のポップアップ表示からのポップアップメニュー
  # 「画像を名前をつけて保存」を選択

  my $evwindow = $_[0];
  $main::gnISxml = Gtk2::GladeXML->new($main::gladefn, 'gnIS');
  $main::gnISxml->signal_autoconnect_from_package('main');
  my $gnIS = $main::gnISxml->get_widget('gnIS');

  # 画像保存の親ディレクトリをセット
  my $gnIS_dir = $main::gnISxml->get_widget('gnIS_dir');
  if ($main::gnCacheTbl{'SavePattern'}{'BaseDir'} ne "") {

     # setするときはURIにエンコードして渡してあげないと、日本語を含むファイルパスのときエラーになる
     my $fld = Encode::encode(&env_locale_to_encstr($ENV{'LANG'}), $main::gnCacheTbl{'SavePattern'}{'BaseDir'});
     $fld = URI::file->new($fld);
     if($main::gnDebugFlag) { print Dumper($fld);}
     $gnIS_dir->set_current_folder_uri($fld);

# なぜかこうすると日本語を含むパスを入れるとエラーになる。バグ？
#     my $fld = Encode::encode('euc-jp', $main::gnCacheTbl{'SavePattern'}{'BaseDir'});
#     $gnIS_dir->set_current_folder($fld);
  }
  
  # 保存オプションを読み込み
  my $gnISkeepopt = $main::gnISxml->get_widget('gnIS_keepopt_thread');
  my $gnISkeepopt_arref = $gnISkeepopt->get_group;
  my @gnISkeepopt_ar = @$gnISkeepopt_arref;
  
  my $gnIS_pattern = $main::gnISxml->get_widget('gnIS_pattern');
  my $gnIS_ptntgt = $main::gnImgPopup_info{'ItaDir'} . chr(001) . $main::gnImgPopup_info{'DatNo'};
  if ($main::gnCacheTbl{'SavePattern'}{$gnIS_ptntgt} ne "") {
     # スレ共通設定を読み込み
     $gnIS_pattern->set_text($main::gnCacheTbl{'SavePattern'}{$gnIS_ptntgt});
     $gnISkeepopt_ar[3]->set_active(1);
  }elsif ($main::gnCacheTbl{'SavePattern'}{$main::gnImgPopup_info{'ItaDir'}} ne "") {
     # 板共通設定を読み込み
     $gnIS_pattern->set_text($main::gnCacheTbl{'SavePattern'}{$main::gnImgPopup_info{'ItaDir'}});
     $gnISkeepopt_ar[2]->set_active(1);
  }elsif ($main::gnCacheTbl{'SavePattern'}{'global'} ne "") {
     # 全体共通設定を読み込み
     $gnIS_pattern->set_text($main::gnCacheTbl{'SavePattern'}{'global'});
     $gnISkeepopt_ar[1]->set_active(1);
  }else{
     # その他の場合はデフォルト値(ファイル名のみ)をセット
     $gnIS_pattern->set_text('%F.%f');
     $gnISkeepopt_ar[0]->set_active(1);
  }

   $gnIS->show_all;
  
}

sub on_gnIP_reload_activate {
  # 画像のポップアップ表示からのポップアップメニュー
  # 「再読み込み」を選択
   my $evwidget = $_[0];
   
   # キャッシュファイルを削除
   &gnLogger("キャッシュを廃棄し再読み込みします");
   &gnUnlink($main::gnTmpfn);
   
   # 画像バッファのアップデート関数を再度セット
   $main::gnImgUpdateCallback = Glib::Timeout->add($main::gnEnvArg{'Browser'}{'PreviewWait'},
                                                       sub {
                                                                        my $retval;
                                                                        my $ref = &gnImgBufferUpdate($main::gnPopupImg, $main::gnPop2);
                                                                        ($main::gnPopupImg, $main::gnPop2, $retval) = @$ref;
                                                                        return($retval);
                                                                        },
                                                                        undef,
                                                                        0);
                        
   # runnnerスレッドに所定のURL読み込みをキューイングする
   $main::gnURLTo = $main::gnImgPopup_info{'URL'};
   my $uid;
   my $pass;
   if (!($main::gnEnvArg{'ReadProxy'}{'UserID'})) { $uid = "-1";}
   if (!($main::gnEnvArg{'ReadProxy'}{'Password'})) { $pass = "-1";}      
   $main::queue->enqueue("geturl", $main::gnURLTo, $main::gnTmpfn, $main::gnEnvArg{'ReadProxy'}{'Proxy'},
                        $main::gnEnvArg{'ReadProxy'}{'Address'}, $main::gnEnvArg{'ReadProxy'}{'Port'},
                        $uid, $pass);
   my $cachetime = time;
   $main::gnCacheTbl{'Cache'}{$main::gnURLTo} = $cachetime . chr(001) . $main::gnTmpfn;

}

sub on_gnIP_URLc_activate{
  # 画像のポップアップ表示からのポップアップメニュー
  # 「URLをコピー」を選択
}

sub on_gnTP_resNo_activate {
   # レス番号ポップアップ->番号そのもの(1行目)をクリック
   # なにもしない。
}

sub on_gnTP_replyToThisRes_activate {
   # レス番号ポップアップ->「ここにレス」をクリック

   my $tgtResNo = substr($gnHoverResN, index($gnHoverResN, "\/\/")+2);
   if($main::gnDebugFlag) { print "$tgtResNo\n"; }
   
   # 環境設定で"「ここにレス」するときに元のレスを引用する"が設定されていたら
   # 元のレスをコピー
   if($main::gnEnvArg{'Browser'}{'gnWriteWithQuotation'} == 0) {
      my $ResText = &gnGetResNoText($tgtResNo, "cont");
      $ResText =~ s/\n/\n>/g;
      $ResText = "\>\>" . substr($tgtResNo, rindex($tgtResNo, "\/")+1) . $ResText;
      &gnWrite(undef,$ResText);
   }else{
      my $ResText = "\>\>" . substr($tgtResNo, rindex($tgtResNo, "\/")+1);
      &gnWrite(undef,"$ResText\n");
   }
}

sub on_gnTP_copyThisRes_activate {
   # レス番号ポップアップ->「このレスをコピー」をクリック
   my $widget = $_[0];
   if($main::gnDebugFlag) { print Dumper($widget) . "\n"; }
   my $tgtResNo = substr($gnHoverResN, index($gnHoverResN, "\/\/")+2);
   if($main::gnDebugFlag) { print "$tgtResNo\n"; }
   my $ResText = &gnGetResNoText($tgtResNo, "full");

   my $gnTxtClip = $widget->get_clipboard();
   $gnTxtClip->set_text($ResText);
}

sub on_gnTP_vabonThisRes_activate {
   # レス番号ポップアップ->[このレスを・・・]-[あぼ〜ん]をクリック

   my $tgtResNo = substr($gnHoverResN, index($gnHoverResN, "\/\/")+2);
   my ($gnTPita, $gnTPsure, $gnTPresno) = split(/\//, $tgtResNo);
   
   my $gnTPNGList_ref = &gnLoadNGList($gnTPita, $gnTPsure);
   my %gnTPNGList = %$gnTPNGList_ref;
   if($gnTPNGList{$gnTPresno}) {
   if($gnTPNGList{$gnTPresno} eq "1") {
       &gnLogger("このレスは既にあぼ〜ん登録されています");
       return;
   }
   }
   $gnTPNGList{$gnTPresno} = "1";
   
   &gnSaveNGList($gnTPita, $gnTPsure, \%gnTPNGList);
   
   # 現在表示しているノートのページからスレの名称を得る
   my $gnSS_Note = $main::gnGUIxml->get_widget('gnNote');
   my $gnSS_Sures = $main::gnGUIxml->get_widget('gnSI');
   my $gnSS_SuresM = $gnSS_Sures->get_model;
   my ($gnSortCol, $gnSortOrder) = $gnSS_SuresM->get_sort_column_id;
   my $gnSS_TgtDat = "";
   my $gnSS_NoteP = $gnSS_Note->get_current_page;
   my $gnSureName = "";
   for my $i ( 0 .. $#main::gnSureViewInfo ) {
      if ($gnSS_NoteP == $i) {
         $gnSS_TgtDat = $main::gnSureViewInfo[$i][0];
         last;
      }
   }
   if ($gnSS_TgtDat ne "") {
      # xxxx/xxx.datをキーにしてスレの名前を取得
      $gnSureName = &gnGetSureVarFromDat($gnSS_SuresM, $gnSS_TgtDat, 0);
      $gnSureName = substr($gnSureName, index($gnSureName, ":")+1);
   }

   my $str = $gnSureName . " の " . $gnTPresno . " 番をあぼ〜ん設定しました";
   &gnLogger($str);

  # スレの内容を再読み込み
  my $gnTPSI = $main::gnGUIxml->get_widget('gnSI');
  &gnSureSelect($gnTPSI, TRUE);
    
}

sub on_gnTP_ivabonThisRes_activate {
   # レス番号ポップアップ->[このレスを・・・]-[透明あぼ〜ん]をクリック

   my $tgtResNo = substr($gnHoverResN, index($gnHoverResN, "\/\/")+2);
   my ($gnTPita, $gnTPsure, $gnTPresno) = split(/\//, $tgtResNo);
   
   my $gnTPNGList_ref = &gnLoadNGList($gnTPita, $gnTPsure);
   my %gnTPNGList = %$gnTPNGList_ref;
   if($gnTPNGList{$gnTPresno} eq "0") {
       &gnLogger("このレスは既に透明あぼ〜ん登録されています");
       return;
   }
   $gnTPNGList{$gnTPresno} = "0";
   
   &gnSaveNGList($gnTPita, $gnTPsure, \%gnTPNGList);
   
   # 現在表示しているノートのページからスレの名称を得る
   my $gnSS_Note = $main::gnGUIxml->get_widget('gnNote');
   my $gnSS_Sures = $main::gnGUIxml->get_widget('gnSI');
   my $gnSS_SuresM = $gnSS_Sures->get_model;
   my ($gnSortCol, $gnSortOrder) = $gnSS_SuresM->get_sort_column_id;
   my $gnSS_TgtDat = "";
   my $gnSS_NoteP = $gnSS_Note->get_current_page;
   my $gnSureName = "";
   for my $i ( 0 .. $#main::gnSureViewInfo ) {
      if ($gnSS_NoteP == $i) {
         $gnSS_TgtDat = $main::gnSureViewInfo[$i][0];
         last;
      }
   }
   if ($gnSS_TgtDat ne "") {
      # xxxx/xxx.datをキーにしてスレの名前を取得
      $gnSureName = &gnGetSureVarFromDat($gnSS_SuresM, $gnSS_TgtDat, 0);
      $gnSureName = substr($gnSureName, index($gnSureName, ":")+1);
   }

   my $str = $gnSureName . " の " . $gnTPresno . " 番を透明あぼ〜ん設定しました";
   &gnLogger($str);

   # スレの内容を再読み込み
   my $gnTPSI = $main::gnGUIxml->get_widget('gnSI');
   &gnSureSelect($gnTPSI, TRUE);
    
}

sub on_gnTP_vabonThisID_activate {
   # レス番号ポップアップ->[このIDを・・・]-[あぼ〜ん]をクリック

   my $tgtResNo = substr($gnHoverResN, index($gnHoverResN, "\/\/")+2);
   my $tgtID = &gnGetResNoText($tgtResNo, "id"); chomp($tgtID);
   if($main::gnDebugFlag) { print "ID abone target: $tgtID\n"; }
   my ($gnTPita, $gnTPsure, $gnTPresno) = split(/\//, $tgtResNo);
   
   my $gnTPNGList_ref = &gnLoadNGList($gnTPita, $gnTPsure);
   my %gnTPNGList = %$gnTPNGList_ref;
   my $rstNums = "";

   my $gnRNI_fn = $main::logdir . $gnTPita . "\/" . $gnTPsure . ".dat";  
   if (&gnCheckPath($gnRNI_fn)) {
      my $gnRNI = &gnOpenLocal($gnRNI_fn, "r");
      my $gnRNI_cnt = 1;
      while(<$gnRNI>) {
         my $gnRNI_RepBuf = $_;
         $gnRNI_RepBuf = Encode::decode('cp932', $gnRNI_RepBuf);
         chomp($gnRNI_RepBuf);
         
         my @gnAR_RepBuf = split(/<>/, $gnRNI_RepBuf);
         # index: 0 = 投稿者名, 1 = メールアドレス, 2 = 投稿日時, 3 = 投稿内容, 4 = null, 5 = ID(投稿日時の部分文字列)
         $gnAR_RepBuf[5] = substr($gnAR_RepBuf[2], index($gnAR_RepBuf[2], "ID:")+3, 8);
         $gnAR_RepBuf[2] = substr($gnAR_RepBuf[2], 0, index($gnAR_RepBuf[2], "ID:"));
           
         if($gnAR_RepBuf[5] eq $tgtID) {
           if($main::gnDebugFlag) { print "h"; }
           $gnTPNGList{$gnRNI_cnt} = "1";
           $rstNums .= "$gnRNI_cnt,";
         }else{
           if($main::gnDebugFlag) { print "n"; }
         }
       $gnRNI_cnt++;
       }
     &gnCloseLocal($gnRNI_fn);
  
     &gnSaveNGList($gnTPita, $gnTPsure, \%gnTPNGList);
  
     # 現在表示しているノートのページからスレの名称を得る
     my $gnSS_Note = $main::gnGUIxml->get_widget('gnNote');
     my $gnSS_Sures = $main::gnGUIxml->get_widget('gnSI');
     my $gnSS_SuresM = $gnSS_Sures->get_model;
     my ($gnSortCol, $gnSortOrder) = $gnSS_SuresM->get_sort_column_id;
     my $gnSS_TgtDat = "";
     my $gnSS_NoteP = $gnSS_Note->get_current_page;
     my $gnSureName = "";
     for my $i ( 0 .. $#main::gnSureViewInfo ) {
         if ($gnSS_NoteP == $i) {
            $gnSS_TgtDat = $main::gnSureViewInfo[$i][0];
            last;
         }
     }
     if ($gnSS_TgtDat ne "") {
         # xxxx/xxx.datをキーにしてスレの名前を取得
         $gnSureName = &gnGetSureVarFromDat($gnSS_SuresM, $gnSS_TgtDat, 0);
         $gnSureName = substr($gnSureName, index($gnSureName, ":")+1);
     }

  my $str = $gnSureName . " のID: " . $tgtID . ", 対象レス番号: " . $rstNums . " 番をあぼ〜ん設定しました";
  &gnLogger($str);

  # スレの内容を再読み込み
  my $gnTPSI = $main::gnGUIxml->get_widget('gnSI');
  &gnSureSelect($gnTPSI, TRUE);
    

  }else{
      &gnLogger("スレのdatファイルがなぜか読み込めません。さっきまでは読めていたはずなんですが・・・");
  }
    
}

sub on_gnTP_ivabonThisID_activate {
   # レス番号ポップアップ->[このIDを・・・]-[透明あぼ〜ん]をクリック

   my $tgtResNo = substr($gnHoverResN, index($gnHoverResN, "\/\/")+2);
   my $tgtID = &gnGetResNoText($tgtResNo, "id"); chomp($tgtID);
   if($main::gnDebugFlag) { print "ID abone target: $tgtID\n"; }
   my ($gnTPita, $gnTPsure, $gnTPresno) = split(/\//, $tgtResNo);
   
   my $gnTPNGList_ref = &gnLoadNGList($gnTPita, $gnTPsure);
   my %gnTPNGList = %$gnTPNGList_ref;
   my $rstNums = "";

   my $gnRNI_fn = $main::logdir . $gnTPita . "\/" . $gnTPsure . ".dat";  
   if (&gnCheckPath($gnRNI_fn)) {
      my $gnRNI = &gnOpenLocal($gnRNI_fn, "r");
      my $gnRNI_cnt = 1;
      while(<$gnRNI>) {
         my $gnRNI_RepBuf = $_;
         $gnRNI_RepBuf = Encode::decode('cp932', $gnRNI_RepBuf);
         chomp($gnRNI_RepBuf);
         
         my @gnAR_RepBuf = split(/<>/, $gnRNI_RepBuf);
         # index: 0 = 投稿者名, 1 = メールアドレス, 2 = 投稿日時, 3 = 投稿内容, 4 = null, 5 = ID(投稿日時の部分文字列)
         $gnAR_RepBuf[5] = substr($gnAR_RepBuf[2], index($gnAR_RepBuf[2], "ID:")+3, 8);
         $gnAR_RepBuf[2] = substr($gnAR_RepBuf[2], 0, index($gnAR_RepBuf[2], "ID:"));
           
         if($gnAR_RepBuf[5] eq $tgtID) {
           if($main::gnDebugFlag) { print "h"; }
           $gnTPNGList{$gnRNI_cnt} = "0";
           $rstNums .= "$gnRNI_cnt,";
         }else{
           if($main::gnDebugFlag) { print "n"; }
         }
       $gnRNI_cnt++;
       }
     &gnCloseLocal($gnRNI_fn);
  
     &gnSaveNGList($gnTPita, $gnTPsure, \%gnTPNGList);
  
     # 現在表示しているノートのページからスレの名称を得る
     my $gnSS_Note = $main::gnGUIxml->get_widget('gnNote');
     my $gnSS_Sures = $main::gnGUIxml->get_widget('gnSI');
     my $gnSS_SuresM = $gnSS_Sures->get_model;
     my ($gnSortCol, $gnSortOrder) = $gnSS_SuresM->get_sort_column_id;
     my $gnSS_TgtDat = "";
     my $gnSS_NoteP = $gnSS_Note->get_current_page;
     my $gnSureName = "";
     for my $i ( 0 .. $#main::gnSureViewInfo ) {
         if ($gnSS_NoteP == $i) {
            $gnSS_TgtDat = $main::gnSureViewInfo[$i][0];
            last;
         }
     }
     if ($gnSS_TgtDat ne "") {
         # xxxx/xxx.datをキーにしてスレの名前を取得
         $gnSureName = &gnGetSureVarFromDat($gnSS_SuresM, $gnSS_TgtDat, 0);
         $gnSureName = substr($gnSureName, index($gnSureName, ":")+1);
     }

  my $str = $gnSureName . " のID: " . $tgtID . ", 対象レス番号: " . $rstNums . " 番を透明あぼ〜ん設定しました";
  &gnLogger($str);

  # スレの内容を再読み込み
  my $gnTPSI = $main::gnGUIxml->get_widget('gnSI');
  &gnSureSelect($gnTPSI, TRUE);
    
  }else{
      &gnLogger("スレのdatファイルがなぜか読み込めません。さっきまでは読めていたはずなんですが・・・");
  }
  
}

sub on_gnTP_rabonThisRes_activate {
   # レス番号ポップアップ->[このレスを・・・]-[あぼ〜ん解除]をクリック
   my $tgtResNo = substr($gnHoverResN, index($gnHoverResN, "\/\/")+2);
   my ($gnTPita, $gnTPsure, $gnTPresno) = split(/\//, $tgtResNo);
   
   my $gnTPNGList_ref = &gnLoadNGList($gnTPita, $gnTPsure);
   my %gnTPNGList = %$gnTPNGList_ref;
   delete $gnTPNGList{$gnTPresno};
   
   &gnSaveNGList($gnTPita, $gnTPsure, \%gnTPNGList);
   
   # 現在表示しているノートのページからスレの名称を得る
   my $gnSS_Note = $main::gnGUIxml->get_widget('gnNote');
   my $gnSS_Sures = $main::gnGUIxml->get_widget('gnSI');
   my $gnSS_SuresM = $gnSS_Sures->get_model;
   my ($gnSortCol, $gnSortOrder) = $gnSS_SuresM->get_sort_column_id;
   my $gnSS_TgtDat = "";
   my $gnSS_NoteP = $gnSS_Note->get_current_page;
   my $gnSureName = "";
   for my $i ( 0 .. $#main::gnSureViewInfo ) {
      if ($gnSS_NoteP == $i) {
         $gnSS_TgtDat = $main::gnSureViewInfo[$i][0];
         last;
      }
   }
   if ($gnSS_TgtDat ne "") {
      # xxxx/xxx.datをキーにしてスレの名前を取得
      $gnSureName = &gnGetSureVarFromDat($gnSS_SuresM, $gnSS_TgtDat, 0);
      $gnSureName = substr($gnSureName, index($gnSureName, ":")+1);
   }

   my $str = $gnSureName . " の " . $gnTPresno . " 番をあぼ〜ん解除しました";
   &gnLogger($str);

  # スレの内容を再読み込み
  my $gnTPSI = $main::gnGUIxml->get_widget('gnSI');
  &gnSureSelect($gnTPSI, TRUE);
    
}

sub on_gnTP_rabonThisID_activate {
   # レス番号ポップアップ->[このIDを・・・]-[あぼ〜ん解除]をクリック

   my $tgtResNo = substr($gnHoverResN, index($gnHoverResN, "\/\/")+2);
   my $tgtID = &gnGetResNoText($tgtResNo, "id"); chomp($tgtID);
   if($main::gnDebugFlag) { print "ID abone target: $tgtID\n"; }
   my ($gnTPita, $gnTPsure, $gnTPresno) = split(/\//, $tgtResNo);
   
   my $gnTPNGList_ref = &gnLoadNGList($gnTPita, $gnTPsure);
   my %gnTPNGList = %$gnTPNGList_ref;
   my $rstNums = "";

   my $gnRNI_fn = $main::logdir . $gnTPita . "\/" . $gnTPsure . ".dat";  
   if (&gnCheckPath($gnRNI_fn)) {
      my $gnRNI = &gnOpenLocal($gnRNI_fn, "r");
      my $gnRNI_cnt = 1;
      while(<$gnRNI>) {
         my $gnRNI_RepBuf = $_;
         $gnRNI_RepBuf = Encode::decode('cp932', $gnRNI_RepBuf);
         chomp($gnRNI_RepBuf);
         
         my @gnAR_RepBuf = split(/<>/, $gnRNI_RepBuf);
         # index: 0 = 投稿者名, 1 = メールアドレス, 2 = 投稿日時, 3 = 投稿内容, 4 = null, 5 = ID(投稿日時の部分文字列)
         $gnAR_RepBuf[5] = substr($gnAR_RepBuf[2], index($gnAR_RepBuf[2], "ID:")+3, 8);
         $gnAR_RepBuf[2] = substr($gnAR_RepBuf[2], 0, index($gnAR_RepBuf[2], "ID:"));
           
         if($gnAR_RepBuf[5] eq $tgtID) {
           if($main::gnDebugFlag) { print "h"; }
           delete $gnTPNGList{$gnRNI_cnt};
           $rstNums .= "$gnRNI_cnt,";
         }else{
           if($main::gnDebugFlag) { print "n"; }
         }
       $gnRNI_cnt++;
       }
     &gnCloseLocal($gnRNI_fn);
  
     &gnSaveNGList($gnTPita, $gnTPsure, \%gnTPNGList);
  
     # 現在表示しているノートのページからスレの名称を得る
     my $gnSS_Note = $main::gnGUIxml->get_widget('gnNote');
     my $gnSS_Sures = $main::gnGUIxml->get_widget('gnSI');
     my $gnSS_SuresM = $gnSS_Sures->get_model;
     my ($gnSortCol, $gnSortOrder) = $gnSS_SuresM->get_sort_column_id;
     my $gnSS_TgtDat = "";
     my $gnSS_NoteP = $gnSS_Note->get_current_page;
     my $gnSureName = "";
     for my $i ( 0 .. $#main::gnSureViewInfo ) {
         if ($gnSS_NoteP == $i) {
            $gnSS_TgtDat = $main::gnSureViewInfo[$i][0];
            last;
         }
     }
     if ($gnSS_TgtDat ne "") {
         # xxxx/xxx.datをキーにしてスレの名前を取得
         $gnSureName = &gnGetSureVarFromDat($gnSS_SuresM, $gnSS_TgtDat, 0);
         $gnSureName = substr($gnSureName, index($gnSureName, ":")+1);
     }

  my $str = $gnSureName . " のID: " . $tgtID . ", 対象レス番号: " . $rstNums . " 番をあぼ〜ん解除しました";
  &gnLogger($str);

  # スレの内容を再読み込み
  my $gnTPSI = $main::gnGUIxml->get_widget('gnSI');
  &gnSureSelect($gnTPSI, TRUE);
    
  }else{
      &gnLogger("スレのdatファイルがなぜか読み込めません。さっきまでは読めていたはずなんですが・・・");
  }
    
}

sub on_gnTP_rabonAll_activate {
   # レス番号ポップアップ->[全あぼ〜ん解除]をクリック
   my $tgtResNo = substr($gnHoverResN, index($gnHoverResN, "\/\/")+2);
   my ($gnTPita, $gnTPsure, $gnTPresno) = split(/\//, $tgtResNo);
   &gnRemoveNGList($gnTPita, $gnTPsure);

   # 現在表示しているノートのページからスレの名称を得る
   my $gnSS_Note = $main::gnGUIxml->get_widget('gnNote');
   my $gnSS_Sures = $main::gnGUIxml->get_widget('gnSI');
   my $gnSS_SuresM = $gnSS_Sures->get_model;
   my ($gnSortCol, $gnSortOrder) = $gnSS_SuresM->get_sort_column_id;
   my $gnSS_TgtDat = "";
   my $gnSS_NoteP = $gnSS_Note->get_current_page;
   my $gnSureName = "";
   for my $i ( 0 .. $#main::gnSureViewInfo ) {
       if ($gnSS_NoteP == $i) {
          $gnSS_TgtDat = $main::gnSureViewInfo[$i][0];
          last;
       }
   }
   if ($gnSS_TgtDat ne "") {
       # xxxx/xxx.datをキーにしてスレの名前を取得
       $gnSureName = &gnGetSureVarFromDat($gnSS_SuresM, $gnSS_TgtDat, 0);
       $gnSureName = substr($gnSureName, index($gnSureName, ":")+1);
   }
   my $str = $gnSureName . " の全てのあぼ〜ん設定を解除しました";
   &gnLogger($str);

  # スレの内容を再読み込み
  my $gnTPSI = $main::gnGUIxml->get_widget('gnSI');
  &gnSureSelect($gnTPSI, TRUE);
    
}

sub on_gnIS_save_clicked {
  # 画像を名前をつけて保存ダイアログで保存ボタンが押された
  my $gnIS_save = $_[0];
  my $gnIS = $gnIS_save->parent->parent->parent->parent;
  
  # キャッシュファイルを指定場所にコピー
  my $gnIS_dir = $main::gnISxml->get_widget('gnIS_dir');
  if ($main::gnDebugFlag) { print Dumper($gnIS_dir) . "\n";}
  my $gnIS_basedir = $gnIS_dir->get_current_folder;
  $gnIS_basedir = Glib::filename_display_name($gnIS_basedir);
  
  my $gnIS_fn = $main::gnISxml->get_widget('gnIS_fn');
  my $gnIS_fnstr = $gnIS_fn->get_text;
  $gnIS_fnstr = &env_gtkstr_to_gtkstr($gnIS_fnstr);

  my @gnIS_fnar = split(/\//, $gnIS_fnstr);
  my $gnIS_fname = pop(@gnIS_fnar);
  
  $gnIS_fnstr = $gnIS_basedir . "\/" . $gnIS_fnstr;
  my $gnIS_path = dirname($gnIS_fnstr);
  
  if ($main::gnDebugFlag) { print "dir\: $gnIS_path\n";
                        print "filename\: $gnIS_fname\n";
                        print "full\: $gnIS_fnstr\n";}
  
  if (!(&gnCheckPath($gnIS_path))) {
     if (&gnMakeDir($gnIS_path)) {
        my $str = "ディレクトリを作成しました\: " . $gnIS_path;
        &gnLogger($str);
     }else{
        my $str = "ディレクトリの作成に失敗しました\: " . $gnIS_path;
        &gnLogger($str);
     }
  }
  
  my $gnCachefn2 = Encode::encode(&env_locale_to_encstr($ENV{'LANG'}), &env_gtkstr_to_gtkstr($main::gnImgPopup_info{'CacheFN'}));
  my $flg = "yes";
  if (&gnCheckPath($gnIS_fnstr)) {
     if ($main::gnDebugFlag) { print "already exist\: $gnIS_fnstr\n"; }
     $flg = &gnYesNo("ファイルが既に存在します。\n上書きしますか？\n$gnIS_fnstr", $gnIS);
  }
  if ($flg eq "yes") {
     if (&gnFCopy($main::gnImgPopup_info{'CacheFN'}, $gnIS_fnstr)) {
        if ($main::gnDebugFlag) { print "file save succeed\n"; }
        my $str = "ファイルを保存しました\: $gnIS_fnstr";
        &gnLogger($str);

         # 保存オプションをセーブ
        $main::gnCacheTbl{'SavePattern'}{'BaseDir'} = $gnIS_basedir;
  
        my $gnIS_pattern = $main::gnISxml->get_widget('gnIS_pattern');
        my $gnISkeepopt = $main::gnISxml->get_widget('gnIS_keepopt_thread');
        my $gnISkeepopt_arref = $gnISkeepopt->get_group;
        my @gnISkeepopt_ar = @$gnISkeepopt_arref;
        if ($gnISkeepopt_ar[3]->get_active == 1) {
           # スレ共通設定として保存
           my $tgt = $main::gnImgPopup_info{'ItaDir'} . chr(001) . $main::gnImgPopup_info{'DatNo'};
           $main::gnCacheTbl{'SavePattern'}{$tgt} = $gnIS_pattern->get_text;
        }elsif ($gnISkeepopt_ar[2]->get_active == 1) {
           # 板共通設定として保存
           my $tgt = $main::gnImgPopup_info{'ItaDir'};
           $main::gnCacheTbl{'SavePattern'}{$tgt} = $gnIS_pattern->get_text;
        }elsif ($gnISkeepopt_ar[1]->get_active == 1) {
           # 全体設定として保存
           $main::gnCacheTbl{'SavePattern'}{'global'} = $gnIS_pattern->get_text;
        }else {
           # 保存しない
         }
  
     }else{
        if ($main::gnDebugFlag) { print "file save failed\n"; }
        my $str = "ファイルの作成に失敗しました\: $gnIS_fnstr";
        &gnLogger($str);
     }
  }
  $gnIS_save->destroy;
  $gnIS->destroy;

}

sub on_gnIS_cancel_clicked {
   # 画像を名前をつけて保存ダイアログでキャンセルボタンが押された
   my $gnIS_cancel = $_[0];
   my $gnIS = $gnIS_cancel->parent->parent->parent->parent;
   $gnIS->destroy;
}

sub on_gnIS_expander_activate {
   my $gnIS_expander = $_[0];
   my $gnIS = $gnIS_expander->parent->parent->parent;

   if ($gnIS_expander->get_expanded) {
    $gnIS->set_resizable(0);
   }else{
    $gnIS->set_resizable(1);  
   }
}

sub on_gnTBS_supdate_clicked {
   # メニューボタンからスレを更新
   my $gnSureView = $main::gnGUIxml->get_widget('gnSI');
   &gnSureUpdate($gnSureView);
}

sub on_gnMS_sureupdate_activate {
   # メニューからスレを更新
   my $gnSureView = $main::gnGUIxml->get_widget('gnSI');
   &gnSureUpdate($gnSureView);
}

sub on_gnMS_find_activate {
   # メニューから「スレ内を検索」を実行、もしくは<Ctrl>+Fを押した
   my $gnFindStr = $main::gnGUIxml->get_widget('gnTBS_findstr');
   my $tgtw = $main::gnGUIxml->get_widget('mW');
   if($main::gnDebugFlag) { print("on_gnMS_find_activate\n"); }
   if($main::gnDebugFlag) { print(Dumper($tgtw)); }
   $tgtw->set_focus($gnFindStr);
}

sub on_gnTBS_find_clicked {
   # メニューボタンからスレ内検索を実行
   &gnSureFindNext;
}

sub on_gnTBS_findstr_changed {
   # メニューのスレ内検索ボックスが変更された
   $main::gnFind_Iter = "";
   &gnSureFindNext;
}

sub on_gnTBS_findstr_key_press_event {
   # メニューのスレ内検索ボックスでキーが押された
   my ($gnWid, $gnEventKey) = @_;
   my $keyval = $gnEventKey->keyval;
   if($keyval == 65293) {
      & gnSureFindNext;
   }elsif($keyval == 65505) {
      $main::gnFind_keyst = "shift";
   }

}

sub on_gnTBS_findstr_key_release_event {
   # メニューのスレ内検索ボックスでキーが離された
   my ($gnWid, $gnEventKey) = @_;
   my $keyval = $gnEventKey->keyval;
   if($keyval == 65505) {
      $main::gnFind_keyst = "";
   }

}

sub on_gnNote_switch_page {
   # スレ本文を表示するNotebookのタブを切り替えた
   if($main::gnDebugFlag) { print "Switch Page\n"; }
   &gnSureSwitch;
}

sub on_gnWM_close_activate {
   # 書き込みウィンドウで、メニューの閉じるを選択したか、<Ctrl>+Wキーを押した
   my $gnW = $main::gnWxml->get_widget('gnWrite');
   $gnW->destroy;
}

sub on_gnW_cutB_clicked {
   &on_gnWE_cut_activate();
}

sub on_gnWE_cut_activate {
   # 書き込みウィンドウで、メニューの切り取りを選択したか、切り取りボタンを押したか、
   # <Ctrl>+Xキーを押した
   my $gnWcont = $main::gnWxml->get_widget('gnW_cont');
   my $gnWcontBuf = $gnWcont->get_buffer;
   if (!($gnWcontBuf)) {
      return;
   }
   my $gnTxtClip = $gnWcont->get_clipboard();
   $gnWcontBuf->cut_clipboard($gnTxtClip, TRUE);
}

sub on_gnW_copyB_clicked {
   &on_gnWE_copy_activate();
}

sub on_gnWE_copy_activate {
   # 書き込みウィンドウで、メニューのコピーを選択したか、コピーボタンを押したか、
   # <Ctrl>+Cキーを押した
   my $gnWcont = $main::gnWxml->get_widget('gnW_cont');
   my $gnWcontBuf = $gnWcont->get_buffer;
   if (!($gnWcontBuf)) {
      return;
   }
   my $gnTxtClip = $gnWcont->get_clipboard();
   $gnWcontBuf->copy_clipboard($gnTxtClip);
}

sub on_gnW_pasteB_clicked {
   &on_gnWE_paste_activate();
}

sub on_gnWE_paste_activate {
   # 書き込みウィンドウで、メニューの張り付けを選択したか、張り付けボタンを押したか、
   # <Ctrl>+Vキーを押した
   my $gnWcont = $main::gnWxml->get_widget('gnW_cont');
   my $gnWcontBuf = $gnWcont->get_buffer;
   if (!($gnWcontBuf)) {
      return;
   }
   my $gnWcontBuf_iter = $gnWcontBuf->get_end_iter;

   my $gnTxtClip = $gnWcont->get_clipboard();

   $gnWcontBuf->paste_clipboard($gnTxtClip, undef, TRUE);

}

sub on_gnW_qpasteB_clicked {
   &on_gnWE_qpaste_activate();
}

sub on_gnWE_qpaste_activate {
   # 書き込みウィンドウで、メニューの引用符付張り付けを選択したか、引用符ボタンを押したか、
   # <Ctrl>+<Shift>+Vキーを押した
   my $gnWcont = $main::gnWxml->get_widget('gnW_cont');
   my $gnWcontBuf = $gnWcont->get_buffer;
   if (!($gnWcontBuf)) {
      return;
   }

   my $gnTxtClip = $gnWcont->get_clipboard();
   
   my $gnTmpTxtBuf = Gtk2::TextBuffer->new(undef);
   $gnTmpTxtBuf->paste_clipboard($gnTxtClip, undef, TRUE);
   my $gnTmpTxtBuf_start = $gnTmpTxtBuf->get_start_iter;
   my $gnTmpTxtBuf_end = $gnTmpTxtBuf->get_end_iter;
   my $gnTmpTxt = $gnTmpTxtBuf->get_text($gnTmpTxtBuf_start, $gnTmpTxtBuf_end, TRUE);
   if($gnTmpTxt ne "") {
      $gnTmpTxt =~ s/\n/\n> /g;
      $gnTmpTxt = "> " . $gnTmpTxt;
   }
   if ($main::gnDebugFlag) {
      print("paste-with-quote\: \n" . $gnTmpTxt . "\n");
   }

   $gnWcontBuf->insert_at_cursor($gnTmpTxt);

}

sub on_gnWE_delete_activate {
   # 書き込みウィンドウで、メニューの削除を選択した
   my $gnWcont = $main::gnWxml->get_widget('gnW_cont');
   my $gnWcontBuf = $gnWcont->get_buffer;
   if (!($gnWcontBuf)) {
      return;
   }

   $gnWcontBuf->delete_selection(TRUE, TRUE);

}

sub on_gnW_sage_toggled {
   # 書き込みウィンドウで、sageチェックボックスをトグルした
   my $gnSage = $_[0];
   my $gnW_mail = $main::gnWxml->get_widget('gnW_mail');
   if ($gnSage->get_active) {
      $gnW_mail->child->set_text("sage");
      $gnW_mail->set_sensitive(FALSE);
   }else{
      $gnW_mail->child->set_text("");
      $gnW_mail->set_sensitive(TRUE);
   }
}

sub on_gnW_SubmitBtn_clicked {
   # 書き込みウィンドウの送信ボタンが押された
   &gnSubmit;
}

sub on_gnWM_submit_activate {
   # 書き込みウィンドウのメニュー[ファイル]-[送信]が選択された
   &gnSubmit;
}

sub on_gnWrite_unrealize {
   # 書き込みウィンドウが閉じた
      # 終了時のウィンドウ位置、大きさを記憶
      my $gnWrite = $main::gnWxml->get_widget('gnWrite');
      ($main::gnEnvArg{'EditorWindowSize'}{'Left'}, $main::gnEnvArg{'EditorWindowSize'}{'Top'}) = Gtk2::Gdk::Window::get_position($gnWrite->window);
      my $sute;
      ($sute, $sute,
       $main::gnEnvArg{'EditorWindowSize'}{'Width'},
       $main::gnEnvArg{'EditorWindowSize'}{'Height'},) = Gtk2::Gdk::Window::get_geometry($gnWrite->window);

   $main::gnWxml = "";
}

sub on_gnPopupText_check_resize {
   # UTF-8 Compliant!
   # ポップアップ画面がウィンドウからはみ出している場合は
   # 出現位置を調整
   my $gnPopupTxt = $_[0];
   
   my ($gnPopupWinX, $gnPopupWinY) = $gnPopupTxt->get_position;
   my ($gnResizedWidth, $gnResizedHeight) = $gnPopupTxt->get_size;
   my $dis = Gtk2::Gdk::Display->get_default;
   my ($scr, $x, $y, $mask) = $dis->get_pointer;
   my ($wid, $hei) = $gnPopupTxt->get_size;
   
   # 出現したウィンドウはなぜか突拍子もないところに表示されたりする。
   # もしマウスカーソルの位置よりも左上であったら、マウスカーソルの位置に修正
   if ($gnPopupWinX < $x ) { $gnPopupWinX = $x; }
   if ($gnPopupWinY < $y ) { $gnPopupWinY = $y; }
   
   if (($x + int($wid/2)) >= Gtk2::Gdk->screen_width) { $gnPopupWinX = $x + int($wid/2); }
   if (($y + int($hei/2)) >= Gtk2::Gdk->screen_width) { $gnPopupWinY = $y + int($hei/2); }
      
   # ポップアップウィンドウのoriginが
   # ポップアップ表示禁止領域内だったら表示領域外に移動
   if ($gnPopupWinX <= $main::gnEnvArg{'Browser'}{'AvoidBorderLeft'}) {
      $gnPopupWinX = $main::gnEnvArg{'Browser'}{'AvoidBorderLeft'} + 1;
   }
   if ($gnPopupWinY <= $main::gnEnvArg{'Browser'}{'AvoidBorderTop'}) {
      $gnPopupWinY = $main::gnEnvArg{'Browser'}{'AvoidBorderTop'} + 1;
   }
   
   # ポップアップ画面がウィンドウからはみ出している場合は
   # 出現位置を調整
      
   if ($gnResizedWidth > 0) {
      my $gnScreenHeight = Gtk2::Gdk->screen_height;
      my $gnScreenWidth = Gtk2::Gdk->screen_width;
      if($main::gnDebugFlag) { print "gnPopupTxt-regeo1\:\($gnPopupWinX, $gnPopupWinY, $gnResizedWidth, $gnResizedHeight\)\n"; }
      if($main::gnDebugFlag) { print "gnPopupTxt-regeo2\:\($gnPopupWinX, $gnPopupWinY, $gnResizedWidth, $gnResizedHeight\)\n"; }
      if (($gnPopupWinX + $gnResizedWidth + $main::gnEnvArg{'Browser'}{'AvoidBorderRight'}) > $gnScreenWidth) {
         if($main::gnDebugFlag) { print "gnPopupWinX moves\n"; }
         $gnPopupWinX = $gnScreenWidth - $gnResizedWidth - $main::gnEnvArg{'Browser'}{'AvoidBorderRight'}; }
      if (($gnPopupWinY + $gnResizedHeight + $main::gnEnvArg{'Browser'}{'AvoidBorderBottom'}) > $gnScreenHeight) {
         if($main::gnDebugFlag) {
            my $before = ($gnPopupWinY + $gnResizedHeight + $main::gnEnvArg{'Browser'}{'AvoidBorderBottom'});
            print "gnPopupWinY moves\: $before versus $gnScreenHeight\n";
            }
         $gnPopupWinY = $gnScreenHeight - $gnResizedHeight - $main::gnEnvArg{'Browser'}{'AvoidBorderBottom'};
      }else{
         if($main::gnDebugFlag) {
            my $before = ($gnPopupWinY + $gnResizedHeight + $main::gnEnvArg{'Browser'}{'AvoidBorderBottom'});
            print "gnPopupWinY moves\: $before versus $gnScreenHeight\n";
            }
      }
      $gnPopupTxt->move($gnPopupWinX, $gnPopupWinY);
      if($main::gnDebugFlag) { print "gnPopupTxt-regeo3\:\($gnPopupWinX, $gnPopupWinY, $gnResizedWidth, $gnResizedHeight\)\n"; }

   }
   
   # ウィンドウがある程度大きくなっていないのであれば、
   # ウィンドウ内にまだテキストが収まっていない。とりあえず決め打ちで縦20ptを
   # 超えるまではこの関数を繰り返す
   if($gnResizedHeight >20) {
      return(FALSE);
   }else{
      return(TRUE);
   }

}

#--------------------------------------
# カスタム関数(gnview内部用)
#--------------------------------------

sub gnSureFindNext {
   # スレ内本文を検索する関数
   #
   # 引数: なし
   
   # 文字列を取得
   my $gnFindStr_Widget = $main::gnGUIxml->get_widget('gnTBS_findstr');
   my $gnFindStr = $gnFindStr_Widget->get_text;
   
   # 現在のスレを確認
   my $gnSS_Note = $main::gnGUIxml->get_widget('gnNote');
   my $gnSS_NoteP = $gnSS_Note->get_current_page;

   my $gnSS_TxtV = $gnSS_Note->get_nth_page($gnSS_NoteP);
   $gnSS_TxtV = $gnSS_TxtV->child;
   my $gnSS_TxtB = $gnSS_TxtV->get_buffer;

   # 現在のカーソル位置のiterを取得
   my $gnSS_TxtI_now = $gnSS_TxtB->get_iter_at_mark($gnSS_TxtB->get_insert);
   my $gnSS_TxtI_first = $gnSS_TxtB->get_start_iter;
   my $gnSS_TxtI_end = $gnSS_TxtB->get_end_iter;

   # 空欄で検索をかけようとしたら検索解除
   if ($gnFindStr eq "") {
      my $gnSS_TxtB_tagT = $gnSS_TxtB->get_tag_table;
      my $tag = $gnSS_TxtB_tagT->lookup("gn-find-hit");
      # 既についているタグを外す
      $gnSS_TxtB->remove_tag($tag, $gnSS_TxtI_first, $gnSS_TxtI_end);
     return;
   }

   # $main::gnFind_Iterが""じゃなかったら同一文字列の次検索。
   # ""だったら新規検索。
   if(($main::gnFind_Iter eq "") || ($gnSS_NoteP != $main::gnFind_pg)) {
      # 検索にヒットした部分を強調表示
      &gnFind_HighlightAll($gnSS_TxtB, $gnFindStr);
      $main::gnFind_Iter = $gnSS_TxtI_now;
      $main::gnFind_pg = $gnSS_NoteP;
   }
   # 検索
   my $gnSS_TxtI_ms;
   my $gnSS_TxtI_me;
   if($main::gnFind_keyst ne "shift") {
      ($gnSS_TxtI_ms, $gnSS_TxtI_me) = $main::gnFind_Iter->forward_search($gnFindStr, 'text-only',);
   }else{
      ($gnSS_TxtI_ms, $gnSS_TxtI_me) = $main::gnFind_Iter->backward_search($gnFindStr, 'text-only',);
   }
   
   # みつからなかったら戻る
   if(!($gnSS_TxtI_ms)) {
      my $str = "対象文字列\(\"" . $gnFindStr . "\"\)は見つかりませんでした";
      &gnLogger($str);
      return;
   }
   
   # 見つかったら対象へ移動
   $gnSS_TxtB->place_cursor($gnSS_TxtI_ms);
   $gnSS_TxtV->scroll_to_iter($gnSS_TxtI_ms, 0, FALSE, 0, 0);
   
   # iterの位置を記憶
   if($main::gnFind_keyst ne "shift") {
      $main::gnFind_Iter = $gnSS_TxtI_me;
   }else{
      $main::gnFind_Iter = $gnSS_TxtI_ms;
   }
}

sub gnFind_HighlightAll {
   # スレ内本文を検索にて、ヒットした語の背景色を変更する関数
   #
   # 引数1: Gtk2::TextBuffer
   my ($gnSS_TxtB, $gnFindStr) = @_;
   my $gnSS_TxtB_tagT = $gnSS_TxtB->get_tag_table;
   my $gnSS_TxtB_tagsz = $gnSS_TxtB_tagT->get_size;
   my $gnSS_TxtI_first = $gnSS_TxtB->get_start_iter;
   my $gnSS_TxtI_end = $gnSS_TxtB->get_end_iter;
   
   # 'gn-find-hit'タグのプライオリティを変更し、一番優先的に
   # 効果が適用されるようにする
   my $tag = $gnSS_TxtB_tagT->lookup("gn-find-hit");
   $tag->set_priority($gnSS_TxtB_tagsz - 1);
   
   # 既についているタグを外す
   $gnSS_TxtB->remove_tag($tag, $gnSS_TxtI_first, $gnSS_TxtI_end);
   
   my $gnSS_TxtI_now = $gnSS_TxtI_first;
   my $hitcnt = 0;
   while(1) {
      my ($gnSS_TxtI_ms, $gnSS_TxtI_me) = $gnSS_TxtI_now->forward_search($gnFindStr, 'text-only',);
      
      if(!($gnSS_TxtI_ms)) {
         last;
      }
      
      $hitcnt++;
      $gnSS_TxtB->apply_tag($tag, $gnSS_TxtI_ms, $gnSS_TxtI_me);
      
      $gnSS_TxtI_now = $gnSS_TxtI_me;
      
   }
   
   my $str = $hitcnt . "件ヒットしました";
   &gnLogger($str);
   
}

sub gnSubmit {
   # UTF-8 Compliant!
   # レスを送信する関数
   #
   # 引数: なし
   
   my $gnW = $main::gnWxml->get_widget('gnWrite');
   # 名前を取得
   my $gnWname = $main::gnWxml->get_widget('gnW_name');
   my $gnFROM = $gnWname->child->get_text;
   if($main::gnDebugFlag) { print "submit-FROM\: $gnFROM\n"; }
   # メールアドレスを取得
   my $gnWmail = $main::gnWxml->get_widget('gnW_mail');
   my $gnMAIL = $gnWmail->child->get_text;
   if($main::gnDebugFlag) { print "submit-mail\: $gnMAIL\n"; }
   # 本文を取得
   my $gnWcont = $main::gnWxml->get_widget('gnW_cont');
   my $gnWcont_buf = $gnWcont->get_buffer;
   my $gnMESSAGE = $gnWcont_buf->get_text($gnWcont_buf->get_start_iter, $gnWcont_buf->get_end_iter, FALSE);
   
   # 本文がない場合はエラー
   if (!($gnMESSAGE)) {
      &gnWarn("本文がないと投稿できません");
      $gnW->present;
      return;
   }
   
   # 波ダッシュ問題対応１：UTF8の全角チルダ、波ダッシュを変換用の文字に変換
   $gnMESSAGE = Encode::encode('utf8', $gnMESSAGE);
   $gnMESSAGE =~ s/\xEF\xBD\x9E/gnmychilder/g;
   $gnMESSAGE =~ s/\xE3\x80\x9C/gnmychilder/g;
   $gnMESSAGE = Encode::decode('utf8', $gnMESSAGE);
   
   # &などのエンティティ文字を変換
   #$gnMESSAGE =~ s/\&/\&amp\;/g;
   #$gnMESSAGE =~ s/'/''/g;
   #encode_entities($gnMESSAGE, '<&>');
   #encode_entities($gnMESSAGE, '<&>"');
   #encode_entities($gnMESSAGE);
   
   if($main::gnDebugFlag) { print "submit-cont\: $gnMESSAGE\n"; }
   
   # 投稿時に必要なキー
   substr($gnW->get_title, rindex($gnW->get_title, "\(")+1) =~ m/\d{9,}/;
   my $gnkey = $&;
   my $gnbbs = $`;                                  # ` gedit誤認識対策用コメント
   chop($gnbbs);
   if($main::gnDebugFlag) { print "submit-bbs\: $gnbbs\n"; }
   if($main::gnDebugFlag) { print "submit-key\: $gnkey\n"; }
   
   # 投稿時間
   my $gntime = $main::gnKeyTime;
   if ($main::gnEnvArg{'2ch'}{'time'}) {
      $gntime = $main::gnEnvArg{'2ch'}{'time'};
   }
   if($main::gnDebugFlag) { print "submit-time\: $gntime\n"; }
   
   # 板名とドメイン名取得
   my $gndomain = $main::gnBoardTbl{$gnbbs};
   my $sep = chr(001);
   $gndomain =~ m/$sep/;
   $gndomain = $';                                  # ' gedit誤認識対策用コメント
   $gndomain = substr($gndomain, 7);
   $sep = q{(?:(?:[a-zA-Z0-9](?:[-a-zA-Z0-9]*[a-zA-Z0-9])?\.)} .
           q{*[a-zA-Z](?:[-a-zA-Z0-9]*[a-zA-Z0-9])?\.?|[0-9]+\.[0-9]+\.[0-9]+\.} .
           q{[0-9]+)(?::[0-9]*)?};
   $gndomain =~ m/$sep/;
   $gndomain = $&;
   if($main::gnDebugFlag) { print "domainname\: $gndomain\n"; }

   # クッキーがあれば取り込み
   my $gnFolIniFN = $main::logdir . $gnbbs . "\/Folder.ini";
   if($main::gnDebugFlag) { print "folderini\: $gnFolIniFN\n"; }
   my $gnPON;
   my $gnPONTime;
   my $gnHAP;
   my %gnFI;
   if (!(&gnCheckPath($gnFolIniFN))) {
      &gnMakeFolderIni($gnFolIniFN);
      &gnLogger("Folder.iniを作成しました\($gnFolIniFN\)");
   }
      my $gnFIRef = &gnLoadEnv($gnFolIniFN);
      %gnFI = %$gnFIRef;
      if ($gnFI{'Cookie'}{'PON'}) {
        if($gnFI{'Cookie'}{'PON'} ne "") {
         $gnPON = $gnFI{'Cookie'}{'PON'};
         my($a, $b) = split(/ /, $gnFI{'Cookie'}{'Expires'});
         my($y, $m, $d) = split(/\//, $a);
         my($hh, $mm, $ss) = split(/:/, $b);
         $m -= 1;
         $gnPONTime = timegm($ss, $mm, $hh, $d, $m, $y);
         $gnPONTime -= time;
        }
      }
      if ($gnFI{'Cookie'}{'Cookie=HAP'}) {
         $gnHAP = $gnFI{'Cookie'}{'Cookie=HAP'};
         chop($gnHAP);
      }
   if($main::gnDebugFlag) { print "PON\: $gnPON, HAP\: $gnHAP\n"; }
   
   # リクエスト組み立て
   my $gnSUA = LWP::UserAgent->new;
   my $gnSCo = HTTP::Cookies->new;
   $gnSUA->agent($main::gnUsrAgent);
   $gnSUA->requests_redirectable([]);
   if($main::gnEnvArg{'WriteProxy'}{'Proxy'} == 1) {
      my $gnSUA_proxystr = "http\:\/\/" . $main::gnEnvArg{'WriteProxy'}{'Address'} . "\:" . $main::gnEnvArg{'WriteProxy'}{'Port'} . "\/";
      $gnSUA->proxy('http', $gnSUA_proxystr);
   }
   $gnSCo->set_cookie(1, "NAME", Encode::encode('cp932', $gnFROM), "\/", $gndomain, 80, 0, 0, 2592000, 0);
   $gnSCo->set_cookie(1, "MAIL", Encode::encode('cp932', $gnMAIL), "\/", $gndomain, 80, 0, 0, 2592000, 0);
   $gnSCo->set_cookie(1, "hana", Encode::encode('cp932', "mogera"), "\/", $gndomain, 80, 0, 0, undef, 0);
   $gnSCo->set_cookie(1, "suka", Encode::encode('cp932', "pontan"), "\/", $gndomain, 80, 0, 0, undef, 0);
   $gnSCo->set_cookie(1, "tepo", Encode::encode('cp932', "don"), "\/", $gndomain, 80, 0, 0, undef, 0);
   if ($gnPON) {
      $gnSCo->set_cookie(0, "PON", Encode::encode('cp932', $gnPON), "\/", $gndomain, 80, 0, 0, $gnPONTime, 0);
   }else{
      $gnSCo->set_cookie(0, "PON", Encode::encode('cp932', ""), "\/", $gndomain, 80, 0, 0, $gnPONTime, 0);
   }
   if ($gnHAP) {
      $gnSCo->set_cookie(0, "HAP", Encode::encode('cp932', $gnHAP), "\/", $gndomain, 80, 0, 0, $gnPONTime, 0);
   }else{
      $gnSCo->set_cookie(0, "HAP", Encode::encode('cp932', ""), "\/", $gndomain, 80, 0, 0, $gnPONTime, 0);
   }
   $gnSUA->cookie_jar($gnSCo);
   if ($main::gnDebugFlag) { print "request-cookies\: " . Dumper($gnSCo->as_string) . "\n"; }
   
   my $gnSRqURL = "http\:\/\/" . $gndomain . "\/test\/bbs.cgi\?UTF-8";
   my $gnSRq = HTTP::Request->new(POST => $gnSRqURL);
   $gnSRq->content_type("application/x-www-form-urlencoded");
   my $gnSRq_ref = "http\:\/\/" . $gndomain . "\/test\/read.cgi\/$gnbbs\/$gnkey\/l50";
   $gnSRq->header(Referer => $gnSRq_ref, 
                         Accept_Language => "ja",
                         Accept_Charset => "Shift-JIS");
   
   $gnMESSAGE = Encode::encode('cp932', $gnMESSAGE);
   $gnMESSAGE =~ s/gnmychilder/\x81\x60/g; # 波ダッシュ問題対応2：変換用文字をShiftjisの全角チルダに変換
   $gnMESSAGE = uri_escape($gnMESSAGE);
   
   my $gncont = "submit=" . Encode::encode('cp932', "書き込む") . "\&FROM=" . $gnFROM . "\&mail=" . $gnMAIL . "\&MESSAGE=" . $gnMESSAGE . "\&bbs=" . $gnbbs . "\&key=" . $gnkey . "\&time=1";
   
   $gnSRq->content($gncont);
   if ($main::gnDebugFlag) { print "POST Content\: \n"; }
   if ($main::gnDebugFlag) { print Dumper($gnSUA) . "\n" . Dumper($gnSRq); }
   
   my $response = $gnSUA->request($gnSRq);
   if ($main::gnDebugFlag) { print "response\:\n" . Dumper($response) . "\n" . Encode::decode('cp932', $response->content) . "\n"; }
   
   # レスポンスをゲット
   my $gnRes_cont = Encode::decode('cp932', $response->content);
   my $gnRes = HTML::TokeParser->new(\$gnRes_cont);
   my $gnRes_txt;
   my $gn2chXflg;
   my $gnRes_title = FALSE;
   my %gn2chForm;
   while (my $gnRes_tkn = $gnRes->get_token) {
      my $flg = $gnRes_tkn->[0];
      my $tag = $gnRes_tkn->[1];
      
      if ($flg eq "C") {
         
         if ($main::gnDebugFlag) { print "response-comment\: " . $tag . "\n"; }
         if (substr($tag, 5, 5) eq "2ch_X") {
            # 2ch_Xステータスを取得
            $gn2chXflg = substr($tag, 11, 4);
         }
      }
      if ($flg eq "T") {
         if ($gnRes_title == TRUE) {
            if ($tag eq "ＥＲＲＯＲ！") {
               $gn2chXflg = "erro";
            }
         }else{
            $gnRes_txt .= $tag;
         }
      }
      if (($flg eq "S") && ($tag eq "br")) {
         $gnRes_txt .= "\n";
      }
      if (($flg eq "S") && ($tag eq "input")) {
         if ($main::gnDebugFlag) { print "response-input\: " . Dumper($gnRes_tkn->[2]) . "\n"; }
      }
      if (($flg eq "S") && ($tag eq "title")) {
         $gnRes_title = TRUE;
      }
      if (($flg eq "E") && ($tag eq "title")) {
         $gnRes_title = FALSE;
      }
      
   }
   
   
   # 2ch_Xステータスを元に処理を分岐
   my $gn2chXflg_res = FALSE;
   if ($gn2chXflg) {
      if ($main::gnDebugFlag) { print "2ch_X-flag \: $gn2chXflg\n"; }
      if ($gn2chXflg eq "cook") {
         # クッキー確認
         my $gnCook = &gnYesNo($gnRes_txt . "\n\nクッキーを設定しますか？");
         if($gnCook eq "yes") {
            $gnSCo->extract_cookies($response);
            if ($main::gnDebugFlag) { print scalar localtime(time) . "\n"; }
            if ($main::gnDebugFlag) { print "response-cookies\: " . Dumper($gnSCo->as_string) . "\n"; }
            &gnSetCookie($gnFolIniFN, $gnSCo, \%gnFI);
         
            &gnWarn("クッキーを設定しました。再度送信ボタンを押して投稿してください");
            $gnW->present;
            
         }
      }elsif($gn2chXflg eq "erro") {
        # エラー
        &gnWarn(decode_entities($gnRes_txt));
        
      }elsif($gn2chXflg eq "fals") {
        # 注意付き書き込み成功
        &gnWarn(decode_entities($gnRes_txt));
        $gn2chXflg_res = TRUE;
      }elsif($gn2chXflg eq "fals") {
        # 正常終了
        $gn2chXflg_res = TRUE;
      }else{
        #未対応(今のところ2ch_X:checkは未対応
        &gnWarn(decode_entities($gnRes_txt) . "\n現在のところ\(バージョン$main::gnVersion\)未対応です\n");
      }
   }else{
      # 2ch_Xステータスがなかったら成功と見なす
      $gn2chXflg_res = TRUE;
   }
   
   # 書き込み成功時の処理
   if ($gn2chXflg_res == TRUE) {
      substr($gnW->get_title, 5) =~ m/\s+\-\s+/;
      my $title = $`;                                   # `gnview誤認識対策コメント
      $title = substr($title, index($title, ":")+1);
      &gnLogger("書き込みが完了しました\($title\)");
      
      # sent.ini に履歴を書き込み
      if (&gnCheckPath($main::gnInitCfg{'Main'}{'sent.ini'})) {
         my $gnSIN = &gnOpenLocal($main::gnInitCfg{'Main'}{'sent.ini'}, "a");
            print $gnSIN "[" . time ."]\n";
            print $gnSIN "Name=" . Encode::encode('cp932', $gnFROM) . "\n";
            print $gnSIN "EMail=" . Encode::encode('cp932', $gnMAIL) . "\n";
            my $gnSIN_mes = URI->new(Encode::encode('cp932', $gnMESSAGE));
            $gnSIN_mes = $gnSIN_mes->as_string;
            print $gnSIN "Body=" . $gnSIN_mes . "\n";
            print $gnSIN "Status=200\n";
            my @now = localtime;
            my $gnSIN_time = ($now[5]+1900) . "\/" . sprintf("%.2d", ($now[4]+1)) . "\/" . sprintf("%.2d", $now[3]) . " " .
                               sprintf("%.2d", $now[2]) . ":" . sprintf("%.2d", $now[1]) . ":" . sprintf("%.2d", $now[0]);
            print $gnSIN "Date=$gnSIN_time\n";
            print $gnSIN "Title=" . Encode::encode('cp932', $title) . "\n";
            print $gnSIN "URL=$gnSRq_ref\n";
            print $gnSIN "Key=$gnkey\n";
            print $gnSIN "\n";
         &gnCloseLocal($main::gnInitCfg{'Main'}{'sent.ini'});
         
      }
      $gnW->destroy;
      return(0);
   }
   
   

}

sub gnSetCookie {
   # UTF-8 Compliant!
   # 書き込み用のクッキーを保存する関数
   #
   # 引数: 1: 文字列(書き込み先のFolder.iniのフルパス)
   #       2: HTTP::Cookiesオブジェクト
   #       3: Folder.iniの内容をgnLoadEnvで読み取ったハッシュ配列へのリファレント
   # 返り値: なし
   my $gnFIFN = $_[0];
   my $gnHCo = $_[1];
   my $gnFIRef = $_[2];
   my %gnFI = %$gnFIRef;
   if ($main::gnDebugFlag) { print "gnSetCookie-Folder.ini\: $gnFIFN\n"; }
   if ($main::gnDebugFlag) { print "gnSetCookie-cookie\: " . Dumper($gnHCo->as_string) . "\n"; }
   my $lnsl = $gnHCo->as_string;
   my @lns = split(/\n/, $lnsl);
   foreach (@lns) {
      my $ln = $_; chomp($ln);
      my ($name, $path, $domain, $port, $expires, $version) = split(/; /, substr($ln, 13));
      if ($main::gnDebugFlag) { print "gnSetCookie-each\: $name\n"; }
      my ($key, $val) = split(/=/, $name);
      if(($key ne "MAIL") && ($key ne "NAME")) {
         if ($key eq "HAP") {
            $gnFI{'Cookie'}{'Cookie=HAP'} = $val . ";";             # HAPの格納だけ書式が違うので対処
         }else{
            $gnFI{'Cookie'}{$key} = $val;
         }
         if ($key eq "PON") {
            my($x,$y) = split(/=/, $expires);
            $y = substr($y, 1, 19);
            $y =~ s/-/\//g;
            if ($main::gnDebugFlag) { print "gnSetCookie-PONExpire\: $y\n"; }
            $gnFI{'Cookie'}{'Expires'} = $y;
         }
      }
   }
   
   if ($main::gnDebugFlag) { print "gnSetCookie-Folder.ini\(update\)\:\n" . Dumper(%gnFI); }
   &gnSaveEnv($gnFIFN, \%gnFI);
}

sub gnWrite {
   # UTF-8 Compliant!
   # 書き込みウィンドウを表示する関数
   #
   # 引数１: 呼び出し元のオブジェクト(単に無視されます)
   # 引数２：文字列(本文にセットする文字列。任意。)
   # 返り値: なし
   my $gnWText;
   if($_[1]) {
      $gnWText = $_[1];
   }
   
   # 既に書き込みウィンドウが出ていたら何もしない
   if ($main::gnWxml ne "") {
      &gnLogger("今のところ書き込みウィンドウは１つしか開けません");
      return;
   }
   # 現在選択しているノートのdat(xxxx/xxx.dat)を得る
   my $gnSS_Note = $main::gnGUIxml->get_widget('gnNote');
   if($main::gnDebugFlag) { print "\n".Dumper($gnSS_Note)."\n"; }
   my $gnSS_Sures = $main::gnGUIxml->get_widget('gnSI');
   my $gnSS_SuresM = $gnSS_Sures->get_model;
   my ($gnSortCol, $gnSortOrder) = $gnSS_SuresM->get_sort_column_id;
   
   my $gnSS_TgtDat = "";
   
   my $gnSS_NoteP = $gnSS_Note->get_current_page;
   for my $i ( 0 .. $#main::gnSureViewInfo ) {
      if ($gnSS_NoteP == $i) {
         $gnSS_TgtDat = $main::gnSureViewInfo[$i][0];
         last;
      }
   }
   
   
   if ($gnSS_TgtDat ne "") {
      # xxxx/xxx.datをキーにしてスレの名前を取得
      my $gnSureName = &gnGetSureVarFromDat($gnSS_SuresM, $gnSS_TgtDat, 0);
      
      # Sent.iniからハンドル名とメールアドレスを取得
      my ($gnSS_GenN, $gnSS_DatN) = split(/\//, $gnSS_TgtDat);
      $gnSS_DatN = substr($gnSS_DatN, 0, rindex($gnSS_DatN, "."));
      if ($main::gnDebugFlag) { print "datname=$gnSS_DatN\n"; }
      my $gnSentRef = &gnLoadEnv($main::gnSentIniFile);
      my %gnSent = %$gnSentRef;
      my $gnSent_hdlRef = &gnHashSel(\%gnSent, "", "Key", $gnSS_DatN);
      my %gnSent_hdl = %$gnSent_hdlRef;
      if ($main::gnDebugFlag) { print "handledata=" . Dumper(%gnSent_hdl); }
      
      # 書き込み用ウィンドウ生成
      if ($main::gnWxml eq "") {
         $main::gnWxml = Gtk2::GladeXML->new($main::gladefn, 'gnWrite');
         $main::gnWxml->signal_autoconnect_from_package('main');
      }
      my $gnWritew = $main::gnWxml->get_widget('gnWrite');
      if ($main::gnDebugFlag) { print Dumper($gnWritew); }
      
      # タイトルをセット
      my $gnWritew_title = $gnWritew->get_title;
      $gnWritew_title .= " - " . $gnSureName . " - " . "\($gnSS_TgtDat\)";
      $gnWritew->set_title($gnWritew_title);
      
      # ハンドル名、メールアドレスをセット
      my $gnW_name = $main::gnWxml->get_widget('gnW_name');
      my $gnW_mail = $main::gnWxml->get_widget('gnW_mail');
      
      my @gnHashKeys = keys(%gnSent_hdl);
      my $namebuf = "";
      my $emailbuf ="";
      my $namecnt = 1;
      foreach my $val(@gnHashKeys) {
         if ($gnSent_hdl{$val}{'Name'}) {
            if(!($namebuf =~ $gnSent_hdl{$val}{'Name'})) {
               $gnW_name->append_text($gnSent_hdl{$val}{'Name'});
               $namebuf .= $gnSent_hdl{$val}{'Name'};
               $namecnt++;
            }
         }
         if ($gnSent_hdl{$val}{'EMail'}) {
            if (!($emailbuf =~ $gnSent_hdl{$val}{'EMail'})) {
               $gnW_mail->append_text($gnSent_hdl{$val}{'EMail'});
               $emailbuf .= $gnSent_hdl{$val}{'EMail'};
            }
         }
      }

      # 本文のセット
      if($gnWText) {
          my $gnW_cont = $main::gnWxml->get_widget('gnW_cont');
          my $gnW_contBuf = $gnW_cont->get_buffer;
          $gnW_contBuf->set_text($gnWText);
      }
      
      # ウィンドウのリサイズ
      $gnWritew->resize($main::gnEnvArg{'EditorWindowSize'}{'Width'}, $main::gnEnvArg{'EditorWindowSize'}{'Height'});
      $gnWritew->move($main::gnEnvArg{'EditorWindowSize'}{'Left'}, $main::gnEnvArg{'EditorWindowSize'}{'Top'});
      $gnWritew->queue_resize;

      $gnWritew->show_all;

   }else{
     &gnLogger("書き込み対象のスレが選択されていません");
   }
   
   
}

sub gnHashSel {
   # UTF-8 Compliant!
   # 2次元ハッシュ配列の中からある特定のkey=valueの組み合わせが含まれるもののみを
   # 抽出して返す関数
   #
   # 例えば、$aaa{'bbb'}{'ccc'}="ddd"
   #         $aaa{'bbb'}{'eee'}="fff" というハッシュ配列がある場合、
   # &gnHashSel(\%aaa, "", "ccc", "ddd"); と関数を呼び出すと、返り値は
   # $aaa{'bbb'}{'ccc'}="ddd" のみが含まれるハッシュ配列へのリファレンスが返る
   #
   # 引数: 1: ハッシュ配列へのリファレンス(元のハッシュ配列)
   #       2: 文字列: 1番目のkey(NULLの場合は*とみなす)
   #       3: 文字列: 2番目のkey(NULLの場合は*とみなす)
   #       4: 文字列: 抽出条件のvalue(NULLの場合は*とみなす)
   #          2~4のそれぞれの要素は部分一致で大文字小文字を区別する。
   #          各要素はANDされるものとする
   my $gnRefHash_Ref = $_[0];
   my %gnRefHash = %$gnRefHash_Ref;
   my $gnKey1 = $_[1];
   my $gnKey2 = $_[2];
   my $gnVal = $_[3];
   my %gnTgtHash;
   
   if ($gnKey1 eq "") { $gnKey1 = "\(.*\)"; }
   if ($gnKey2 eq "") { $gnKey2 = "\(.*\)"; }
   if ($gnVal eq "") { $gnVal = "\(.*\)"; }
   
   my @gnRefHash_cat = keys(%gnRefHash);
   foreach my $val1(@gnRefHash_cat) {
      if ($val1 =~ $gnKey1) {
         my @gnRefHash_keys = keys(%{$gnRefHash{$val1}});
         foreach my $val2(@gnRefHash_keys) {
            if ($val2 =~ $gnKey2) {
               my $val3 = $gnRefHash{$val1}{$val2};
               if ($val3 =~ $gnVal) {
                  $gnTgtHash{$val1} = $gnRefHash{$val1};
               }
            }
         }
      }
   }
   
   return(\%gnTgtHash);
   
}

sub gnGetSureVarFromDat {
   # UTF-8 Compliant!
   # dat名(xxxx/xxxx.dat)をキーにして、スレ一覧の中の
   # 任意の列の要素を取得する関数
   #
   # 引数: 1: 文字列(xxxxx/xxxx.dat)
   #       2: 整数(取り出す列。0スタート)
   # 返り値: 文字列
   my $gnTrModel = $_[0];
   my $gnTgtGenre = $_[1];
   my $gnTrTgtCol = $_[2];
   
   my $gnTrIter = $gnTrModel->get_iter_first;
   
   my $cnt = 0;
   my $gnRetVal;
   while (1) {
      my $gnRefDat = $gnTrModel->get($gnTrIter, 10);
      if ($main::gnDebugFlag>2) { print "referense\: " . Dumper($gnRefDat); }
      if ($gnRefDat eq $gnTgtGenre) {
         $gnRetVal = $gnTrModel->get($gnTrIter, $gnTrTgtCol);
         last;
      }else{
         $gnTrIter = $gnTrModel->iter_next($gnTrIter);
      }
   }

   if ($gnRetVal) {
      return($gnRetVal);
   }else{
      return("");
   }
}

sub gnJumpToURL {
   # URLを引数にして外部アプリを呼び出す関数
   #
   # 引数: 文字列: (URL)
   # 返り値: なし
   my $gnToURL = $_[0];
   if($main::gnDebugFlag) { print "$gnToURL\n"; }
   
   if ($main::gnEnvArg{'URLApp'}{'gnSelect'} == 0) {
      
      # Windows/Mac専用：既定のブラウザを起動する
      if($^O eq "darwin") {
         system("open $gnToURL");
      }else{
         system("cmd \/c start $gnToURL");
      }
      
   }elsif ($main::gnEnvArg{'URLApp'}{'gnSelect'} == 1) {
      
      # 汎用：指定したコマンドを使用する
      my $URLcmdln = $main::gnEnvArg{'URLApp'}{'gnFile'} . " $gnToURL";
      if($main::gnDebugFlag) { print "$URLcmdln\n"; }
      system("$URLcmdln \&");
      
   }elsif ($main::gnEnvArg{'URLApp'}{'gnSelect'} == 2) {
      
      # Windows以外：指定したブラウザを起動する
      if ($main::gnEnvArg{'URLApp'}{'gnSelBrowser'} == 0) {
         
         # Mozilla(Seamonkey)
         if($^O eq "darwin") {
            system("open -a Seamonkey.app $gnToURL");
         }else{
            system("mozilla $gnToURL \&");
         }

      }elsif ($main::gnEnvArg{'URLApp'}{'gnSelBrowser'} == 1) {
         
         # Mozilla Firefox
         if($^O eq "darwin") {
            system("open -a Firefox.app $gnToURL");
         }else{
            system("firefox -UILocale ja $gnToURL \&");
         }

      }elsif ($main::gnEnvArg{'URLApp'}{'gnSelBrowser'} == 2) {
         
         # Opera
         if($^O eq "darwin") {
            system("open -a Opera.app $gnToURL");
         }else{
            system("opera -newpage $gnToURL \&");
         }

      }elsif ($main::gnEnvArg{'URLApp'}{'gnSelBrowser'} == 3) {
         
         # Konqueror
         system("konqueror --silent $gnToURL \&");
         
      }elsif ($main::gnEnvArg{'URLApp'}{'gnSelBrowser'} == 4) {
         
         # Epiphany
         system("epiphany $gnToURL \&");
         
      }elsif ($main::gnEnvArg{'URLApp'}{'gnSelBrowser'} == 5) {
         
         # Safari
         if($^O eq "darwin") {
            system("open -a Safari.app $gnToURL");
         }else{
            gnLogger()
         }
      }
   }
   
   return(FALSE);
}

sub gnItaSelect {
   # 板のジャンル名を引数にして、ツリーから該当の板を選択する
   #
   # 引数: 文字列(板のURLからホスト名を除いたもの。例えばLinux板なら"linux"。)
   # 返り値; なし
   my $tgtgenre = $_[0];
   
   my $gnTrV = $main::gnGUIxml->get_widget('gnII');
   my $gnTrV_Model = $gnTrV->get_model;
   $gnTrV_Model->foreach(\&gnGetItaPathFromStr, $tgtgenre);
}

sub gnExit {
   # 終了処理関数
   #
   # 引数: なし
   # 返り値: なし

      # 終了時のウィンドウ位置、大きさを記憶
      my $gnmW = $main::gnGUIxml->get_widget('mW');
      ($main::gnEnvArg{'WindowSize'}{'Left'}, $main::gnEnvArg{'WindowSize'}{'Top'}) = Gtk2::Gdk::Window::get_position($gnmW->window);
      my $sute;
      ($sute, $sute,
       $main::gnEnvArg{'WindowSize'}{'Width'},
       $main::gnEnvArg{'WindowSize'}{'Height'},) = Gtk2::Gdk::Window::get_geometry($gnmW->window);

      # お気に入りを保存
      #my $gnFA = $main::gnGUIxml->get_widget('gnFA');
      &gnSaveFavorites($main::gnFavXML, $main::gnEnvArg{'gnFavorite'}{'gnFavFile'});
      
      # キャッシュファイルをセーブ
      if ($main::gnEnvArg{'Cache'}{'Enable'}) {
         if ($main::gnEnvArg{'Cache'}{'ClearOnExit'}) {
            &gnClearAllCache;
         }else{
            &gnClearExpiredCache;
         }
      }
      &gnSaveEnv($main::gnCacheTblFile, \%main::gnCacheTbl);
      
      # gikoNavi.iniに設定値を書き出し
      &gnSaveEnv($main::gnEnvFile, \%main::gnEnvArg);
      
      # URL読み込みスレッドを終了
      $main::queue->enqueue("exit");
      &gnJoinThreads;
      
      # ロックファイルを削除
      my $gnCfgPath = &gnGetPersonalCfgPath;
      my $gnLockFileN = $gnCfgPath . "\." . "${main::gnGnname}lock";
      &gnUnlink($gnLockFileN);
      
      exit(0);
}

sub gnSureSwitch {
   # スレを表示するNotebookのタブを切り替えたらそれに対応する
   # カテゴリ、スレ一覧の該当部分を選択するようにする
   #
   # 引数: なし
   # 返り値: なし
   my $gnSS_Note = $main::gnGUIxml->get_widget('gnNote');
   if($main::gnDebugFlag) { print "\n".Dumper($gnSS_Note)."\n"; }
   my $gnSS_Genre = $main::gnGUIxml->get_widget('gnII');
   my $gnSS_Sures = $main::gnGUIxml->get_widget('gnSI');
   my $gnSS_SuresM = $gnSS_Sures->get_model;
   my ($gnSortCol, $gnSortOrder) = $gnSS_SuresM->get_sort_column_id;
   
   # スレフィルタをクリア
   my $gnSIFil = $main::gnGUIxml->get_widget('gnSI_fil');
   $gnSIFil->child->set_text("");
   
   my $gnSS_TgtDat = "";
   
   my $gnSS_NoteP = $gnSS_Note->get_current_page;
   for my $i ( 0 .. $#main::gnSureViewInfo ) {
      if ($gnSS_NoteP == $i) {
         $gnSS_TgtDat = $main::gnSureViewInfo[$i][0];
         last;
      }
   }
   
   if ($gnSS_TgtDat ne "") {
      my ($gnSS_TgtDat_Ita, $gnSS_TgtDat_dat) = split(/\//, $gnSS_TgtDat);
      # ジャンルを選択

      my $gnSS_GenreM = $gnSS_Genre->get_model;
      my ($gnSS_GenreP, $gnSS_GenreC) = $gnSS_Genre->get_cursor;
      my $gnSS_GenreI = $gnSS_GenreM->get_iter($gnSS_GenreP);
      my $gnSS_Genre_now = $gnSS_GenreM->get($gnSS_GenreI, 1);

      $gnSS_Genre_now = &gnGetGenreFromURL($gnSS_Genre_now);
      if($main::gnDebugFlag) { print "$gnSS_Genre_now\n"; }

      if ($gnSS_Genre_now ne $gnSS_TgtDat_Ita) {
         $gnSS_GenreM->foreach(\&gnGetItaPathFromStr, $gnSS_TgtDat_Ita);
         
         my $gnSS_SuresNow = $main::gnGUIxml->get_widget('gnSI');
         $gnSS_SuresNow->scroll_to_point(0, 0);
         $gnSS_SuresNow->set_cursor(&gnSureSelectFromDat($gnSS_TgtDat));
         
      }else{
         my $gnSS_SuresNow = $main::gnGUIxml->get_widget('gnSI');
         $gnSS_SuresNow->scroll_to_point(0, 0);
         $gnSS_SuresNow->set_cursor(&gnSureSelectFromDat($gnSS_TgtDat));
      
      }
   }
}

sub gnGetGenreFromURL {
   # 板のURL(http://xxx.xxx.xxx/xxxxx/)からジャンル名を返す関数
   #
   # 引数: 1: 文字列(板のURL。http://xxxxx.xxxx.xxxx/yyyyyy/)<-最後にスラッシュが必ずあり、その前がジャンル名であること
   # 返り値:  文字列(引数のyyyyyの部分)
   my $gnGGFU_url = $_[0];
   
   my @gnGGFU_val = split(/\//, $gnGGFU_url);
   my $gnGGFU_valcnt = @gnGGFU_val;
   return($gnGGFU_val[$gnGGFU_valcnt-1]);
   
}

sub gnGetItaPathFromStr {
   # 板名"xxxxx"をキーにして板一覧の該当行を選択する関数
   #
   # 引数: 1: 文字列(板名。例えばLinux板なら"linux")
   # 返り値: なし
   my $gnTrModel = $_[0];
   my $gnTrPath = $_[1];
   my $gnTrIter = $_[2];
   my $gnTgtGenre = $_[3];
   
   my $gnRefGenreURL = $gnTrModel->get($gnTrIter, 1);
   my @Str = split(/\//, $gnRefGenreURL);
   my $strCnt = @Str;
   my $gnRefGenre = $Str[$strCnt-1];
   
   if($gnRefGenre) {
      if($main::gnDebugFlag) { print "Target=$gnTgtGenre, Reference=$gnRefGenre\n"; }
      if ($gnRefGenre eq $gnTgtGenre) {
         my $gnTrV = $main::gnGUIxml->get_widget('gnII');
         $gnTrV->expand_to_path($gnTrPath);
         $gnTrV->set_cursor($gnTrPath);
         return(1);
      }else{
         return(0);
      }
   }else{
      return(0);
   }
}

sub gnSureIchiranInit {
   # スレ一覧を作成する関数
   #
   # 引数: 1: Gtk2::TreeStore(スレ一覧に入れるTreeStore(スレの一覧データ))
   #       2: array(参照するGtk2::TreeViewColumnの配列(スレ一覧の並び替え状態を再現する)。省略可)
   # 返り値: なし(この関数内でスレ一覧を作成するため戻り値はなし)
   my $gnSureStore = shift;
   my @gnTrVwColumn = @_;
   
   my $checkval = Gtk2::TreeViewColumn->new();
   my $checkref = Data::Dumper->new([$checkval]);
   my $checkref_flg = $checkref->Dump;
   
   my $checktgt = Data::Dumper->new([$gnTrVwColumn[0]]);
   my $checktgt_flg = $checktgt->Dump;
   
   my $check_flg;
   if($checkref_flg eq $checktgt_flg) {
       $check_flg = "matched";
       if($main::gnDebugFlag) { print "matched\n"; }
   }else{
       $check_flg = "unmatched";
       if($main::gnDebugFlag) { print "unmatched\n"; }
   }
  
   # TreeView作成
   my $gnSureView = $main::gnGUIxml->get_widget('gnSI');
   
   # 既にcolumnが設定してあったら削除
   if ($check_flg eq "matched") {
      my @gnSureViewCols = $gnSureView->get_columns;
      my $gnSureViewColN = @gnSureViewCols;
      for (my $i = 0 ; $i<$gnSureViewColN ; $i++) {
         $gnSureView->remove_column($i);
      }
   }
   
   $gnSureView->set_model($gnSureStore);
   $gnSureView->set_reorderable(TRUE);
   $gnSureView->signal_connect('row-activated' => sub{ &gnSureUpdate; });
   $gnSureView->signal_connect('cursor-changed' => sub{ &gnSureSelect($gnSureView, FALSE); });

   my @gnSICol ='';
   # スレ一覧の表タイトル
   my @gnSICol_title = ('スレッド名','カウント','取得','未取得','新着',
                        '未読','巡回予約','取得日時','スレ作成日時','最終更新日時',
                        'スレデータファイル名(隠し)'
                       );
   my $gnSIColRend = Gtk2::CellRendererText->new;
   for(my $cnt=0;$cnt<12;$cnt++) {
      $gnSICol[$cnt] = Gtk2::TreeViewColumn->new();
      $gnSICol[$cnt]->set_title($gnSICol_title[$cnt]);
      $gnSICol[$cnt]->set_resizable(TRUE);
      $gnSICol[$cnt]->set_sort_column_id($cnt);
      $gnSICol[$cnt]->pack_start($gnSIColRend, FALSE);
      $gnSICol[$cnt]->add_attribute($gnSIColRend, text => $cnt);
      if($cnt < 10) {
         if ($check_flg eq "matched") {
            if($main::gnDebugFlag) { print "aaa\n" . Dumper($gnTrVwColumn[$cnt]); }
               my $gnTrVwColumn_sortType = $gnTrVwColumn[$cnt]->get_sort_order;
               $gnSICol[$cnt]->set_sort_order($gnTrVwColumn_sortType);
            }
         $gnSureView->append_column($gnSICol[$cnt]);
      }

   }


}

sub gnGetLogDir {
   # UTF-8 Compliant!
   # ログの保管ディレクトリ取得用関数
   # 環境設定に記述があればそれを使用
   # ない場合は"./Log/2ch/"を返す
   # 引数: なし
   # 返り値: 文字列(ログ保管ディレクトリへのフルパス)
   my $logdir = '';
   if($^O eq 'MSWin32') {
      if($main::gnEnvArg{'Folder'}{'LogFolder'} eq '') {
         $main::logdir  = "Log/2ch/";
         
      }else{
         $main::logdir  = "/2ch";
      }
   }else{
      if($main::gnEnvArg{'Folder'}{'LogFolderUnix'} eq '') {
         $main::logdir  = "Log/2ch/";
      }else{
         $main::logdir  = $main::gnEnvArg{'Folder'}{'LogFolderUnix'} . "/2ch/";
      }
   }
   
   return($main::logdir);

}

sub gnMenu_AppendFavMenu {
   # お気に入り変数からメインメニューのお気に入り部分を作成する関数
   # 引数１: Gtk2::Menu
   # 引数２: 変数(XML::Parserで読み込んだお気に入り)
   # 返り値: Gtk2::Menu
   
   my $favMenu = $_[0];
   my $favXML  = $_[1];

   #my $firstitem = 1;
   $favXML = $favXML->[1];
   if($main::gnDebugFlag>2) { print "gnMenu_AppendFavMenu\n"; }
   if($main::gnDebugFlag>2) { print Dumper($favMenu); }
   if($main::gnDebugFlag>2) { print Dumper($favXML); }
   
   my $favCnt = @$favXML-1;
   for(my $cnt=1;$cnt<$favCnt;$cnt=$cnt+2) {
       my $favFlag = $favXML->[$cnt];
       if($favFlag eq "folder") {
           my $title = $favXML->[$cnt+1]->[0]->{'title'};
           if($main::gnDebugFlag>2) { print "folder: $title\n"; }
           my $favFolder = Gtk2::ImageMenuItem->new_with_label($title);
           my $iconimg = Gtk2::Image->new_from_stock('gtk-directory', 'menu');
           $favFolder->set_image($iconimg);
           #if($level>0 && $firstitem) {
           #    
           #}else{
           #}
           my $favXMLchild = $favXML->[$cnt+1];
           #$level++;
           my $favSubMenu = &gnMenu_FavCreateSubMenu($favXMLchild);
           $favFolder->set_submenu($favSubMenu);
           $favMenu->append($favFolder);

       }elsif($favFlag eq "favitem"){
           my $title = $favXML->[$cnt+1]->[0]->{'title'};
           if($main::gnDebugFlag>2) { print "favitem: $title\n"; }
           my $favFolder = Gtk2::ImageMenuItem->new_with_label($title);
           my $iconimg = Gtk2::Image->new_from_stock('gtk-file', 'menu');
           $favFolder->set_image($iconimg);
           $favMenu->append($favFolder);
           
       }else{
           if($main::gnDebugFlag>2) { print "Unknown flag\n"; }
       
       }
   }
   
   return($favMenu);
    
}

sub gnMenu_FavCreateSubMenu {
   # メインメニューのお気に入り部分のサブメニューを作成する関数
   # (サブメニューが入れ子構造の場合は自分が自分を再帰的に呼び出す)
   #
   # 引数： リファレント(XML::Parserで読み込んだお気に入りのfolder以下)
   # 返り値: Gtk2::Menu
   my $favXML = $_[0];
   if($main::gnDebugFlag>2) { print "gnMenu_FavCreateSubMenu\n"; }
   #if($main::gnDebugFlag>2) { print Dumper($favMenu); }
   if($main::gnDebugFlag>2) { print Dumper($favXML); }

   my $favMenu = Gtk2::Menu->new;
   
   my $favCnt = @$favXML-1;
   for(my $cnt=1;$cnt<$favCnt;$cnt=$cnt+2) {
       my $favFlag = $favXML->[$cnt];
       if($favFlag eq "folder") {
           my $title = $favXML->[$cnt+1]->[0]->{'title'};
           if($main::gnDebugFlag>2) { print "folder: $title\n"; }
           my $favFolder = Gtk2::ImageMenuItem->new_with_label($title);
           my $iconimg = Gtk2::Image->new_from_stock('gtk-directory', 'menu');
           $favFolder->set_image($iconimg);
           my $favXMLchild = $favXML->[$cnt+1];
           my $favSubMenu = &gnMenu_FavCreateSubMenu($favXMLchild);
           $favFolder->set_submenu($favSubMenu);
           $favMenu->append($favFolder);
           
       }elsif($favFlag eq "favitem"){
           my $title = $favXML->[$cnt+1]->[0]->{'title'};
           if($main::gnDebugFlag>2) { print "favitem: $title\n"; }
           my $favFolder = Gtk2::ImageMenuItem->new_with_label($title);
           my $iconimg = Gtk2::Image->new_from_stock('gtk-file', 'menu');
           $favFolder->set_image($iconimg);
           $favMenu->append($favFolder);
       }else{
           if($main::gnDebugFlag>2) { print "Unknown flag\n"; }
       }
       
   }
   
   return($favMenu);
   
}

sub gnMO_AppendFavorites {
   # お気に入りをgnMO_menu(Gtk2::Menu)に追加する関数
   # 引数１: Gtk2::Menu
   # 引数２: 文字列(お気に入りファイル(Favorites.xml)へのフルパス)
   # 返り値: なし
   my $gnMO_menu = $_[0];
   my $gnFavXMLfn = $_[1];

   my $gnFavXMLraw = XML::Parser->new(Style => 'Tree', ProtocolEncoding => 'X-SJIS-CP932');
   $main::gnFavXML = $gnFavXMLraw->parsefile($gnFavXMLfn);
   if($main::gnDebugFlag>2) { print "gnMenu_AppendFavorites\n"; }
   if($main::gnDebugFlag>2) { print Dumper($main::gnFavXML); }
   
   # メインメニューのお気に入りを作成
   my $gnFavMenuNew = &gnMenu_AppendFavMenu($gnMO_menu, $main::gnFavXML);
   
}

sub gnFA_AppendFavTree {
   # お気に入り変数からスレ一覧のお気に入り部分を作成する関数
   # 引数１: Gtk2::TreeStore
   # 引数２: 変数(XML::Parserで読み込んだお気に入りへのリファレンス)
   # 引数３: 変数(ルートレベルであればundef, そうでなければGtk2::TreeIterへのリファレンス)
   
   my $favTreeStore = $_[0];
   my $favXML  = $_[1];
   my $favTreeIter = $_[2];

   if($main::gnDebugFlag>2) { print "gnFA_AppendFavTree\n"; }
   if($main::gnDebugFlag>2) { print Dumper($favTreeStore); }
   if($main::gnDebugFlag>2) { print Dumper($favXML); }
   
   my $favCnt = @$favXML-1;
   my $hasChild = 0;
   for(my $cnt=1;$cnt<$favCnt;$cnt=$cnt+2) {
       my $favFlag = $favXML->[$cnt];
       if($favFlag eq "folder") {
           $hasChild = 1;
           my $title = $favXML->[$cnt+1]->[0]->{'title'};
           if($main::gnDebugFlag>2) { print "folder: $title\n"; }
           my $favTreeIter2 = $favTreeStore->append($favTreeIter);
           $favTreeStore->set($favTreeIter2, 0 => $title, 1=>'', 2=>'', 3=>'', 4=>'',5=>'', 6=>'', 7=>'', 8=>'', 9=>'', 10=>'');

           my $favXMLchild = $favXML->[$cnt+1];
           $favTreeStore = &gnFA_AppendFavTree($favTreeStore, $favXMLchild, $favTreeIter2);

       }elsif($favFlag eq "favitem"){
           $hasChild = 1;
           my $title = $favXML->[$cnt+1]->[0]->{'title'};
           if($main::gnDebugFlag>2) { print "favitem: $title\n"; }
           my $favTreeIter2 = $favTreeStore->append($favTreeIter);
           $favTreeStore->set($favTreeIter2, 0 => $title, 1=>'', 2=>'', 3=>'', 4=>'',5=>'', 6=>'', 7=>'', 8=>'', 9=>'', 10=>'');
           
       }else{
           if($main::gnDebugFlag>2) { print "Unknown flag\n"; }
       
       }
       if($main::gnDebugFlag>2) { print Dumper($favTreeIter); }
   }
   if(($favTreeIter) && (!$hasChild)) {
       my $title = '(空のフォルダ)';
       my $favTreeIter2 = $favTreeStore->append($favTreeIter);
       $favTreeStore->set($favTreeIter2, 0 => $title, 1=>'', 2=>'', 3=>'', 4=>'',5=>'', 6=>'', 7=>'', 8=>'', 9=>'', 10=>'');
   }
   
   return($favTreeStore);
    
}

sub gnFA_AppendFavorites {
   # お気に入りをgnMA(Gtk2::TreeView)に追加する関数
   # 引数１: Gtk2::TreeView
   # 引数２: 文字列(お気に入りファイル(Favorites.xml)へのフルパス)
   # 返り値: なし
   my $gnFA_TreeView = $_[0];
   my $gnFavXMLfn = $_[1];

   my $gnFavXMLraw = XML::Parser->new(Style => 'Tree', ProtocolEncoding => 'X-SJIS-CP932');
   $main::gnFavXML = $gnFavXMLraw->parsefile($gnFavXMLfn);
   if($main::gnDebugFlag>2) { print "gnFA_AppendFavorites\n"; }
   if($main::gnDebugFlag>2) { print Dumper($main::gnFavXML); }
   
   
   # (暫定的に)並び替えを禁止
   #$gnFA_TreeView
   
   # お気に入りの表タイトル
   my @gnSICol_title = ('フォルダ名/スレッド名','カウント','取得','未取得','新着',
                        '未読','巡回予約','取得日時','スレ作成日時','最終更新日時',
                        'スレデータファイル名(隠し)'
                       );
   my $gnSIColRend = Gtk2::CellRendererText->new;
   for(my $cnt=0;$cnt<12;$cnt++) {
      my $gnSICol = Gtk2::TreeViewColumn->new();
         $gnSICol->set_title($gnSICol_title[$cnt]);
         $gnSICol->set_resizable(TRUE);
         #$gnSICol->set_reorderable(FALSE);
         $gnSICol->set_sort_column_id($cnt);
         $gnSICol->pack_start($gnSIColRend, FALSE);
         $gnSICol->add_attribute($gnSIColRend, text => $cnt);
         
      if($cnt < 10) {
         $gnFA_TreeView->append_column($gnSICol);
      }

   }

   
   # メインメニューのお気に入りを作成
   my $favXML = $main::gnFavXML->[1];
   my $favTreeStore = Gtk2::TreeStore->new( qw/ Glib::String Glib::String Glib::String
                                                   Glib::String Glib::String Glib::String
                                                   Glib::String Glib::String Glib::String
                                                   Glib::String Glib::String / );
   $favTreeStore = &gnFA_AppendFavTree($favTreeStore, $favXML, undef);
   
   $gnFA_TreeView->set_model($favTreeStore);
   $gnFA_TreeView->set_reorderable(FALSE);
   
}

sub gnSaveFavorites {
    # お気に入りデータを読み込み、XMLファイルに保存する関数
    #
    # 引数1：XML::Parserで読み込んだお気に入りXMLの内容(ハッシュの配列)
    # 引数2: 文字列($main::gnEnvArg{'gnFavorite'}{'gnFavFile'})
    # 返り値： 整数(1=成功、0=失敗)
    my $gnFAXML = $_[0];
    my $fn = $_[1];
    
    if(&gnCheckPath($fn) != 1) {
        if($main::gnDebugFlag) { print "Filename not found: $fn\n"; }
        return(0);
    }
    
    my $fh = &gnOpenLocal($fn, "w");
    if(!($fh)) {
        if($main::gnDebugFlag) { print "File open failed: $fn\n"; }
        return(0);
    }
    
    print $fh '<?xml version="1.0" encoding="Shift_JIS" standalone="yes"?><favorite>';
    $gnFAXML = $gnFAXML->[1];
    shift(@$gnFAXML);
    &gnSaveFavoritesChild($gnFAXML, $fh);
    
    print $fh '</favorite>' . "\n";
    &gnCloseLocal($fn);
    return(1);
}

sub gnSaveFavoritesChild {
    # お気に入りデータを読み込み、XMLファイルに保存する関数
    # (再帰呼び出し用)
    #
    # 引数1：XML::Parserで読み込んだお気に入りXMLの内容の一部(ハッシュの配列)
    # 引数2: ファイルハンドルへのリファレンス
    # 返り値： なし
   my $favXMLc = $_[0];
   my $fhc = $_[1];
    
   my $favCnt = @$favXMLc-1;
   if($favCnt < 1) { return; }

#   print Dumper($favXMLc);

   for(my $cnt=0;$cnt<$favCnt;$cnt=$cnt+2) {
       my $favFlag = $favXMLc->[$cnt];
       my $OptsR = $favXMLc->[$cnt+1]->[0];
       my %Opts = %$OptsR;

       if($favFlag eq "folder") {
           print $fhc '<folder';
           my @keys = keys(%Opts);
           foreach my $val1(@keys) {
              my $str = " " . ${val1} . '="' . $Opts{$val1} . '"';
              $str = Encode::encode("cp932", $str);
              print $fhc $str;
           }
           print $fhc '>';
           
           my $favXMLchild = $favXMLc->[$cnt+1];
           shift(@$favXMLchild);
           &gnSaveFavoritesChild($favXMLchild, $fhc);
           
           print $fhc '</folder>';
       }elsif($favFlag eq "favitem"){
           print $fhc '<favitem';
           my @keys = keys(%Opts);
           foreach my $val1(@keys) {
              my $str = " " . ${val1} . '="' . $Opts{$val1} . '"';
              $str = Encode::encode("cp932", $str);
              print $fhc $str;
           }
           print $fhc '/>';
           
       }else{
       
       }
   }

}

sub gnLoadEnv {
   # UTF-8 Compliant!
   # 環境設定ファイル(gikoNavi.ini)を読み込んで
   # 内部管理用のハッシュ配列に格納する
   # 引数: 文字列("gikoNavi.ini"へのパス。UTF-8フラグ付きを想定)
   # 返り値: 2次元ハッシュ配列(カテゴリ名, Key)
   # ----------------------
   # 備考:   各変数へのアクセスのしかたは
   #         <$変数>{<カテゴリの名前>}{<keyの名前>} とすると値が出てくる
   #         <$変数>{<カテゴリの名前>}{<keyの名前>} = <新しい値> とすれば値を変更できる
   #         (例1)
   #           my $testvar = $main::gnEnvArg{'WindowSize'}{'Top'};
   #                       $testvar に入るのは、[WindowSize]カテゴリの Top=xxxxxx の値(xxxxxxx)
   #         (例2)
   #           $main::gnEnvArg{'WindowSize'}{'Top'} = "500";
   #                       [WindowSize]カテゴリの Top=xxxxxx の値(xxxxxxx) が 500 になる
   #        ---------------
   #         読み込むファイルはSJISだけど、配列の中にはutf8フラグ付きのshiftjisで
   #         記録されているので、Perl内部ではUTF-8として扱われている・・・はず
   
   # 引数を取得
   my $fn = $_[0];
   if($main::gnDebugFlag) { print "gnLoadEnv Filename=$fn\n"; }
   
   my $inibuf = '';
   # ファイルをオープンして読み込み
   my $gnLE = &gnOpenLocal($fn, "r");
      $inibuf = join '', <$gnLE>;
   &gnCloseLocal($fn);
   
   $inibuf =~ s/\r//g;
   $inibuf = Encode::decode('cp932', $inibuf);
   my @inibufarray = split(/\n/, $inibuf);
   
   my $iniGenre= '';
   my $iniKey = '';
   my $iniVal = '';
   my %retarray;
   foreach(@inibufarray) {
      my $iniln = $_;
      if($iniln =~ /^\[/) {
         chop($iniln);
         $iniGenre = substr($iniln, 1);
      }else{
         $iniKey = substr($iniln, 0, rindex($iniln, "="));
         $iniVal = substr($iniln, rindex($iniln, "=")+1);
         $retarray{$iniGenre}{$iniKey} = $iniVal;
      }
   }
   return(\%retarray);
}

sub gnSaveEnv {
   # UTF-8 Compliant!
   # 環境設定ファイル(*.ini)へ、内部で保管したハッシュ配列を書き込む
   # 引数: 1:文字列("*.ini"へのパス。UTF-8フラグ付きを想定)
   #       2:ハッシュ配列
   # 返り値: なし
   # ----------------------
   # 備考:   各変数は
   #         <$変数>{<カテゴリの名前>}{<keyの名前>} という形式で保管されている
   #         iniファイルに書き込むときは
   #         [カテゴリの名前]
   #         <keyの名前>=<値>crlf
   #         という形で書き込まれる
   #        ---------------
   #         ハッシュ配列はutf8フラグ付きのshiftjisで記録されているが
   #         iniファイルに書き出す際にはutf8フラグを落とし、ShiftJISで書き込まれる
   
   # 引数を取得
   my $fn = $_[0];
   my $gnEnvArg1 = $_[1];
   my %gnEnvArg2 = %$gnEnvArg1;
   if($main::gnDebugFlag) { print "saveenv\: $fn\n"; }

   my @gnEA_cat = keys(%gnEnvArg2);
   
   # ファイルをオープン
   my $gnLE = &gnOpenLocal($fn, "w");
   foreach my $val(@gnEA_cat) {
      # カテゴリの一覧を取得
      my @gnEA_keys = keys(%{$gnEnvArg2{$val}});
      
      my $flg1 = TRUE;
      foreach my $val2(@gnEA_keys) {
         # カテゴリの中のそれぞれのkeyを取り出し
         
         if($flg1) {
            my $str = "[" . $val . "]\n";
            print $gnLE $str;
            $flg1 = FALSE;
         
         }
         
         my $val3 = $gnEnvArg2{$val}{$val2};
         
         my $str = $val2 . "=" . $val3 . "\n";
         $str = Encode::encode('cp932', $str);
         
         print $gnLE $str;
      
      }
   }
   &gnCloseLocal($fn);
   
}

sub gnMakeItaTreeStore {
   # UTF-8 Flag Compliant!
   # 板一覧のファイル名を引数として受け取り、
   # TreeStore型のウィジェットを返す
   # またグローバル変数%main::gnBoardTblも更新する
   #
   # 引数：文字列(板一覧へのフルパス。UTF-8フラグ付)
   # 返り値：
   my $cfgfile = $_[0];
   
   my $gnGenreid;
   my $gnGenreStr;
   
   my @gnItaGenre;
   my @gnItaInfo;
   
   # TreeStoreを作成
   my $gnItaStore = Gtk2::TreeStore->new( qw/ Glib::String Glib::String / );

   # 一番上「２ちゃんねる」を作成
   my $gnItaStore_iter1 = $gnItaStore->append(undef);
   $gnItaStore->set($gnItaStore_iter1, 0 => "２ちゃんねる", 1 => '');
   
   # TreeStoreのトップレベルになるジャンル抽出
   my $gnMITS = &gnOpenLocal($cfgfile, "r");
   if($gnMITS) {
      while(<$gnMITS>) {
         my $gnStr = $_; chomp($gnStr);
         $gnStr = Encode::decode('utf8', $gnStr);
         if($gnStr =~ /-0::/) {
            (my $gnGenreid, my $gnGenreStr) = split(/-0::/, $gnStr);
            push(@gnItaGenre, [$gnGenreid, $gnGenreStr])
          }
      }
      &gnCloseLocal($cfgfile);
   }else{
      return(undef);
   }
   
   # ジャンルごとに板一覧を抽出
   my $loadcnt = 0;
   my $gnItaGenreCnt = @gnItaGenre;
   foreach my $gnGenreTmp (@gnItaGenre) {
      $gnGenreid  = $gnGenreTmp->[0];  # ジャンル番号
      $gnGenreStr = $gnGenreTmp->[1];  # ジャンルの名称
      
      # 第2レベルとなる各ジャンルをTreeStoreに追加
      my $gnItaStore_iter2 = $gnItaStore->append($gnItaStore_iter1);
      $gnItaStore->set($gnItaStore_iter2, 0 => $gnGenreStr, 1 => '');
      
      my $gnMITS = &gnOpenLocal($cfgfile, "r");
      if($gnMITS) {
         while(<$gnMITS>) {
            my $gnStr = $_; chomp($gnStr);
            $gnStr = Encode::decode('utf8', $gnStr);
            
            my $gnValStr = "/${gnGenreid}-/";
            if($gnStr =~ /^$gnGenreid-/) {
              if($gnStr !~ /$gnGenreid-0::/) {
              
                 # 第3レベルとなる各板を作成
                 my $gnItaStore_iter3 = $gnItaStore->append($gnItaStore_iter2);
                 (my $gnGenreid, my $gnItaName, my $gnItaUrl) = split(/::/, $gnStr);
                 $gnItaStore->set($gnItaStore_iter3, 0 => $gnItaName, 1 => $gnItaUrl);
                 
                 # 環境変数%main::gnBoardTblを更新
                 $main::gnBoardTbl{&gnGetGenreFromURL($gnItaUrl)} = $gnItaName . chr(001) . $gnItaUrl;
                 
                 print STDERR ".";
                 
              }
            }
         }
         &gnCloseLocal($cfgfile);
      }else{
         return(undef);
      }
      
      $loadcnt++;
      print STDERR int($loadcnt / $gnItaGenreCnt * 100) . "\%";
   }
   
   return($gnItaStore);
}

sub gnMakeInitialSureLst {
   # UTF-8 compliant!
   # 引数なし
   # スレ一覧の表に起動時の空データを渡す
   # 返り値はTreeStore型のウィジェット(実データは空)
   
   # TreeStoreを作成                       0: スレッド名(Str)
   #                                       1: カウント(Int)
   #                                       2: 取得(Int)
   #                                       3: 未取得(Int)
   #                                       4: 新着(Int)
   #                                       5: 未読(Int)
   #                                       6: 巡回予約(Str)
   #                                       7: 取得日時(Str)
   #                                       8: スレ作成日時(Str)
   #                                       9: 最終更新日時(Str)
   #                                      10: スレデータファイル名(Str, 隠し要素)
   my $gnSureStore = Gtk2::TreeStore->new( qw/ Glib::String Glib::String Glib::String
                                               Glib::String Glib::String Glib::String
                                               Glib::String Glib::String Glib::String
                                               Glib::String Glib::String / );
   my $gnSureStore_iter1 = $gnSureStore->append(undef);
   $gnSureStore->set($gnSureStore_iter1, 0 => '', 1 => 0, 2 => 0, 3 => 0, 4 => 0, 5 => 0,
                     6 => '', 7 => '', 8 => '', 9 => '', 10 => '', 11 => '');
   
   return($gnSureStore);
}

sub gnSleIchiranSelect {
   # UTF-8 compliant!
   # 板がクリックされたらスレの情報を読み込む
   # <ログディレクトリ>/Folder.idxがなかった場合はそのまま終了。
   # 一度もスレの一覧をとったことがない場合は確認の上、スレの一覧を取得する。(別関数へ)
   # あったら"<ログディレクトリ>/Folder.idx"を引数に
   # gnSleIchiranReadを呼ぶ
   #-------------------------------------------------------------------

   # 引数: 1: Gtk2::TreeView
   #       2: 文字列(強制的にFolder.idxの再読み込みをするか指定。"force"なら再読み込み。"none"ならしない。)
   
  if ($main::gnSuppressEventFlg == FALSE) { 
   my $gnSISHikisu =$_[0];
   if($main::gnDebugFlag) { print Dumper($gnSISHikisu); }
   
   my $gnSISForceFLG = $_[1];
   
   my ($gnMyTree, $gnMyTreePath, $gnMyTreeCol) = $gnSISHikisu;

   # 選択している部分を取得(返り値はGtk2::TreeSelecton)
   my $gnTreeSel = $gnMyTree->get_selection;

   # 得られたTreeSelectionからTreeModelとTreeIterを得る
   my ($gnMyTreeModel, $gnTM_iter) = $gnTreeSel->get_selected;

   # TreeIterを引数にしてget_valueすると、選択した行の配列が得られる
   my ($gnItaName, $gnItaUrl) = $gnMyTreeModel->get_value($gnTM_iter);

   
   # URLの最後はログのディレクトリ名でもあるので取り出す
   my @gnItaUrl_val = split(/\//, $gnItaUrl);
   my $gnIUv_cnt = @gnItaUrl_val;
   $gnIUv_cnt--;
   
   if($gnIUv_cnt > 0) {

      $main::gnItaLogDir = $gnItaUrl_val[$gnIUv_cnt];
      if($main::gnDebugFlag) { print "gnItaLogDir: " . $main::gnItaLogDir ."\n"; }

      # ここでログのあるディレクトリが確定
      if($main::gnDebugFlag) { print "logdir: " . $main::logdir ."\n"; }
      my $gnItaSfx = $main::logdir . $main::gnItaLogDir . "/";
      if($main::gnDebugFlag > 2) { print "folder.idx_sfx: $gnItaSfx \n"; }
      my $gnItaIdxFN = $gnItaSfx . "Folder.idx";
      if($main::gnDebugFlag) { print "folder.idx_path: $gnItaIdxFN \n"; }
      
      # Folder.idxがなかったら新規作成用関数に飛ぶ
          if (!(&gnCheckPath($gnItaSfx))) {
             &gnLogger("板を格納するディレクトリがありません\($gnItaSfx\)");
             my $mW = $main::gnGUIxml->get_widget('mW');
             my $gnMsgDialog = &gnYesNo("スレ一覧を格納するディレクトリがありません。\n作成してスレ一覧を取得しますか？");
             if($gnMsgDialog eq 'yes') {
                my $rst = &gnMakeDir($gnItaSfx);
                if($rst >1) {
                   &gnLogger("板を格納するディレクトリを作成しました\($gnItaSfx\)");
                }else{
                   &gnLogger("ディレクトリの作成に失敗しました。処理をキャンセルします\($gnItaSfx\)");
                }
                if(!(&gnCheckPath($gnItaIdxFN))) {
                   &gnMakeFolderIni($gnItaSfx . "\/Folder.ini");
                   &gnLogger("Folder.iniを作成しました\($gnItaSfx\/Folder.ini\)");
                }

                my $gnSINFlg = &gnSureItiranNew($gnItaUrl, $gnItaSfx);
                if ($gnSINFlg == FALSE) {
                   &gnLogger("スレ一覧更新に失敗しました");
                   return(FALSE);
                }
             }else{
                if($main::gnDebugFlag) { print "gnMsgDialog_response: " . Dumper($gnMsgDialog)."\n"; }
                &gnLogger("この板はまだ一覧を取得していません\($gnItaName\)");
                return(FALSE);
             }
          }
      
      if ($gnSISForceFLG eq "force") {
         my $gnSINFlg = &gnSureItiranNew($gnItaUrl, $gnItaSfx);
         if ($gnSINFlg == FALSE) {
            &gnLogger("スレ一覧更新に失敗しました");
            return(FALSE);
         }
      }
      
      # ファイルパスを引数にして
      # gnSleIchiranReadを呼ぶ
      &gnSleIchiranRead($gnItaIdxFN);
      return(TRUE);
      
   }else{
      return(FALSE);
   }
 }  
}

sub gnSureItiranNew {
   # UTF-8 Compliant!
   # スレ一覧を更新(もしくは新規作成)する関数
   #
   # 引数: 1: 文字列(板のベースURL。UTF-8フラグ付きを想定)
   #       2: 文字列(板のディレクトリ。UTF-8フラグ付きを想定)
   
   my $gnItaUrl = $_[0];
   my $gnItaSfx = $_[1];
       
       &gnLogger("subject.txtを取得します");
       my $gnItaIdxFURL = $gnItaUrl . "subject.txt";
       
       my $gnSIUFlg = &gnSureItiranUpdate($gnItaIdxFURL, $gnItaSfx);
       if($gnSIUFlg == TRUE) {
           &gnLogger("スレ一覧を更新しました");
           return(TRUE);
       }else{
           &gnLogger("スレ一覧更新に失敗しました");
           return(FALSE);
       }
}

sub gnSureItiranUpdate {
   # UTF-8 Compliant!
   # 指定されたURLからsubject.txtを取得して
   # gnSub2FldIniを呼び出す。
   #
   # 引数: 1: 文字列(取得するsubject.txtのURL。UTF-8フラグ付きを想定)
   #       2: 文字列(subject.txt, Folder.idxを保存するディレクトリ。UTF-8フラグ付きを想定)
   my $gnItaIdxFURL = $_[0];
   my $gnItaSfx = $_[1];

   &gnLogger("取得するURL：$gnItaIdxFURL");
                
   my $gnUA = LWP::UserAgent->new;
   $gnUA->agent($main::gnUsrAgent);
   if($main::gnEnvArg{'ReadProxy'}{'Proxy'} == 1) {
      my $gnUA_proxystr = "http\:\/\/" . $main::gnEnvArg{'ReadProxy'}{'Address'} . "\:" . $main::gnEnvArg{'ReadProxy'}{'Port'} . "\/";
      $gnUA->proxy('http', $gnUA_proxystr);
   }
             
   my $gnUA_res = $gnUA->get($gnItaIdxFURL);
   
   if($gnUA_res->is_success) {
       # subject.txtを取得したのでローカルに保存
       my $gnItaSubFN = $gnItaSfx . "subject.txt";
               
       my $gnIdxF = &gnOpenLocal($gnItaSubFN, "w");
          print $gnIdxF $gnUA_res->content;
       &gnCloseLocal($gnItaSubFN);
               
       &gnLogger("subject.txtの取得に成功しました");
       
       # subject.txtからFolder.idxを生成(既にある場合はアップデート)
       my $gnSub2FldIniRST = &gnSub2FldIni($gnItaSubFN, $gnItaSfx);
               
       if($gnSub2FldIniRST eq FALSE) {
           &gnLogger("インデックスファイルの更新に失敗しました");
           return(FALSE);
       }else{
         return(TRUE);
       }
               
    }else{
       &gnLogger("subject.txtの取得に失敗しました");
    }
          
}

sub gnSub2FldIni {
   # UTF-8 Compliant!
   # 板のインデックスファイル(<logdirname>/subject.txt)とワーキングディレクトリを引数として受け取り
   # ワーキングディレクトリのFolder.idxを更新する。
   # 既にFolder.idxがあれば差分のみ追加
   #
   # 引数: 1: 文字列(<logdirname>/subject.txt)
   #       2: 文字列(<logdirname>)
   # 返り値: int(TRUEが成功、FALSEが失敗)
   
   my $gnSubFN = $_[0];
   my $gnFldIdxDir = $_[1];
   
   my $gnFldIdxFN = $gnFldIdxDir . "Folder.idx";
   # もしFolder.idxがなかったら作っておいて、行数を計っておく
   # (いちおう行数と行内の1カラム目が同期していない場合を考えて・・・
   
   if($main::gnDebugFlag) { print "$gnFldIdxFN\n"; }
   my $gnSureNo = 0;
   
   if (!(&gnCheckPath($gnFldIdxFN))) {
      my $gnFIdx = &gnOpenLocal($gnFldIdxFN, "a");
         print $gnFIdx "$main::gnIdxFileVersion\n";
      &gnCloseLocal($gnFldIdxFN);
   }else{
      my $gnFIdx2 = &gnOpenLocal($gnFldIdxFN, "r");
      while(<$gnFIdx2>) {
         $gnSureNo++;
      }
      &gnCloseLocal($gnFldIdxFN);
   }

   # subject.txt の内容を配列に入れる
   my $gnSubBuf_a;
   my $gnFSub = &gnOpenLocal($gnSubFN, "r");
      $gnSubBuf_a = join '', <$gnFSub>;
   &gnCloseLocal($gnSubFN);
   my @gnSubBuf_b = split(/\n/, $gnSubBuf_a);

   # Folder.idxの内容を変数に入れる(マッチング専用なので改行で区切って配列化はやっていない)
   my $gnIDNAL_Buf_a;
   my $gnFIDNAL = &gnOpenLocal($gnFldIdxFN, "r");
      $gnIDNAL_Buf_a = join '', <$gnFIDNAL>;
   &gnCloseLocal($gnFldIdxFN);

   
   my $aaa = 0;
   foreach my $gnBuf(@gnSubBuf_b) {
      # subject.txtの行をUTF8で処理できるように変換
      chomp($gnBuf);
      $gnBuf = Encode::decode('cp932', $gnBuf);

      # datファイル名とスレタイを分離
      my ($gnDatName, $gnSureTitle) = split(/\<\>/, $gnBuf);
      # コメント数を取得
      my $gnSureCnt = substr($gnSureTitle,
                                rindex($gnSureTitle, "\(")+1,
                                (length($gnSureTitle) - rindex($gnSureTitle, "\)"))
                                );

      # コメント数が取得できなかったらその行は飛ばす
      # subject.txtの最後の行にchr(000)が続く行があるため
      if (!($gnSureCnt)) {
         next;
      }
      # タイトル名を取得
      my $bbb = rindex($gnSureTitle, "\(");
      if ($bbb != -1) {
        $gnSureTitle = substr($gnSureTitle, 0, $bbb-1);
      }
      
      my $gnDatFileFN = $gnFldIdxDir . $gnDatName;
      my $gnSureNoHex = sprintf("%X", $gnSureNo);
      my $gnIdxBuf = $gnSureNoHex . chr(001) .
                       $gnDatName . chr(001) .
                       $gnSureTitle . chr(001) .
                       "0" . chr(001) .
                       "0" . chr(001) .
                       "0" . chr(001) .
                       "0" . chr(001) .
                       "0" . chr(001) .
                       "0" . chr(001) .
                       "0" . chr(001) .
                       "0" . chr(001) .
                       "0" . chr(001) .
                       $gnSureCnt . chr(001) .
                       $gnSureCnt . chr(001) .
                       "0";
      $gnIdxBuf = Encode::encode("cp932", $gnIdxBuf);
      
      # 現在のFolder.idxの中に$gnDatNameのエントリがなかったら追加する
      my $gnIsDatNameAlrdyLocalFLG = FALSE;
      my $pos=-1;
      $pos = index($gnIDNAL_Buf_a, $gnDatName);
      if($pos>0) {
         $gnIsDatNameAlrdyLocalFLG = TRUE;
      }
      
      if ($gnIsDatNameAlrdyLocalFLG == FALSE) {
         my $gnFIdx = &gnOpenLocal($gnFldIdxFN, "a");
            print $gnFIdx "$gnIdxBuf\n";
         &gnCloseLocal($gnFldIdxFN);
         $gnSureNo++;
         $aaa++;
      }
   }
   if($main::gnDebugFlag>1) { print "add $aaa entry to Folder.idx\: $gnFldIdxFN\n"; }
   &gnLogger("$aaa 件の新着スレを追加しました");

   
   #仮置き
   return(TRUE);
}

sub gnIsDatNameAlrdyLocal {
   # UTF-8 Compliant!
   # 指定したスレ(xxxxxx.dat)が既にFolder.idxの中に
   # いるかどうかを調べる関数
   #
   # 引数: 1: 文字列(スレファイル名(xxxxxx.dat)。パスなし)
   #       2: 文字列(Folder.idxのフルパス)
   # 返り値 : TRUE あった
   #        : FALSE なかった
   my $gnDatName = $_[0];
   my $gnFldIdxFN = $_[1];
   
   my $ret = FALSE;
   my $pos = -1;
   if (!(&gnCheckPath($gnFldIdxFN))) {
      &gnWarn("指定されたFolder.idx\($gnFldIdxFN\)が存在しません。\nFolder.idxを入れるディレクトリがない可能性があります");
      return(FALSE);
   }
   
   my $gnIDNAL_Buf_a;
   my $gnFIDNAL = &gnOpenLocal($gnFldIdxFN, "r");
      $gnIDNAL_Buf_a = join '', <$gnFIDNAL>;
   &gnCloseLocal($gnFldIdxFN);
   
   $pos = index($gnIDNAL_Buf_a, $gnDatName);
   if($pos>0) {
      $ret = TRUE;
   }
   
   if($ret == TRUE) {
      return(TRUE);
   }else{
      return(FALSE);
   }
}

sub gnSleIchiranRead {
   # UTF-8 Compliant!
   # 板のインデックスファイル(<logdirname>/Folder.idx)を引数として受け取り
   # オープンし、TreeStoreを構築し、gnSureViewに当てはめる
   my $gnSureIdxFN = shift;
   if($main::gnDebugFlag) { print "$gnSureIdxFN\n"; }
   
   # TreeStoreを作成                       0: スレッド名(Str)
   #                                       1: カウント(Int)
   #                                       2: 取得(Int)
   #                                       3: 未取得(Int)
   #                                       4: 新着(Int)
   #                                       5: 未読(Int)
   #                                       6: 巡回予約(Str)
   #                                       7: 取得日時(Str)
   #                                       8: スレ作成日時(Str)
   #                                       9: 最終更新日時(Str)
   #                                      10: スレデータファイル名(Str, 隠し要素)
   my $gnSureStore = Gtk2::TreeStore->new( qw/ Glib::String Glib::Int    Glib::Int
                                               Glib::Int    Glib::Int    Glib::Int
                                               Glib::String Glib::String Glib::String
                                               Glib::String Glib::String  / );

   
   my $gnSureDir = substr($gnSureIdxFN,
                            length($main::logdir),
                            (length($gnSureIdxFN) - (length($main::logdir)+length("Folder.idx")))-1
                            );
   if($main::gnDebugFlag) { print "$main::logdir\n"; }
   if($main::gnDebugFlag) { print "$gnSureDir\n"; }
   
   # スレフィルタの情報を取得
   my $gnSIFil = $main::gnGUIxml->get_widget('gnSI_fil');
   my $gnSIFilTxt = $gnSIFil->child->get_text;
   if ($main::gnDebugFlag) { print "sure_filter\: $gnSIFilTxt\n";}

   # gnSureStoreにデータを入れる
   if ($main::gnDebugFlag) { print "open Folder.idx to TreeStore\n";}
   my $gnSureStrcnt = 0;
   my $gnSIDX = &gnOpenLocal($gnSureIdxFN, "r");
      while(<$gnSIDX>) {
         if ($main::gnDebugFlag>2) { print "\tFolder.idx-line\: " . sprintf("%x",$gnSureStrcnt) . "\n";}
         my $gnSureInfoStr = $_;
         $gnSureInfoStr = Encode::decode('cp932', $gnSureInfoStr);
         chomp($gnSureInfoStr);
         
         if($gnSureStrcnt > 0) {
         
            my @gnSureInfoStr_ar = split(/\001/, $gnSureInfoStr);

            if (@gnSureInfoStr_ar != 15) {
                # 要素数が15個じゃなかったデータは華麗にヌルー
                if ($main::gnDebugFlag) { print "\tCorrupted Data Found\n" . Dumper(@gnSureInfoStr_ar);}
                $gnSureStrcnt++;
                &gnLogger("スレ一覧の中に壊れたデータを見つけました。スキップします\:" . $gnSureIdxFN . " " . $gnSureStrcnt . "行目");
                next;
            }
            # スレデータ1行を各要素に分割
            my($gnSureId, $gnSureFN, $gnSureName, $gnSureShutoku, $gnSureByte, $gnSureShutokuDate,
               $gnSureLastUpdate, $gnSureKidoku, $gnSurenazo1, $gnSurenazo2, $gnSurenazo3,
               $gnSurenazo4, $gnSurecnt, $gnSureShinchaku, $gnSurenazo7) = @gnSureInfoStr_ar;
            
            # 未取得はカウント-取得で算出
            my $gnSureMishutoku = hex($gnSurecnt) - hex($gnSureShutoku);

            # 取得日時・最終更新は文字列変換
            if(hex($gnSureShutokuDate) > 0) {
               my ($ss, $mm, $hh, $DD, $MM, $YY, $WKD, $YD, $ID) = gmtime(hex($gnSureShutokuDate));
               $MM++; $YY += 1900;
               $gnSureShutokuDate = sprintf("%04d/%02d/%02d %02d:%02d:%02d", $YY, $MM, $DD, $hh, $mm, $ss);
               ($ss, $mm, $hh, $DD, $MM, $YY, $WKD, $YD, $ID) = gmtime(hex($gnSureLastUpdate));
               $MM++; $YY += 1900;
               $gnSureLastUpdate = sprintf("%04d/%02d/%02d %02d:%02d:%02d", $YY, $MM, $DD, $hh, $mm, $ss);
            } else {
               $gnSureShutokuDate = '';
               $gnSureLastUpdate = '';
            }

            # スレタイトルは先頭にidをつける
            $gnSureName = sprintf("%05d",hex($gnSureId)) . ": " . decode_entities($gnSureName);
            # スレ作成日時はファイル名から抽出する
            my ($gnSureMkDate, $gnSureExt) = split(/\./, $gnSureFN);
            my ($ss, $mm, $hh, $DD, $MM, $YY, $WKD, $YD, $ID) = localtime($gnSureMkDate);
            $MM++; $YY += 1900;
            $gnSureMkDate = sprintf("%04d/%02d/%02d %02d:%02d:%02d", $YY, $MM, $DD, $hh, $mm, $ss);

            # スレフィルタにヒットしなければ次へ
            if (!($gnSIFilTxt =~ m/^ *$/)) {
               # スレフィルタが空白しか含まない場合は評価しない
               my $val = index($gnSureName, $gnSIFilTxt);
               if ($val < 0) {
                  if ($main::gnDebugFlag>1) { print "s";}
                  $gnSureStrcnt++;
                  next;
               }else{
                  if ($main::gnDebugFlag>1) { print "h";}
               }
            }else{
                  if ($main::gnDebugFlag>1) { print "b";}
            }
            
            
            # $gnSureStore(TreeStore)に行を追加
            my $gnSureStore_iter = $gnSureStore->append(undef);
            $gnSureStore->set($gnSureStore_iter,
                              0 => $gnSureName,
                              1 => hex($gnSurecnt), 2 => hex($gnSureShutoku), 3 => $gnSureMishutoku,
                              4 => hex($gnSureShinchaku), 5 => '', 6 => '',
                              7 => $gnSureShutokuDate, 8 => $gnSureMkDate,
                              9 => $gnSureLastUpdate, 10 => ($gnSureDir . "\/" . $gnSureFN)
                              );
         
         }
         $gnSureStrcnt++;
      }
   &gnCloseLocal($gnSureIdxFN);
   if ($main::gnDebugFlag>1) { print "\n";}
   
   # スレ一覧(TreeView)を呼び出し、新しく作ったTreeStoreを当てはめる
   my $gnSureLst = $main::gnGUIxml->get_widget('gnSI');
   $gnSureLst->set_model($gnSureStore);
   

}

sub gnSureSelect {
   # (多分)UTF-8 Compliant!
   # スレ一覧から選択されたスレのファイルを読み込む
   # 既にNotebookに読み込んでいたら読み込んだページを表示
   # 読み込んでいなかったらデータファイルを読み込みNotebookウィジェットに追加。
   
   # 引数１：Gtk2::TreeView
   # 引数２：
   
   my $gnTrView = $_[0];
   my $gnSureUpdateForce = $_[1];
   if ($main::gnDebugFlag) { print "line4585 hikisu: \n" . Dumper($gnTrView, $gnSureUpdateForce), "\n"; }

   # 処理の間はswitch_pageシグナルをブロック
   my $gnNotebook = $main::gnGUIxml->get_widget('gnNote');
   $gnNotebook->signal_handler_block($main::gnSignalHandler->{'gnNote'}{'switch_page'});

   # 選択している部分を取得(返り値はGtk2::TreeSelecton)
   my $gnTreeSel = $gnTrView->get_selection;

   # 得られたTreeSelectionからTreeModelとTreeIterを得る
   my ($gnMyTreeModel, $gnTM_iter) = $gnTreeSel->get_selected;
   

   # TreeIterを引数にしてget_valueすると、選択した行の配列が得られる
   my @gnSureInfo = $gnMyTreeModel->get_value($gnTM_iter);
   
   # 管理用の配列を参照して、Notebook内に既に展開されているかを
   # 確認する
   my $gnFlg_in = FALSE;
   my $gnSVI_fn = '';
   my $gnSVI_idx = -1;
   my $gntmpval1 = @main::gnSureViewInfo;
   my @gnSureViewInfoTmp = @main::gnSureViewInfo;
   my @gnSureViewInfoNew;
   
   for my $i ( 0 .. $#main::gnSureViewInfo ){
      my $gnSVI_fnBuf = $main::gnSureViewInfo[$i][0];
      my $gnSVI_idxBuf = $i;
      
      if($gnSVI_fnBuf eq $gnSureInfo[10]) {
         $gnFlg_in = TRUE;
         $gnSVI_fn = $gnSVI_fnBuf;
         $gnSVI_idx = $gnSVI_idxBuf;
         if($gnSureUpdateForce == FALSE) {
            push(@gnSureViewInfoNew, ([$gnSVI_fnBuf, $gnSVI_idxBuf]));
         }else{
         }
      }else{
         push(@gnSureViewInfoNew, ([$gnSVI_fnBuf, $gnSVI_idxBuf]));
      }
      
   }
   @main::gnSureViewInfo = @gnSureViewInfoNew;   

   if($gnFlg_in == TRUE) {
        # スレはNotebookのなかにある
       if($gnSureUpdateForce == TRUE) {
          # 強制Updateモードに入る

          # ノートブックのページを削除する
          $gnNotebook->remove_page($gnSVI_idx);
          
          # 新規にページを追加する
          # スレ表示用にNotebookに新規ページを作成
          my $gnNB_tv = Gtk2::TextView->new;
          $gnNB_tv->set_property('left-margin' => 5);
          $gnNB_tv->set_property('pixels-above-lines' => 1);
          $gnNB_tv->set_property('pixels-below-lines' => 2);
          $gnNB_tv->set_property('editable' => FALSE);
          $gnNB_tv->signal_connect (motion_notify_event => \&gnSureViewMouseMove);     # マウスが動いたらイベント発生
          $gnNB_tv->signal_connect (button_press_event => \&gnSureViewLinkPress);
          $gnNB_tv->signal_connect (button_release_event => \&gnSureViewLinkRelease);
          $gnNB_tv->signal_connect (key_release_event => \&gnSureViewKeyRelease);
          
          # フォントを指定する
          my $gnNB_tv_context = $gnNB_tv->get_pango_context();
          my $gnNB_tv_fontDesc = $gnNB_tv_context->get_font_description();
          my $gnNB_tv_fontscale = Gtk2::Pango->scale;
          if($main::gnEnvArg{'Browser'}{'gnBrowserFontUseCustom'} == TRUE) {
             $gnNB_tv_fontDesc->set_family($main::gnEnvArg{'Browser'}{'BrowserFontName'});
             $gnNB_tv_fontDesc->set_size($main::gnEnvArg{'Browser'}{'BrowserFontSize'} * $gnNB_tv_fontscale);
             if($main::gnEnvArg{'Browser'}{'BrowserFontBold'} != -1) {
                $gnNB_tv_fontDesc->set_weiget('bold');
             }
             if($main::gnEnvArg{'Browser'}{'BrowserFontItalic'} != -1) {
                $gnNB_tv_fontDesc->set_style('italic');
             }
             $gnNB_tv->modify_font($gnNB_tv_fontDesc);
          }
          
          # TextBufferを取得して初期化(必要ないかも)
          my $gnNB_tvbuf = $gnNB_tv->get_buffer;
          $gnNB_tvbuf->set_text('');
          
          # ScrolledWindowに入れる
          my $gnNB_tvsw = Gtk2::ScrolledWindow->new(undef, undef);
          $gnNB_tvsw->set_shadow_type('etched-out');
          $gnNB_tvsw->set_policy('automatic', 'automatic');
          $gnNB_tvsw->add($gnNB_tv);

          # スレの名前からタブ用のラベルを作成
          my ($gnSureNum, $gnSureName) = split(/: /, $gnSureInfo[0]);
          my $gnNB_lb = "";
          if ($main::gnDebugFlag) { 
             $gnNB_lb = "${gnSureName}\n${gnSVI_fn}:${gnSVI_idx}";
             $gnNB_lb = Gtk2::Label->new($gnNB_lb);
          }else{
             $gnNB_lb = Gtk2::Label->new($gnSureName);
          }

          # フォントサイズを小さくする
          # デフォルトの85%に【今後】将来的には設定できるように？
          my $gnNB_lb_context = $gnNB_lb->get_pango_context();
          my $gnNB_lb_fontDesc = $gnNB_lb_context->get_font_description();
          my $gnNB_lb_fontsize = $gnNB_lb_fontDesc->get_size();
          my $gnNB_lb_newsize = int($gnNB_lb_fontsize * 0.85);
          $gnNB_lb_fontDesc->set_size($gnNB_lb_newsize);
          $gnNB_lb->modify_font($gnNB_lb_fontDesc);
       
          # ファイルパスを関数gnParseSureにあたえると
          # 整形済みのTextBufferが返って来るので$gnNB_tvbuf(TextBuffer)に格納
          my $gnSureFN = $main::logdir . $gnSureInfo[10];

          my $gnSureFN1 = $gnSureInfo[10];
          $gnNB_tvbuf = &gnParseSure($gnSureFN, $gnSureFN1);
          $gnNB_tv->set_buffer($gnNB_tvbuf);

          # カーソルを先頭に(後々変える必要あり)
          $gnNB_tvbuf->place_cursor($gnNB_tvbuf->get_start_iter);
       
          # 用意できたページをNotebookに追加
          my $gnSureView_newpagenum = $gnNotebook->append_page($gnNB_tvsw, $gnNB_lb);
          
          # Notebookを再表示(なぜかこれをしないと追加したページが表示されない)
          $gnNotebook->show_all;
          $gnNotebook->set_current_page($gnSureView_newpagenum);

          # 管理配列にスレの情報を書き込み
          push(@main::gnSureViewInfo, ([$gnSureInfo[10], $gnSureView_newpagenum]));
          

       }else{
          # スレは既にNotebook内に表示されているので
          # 該当のページを表示
          $gnNotebook->set_current_page($gnSVI_idx);
       }
       
   }else{
       # スレはNotebook内にはない。
       # スレが取得されていないかを確認
       if($gnSureInfo[2] eq "0") {
          # スレはまだ取得されていない
          # ログウィンドウにエラーログを出力
          
          my ($gnSureNum, $gnSureName) = split(/: /, $gnSureInfo[0]);
          my $gnLogStr = "このスレはまだ取得していません(" . $gnSureName . ")";
          if ($main::gnDebugFlag) { print "sure is never gotton: $gnSureInfo[2]\n"; }
          
          &gnLogger($gnLogStr);
          
       }else{
          # スレは取得されているので、ファイルから読み込み
          
          # スレ表示用にNotebookに新規ページを作成
          my $gnNB_tv = Gtk2::TextView->new;
          $gnNB_tv->set_property('left-margin' => 5);
          $gnNB_tv->set_property('pixels-above-lines' => 1);
          $gnNB_tv->set_property('pixels-below-lines' => 2);
          $gnNB_tv->set_property('editable' => FALSE);
          $gnNB_tv->signal_connect (motion_notify_event => \&gnSureViewMouseMove);     # マウスが動いたらイベント発生
          $gnNB_tv->signal_connect (button_press_event => \&gnSureViewLinkPress);
          $gnNB_tv->signal_connect (button_release_event => \&gnSureViewLinkRelease);
          $gnNB_tv->signal_connect (key_release_event => \&gnSureViewKeyRelease);
          
          # フォントを指定する
          my $gnNB_tv_context = $gnNB_tv->get_pango_context();
          my $gnNB_tv_fontDesc = $gnNB_tv_context->get_font_description();
          my $gnNB_tv_fontscale = Gtk2::Pango->scale;
          if($main::gnEnvArg{'Browser'}{'gnBrowserFontUseCustom'} == TRUE) {
             $gnNB_tv_fontDesc->set_family($main::gnEnvArg{'Browser'}{'BrowserFontName'});
             $gnNB_tv_fontDesc->set_size($main::gnEnvArg{'Browser'}{'BrowserFontSize'} * $gnNB_tv_fontscale);
             if($main::gnEnvArg{'Browser'}{'BrowserFontBold'} != -1) {
                $gnNB_tv_fontDesc->set_weiget('bold');
             }
             if($main::gnEnvArg{'Browser'}{'BrowserFontItalic'} != -1) {
                $gnNB_tv_fontDesc->set_style('italic');
             }
             $gnNB_tv->modify_font($gnNB_tv_fontDesc);
          }

          # TextBufferを取得して初期化(必要ないかも)
          my $gnNB_tvbuf = $gnNB_tv->get_buffer;
          $gnNB_tvbuf->set_text('');
          
          # ScrolledWindowに入れる
          my $gnNB_tvsw = Gtk2::ScrolledWindow->new(undef, undef);
          $gnNB_tvsw->set_shadow_type('etched-out');
          $gnNB_tvsw->set_policy('automatic', 'automatic');
          $gnNB_tvsw->add($gnNB_tv);

          # スレの名前からタブ用のラベルを作成
          my ($gnSureNum, $gnSureName) = split(/: /, $gnSureInfo[0]);
          my $gnNB_lb = Gtk2::Label->new($gnSureName);

          # フォントサイズを小さくする
          # デフォルトの85%に【今後】将来的には設定できるように？
          my $gnNB_lb_context = $gnNB_lb->get_pango_context();
          my $gnNB_lb_fontDesc = $gnNB_lb_context->get_font_description();
          my $gnNB_lb_fontsize = $gnNB_lb_fontDesc->get_size();
          my $gnNB_lb_newsize = int($gnNB_lb_fontsize * 0.85);
          $gnNB_lb_fontDesc->set_size($gnNB_lb_newsize);
          $gnNB_lb->modify_font($gnNB_lb_fontDesc);
       
          # ファイルパスを関数gnParseSureにあたえると
          # 整形済みのTextBufferが返って来るので$gnNB_tvbuf(TextBuffer)に格納
          my $gnSureFN = $main::logdir . $gnSureInfo[10];
          if($main::gnDebugFlag) { print "$gnSureFN\n"; }

          my $gnSureFN1 = $gnSureInfo[10];
          if($main::gnDebugFlag) { print "$gnSureFN1\n"; }
          $gnNB_tvbuf = &gnParseSure($gnSureFN, $gnSureFN1);
          $gnNB_tv->set_buffer($gnNB_tvbuf);

          # カーソルを先頭に(後々変える必要あり)
          $gnNB_tvbuf->place_cursor($gnNB_tvbuf->get_start_iter);
       
          # 用意できたページをNotebookに追加
          my $gnSureView_newpagenum = $gnNotebook->append_page($gnNB_tvsw, $gnNB_lb);
          if($main::gnDebugFlag) { print "page appended\(normal, num=$gnSureView_newpagenum\).\n"; }
       
          # Notebookを再表示(なぜかこれをしないと追加したページが表示されない)
          $gnNotebook->show_all;
          $gnNotebook->set_current_page($gnSureView_newpagenum);
          if($main::gnDebugFlag) { print "show again\(normal\).\n"; }

          # 管理配列にスレの情報を書き込み
          my $gnSureInfoStr = sprintf("%s", $gnSureInfo[10]);
          my @gnNewSureInfo = ($gnSureInfoStr, $gnSureView_newpagenum);
          if($main::gnDebugFlag) { print "added\n" . Dumper("@gnNewSureInfo"); }
          
          # デバッグフラグがたっていたら、ページラベルに情報を追加
          if ($main::gnDebugFlag) {
             my $gnNB_lb_childwidget = $gnNotebook->get_nth_page($gnSureView_newpagenum);
             my $gnNB_lb_label = $gnNotebook->get_tab_label($gnNB_lb_childwidget);
             $gnNB_lb_label->set_text("${gnSureName}\n${gnSureInfoStr}:${gnSureView_newpagenum}");
          }
          
          push(@main::gnSureViewInfo, ([$gnSureInfoStr, $gnSureView_newpagenum]));
          undef(@gnNewSureInfo);
          if($main::gnDebugFlag) { print "whole\n" . Dumper(@main::gnSureViewInfo) . "\n"; }
       
       }

   }
   
   &gnSIFilUpdate;

   # switch_pageシグナルのブロックを解除
   $gnNotebook->signal_handler_unblock($main::gnSignalHandler->{'gnNote'}{'switch_page'});

}

sub gnSIFilUpdate {
   # UTF-8 Compliant!
   # スレフィルタを更新する
   # つまり現在のテキストボックスの入力内容をプルダウンメニューに追加する
   my $gnSIFil = $main::gnGUIxml->get_widget('gnSI_fil');
   my $gnSIFil_txt = $gnSIFil->child->get_text;
   
   if ($gnSIFil_txt =~ m/^ *$/) {
     # スレフィルタが空白しか含まない場合はそのままリターンする
     return;
   }   

   # フィルタリストのなかになかったらリストに追加
   my $gnSIFilHit = FALSE;
   my $cnt = 0;
   my @gnSIFilHashKeys = keys(%{$main::gnEnvArg{'SelectText'}});
   foreach my $val(@gnSIFilHashKeys) {
     if ($main::gnEnvArg{'SelectText'}{$val} eq $gnSIFil_txt) {
        $gnSIFilHit = TRUE;
     }
     $cnt++;
   }
  
  if ($gnSIFilHit == FALSE) {
     $cnt++;
     my $cntstr = sprintf("%02d", $cnt);
     $main::gnEnvArg{'SelectText'}{$cntstr} = $gnSIFil_txt;
     $gnSIFil->append_text($gnSIFil_txt);
  }

}

sub gnSureUpdate {
   # 
   # 選択したスレを更新する
   #
   # 引数: 1: Gtk2::TreeView

   # 引数(Gtk2::TreeView)を代入
   my $gnTrView = $_[0];
   if($main::gnDebugFlag) { print "gnSureUpdate\n"; }
   
   # Notebook内のページを再読み込みするか
   my $gnIsNoteReload = FALSE;

   # 選択している部分を取得(返り値はGtk2::TreeSelecton)
   my $gnTreeSel = $gnTrView->get_selection;
   my ($gnTreePath,) = $gnTrView->get_cursor;

   # 得られたTreeSelectionからTreeModelとTreeIterを得る
   if($main::gnDebugFlag) { print Dumper($gnTreePath); }
   if(!($gnTreePath)) {
      &gnLogger("更新するスレを選択してからスレ更新を実行してください。スレ更新をキャンセルしました");
      return;
   }
   my ($gnMyTreeModel, $gnTM_iter) = $gnTreeSel->get_selected;
   my @gnTreeSelRows = $gnTreeSel->get_selected_rows;

   # TreeIterを引数にしてget_valueすると、選択した行の配列が得られる
   # [10]の中身が板のディレクトリとdatファイル名
   my @gnSureInfo = $gnMyTreeModel->get_value($gnTM_iter);
   my ($linktgt_ita, $linktgt_sure) = split(/\//, $gnSureInfo[10]);
   if($main::gnDebugFlag) { print "gnSureUpdate:\t$gnSureInfo[10]\n"; }
   
   # 板のURL取得
   # 【俺メモ】要改善：板一覧をいじった後にスレ取得しようとすると、現在の板が取得できないので
   #                  URLが取得できずエラーになる
   my $gnIIBuf = $main::gnGUIxml->get_widget('gnII');
   my ($gnMyTree, $gnMyTreePath, $gnMyTreeCol) = $gnIIBuf;

   # 選択している部分を取得(返り値はGtk2::TreeSelecton)
   my $gnTreeSel2 = $gnMyTree->get_selection;

   # 得られたTreeSelectionからTreeModelとTreeIterを得る
   my ($gnMyTreeModel2, $gnTM_iter2) = $gnTreeSel2->get_selected;

   # TreeIterを引数にしてget_valueすると、選択した行の配列が得られる
   my ($gnItaName, $gnItaUrl) = $gnMyTreeModel2->get_value($gnTM_iter2);
   
   # リクエストヘッダを生成
   my $gnItaDatURL = $gnItaUrl . "dat\/" . $linktgt_sure;
   my $gnItaDatFN = $main::logdir . "\/" . $gnSureInfo[10];
   if($main::gnDebugFlag) { print "gnSureUpdate:\t$gnItaDatURL\n"; }

   my $gnUpdateFLG = FALSE; # 既にあるファイルの更新なのか新規取得なのか
   my $gnDatSize = 0;
   
   my $gnDatLastModified = time2str(0);
   my $gnItaDatFN_1 = Encode::encode(&env_locale_to_encstr($ENV{'LANG'}), $gnItaDatFN);
   if (&gnCheckPath($gnItaDatFN)) {
      $gnUpdateFLG = TRUE;
      my @gnDatStat = stat($gnItaDatFN_1);
      $gnDatLastModified = time2str($gnDatStat[9]);
      $gnDatSize = $gnDatStat[7];
      $gnDatSize++;
   }
   if($main::gnDebugFlag) { print "gnSureUpdate:\t$gnDatLastModified\n"; }
   
   # datファイルを取得
   my ($gnGetDatRST, $gnGetDatRes) = &gnGetDat($gnItaUrl, $linktgt_sure);
   
   if ($gnGetDatRST eq "gn200OK") {
       my $gnNow = time();
       # 取得数を更新
       my $gnDatNumRow = 0;
       my $gnDatF2 = &gnOpenLocal($gnItaDatFN, "r");
       while(<$gnDatF2>) {
          $gnDatNumRow++;
       }
       &gnCloseLocal($gnItaDatFN);

       my $gnFolderIdxUpdateFLG = "";
       my $gnFolderIdxGetValFLG = "";
       $gnFolderIdxUpdateFLG = &gnFolderIdxUpdate($main::logdir . "\/" . $linktgt_ita . "/Folder.idx",
                                                        $linktgt_sure,
                                                        "3",
                                                        sprintf("%X", $gnDatNumRow)
                                                        );
       $gnFolderIdxUpdateFLG = &gnFolderIdxUpdate($main::logdir . "\/" . $linktgt_ita . "/Folder.idx",
                                                        $linktgt_sure,
                                                        "12",
                                                        sprintf("%X", $gnDatNumRow)
                                                        );
       # 取得日時が0なら更新
       $gnFolderIdxUpdateFLG = &gnFolderIdxUpdate($main::logdir . "\/" . $linktgt_ita . "/Folder.idx",
                                                           $linktgt_sure,
                                                           "5",
                                                           sprintf("%X",$gnNow+32400));  # quick-hack
       # 最終更新日を取得
       my $gnSureUpdateTime = str2time($gnGetDatRes->header('Last-Modified'));
       
       $gnFolderIdxUpdateFLG = &gnFolderIdxUpdate($main::logdir . "\/" . $linktgt_ita . "/Folder.idx",
                                                           $linktgt_sure,
                                                           "6",
                                                           sprintf("%X", $gnSureUpdateTime+32400)); # quick-hack

       if($main::gnDebugFlag) { print "gnSureUpdate:\tLast-Modified\: $gnSureUpdateTime"; }
       &gnLogger("Folder.idxを更新しました：" . $main::logdir . "\/" . $linktgt_ita . "/Folder.idx");
       if($main::gnDebugFlag) { print "gnSureUpdate:\tupdate aquired.\n"; }
       
       # スレ一覧をアップデート
       &gnSureIchiranSetVal($gnSureInfo[10], 1, $gnDatNumRow);
       &gnSureIchiranSetVal($gnSureInfo[10], 2, $gnDatNumRow);
       my ($ss, $mm, $hh, $DD, $MM, $YY, $WKD, $YD, $ID) = localtime($gnNow);
       $MM++; $YY += 1900;
       my $gnGetTime = sprintf("%04d/%02d/%02d %02d:%02d:%02d", $YY, $MM, $DD, $hh, $mm, $ss);
       &gnSureIchiranSetVal($gnSureInfo[10], 7, $gnGetTime);

       ($ss, $mm, $hh, $DD, $MM, $YY, $WKD, $YD, $ID) = localtime($gnSureUpdateTime);
       $MM++; $YY += 1900;
       my $gnLastUpdate = sprintf("%04d/%02d/%02d %02d:%02d:%02d", $YY, $MM, $DD, $hh, $mm, $ss);
       &gnSureIchiranSetVal($gnSureInfo[10], 9, $gnLastUpdate);
       &gnLogger("スレ一覧の情報を更新しました");
       if($main::gnDebugFlag) { print "gnSureUpdate:\tupdate sure-list.\n"; }
       
       # ソート順序を再現
       my ($gnSortCol, $gnSortOrder) = $gnMyTreeModel->get_sort_column_id;
       if ($gnSortOrder) {
          my $gnTrViewAfter = $main::gnGUIxml->get_widget('gnSI');
          my $gnTrViewA_Model = $gnTrViewAfter->get_model;
          $gnTrViewA_Model->set_sort_column_id($gnSortCol, $gnSortOrder);
       }
       if($main::gnDebugFlag) { print "gnSureUpdate:\tid=$gnSortCol, order=$gnSortOrder\n"; }
       
       # アップデート前のコピーを元にスレ一覧の並び替え状況を復元
       #
       $gnTrView->scroll_to_point(0, 0);
       my $gnNewPath = &gnSureSelectFromDat($gnSureInfo[10]);
       $gnTrView->set_cursor($gnNewPath);
       $gnTrView->scroll_to_cell($gnNewPath);

       # スレを再読み込み
       &gnSureSelect($gnTrView, TRUE);
       if($main::gnDebugFlag) { print "gnSureUpdate:\t\(force\)about to re-show.\n"; }
       
   }else{
       &gnLogger("datの取得に失敗しました\($gnItaDatURL\)");
       if($main::gnDebugFlag) { print "gnSureUpdate:\tsure update canceled.\n"; }
   }

   if($main::gnDebugFlag) { print "gnSureUpdate:\tEndSub\n"; }
}

sub gnSureSelectFromDat {
   # UTF-8 Compliant!
   # "xxxxx/xxxxx.dat"をキーにしてスレ一覧の該当行(Gtk2::TreePath)を返す
   #
   # 引数: 1: 文字列(xxxxxx/xxxxx.dat)
   # 返り値: Gtk2::TreePath
   my $gnDatStr = $_[0];
   my $gnRetPath;
   
   my $gnTrV = $main::gnGUIxml->get_widget('gnSI');
   my $gnTrVModel = $gnTrV->get_model;
   my $gnTrvModel_iter = $gnTrVModel->get_iter_first;
   my $gnTrVModelR;
   while ($gnTrvModel_iter) {
      $gnTrVModelR = $gnTrVModel->get($gnTrvModel_iter, 10);
      if ($gnTrVModelR eq $gnDatStr) {
         $gnRetPath = $gnTrVModel->get_path($gnTrvModel_iter);
         last;
      }
   $gnTrvModel_iter = $gnTrVModel->iter_next($gnTrvModel_iter);
   }
   
   return($gnRetPath);
}

sub gnSureIchiranSetVal {
   # UTF-8 Compliant!
   # スレ一覧の要素を書き換える関数
   #
   # 引数: 1: 文字列(xxxxxx/xxxxx.datの書式で記述。更新する行を指定)
   #       2: 整数(0スタート。更新する列を指定)
   #       3: 文字列(更新内容を指定(この関数内で型変換などは特にはしない))
   my $gnDatStr = $_[0];
   my $gnSelCol = $_[1];
   my $gnUpdtVar = $_[2];
   
   my $gnTrV = $main::gnGUIxml->get_widget('gnSI');
   my $gnTrVModel = $gnTrV->get_model;
   my $gnTrvModel_iter = $gnTrVModel->get_iter_first;
   my $gnTrVModelR;
   while ($gnTrvModel_iter) {
      $gnTrVModelR = $gnTrVModel->get($gnTrvModel_iter, 10);
      if ($gnTrVModelR eq $gnDatStr) {
         $gnTrVModel->set($gnTrvModel_iter,
                            $gnSelCol, $gnUpdtVar);
         last;
      }
   $gnTrvModel_iter = $gnTrVModel->iter_next($gnTrvModel_iter);
   }
   

}

sub gnSetTreeViewOrder {

}

sub gnGetDat {
   # (statするところを残して) UTF-8 Compliant!
   # datファイル名を指定してレスを取得するラッパー関数
   # 2ch, bbspinkに対応して、notfoundに対してURLを変えながらdatの取得を試みる
   #
   # 引数: 1: 板のURL(http://xxx.xxx.xxx/yyyy/)
   #       2: datファイル名(xxxxx.dat)
   # 返り値 1: 文字列(ステータスコード: "gn200OK"=正常完了, "gn404NOTFOUND"=dat存在せず, "gn999UNKNOWN"=不明のエラー)
   #        2: HTTP::Response構造体(返り値1が"gn200OK"の場合のみ含まれる。返り値1がそれ以外の場合はNULLとなる)
   my $gnDatURL = $_[0];
   my $gnDatFN = $_[1];
   my $gnGetDatRetVal1;
   my $gnGetDatRetVal2;
   if($main::gnDebugFlag) { print ("gnGetDat\:\ngnGetDat-Filename/:$gnDatFN"); }

   my @gnDatURLVal = split(/\//, $gnDatURL);
   my $gnDatURLValCnt = @gnDatURLVal;
   if($main::gnDebugFlag) { print ("$gnDatURL\n" . "$gnDatURLVal[$gnDatURLValCnt-1]\n"); }
   
   my $gnItaDatFN = $main::logdir .
                      $gnDatURLVal[$gnDatURLValCnt-1] . "\/" .
                      $gnDatFN;
   if($main::gnDebugFlag) { print "$main::logdir\n" . "$gnDatURL\n" . "$gnDatURLVal[$gnDatURLValCnt-1]\n" . "$gnItaDatFN\n"; }

   my $gnDatURLFLG = "else";
   my $gnDatURLFLG1;
   $gnDatURLFLG1 = index($gnDatURL, "2ch\.net");
   if ($gnDatURLFLG1>-1) { $gnDatURLFLG = "2ch"; }
   $gnDatURLFLG1 = index($gnDatURL, "bbspink\.com");
   if ($gnDatURLFLG1>-1) { $gnDatURLFLG = "bbspink"; }
   if($main::gnDebugFlag) { print "$gnDatURLFLG\n"; }
   
   my $gnReq = HTTP::Request->new;
   my $gnUA  = LWP::UserAgent->new;
   my $gnHed = HTTP::Headers->new;
   $gnUA->agent($main::gnUsrAgent);
   $gnUA->requests_redirectable([]); # 自動リダイレクト禁止
   if($main::gnEnvArg{'ReadProxy'}{'Proxy'} == 1) {
      my $gnUA_proxystr = "http\:\/\/" . $main::gnEnvArg{'ReadProxy'}{'Address'} . "\:" . $main::gnEnvArg{'ReadProxy'}{'Port'} . "\/";
      $gnUA->proxy('http', $gnUA_proxystr);
   }

   my $gnItaDatFN_1 = Encode::encode(&env_locale_to_encstr($ENV{'LANG'}), $gnItaDatFN);
   if (&gnCheckPath($gnItaDatFN)) {
         my @gnDatStat = stat($gnItaDatFN_1);
         my $gnDatLastModified = time2str($gnDatStat[9]);
         my $gnIfModSince = $gnDatLastModified;
         chop($gnIfModSince); chop($gnIfModSince); chop($gnIfModSince); chop($gnIfModSince);
         my $gnDatSize = $gnDatStat[7];
         
         # 更新用ヘッダの生成
         $gnHed->header ( 'Last-Modified' => $gnDatLastModified,
                            'Accept' => "text\/html, \*\/\*",
                            'If-Modified-Since' => $gnIfModSince . " \+0900",
                            'Cache-control' => "no-cache",
                            'Pragma' => "no-cache",
                            'Range' => "$gnDatSize-");
         $gnHed->remove_header('TE', 'Conection', 'Date');
   }else{
         my $gnDatLastModified = time2str(0);
         
         # 新規取得用ヘッダの生成
         $gnHed->header ( 'Last-Modified' => $gnDatLastModified,
                            'Accept' => "text\/html, \*\/\*",
                            'Accept-Encoding' => 'gzip',
                            'If-Modified-Since' => $gnDatLastModified);
   }
             
   my $gnUA_res;
   my $gnUA_rescode;
   my $gnDatURL1;
   
   if (($gnDatURLFLG eq "2ch") || ($gnDatURLFLG eq "bbspink")) {
            my $gnDatFN1;
            my $gnDatFN2;
                
            $gnDatURL1 = $gnDatURL . "dat\/" . $gnDatFN;
            $gnReq->url($gnDatURL1);
            $gnUA->default_headers($gnHed);
            $gnReq->method('GET');
            $gnUA_res = $gnUA->request($gnReq);
            if($main::gnDebugFlag) { print "First Try\!\!\($gnDatURL1\)\n"; }
            &gnLogger("アクセス結果\($gnDatURL1\)：" . $gnUA_res->code);
                
            if (!($gnUA_res->is_success)) {
                   $gnUA_rescode = substr($gnUA_res->code, 0, 1);
                   if ($gnUA_rescode == "5") {
                      # 500番台はテクニカルエラー
                      
                   } elsif (!($gnUA_res->code == "304")) {
                    my $gnDatFNLength = length($gnDatFN);
                    if ($gnDatFNLength == 13) {
                        $gnDatFN1 = substr($gnDatFN, 0, 3);
                        $gnDatURL1 = $gnDatURL . "kako\/" . "$gnDatFN1\/" . $gnDatFN . "\.gz";
                        $gnReq->url($gnDatURL1);
                        $gnReq->method('GET');
                        $gnUA_res = $gnUA->request($gnReq);
                        if ($main::gnDebugFlag) { print "Second Try\(1\)\!\!\($gnDatURL1\)\n"; }
                        &gnLogger("アクセス結果\($gnDatURL1\)：" . $gnUA_res->code);

                
                        if (!($gnUA_res->is_success)) {
                            $gnDatFN1 = substr($gnDatFN, 0, 3);
                            $gnDatURL1 = $gnDatURL . "kako\/" . "$gnDatFN1\/" . $gnDatFN;
                            $gnReq->url($gnDatURL1);
                            $gnReq->method('GET');
                            $gnUA_res = $gnUA->request($gnReq);
                            if($main::gnDebugFlag) { print "Second Try\(2\)\!\!\($gnDatURL1\)\n"; }
                            &gnLogger("アクセス結果\($gnDatURL1\)：" . $gnUA_res->code);
                        }
                    }else{

                    
                        $gnDatFN1 = substr($gnDatFN, 0, 4);
                        $gnDatFN2 = substr($gnDatFN, 0, 5);
                        $gnDatURL1 = $gnDatURL . "kako\/" . "$gnDatFN1\/" . "$gnDatFN2\/" . $gnDatFN . "\.gz";
                        $gnReq->url($gnDatURL1);
                        $gnReq->method('GET');
                        $gnUA_res = $gnUA->request($gnReq);
                        if($main::gnDebugFlag) { print "Third Try\(1\)\!\!\($gnDatURL1\)\n"; }
                        &gnLogger("アクセス結果\($gnDatURL1\)：" . $gnUA_res->code);


                        if (!($gnUA_res->is_success)) {
                            $gnDatFN1 = substr($gnDatFN, 0, 4);
                            $gnDatFN2 = substr($gnDatFN, 0, 5);
                            $gnDatURL1 = $gnDatURL . "kako\/" . "$gnDatFN1\/" . "$gnDatFN2\/" . $gnDatFN;
                            $gnReq->url($gnDatURL1);
                            $gnReq->method('GET');
                            $gnUA_res = $gnUA->request($gnReq);
                            if($main::gnDebugFlag) { print "Third Try\(2\)\!\!\($gnDatURL1\)\n"; }
                            &gnLogger("アクセス結果\($gnDatURL1\)：" . $gnUA_res->code);
                        }
                    }
                }
            }
   }else{
            # 今のところ2ch.netとbbspink.com以外のログ取得は
            # 対応していませんorz
            &gnLogger("2ch.netとbbspink.com以外のログ取得は対応していません");
   }
   
   if ($gnUA_res) {
      if($gnUA_res->is_success) {
        $gnGetDatRetVal1 = "gn200OK";
      }else{
        if ($gnUA_res->code == "304") {
           $gnGetDatRetVal1 = "gn302NOCHANGE";
        }elsif ($gnUA_rescode == "5") {
           $gnGetDatRetVal1 = "gn" . $gnUA_res->code . "SERVERERROR";
        }else{
           $gnGetDatRetVal1 = "gn404NOTFOUND";
        }
      }
   }else{
      $gnGetDatRetVal1 = "gn999NOFUNCTION";
   }
   #
   # ここから下の処理は将来的には別関数として処理
   #
   if($gnUA_res->is_success) {
       # datを取得したのでローカルに保存
       my $gnContEnc = $gnUA_res->header('Content-Encoding');
       if($main::gnDebugFlag) { print ("Content-Encoding\: $gnContEnc\n"); }
       
       
       
       my $gnContBuf = "";
       if ($gnContEnc) {
          if($gnContEnc eq "gzip") {
             $gnContBuf = Compress::Zlib::memGunzip($gnUA_res->content);
          }else{
          $gnContBuf = $gnUA_res->content;
          }
       }else{
          $gnContBuf = $gnUA_res->content;
       }
       my $gnResCode = $gnUA_res->code;
       if($gnResCode eq "200") { # 全体を正常取得
                     my $gnModTimeStr = $gnUA_res->header('Last-Modified');
                     my $gnModTime = str2time($gnModTimeStr);
                     
                     my $gnDatF = &gnOpenLocal($gnItaDatFN, "w");
                     print $gnDatF $gnContBuf;
                     &gnCloseLocal($gnItaDatFN);
                     
                     # 更新日時はサーバ側の最終更新と同じにする
                     utime($gnModTime, $gnModTime, $gnItaDatFN);
                     &gnLogger("スレ全体を取得しました");
       }elsif($gnResCode eq "206") { # 一部(更新された部分)を正常取得
                     my $gnModTimeStr = $gnUA_res->header('Last-Modified');
                     my $gnModTime = str2time($gnModTimeStr);
                     
                     my $gnDatF = &gnOpenLocal($gnItaDatFN, "w");
                     print $gnDatF $gnContBuf;
                     &gnCloseLocal($gnItaDatFN);
                     
                     # 更新日時はサーバ側の最終更新と同じにする
                     #my $gnModTime = str2time($gnModTimeStr);
                     &gnLogger("差分を取得しました");
       }else {
                     &gnLogger("対応していないリターンコードです\($gnResCode\)");
       }

       my $gnNow = time();

   }else{
       &gnLogger("datの取得に失敗しました");
       my $gnResCode = $gnUA_res->code;
       if($gnResCode eq "302") { # bbspinkだけ？notfond
                     &gnLogger("datファイルが存在しません\(code\:302\)");
       }elsif($gnResCode eq "304") { # 更新なし
                     &gnLogger("スレは更新されていません\(code\:304\)");
       }elsif($gnResCode eq "404") { # datがなかった
                     &gnLogger("datファイルが存在しません\(code\:404\)");
       }else {
                     &gnLogger("対応していないリターンコードです\(code\:$gnResCode\)");
       }
   }

   return($gnGetDatRetVal1, $gnUA_res);
}

sub gnFolderIdxGetVal {
   # Folder.idx内の項目を返す関数
   #
   # 引数: 1: 文字列(Folder.idxへのフルパス)
   #       2: 文字列(xxxxxx.dat で取得する行を指定)
   #       3: 整数(0スタート。取得する列)
   # 返り値: 文字列(エラーの場合はNULLを返す)
   my $gnFIdxFN = $_[0];
   my $gnFIdxDatName = $_[1];
   my $gnFIdxCol = $_[2];
   my $retval = "";

   if (&gnCheckPath($gnFIdxFN)) {
      my $gnFIdxFrom = &gnOpenLocal($gnFIdxFN, "r");
      while(<$gnFIdxFrom>) {
         my $buf = $_; chomp($buf);
         $buf = Encode::decode('cp932', $buf);
         
         my $isHit = index($buf, $gnFIdxDatName);
         if($isHit>0) {
            # 該当行
            my $separator = chr(001);
            my @colsbuf = split($separator, $buf);
            $retval = $colsbuf[$gnFIdxCol];
         }
      }
      &gnCloseLocal($gnFIdxFN);
            
      &gnLogger("Folder.idx\($gnFIdxFN\)の値：$retval");
      return("$retval");
      
   }else{
      &gnLogger("Folder.idxが存在しません：$gnFIdxFN");
      return("");
   }
}

sub gnFolderIdxUpdate {
   # UTF-8 Compliane!
   # Folder.idx内の項目を更新する関数
   #
   # 引数: 1: 文字列(Folder.idxへのフルパス)
   #       2: 文字列(xxxxxx.dat で更新する行を指定)
   #       3: 整数(0スタート。更新する列)
   #       4: 文字列(更新する内容)
   # 返り値: TRUE/FALSE(TRUE=成功。FALSE=失敗)
   my $gnFIdxFN = $_[0];
   my $gnFIdxDatName = $_[1];
   my $gnFIdxCol = $_[2];
   my $gnFIdxUpdateBuf = $_[3];
   
   if (&gnCheckPath($gnFIdxFN)) {
      my $gnFIdxTmpFN = $gnFIdxFN . &genRandStr("8");
      my $gnFIdxFrom = &gnOpenLocal($gnFIdxFN, "r");
      my $gnFIdxTo = &gnOpenLocal($gnFIdxTmpFN, "w");
      while(<$gnFIdxFrom>) {
         my $buf = $_; chomp($buf);
         $buf = Encode::decode('cp932', $buf);
         
         my $isHit = index($buf, $gnFIdxDatName);
         if($isHit<0) {
            # 該当行じゃない場合はそのままoutfileに書き出し
            my $outbuf = Encode::encode('cp932', $buf);
            print $gnFIdxTo "$outbuf\n";
         }else{
            # 該当行
            my $separator = chr(001);
            my @colsbuf = split($separator, $buf);
            $colsbuf[$gnFIdxCol] = $gnFIdxUpdateBuf;
            
            my $outbuf = "";
            my $cnt = 0;
            foreach(@colsbuf) {
               $outbuf = $outbuf . $colsbuf[$cnt] . chr(001);
               $cnt++;
            }
            
            $outbuf = Encode::encode('cp932', $outbuf);
            print $gnFIdxTo "$outbuf\n";

         }
      }
      &gnCloseLocal($gnFIdxTmpFN);
      &gnCloseLocal($gnFIdxFN);
      
      &gnFMove($gnFIdxTmpFN, $gnFIdxFN);
      
      if($main::gnDebugFlag) { print "Update Complete Folder.idx\: $gnFIdxFN\n"; }
      return(TRUE);
      
   }else{
      if($main::gnDebugFlag) { print "File miss\: $gnFIdxFN\n"; }
      return(FALSE);
   }
}

sub gnFolderIdxPush {
   # 指定したFolder.idxに指定したデータを追加する関数
   #
   # 引数: 1: 文字列(Folder.idxへのフルパス)
   #       2: arrayへのリファレンス(arrayにはFolder.idxの書式で入れるべきデータが1エントリ分入っている)
   # 返り値 : TRUE/FALSE(TRUE=成功、FALSE=失敗)
   my $idxfn = $_[0];
   my $varref = $_[1];
   my @var = @$varref;
   
   my $cnt = 0;
   if (&gnCheckPath($idxfn)) {
      my $gnFIP = &gnOpenLocal($idxfn, "r");
         while(<$gnFIP>) {
            $cnt++;
         }
      &gnCloseLocal($idxfn);
   }else{
      my $gnFIP = &gnOpenLocal($idxfn, "w");
         print $gnFIP "$main::gnIdxFileVersion\n";
      &gnCloseLocal($idxfn);
   }
   
   my $buf = sprintf("%X", $cnt);
   
   my $cnt2 = 0;
   foreach (@var) {
      $buf = $buf . chr(001) . $var[$cnt2];
      $cnt2++;
   }
   my $gnFIP = &gnOpenLocal($idxfn, "a");
      print $gnFIP "$buf\n";
   &gnCloseLocal($idxfn);
   
   return(TRUE);
}

sub gnMakeFolderIni {
   # UTF-8 Compliant!
   # Folder.iniを初期作成する関数
   #
   # 引数: 1: 文字列(Folder.iniへのフルパス。UTF-8フラグ付きを想定)
   # 返り値: なし
   my $gnFI_path = $_[0];
   
   my %gnMFI;
   $gnMFI{'Status'}{'RoundDate'} = &gnGetNowTime;
   $gnMFI{'Status'}{'LastModified'} = &gnGetNowTime;
   $gnMFI{'Status'}{'LastGetTime'} = &gnGetNowTime;
   $gnMFI{'Status'}{'UnRead'} = "0";
   $gnMFI{'Cookie'}{'SPID'} = "";
   $gnMFI{'Cookie'}{'PON'} = "";
   $gnMFI{'Kotehan'}{'Name'} = "";
   $gnMFI{'Kotehan'}{'Mail'} = "";
   $gnMFI{'BoardInformation'}{'SETTINGTXTTime'} = "1899\/12\/30";
   $gnMFI{'BoardInformation'}{'HEADTXTTime'} = "1899\/12\/30";
   $gnMFI{'BoardInformation'}{'IsSETTINGTXT'} = "0";
   $gnMFI{'BoardInformation'}{'IsHEADTXT'} = "0";
   $gnMFI{'BoardInformation'}{'TitlePictureURL'} = "";
   
   &gnSaveEnv($gnFI_path, \%gnMFI);

}

sub gnGetNowTime {
   # 現在の時刻を取得して文字列で返す関数(ログ記録用)
   # 引数: なし
   # 返り値: 文字列(YYYY/MM/DD HH:MM:SS)
   my ($ss, $mm, $hh, $DD, $MM, $YY, $WKD, $YD, $ID) = localtime(time);
   $MM++; $YY += 1900;
   my $retval = sprintf("%04d/%02d/%02d %02d:%02d:%02d", $YY, $MM, $DD, $hh, $mm, $ss);
   return($retval);
}

sub gnLoadNGList {
   # UTF-8 Compliant!
   # NG設定ファイルを読み出す関数
   #
   # 引数１：文字列(板の名前)
   # 引数２：文字列(スレの番号)
   # 返り値：ハッシュ配列へのリファレンス
   
   my $gnNGL_Ita = $_[0];
   my $gnNGL_Sure = $_[1];
   my $gnNGbuf = "";
   my %gnNGList = ();
   
   my $gnNGL_fn = &gnGetLogDir . $gnNGL_Ita . "\/" . $gnNGL_Sure . "\.NG";
   if($main::gnDebugFlag) { print "NGList Filename: $gnNGL_fn\n"; }
   if(&gnCheckPath($gnNGL_fn)) {
      my $gnNG = &gnOpenLocal($gnNGL_fn, "r");
         $gnNGbuf = join '', <$gnNG>;
      &gnCloseLocal($gnNGL_fn);
   }else{
      return(\%gnNGList);
   }
   
   $gnNGbuf =~ s/\r//g;
   $gnNGbuf = Encode::decode('cp932', $gnNGbuf);
   my @gnNGbufarray = split(/\n/, $gnNGbuf);
   
   foreach(@gnNGbufarray) {
      my $gnNGln = $_;
      my $gnNGnum = substr($gnNGln, 0, index($gnNGln, "-"));
      my $gnNGflg = substr($gnNGln, index($gnNGln, "-")+1, 1);
      $gnNGList{$gnNGnum} = "$gnNGflg";
   }
   
   return(\%gnNGList);
   
}

sub gnSaveNGList {
   # UTF-8 Compliant!
   # NG設定ファイルを書き込む関数
   #
   # 引数１：文字列(板の名前)
   # 引数２：文字列(スレの番号)
   # 引数３：ハッシュ配列へのリファレンス
   # 返り値: なし
   
   my $gnNGL_Ita = $_[0];
   my $gnNGL_Sure = $_[1];
   my $gnNGLref = $_[2];
   my %gnNGList = %$gnNGLref;
   my @gnNGListKeys = keys(%gnNGList);
   
   my $gnNGL_fn = &gnGetLogDir . $gnNGL_Ita . "\/" . $gnNGL_Sure . "\.NG";
   if($main::gnDebugFlag) { print "NGList Filename: $gnNGL_fn\n"; }

   my $gnNG = &gnOpenLocal($gnNGL_fn, "w");
   foreach(@gnNGListKeys) {
      my $gnNGnum = $_;
      my $str = $gnNGnum . "-" . $gnNGList{$gnNGnum} ."\n";
      $str = Encode::encode('cp932', $str);
      print $gnNG $str;
   }
   &gnCloseLocal($gnNGL_fn);
   
}

sub gnRemoveNGList {
   # UTF-8 Compliant!
   # NG設定ファイルを削除する関数
   #
   # 引数１：文字列(板の名前)
   # 引数２：文字列(スレの番号)
   # 返り値: なし
   
   my $gnNGL_Ita = $_[0];
   my $gnNGL_Sure = $_[1];
   
   my $gnNGL_fn = &gnGetLogDir . $gnNGL_Ita . "\/" . $gnNGL_Sure . "\.NG";
   if($main::gnDebugFlag) { print "NGList Filename: $gnNGL_fn\n"; }

   if(&gnCheckPath($gnNGL_fn)) {
       &gnUnlink($gnNGL_fn);
   }
}

sub gnLogger {
  # ログウィンドウに時刻をつけてログ表示する関数
  # 引数: 文字列(ログに表示する文字列)
  # 返り値: なし
  
  # 引数を取得
  my $gnLogStr = $_[0];
  
  # 現在の時刻を取得
  my $gnLogTime = &gnGetNowTime;
  
  # ログウィジェットを取得
  my $gnLogView = $main::gnGUIxml->get_widget('gnLogView');
  my $gnLV_buf = $gnLogView->get_buffer;
  my $gnLVB_iter = $gnLV_buf->get_end_iter;

  # ログ用文字列を生成
  $gnLogStr = $gnLogTime . " " . $gnLogStr . "\n";

  # ログを書き込み
  $gnLV_buf->insert($gnLVB_iter, $gnLogStr);

  # ログの末尾にスクロール
  my $gnLV_Sc = $main::gnGUIxml->get_widget('gnLogViewSW');
  my $gnLV_Sc_va = $gnLV_Sc->get_vadjustment;
  $gnLV_Sc_va->set_value($gnLV_Sc_va->upper);

}

sub gnParseSure {
   # UTF-8 Compliant!
   # ファイルから読み込まれたスレの内容を
   # 表示用に整形する。
   # 引数: 1: 文字列(スレのファイルパス)
   #       2: 文字列(スレのファイルパスから環境変数のパスを抜いたもの(ascii2d/xxxxxxxx.dat))
   # 返り値: 整形済みTextBuffer
   my $gnSureFN = $_[0];
   my $linktgt_base = $_[1];
   my ($linktgt_ita, $linktgt_sure) = split(/\//, $linktgt_base);
   my ($linktgt_sure2, $sute) = split(/\./, $linktgt_sure);

   my $gnTmpBuf;
   
   if (&gnCheckPath($gnSureFN)) {
      my $gnSR = &gnOpenLocal($gnSureFN, "r");
        $gnTmpBuf = join '', <$gnSR>;
     &gnCloseLocal($gnSureFN);
   }else{
      &gnLogger("【異常動作】スレの読み込みに失敗しました。ファイル名：$gnSureFN");
   }
   my @gnSureBuf = split(/\n/, $gnTmpBuf);
   
   # return用のTextBufferを作成。iterも作っておく
   my $rescnt = 1;
   my $gnSureTBuf = Gtk2::TextBuffer->new;
   &gnCreateTag($gnSureTBuf);
   my $gnSureTBuf_iter = $gnSureTBuf->get_start_iter;
   
   # NGリストを読み込み
   my $gnSureNGList_ref = &gnLoadNGList($linktgt_ita, $linktgt_sure2);
   my %gnSureNGList = %$gnSureNGList_ref;
   
   # 1レスづつ変換
   foreach(@gnSureBuf){
     # レス(1行)を読んで各要素に分割
     my $LineBuf = $_; chomp($LineBuf);
     # 内容をレンダリング
     &gnAppendRes($gnSureTBuf, $LineBuf, $linktgt_ita, $linktgt_sure2, $rescnt, \%gnSureNGList);
   
     # レス番カウンタをインクリメント
     $rescnt++;
   }
   
   return($gnSureTBuf);

}

sub gnResPopup {
   # UTF-8 Compliant!
   # レスポップアップ用関数
   # (レス内の">>1"にマウスを乗せた場合に出るポップアップウィンドウを表示する)
   # 引数: 文字列("<板フォルダ名>/<スレ番号>/<レス番号>")
   # 返り値: Gtk2::Window(実際に表示されているポップアップウィンドウ。
   #                      マウスが外れた際にはこれを使ってdestroyする)
   my $gnReplyTo = $_[0];
   
   # ポップアップウィンドウを取得する
   my $gnPopxml = Gtk2::GladeXML->new($main::gladefn, 'gnPopupText');
   $gnPopxml->signal_autoconnect_from_package('main');
   my $gnPopupWin = $gnPopxml->get_widget('gnPopupText');
   
   # TextViewウィジェットを取得する
   my $gnPT_Text = $gnPopxml->get_widget('gnPT_Text');
   my $gnPTT_buf = $gnPT_Text->get_buffer;
   my $gnPTTbuf_iter = $gnPTT_buf->get_end_iter;

   # フォントを指定する
   my $gnPT_Text_context = $gnPT_Text->get_pango_context();
   my $gnPT_Text_fontDesc = $gnPT_Text_context->get_font_description();
   my $gnPT_Text_fontscale = Gtk2::Pango->scale;
   if($main::gnEnvArg{'Browser'}{'gnBrowserFontUseCustom'} == TRUE) {
      $gnPT_Text_fontDesc->set_family($main::gnEnvArg{'Browser'}{'BrowserFontName'});
      $gnPT_Text_fontDesc->set_size($main::gnEnvArg{'Browser'}{'BrowserFontSize'} * $gnPT_Text_fontscale);
      if($main::gnEnvArg{'Browser'}{'BrowserFontBold'} != -1) {
         $gnPT_Text_fontDesc->set_weiget('bold');
      }
      if($main::gnEnvArg{'Browser'}{'BrowserFontItalic'} != -1) {
         $gnPT_Text_fontDesc->set_style('italic');
      }
      $gnPT_Text->modify_font($gnPT_Text_fontDesc);
   }

   # 該当レスを書き込み
   $gnPTT_buf = &gnGetResNo($gnReplyTo, $gnPTT_buf);
   

   # ポップアップウィンドウを表示
   $gnPT_Text->set_buffer($gnPTT_buf);
   $gnPopupWin->show_all;

   return($gnPopupWin);

}

sub gnImgPopup2 {
   # UTF-8 Compliant!
   # 画像プレビューポップアップ用関数(プログレッシブダウンロード対応版)
   # (レス内の画像と判断できるURLにマウスを乗せたときにポップアップウィンドウを表示する)
   #
   # 引数１: 文字列(画像へのURL)
   # 引数１: Gtk2::Window(呼び出し元のウィンドウ)
   # 返り値: 1:Gtk2::Window(実際には表示されているポップアップウィンドウ。
   #                        マウスが外れたときにはこれを使ってdestoryする)
   #         2: Gtk2::Image(画像の更新用)
   my $gnURLTo = $_[0];
   my $evwindow = $_[1];
   my $gnResizedBuf;
   my $gnResizedWidth;
   my $gnResizedHeight;

   my $gnPopxml = Gtk2::GladeXML->new($main::gladefn, 'gnPopupImg');
   $gnPopxml->signal_autoconnect_from_package('main');
   my $gnPopupWin = $gnPopxml->get_widget('gnPopupImg');
   my $gnPI_Image = $gnPopxml->get_widget('gnPI_Img');

   # キャッシュテーブルをチェック
   (my $gnImgCacheHitFLG, $main::gnTmpfn) = &gnImgCacheQuery($gnURLTo);
   my $gnPopupSize;
   if ($main::gnPopupImgSt == 1) {
      $gnPopupSize = $main::gnEnvArg{'Browser'}{'PreviewSize'} . "00";
   }else{
      $gnPopupSize = $main::gnEnvArg{'Browser'}{'PreviewSizeSt2'} . "00";
   }
   
   if ($gnImgCacheHitFLG == TRUE) {
      # キャッシュヒットしていたら
      if (&gnCheckPath($main::gnTmpfn)) {
         &gnLogger("キャッシュされたファイルを表示します");
         eval { $main::gnPopupImgBuf = Gtk2::Gdk::Pixbuf->new_from_file_at_scale($main::gnTmpfn,$gnPopupSize,
                                                                        $gnPopupSize,TRUE); };
         if ($@) {
            $gnPI_Image->set_from_stock('gtk-missing-image', 'GTK_ICON_SIZE_DIALOG');
            ($gnResizedWidth, $gnResizedHeight) = ($gnPopupSize, $gnPopupSize);
         }else{
            $gnPI_Image->set_from_pixbuf($main::gnPopupImgBuf);
            $gnResizedWidth = $main::gnPopupImgBuf->get_width;
            $gnResizedHeight = $main::gnPopupImgBuf->get_height;
         }
      }else{
         $gnPI_Image->set_from_stock('gtk-missing-image', 'GTK_ICON_SIZE_DIALOG');
         ($gnResizedWidth, $gnResizedHeight) = ($gnPopupSize, $gnPopupSize);
      }
   }else{
      # ヒットしていなかったら仮のウィンドウを生成
      $gnPI_Image->set_from_stock('gtk-refresh', 'GTK_ICON_SIZE_DIALOG');
      ($gnResizedWidth, $gnResizedHeight) = ($gnPopupSize, $gnPopupSize);
   }
         $gnPopupWin->set_size_request($gnResizedWidth, $gnResizedHeight);
   
   $gnPopupWin->show_all;
   
   
   my $gnScreenHeight = Gtk2::Gdk->screen_height;
   my $gnScreenWidth = Gtk2::Gdk->screen_width;
   my $dis = Gtk2::Gdk::Display->get_default;
   my ($scr, $x, $y, $mask) = $dis->get_pointer;
   my ($gnPopupWinX, $gnPopupWinY) = $gnPopupWin->get_position;
   if ($gnPopupWinX == 0) {
      $gnPopupWinX = $x - 50;
   }
   if ($gnPopupWinY == 0) {
      $gnPopupWinY = $y - 50;
   }

   # ポップアップウィンドウのoriginが
   # ポップアップ表示禁止領域内だったら表示領域外に移動
   if ($gnPopupWinX <= $main::gnEnvArg{'Browser'}{'AvoidBorderLeft'}) {
      $gnPopupWinX = $main::gnEnvArg{'Browser'}{'AvoidBorderLeft'} + 1;
   }
   if ($gnPopupWinY <= $main::gnEnvArg{'Browser'}{'AvoidBorderTop'}) {
      $gnPopupWinY += $main::gnEnvArg{'Browser'}{'AvoidBorderTop'} + 1;
   }
   
   # ポップアップ画面がウィンドウからはみ出している場合、
   # ポップアップ表示禁止領域内に入っていた場合は
   # 出現位置を調整
   if (($gnPopupWinX + $gnResizedWidth + $main::gnEnvArg{'Browser'}{'AvoidBorderRight'}) > $gnScreenWidth) { $gnPopupWinX = $gnScreenWidth - $gnResizedWidth - $main::gnEnvArg{'Browser'}{'AvoidBorderRight'}; }
   if (($gnPopupWinY + $gnResizedHeight + $main::gnEnvArg{'Browser'}{'AvoidBorderBottom'}) > $gnScreenHeight) { $gnPopupWinY = $gnScreenHeight - $gnResizedHeight - $main::gnEnvArg{'Browser'}{'AvoidBorderRight'}; }
   $gnPopupWin->move($gnPopupWinX, $gnPopupWinY);
   
   # キャッシュにヒットしていない場合は
   #   1. HTTPリクエストを別スレッドにして呼び出す
   #      別スレッドではURLからデータを取り込みキャッシュファイルに書き込んでいく
   if ($gnImgCacheHitFLG == FALSE) {
      &gnLogger("キャッシュにないので取得します");
      $main::hold = 1;
      $main::gnTmpfn = $main::gnEnvArg{'Cache'}{'gnCacheFolder'} . "/gnTmp" . &genRandStr(12);
      # 生成したキャッシュファイル名が既に存在していたらつけ直す
      while(&gnCheckPath($main::gnTmpfn)) {
         $main::gnTmpfn = $main::gnEnvArg{'Cache'}{'gnCacheFolder'} . "/gnTmp" . &genRandStr(12);
      }
      my @val = ("geturl", $gnURLTo, $main::gnTmpfn);
      my $uid;
      my $pass;
      if (!($main::gnEnvArg{'ReadProxy'}{'UserID'})) { $uid = "-1";}
      if (!($main::gnEnvArg{'ReadProxy'}{'Password'})) { $pass = "-1";}      
      $main::queue->enqueue("geturl", $gnURLTo, $main::gnTmpfn, $main::gnEnvArg{'ReadProxy'}{'Proxy'},
                        $main::gnEnvArg{'ReadProxy'}{'Address'}, $main::gnEnvArg{'ReadProxy'}{'Port'},
                        $uid, $pass);
      my $cachetime = time;
      $main::gnCacheTbl{'Cache'}{$gnURLTo} = $cachetime . chr(001) . $main::gnTmpfn;
      
      $main::gnImgPopup_info{'CacheFN'} = $main::gnTmpfn;
      $main::gnImgPopup_info{'CacheTime'} = $cachetime;
      my @gnPop_cachetimear = localtime($cachetime);
      $main::gnImgPopup_info{'Year'} = $gnPop_cachetimear[5]+1900;
      $main::gnImgPopup_info{'Month'} = sprintf("%02d", $gnPop_cachetimear[4]+1);
      $main::gnImgPopup_info{'Day'} = sprintf("%02d", $gnPop_cachetimear[3]);
      $main::gnImgPopup_info{'Hour'} = sprintf("%02d", $gnPop_cachetimear[2]);
      $main::gnImgPopup_info{'Minute'} = sprintf("%02d", $gnPop_cachetimear[1]);
      $main::gnImgPopup_info{'Second'} = sprintf("%02d", $gnPop_cachetimear[0]);

   }


   my @retval = ($gnPopupWin, $gnPI_Image);
   return(\@retval);
}

sub gnImgBufferUpdate {
   # (多分) UTF-8 Compliant!
   # ポップアップ用画像バッファを定期的にアップデートする
   #
   # 引数:   1: Gtk2::Window(更新対象のポップアップウィンドウ)
   #         2: Gtk2::Image(更新対象のImageオブジェクト)
   #         3: Gtk2::Label(更新対象のウィンドウに含まれるURL(隠しラベルオブジェクト))
   #         4: Gtk2::Label(更新対象のウィンドウに含まれるキャッシュファイルのファイル名(隠しラベルオブジェクト))
   # 返り値: 1:Gtk2::Window(実際には表示されているポップアップウィンドウ。
   #                        マウスが外れたときにはこれを使ってdestoryする)
   #         2: Gtk2::Image(画像の更新用)
   #         3: TRUE/FALSE(TRUE=画像はダウンロード中, FALSE=画像のダウンロードは終了している)

   my $gnPopupWin =$_[0];
   my $gnPI_Image = $_[1];
   my $gnResizedWidth = 0;
   my $gnResizedHeight = 0;
   my $pointx = -1;
   my $pointy = -1;
   
   if($main::gnDebugFlag) { print "gnImgBufferUpdate-gnpopupwin\:" . Dumper($gnPopupWin) . "\n"; }
   if($main::gnDebugFlag) { print "gnImgBufferUpdate-gnPI_Image\:" . Dumper($gnPI_Image) . "\n"; }
   my $gnTmpImgfn = $main::gnTmpfn;

   my ($gnPopupWinX, $gnPopupWinY) = $gnPopupWin->get_position;
   if($main::gnDebugFlag) { print "gnImgBufferUpdate-regeo\:\($gnPopupWinX, $gnPopupWinY, $gnResizedWidth, $gnResizedHeight\)\n"; }
   my $dis = Gtk2::Gdk::Display->get_default;
   my ($scr, $x, $y, $mask) = $dis->get_pointer;
   ($gnPopupWinX, $gnPopupWinY) = $gnPopupWin->get_position;
   if ($gnPopupWinX == 0) {
      $gnPopupWinX = $x - 50;
   }
   if ($gnPopupWinY == 0) {
      $gnPopupWinY = $y - 50;
   }
   if($main::gnDebugFlag) { print "gnImgBufferUpdate-regeo\:\($gnPopupWinX, $gnPopupWinY, $gnResizedWidth, $gnResizedHeight\)\n"; }
   
   my $gnPopupSize;
   if ($main::gnPopupImgSt == 1) {
      $gnPopupSize = $main::gnEnvArg{'Browser'}{'PreviewSize'} . "00";
   }else{
      $gnPopupSize = $main::gnEnvArg{'Browser'}{'PreviewSizeSt2'} . "00";
   }



   my $gnPopupImgBuf2;
   if ($gnTmpImgfn) {
      eval { $main::gnPopupImgBuf2 = Gtk2::Gdk::Pixbuf->new_from_file_at_scale($gnTmpImgfn,$gnPopupSize,
                                                                  $gnPopupSize,TRUE); };
      if ($@) {
         if ($main::gnImgGetSt) {
            $gnPI_Image->set_from_stock('gtk-refresh', 'GTK_ICON_SIZE_DIALOG');
         }else{
            $gnPI_Image->set_from_stock('gtk-missing-image', 'GTK_ICON_SIZE_DIALOG');
         }
         ($gnResizedWidth, $gnResizedHeight) = ($gnPopupSize, $gnPopupSize);
      }else{
         if($main::gnDebugFlag) { print "gnImgBufferUpdate-pixbuf\:" . Dumper($main::gnPopupImgBuf2) .
                                        "\n" . Dumper($gnPI_Image) . "\n"; }
         $gnPI_Image->set_from_pixbuf($main::gnPopupImgBuf2);
         $gnResizedWidth = $main::gnPopupImgBuf2->get_width;
         $gnResizedHeight = $main::gnPopupImgBuf2->get_height;
      }
   }else{
      if ($main::gnImgGetSt) {
         $gnPI_Image->set_from_stock('gtk-refresh', 'GTK_ICON_SIZE_DIALOG');
      }else{
         $gnPI_Image->set_from_stock('gtk-missing-image', 'GTK_ICON_SIZE_DIALOG');
      }
      ($gnResizedWidth, $gnResizedHeight) = ($gnPopupSize, $gnPopupSize);
   }
      $gnPopupWin->set_size_request($gnResizedWidth, $gnResizedHeight);
      $gnPopupWin->resize($gnResizedWidth, $gnResizedHeight);
      
      $dis = Gtk2::Gdk::Display->get_default;
      ($scr, $x, $y, $mask) = $dis->get_pointer;
      my ($wid, $hei) = $gnPopupWin->get_size;
      if (($x + int($wid/2)) >= Gtk2::Gdk->screen_width) { $gnPopupWinX = $x + int($wid/2); }
      if (($y + int($hei/2)) >= Gtk2::Gdk->screen_width) { $gnPopupWinY = $y + int($hei/2); }
      
      # ポップアップウィンドウのoriginが
      # ポップアップ表示禁止領域内だったら表示領域外に移動
      if ($gnPopupWinX <= $main::gnEnvArg{'Browser'}{'AvoidBorderLeft'}) {
         $gnPopupWinX = $main::gnEnvArg{'Browser'}{'AvoidBorderLeft'} + 1;
      }
      if ($gnPopupWinY <= $main::gnEnvArg{'Browser'}{'AvoidBorderTop'}) {
         $gnPopupWinY += $main::gnEnvArg{'Browser'}{'AvoidBorderTop'} + 1;
      }
   
      # ポップアップ画面がウィンドウからはみ出している場合は
      # 出現位置を調整
      
      if ($gnResizedWidth > 0) {
         my $gnScreenHeight = Gtk2::Gdk->screen_height;
         my $gnScreenWidth = Gtk2::Gdk->screen_width;
         if($main::gnDebugFlag) { print "gnImgBufferUpdate-regeo\:\($gnPopupWinX, $gnPopupWinY, $gnResizedWidth, $gnResizedHeight\)\n"; }
         if($main::gnDebugFlag) { print "gnImgBufferUpdate-regeo\:\($gnPopupWinX, $gnPopupWinY, $gnResizedWidth, $gnResizedHeight\)\n"; }

         if (($gnPopupWinX + $gnResizedWidth + $main::gnEnvArg{'Browser'}{'AvoidBorderRight'}) > $gnScreenWidth) { $gnPopupWinX = $gnScreenWidth - $gnResizedWidth - $main::gnEnvArg{'Browser'}{'AvoidBorderRight'}; }
         if (($gnPopupWinY + $gnResizedHeight + $main::gnEnvArg{'Browser'}{'AvoidBorderBottom'}) > $gnScreenHeight) { $gnPopupWinY = $gnScreenHeight - $gnResizedHeight - $main::gnEnvArg{'Browser'}{'AvoidBorderBottom'}; }
         $gnPopupWin->move($gnPopupWinX, $gnPopupWinY);
         if($main::gnDebugFlag) { print "gnImgBufferUpdate-regeo\:\($gnPopupWinX, $gnPopupWinY, $gnResizedWidth, $gnResizedHeight\)"; }

      }
   
   undef($main::gnPopupImgBuf2);
   
   my @retval = ($gnPopupWin, $gnPI_Image, $main::gnImgGetSt);
   return(\@retval);
}

sub gnGetResNo {
  # UTF-8 Compliant!
  # ポップアップウィンドウ用レス取得関数
  # ポップアップ内に表示するレスの内容を取得する
  # 引数１：文字列("<板フォルダ名>/<スレ番号>/<レス番号>")
  # 　　２：GtkTextBuffer(ポップアップウィンドウ内のTextViewにはめこむもの)
  # 返り値：GtkTextBuffer(引数２で受け取ったものにレスが入ったもの)
  
  my $gnResNoInfo = $_[0];
  if ($main::gnDebugFlag) { print "$gnResNoInfo\n"; }
  my $gnRNI_TextBuf = $_[1];

  my $gnRNI_return = "";
  my $gnRNI_from = 0;
  my $gnRNI_to = 0;
  
  my @gnRNI_info = split(/\//, $gnResNoInfo);
      # index: 0 = 板フォルダ名, 1 = スレ番号, 2 = レス番号
  if($gnRNI_info[2] =~ /-/) {
    ($gnRNI_from, $gnRNI_to) = split(/-/, $gnRNI_info[2]);
    if ($gnRNI_from > $gnRNI_to) {
       my $tmp = $gnRNI_from;
       $gnRNI_from = $gnRNI_to;
       $gnRNI_to = $tmp;
    }
  }else{
    $gnRNI_from = $gnRNI_info[2];
    $gnRNI_to = $gnRNI_info[2];
  }
  
  # NGリストを取得
  my %gnRNI_NGList = ();
  my $gnRNI_NGList_ref = &gnLoadNGList($gnRNI_info[0], $gnRNI_info[1]);
  if($gnRNI_NGList_ref) {
     %gnRNI_NGList = %$gnRNI_NGList_ref;
  }
  
  my $gnRNI_fn = $main::logdir . $gnRNI_info[0] . "\/" . $gnRNI_info[1] . ".dat";
  if ($main::gnDebugFlag) { print "Fileame: $gnRNI_fn\n"; }
  if (&gnCheckPath($gnRNI_fn)) {
     my $gnRNI = &gnOpenLocal($gnRNI_fn, "r");
     my $gnRNI_cnt = 1;
     while(<$gnRNI>) {
        my $gnRNI_RepBuf = $_;
        if(($gnRNI_cnt >= $gnRNI_from) & ($gnRNI_cnt <= $gnRNI_to)) {
           chomp($gnRNI_RepBuf);
           $gnRNI_TextBuf = &gnAppendRes($gnRNI_TextBuf, $gnRNI_RepBuf,
                                             $gnRNI_info[0], $gnRNI_info[1], $gnRNI_cnt, \%gnRNI_NGList);

           $gnRNI_return = "found";
        }
        $gnRNI_cnt++;
     }
     &gnCloseLocal($gnRNI_fn);
  }else{
     $gnRNI_return = "";
  }

  if($gnRNI_return eq "") {
     &gnLogger("該当の番号がありませんでした");
  }
  return($gnRNI_TextBuf);

}

sub gnGetResNoText {
  # レス取得関数
  # レスの内容文字列を取得する
  # 引数１：文字列("<板フォルダ名>/<スレ番号>/<レス番号>")
  # 引数２：文字列("full"=レス番号,名前,メールアドレス,投稿日時,ID,本文
  #                もしくは
  #                "num" = レス番号
  #                "name" = 名前
  #                "mail" = メールアドレス
  #                "date" = 投稿日時
  #                "id"   = ID
  #                "cont" = 本文
  #                num/name/mail/date/id/contは混在してもおk。
  #                例えば"numcont"とかしてもよい)
  # 返り値：文字列(レスの内容。UTF8フラグ付き)
  
  my $gnResNoInfo = $_[0];
  my $gnResType = $_[1];
  if ($main::gnDebugFlag) { print "$gnResNoInfo\n"; }

  my $gnRNI_return = "";
  my $gnRNI_from = 0;
  my $gnRNI_to = 0;
  my $gnRNI_Text = "";
  
  my @gnRNI_info = split(/\//, $gnResNoInfo);
      # index: 0 = 板フォルダ名, 1 = スレ番号, 2 = レス番号
  if($gnRNI_info[2] =~ /-/) {
    ($gnRNI_from, $gnRNI_to) = split(/-/, $gnRNI_info[2]);
    if ($gnRNI_from > $gnRNI_to) {
       my $tmp = $gnRNI_from;
       $gnRNI_from = $gnRNI_to;
       $gnRNI_to = $tmp;
    }
  }else{
    $gnRNI_from = $gnRNI_info[2];
    $gnRNI_to = $gnRNI_info[2];
  }
  my $gnRNI_fn = $main::logdir.$gnRNI_info[0]."\/".$gnRNI_info[1].".dat";
  
  if (&gnCheckPath($gnRNI_fn)) {
  my $gnRNI = &gnOpenLocal($gnRNI_fn, "r");
     my $gnRNI_cnt = 1;
     while(<$gnRNI>) {
        my $gnRNI_RepBuf = $_;
        $gnRNI_RepBuf = Encode::decode('cp932', $gnRNI_RepBuf);
        if(($gnRNI_cnt >= $gnRNI_from) & ($gnRNI_cnt <= $gnRNI_to)) {
           chomp($gnRNI_RepBuf);
           my @gnAR_RepBuf = split(/<>/, $gnRNI_RepBuf);
           # index: 0 = 投稿者名, 1 = メールアドレス, 2 = 投稿日時, 3 = 投稿内容, 4 = null, 5 = ID(投稿日時の部分文字列)
              $gnAR_RepBuf[5] = substr($gnAR_RepBuf[2], index($gnAR_RepBuf[2], "ID:")+3, 8);
              $gnAR_RepBuf[2] = substr($gnAR_RepBuf[2], 0, index($gnAR_RepBuf[2], "ID:"));
              $gnAR_RepBuf[3] =~ s/\<br\>/\n/g;             # brタグを削除
              $gnAR_RepBuf[3] =~ s/\<a(\s|\S)+?\>//g;           # aタグを削除
              $gnAR_RepBuf[3] =~ s/\<\/a\>//g;              # /aタグを削除
              $gnAR_RepBuf[3] = decode_entities($gnAR_RepBuf[3]);   # エンティティ文字を復元

           if($gnResType eq "full") {
              $gnRNI_Text  .= $gnRNI_cnt . "：" . $gnAR_RepBuf[0] . "[" . $gnAR_RepBuf[1] . "]：" . $gnAR_RepBuf[2] . "\n" . $gnAR_RepBuf[3] . "\n";
           }
           if($gnResType =~ /num/) {
               $gnRNI_Text .= $gnRNI_cnt;
           }
           if($gnResType =~ /name/) {
               if($gnResType =~ /num/) {
                  $gnRNI_Text .= "：" . $gnAR_RepBuf[0];
               }else{
                  $gnRNI_Text .= $gnAR_RepBuf[0];
               }
           }
           if($gnResType =~ /mail/) {
               if($gnResType =~ /name/) {
                  $gnRNI_Text .= "[" . $gnAR_RepBuf[1] . "]";
               }else{
                  $gnRNI_Text .= $gnAR_RepBuf[1];
               }
           }
           if($gnResType =~ /date/) {
               if($gnResType =~ /(num|name)/) {
                  $gnRNI_Text .= "：" . $gnAR_RepBuf[2];
               }else{
                  $gnRNI_Text .= $gnAR_RepBuf[2];
               }
           }
           if($gnResType =~ /id/) {
                  $gnRNI_Text .= $gnAR_RepBuf[5];
           }
           if($gnResType =~ /cont/) {
               $gnRNI_Text .= "\n" . $gnAR_RepBuf[3];
           }
           $gnRNI_Text .= "\n";

           $gnRNI_return = "found";
        }
        $gnRNI_cnt++;
     }
     &gnCloseLocal($gnRNI_fn);
  }else{
     $gnRNI_return = "";
  }

  if($gnRNI_return eq "") {
     &gnLogger("該当の番号がありませんでした");
  }
  return($gnRNI_Text);

}

sub gnCreateTag {
   # レス表示用にGtk2::TextTagを定義する
   # 引数: Gtk2::TextBuffer(レス表示用のTextBufer)
   # 返り値: なし
   
   # 引数を取得
   my $gnBuffer = shift;
   my $gnBuffer_tagtable = $gnBuffer->get_tag_table;
   
   if(!($gnBuffer_tagtable->lookup("gn-link"))) {
      $gnBuffer->create_tag("gn-link", foreground => "blue",
                                       underline => 'single');
   }
   if(!($gnBuffer_tagtable->lookup("gn-linkname"))) {
   $gnBuffer->create_tag("gn-linkname", foreground => "blue",
                                        underline => 'single',
                                        weight => PANGO_WEIGHT_BOLD);
   }
   if(!($gnBuffer_tagtable->lookup("gn-name"))) {
   $gnBuffer->create_tag("gn-name", foreground => "#05B705",
                                        weight => PANGO_WEIGHT_BOLD);
   }
   if(!($gnBuffer_tagtable->lookup("gn-mail"))) {
   $gnBuffer->create_tag("gn-mail", foreground => "blue",
                                        weight => PANGO_WEIGHT_BOLD);
   }
   if(!($gnBuffer_tagtable->lookup("gn-cont-normal"))) {
   $gnBuffer->create_tag("gn-cont-normal", left_margin => 25,
                                           pixels_above_lines => 2);
   }
   if(!($gnBuffer_tagtable->lookup("gn-cont-link"))) {
   $gnBuffer->create_tag("gn-cont-link", foreground => "blue",
                                         underline => 'single',
                                         left_margin => 25,
                                         pixels_above_lines => 2);
   }
   if(!($gnBuffer_tagtable->lookup("gn-find-hit"))) {
   $gnBuffer->create_tag("gn-find-hit", background => "yellow");
   }
    if(!($gnBuffer_tagtable->lookup("gn-abon-visible"))) {
   $gnBuffer->create_tag("gn-abon-visible", foreground=> "#007300",
                                         background => "#90EE90");
   }

}

sub gnCreateResLinkTag {
  # レス内のコメントリンク(例えばレスのコメントが「>>1乙」であった場合の">>1"へのリンク)を
  # 動的に生成する
  # 引数: 1: Gtk2::TextBuffer(タグ対象のTextBuffer)
  #       2: 文字列(リンク先(板名/スレID/コメント番号)
  # 返り値: Gtk2::TextTag
  
  # 引数を取得
  my $txtbuf = $_[0];
  my $restgt = $_[1];
  
  # TextTagを作成
  my ($gnResLinkCache_flg, $gnResLinkCache_tgt) = &gnImgCacheQuery($restgt);
  my $gnResLinkTag;
  if($gnResLinkCache_flg == TRUE) {
  $gnResLinkTag = $txtbuf->create_tag(undef,
                                       foreground => "$main::gnEnvArg{'Thread'}{'gnLinkColorAlreadyCached'}",
                                       underline => 'single',
                                       left_margin => 25,
                                       pixels_above_lines => 2);
  $gnResLinkTag->{page} = $restgt;
  }else{
  $gnResLinkTag = $txtbuf->create_tag(undef,
                                       foreground => "$main::gnEnvArg{'Thread'}{'gnLinkColorNotCached'}",
                                       underline => 'single',
                                       left_margin => 25,
                                       pixels_above_lines => 2);
  $gnResLinkTag->{page} = $restgt;
  }
  
  return($gnResLinkTag);
}

sub gnCreateNoLinkTag {
  # レス番号へポップアップメニュー用リンクを
  # 動的に生成する
  # 引数: 1: Gtk2::TextBuffer(タグ対象のTextBuffer)
  #       2: 文字列(リンク先(板名/スレID/コメント番号)
  # 返り値: Gtk2::TextTag
  
  # 引数を取得
  my $txtbuf = $_[0];
  my $restgt = $_[1];
  
  # TextTagを作成
  my $gnResLinkTag = $txtbuf->create_tag(undef,
                                         foreground => "blue",
                                         underline => 'single',
                                         pixels_above_lines => 2,
                                         left_margin => 0);
  $gnResLinkTag->{page} = $restgt;
  
  return($gnResLinkTag);
}

sub gnIsURL {
   # 文字列がURLかどうかを返す関数
   # http://www.din.or.jp/~ohzaki/perl.htm#httpURL を使用
   # ありがとうございます
   # 引数: 文字列
   # 返り値: 1: Boolean (URLを含む場合はTrue(1), 含まなければFalse(0))
   #         2: 文字列 (含まれるURL(http://が補完されている))
   #         3: 文字列 (hitした前の文字列)
   #         4: 文字列 (hitした文字列(ttp://...... で抽出している))
   #         5: 文字列 (hitした後の文字列)
   
   my $url = $_[0];
   my $isurl = FALSE;
   my $urltgt = '';
   my $strBefore = '';
   my $strHit = '';
   my $strAfter = '';

   my $http_URL_regex = q{ttp(?:[s])*://(?:(?:[-_.!~*'()a-zA-Z0-9;:&=+$,]|%[0-9A-Fa-f]} .       # 'gedit誤認識対策用コメント
                        q{[0-9A-Fa-f])*@)?(?:(?:[a-zA-Z0-9](?:[-a-zA-Z0-9]*[a-zA-Z0-9])?\.)} .
                        q{*[a-zA-Z](?:[-a-zA-Z0-9]*[a-zA-Z0-9])?\.?|[0-9]+\.[0-9]+\.[0-9]+\.} .
                        q{[0-9]+)(?::[0-9]*)?(?:/(?:[-_.!~*'()a-zA-Z0-9:@&=+$,]|%[0-9A-Fa-f]} .
                        q{[0-9A-Fa-f])*(?:;(?:[-_.!~*'()a-zA-Z0-9:@&=+$,]|%[0-9A-Fa-f][0-9A-} .
                        q{Fa-f])*)*(?:/(?:[-_.!~*'()a-zA-Z0-9:@&=+$,]|%[0-9A-Fa-f][0-9A-Fa-f} .
                        q{])*(?:;(?:[-_.!~*'()a-zA-Z0-9:@&=+$,]|%[0-9A-Fa-f][0-9A-Fa-f])*)*)} .
                        q{*)?(?:\?(?:[-_.!~*'()a-zA-Z0-9;/?:@&=+$,]|%[0-9A-Fa-f][0-9A-Fa-f])} .
                        q{*)?(?:#(?:[-_.!~*'()a-zA-Z0-9;/?:@&=+$,]|%[0-9A-Fa-f][0-9A-Fa-f])*} .
                        q{)?};
   my $pattern = $http_URL_regex;
   my $http_URL_regex2 = q{sssp(?:[s])*://(?:(?:[-_.!~*'()a-zA-Z0-9;:&=+$,]|%[0-9A-Fa-f]} .     # 'gedit誤認識対策用コメント
                        q{[0-9A-Fa-f])*@)?(?:(?:[a-zA-Z0-9](?:[-a-zA-Z0-9]*[a-zA-Z0-9])?\.)} .
                        q{*[a-zA-Z](?:[-a-zA-Z0-9]*[a-zA-Z0-9])?\.?|[0-9]+\.[0-9]+\.[0-9]+\.} .
                        q{[0-9]+)(?::[0-9]*)?(?:/(?:[-_.!~*'()a-zA-Z0-9:@&=+$,]|%[0-9A-Fa-f]} .
                        q{[0-9A-Fa-f])*(?:;(?:[-_.!~*'()a-zA-Z0-9:@&=+$,]|%[0-9A-Fa-f][0-9A-} .
                        q{Fa-f])*)*(?:/(?:[-_.!~*'()a-zA-Z0-9:@&=+$,]|%[0-9A-Fa-f][0-9A-Fa-f} .
                        q{])*(?:;(?:[-_.!~*'()a-zA-Z0-9:@&=+$,]|%[0-9A-Fa-f][0-9A-Fa-f])*)*)} .
                        q{*)?(?:\?(?:[-_.!~*'()a-zA-Z0-9;/?:@&=+$,]|%[0-9A-Fa-f][0-9A-Fa-f])} .
                        q{*)?(?:#(?:[-_.!~*'()a-zA-Z0-9;/?:@&=+$,]|%[0-9A-Fa-f][0-9A-Fa-f])*} .
                        q{)?};
   my $pattern2 = $http_URL_regex2;
   
   if($url =~ /$pattern/) {
      $url =~ /$pattern/;
      ($strBefore, $strHit, $strAfter) = ($`, $&, $'); # ` <--gedit誤認識対策用コメント
      $urltgt = "h" . $strHit;
      $isurl = TRUE;
   }elsif($url =~ /$pattern2/){
      $url =~ /$pattern2/;
      ($strBefore, $strHit, $strAfter) = ($`, $&, $'); # ` <--gedit誤認識対策用コメント
      $urltgt = "http" . substr($strHit, 4);
      $isurl = TRUE;
   }
   
   return(($isurl, $urltgt, $strBefore, $strHit, $strAfter));

}

sub gnGetlinktgt {
  # UTF-8 Compliant!
  # 2ch仕様変更吸収用関数
  # 参照先コメント番号を指すURLの違いによって抽出方法をわける
  # 古い方：../test/read.cgi?bbs=unix&key=985444963&st=3&to=3&nofirst=true
  # 新しい方：../test/read.cgi/unix/985444963/303
  # 引数：文字列(URLの中のread.cgiより後の部分。古い仕様の場合は"?bbs=unix&key=xxxxx"、
  #             新しい仕様の場合は"/unix/xxxxxx"という文字列が与えられている)
  # 返り値：文字列(板名/スレID/コメント番号)
  my $gnBufURL = $_[0];
  
  if (!($gnBufURL)) { return(""); }
  
  my $flg = substr($gnBufURL,0,1);
  if($flg eq "\?") {
     my ($bbs, $key, $st, $to, $nofirst) = split(/\&/, substr($gnBufURL,1));
     my ($bbs_k, $bbs_v) = split(/=/, $bbs);
     my ($key_k, $key_v) = split(/=/, $key);
     my ($st_k, $st_v) = split(/=/, $st);
     
     my $retval = $bbs_v . "\/" . $key_v . "\/" . $st_v;
     return($retval);
  }else{
     if ($gnBufURL) {
        my $retval = substr($gnBufURL, 1);
        return($retval);
     }else{
        return("");
     }
  }
} 

sub gnGetItaIchiran {
   # UTF-8 Flag Compliant!
   # 指定した場所から2ch板一覧を取得してローカルテーブルをアップデートする関数
   # 引数：なし
   # 返り値：Integer(-1=成功
   #                  0=失敗：ネットワークがタイムアウト
   #                  1=失敗：ローカルファイルに書き込み失敗)
   my $gnURLNo = $main::gnURLIni{'URL'}{'selected'};
   my $gnURLTo = $main::gnURLIni{'URL'}{$gnURLNo};
   if($main::gnDebugFlag) { print "$gnURLNo\n"; }
   if($main::gnDebugFlag) { print "$gnURLTo\n"; }
   
   my $gnUA = LWP::UserAgent->new;
   $gnUA->agent($main::gnUsrAgent);
   if($main::gnEnvArg{'ReadProxy'}{'Proxy'} == 1) {
      my $gnUA_proxystr = "http\:\/\/" . $main::gnEnvArg{'ReadProxy'}{'Address'} . "\:" . $main::gnEnvArg{'ReadProxy'}{'Port'} . "\/";
      $gnUA->proxy('http', $gnUA_proxystr);
   }

   my $gnUA_res = $gnUA->get($gnURLTo);
   if($main::gnDebugFlag) { print Dumper($gnUA_res->code) . "\n"; }
   
   if($gnUA_res->is_success) {
      # 板一覧を取得したので展開
      my $gnItaTmpBuf = $gnUA_res->content;
      
      my $gnTmpCatIdx = 0; # カテゴリ順をカウント
      my $gnTmpItaIdx = 0; # 板をカウント
      my $gnTmpPos = "";   # 現在位置("category" もしくは "ita")
      my $gnItaURL = "";   # 板のURL
      my $p = HTML::TokeParser->new(\$gnItaTmpBuf);
      
      my $gnFItaIdx = &gnOpenLocal($main::boardcfg, "w");
      
      if(!($gnFItaIdx)) {
         &gnLogger("板一覧保存用ファイル\($main::boardcfg\)のオープンに失敗しました。処理をキャンセルします");
         return(FALSE);
      }
      while (my $token = $p->get_token) {
         my $flg = $token->[0];
         my $tag = $token->[1];
            
            # bタグがあったらカテゴリカウントをインクリメント
            # 参照先：http://info.2ch.net/wiki/pukiwiki.php?monazilla%2Fdevelop%2Fboardlist
            if(($flg eq "S") && ($tag eq "b")) { $gnTmpCatIdx++;}

            # 1回目のbタグでカテゴリに入ったこととして、データを作り始める
            if ($gnTmpCatIdx > 0) {
            
               if(($flg eq "S") && ($tag eq "b")) { $gnTmpPos = "category"; $gnTmpItaIdx = 0; }
               if(($flg eq "E") && ($tag eq "b")) { $gnTmpPos = "other"; }
               if(($flg eq "S") && ($tag eq "a")) { $gnTmpPos = "ita";
                                                      $gnTmpItaIdx++;
                                                      $gnItaURL = $token->[2]->{'href'};}
               if(($flg eq "E") && ($tag eq "a")) { $gnTmpPos = "other"; }
               
               if($flg eq "T") {
                  my $gnPrintBuf = "";
                  if($gnTmpPos eq "category") {
                     $gnPrintBuf = $gnTmpCatIdx . "-0::" . $tag . "\n";
                  }
                  if($gnTmpPos eq "ita") {
                     $gnPrintBuf = $gnTmpCatIdx . "-" . $gnTmpItaIdx . "::" . $tag . "::" . $gnItaURL . "\n";
                  }
                  
                  $gnPrintBuf = Encode::decode('shiftjis', $gnPrintBuf);
                  $gnPrintBuf = Encode::encode('utf8', $gnPrintBuf);
                  print $gnFItaIdx $gnPrintBuf;
               }

               
            }
      }
      
      &gnCloseLocal($main::boardcfg);
      
      #板一覧を更新したらTreeViewウィジェットの内容をアップデートする
      my $gnItaStore = &gnMakeItaTreeStore($main::boardcfg);
      my $gnItaView = $main::gnGUIxml->get_widget('gnII');
      $gnItaView->set_model($gnItaStore);
      my $gnIS_pos = Gtk2::TreePath->new_from_indices(0);
      $gnItaView->expand_row($gnIS_pos, FALSE);

      &gnLogger("板一覧を更新しました");
      return(TRUE);
   }else{
      &gnLogger("板一覧取得失敗");
      return(FALSE);
   }
}

sub gnAppendRes {
   # UTF-8 Compliant!
   # dat1行分のコメント文字列を整形したTextBufferに変換し、与えられた
   # TextBufferの末尾に追加する
   # スレ表示、ポップアップ表示に使用
   # 引数１：Gtk2::TextBuffer (変更するTextBuffer)
   # 引数２：文字列 (追加するコメントのデータ。１行(１コメント)分。
   #                 ファイルから取得されたままの状態で、ShiftJIS+UTFフラグ無しであることを
   #                 想定する。つまりEncode::decodeはこの関数の内部で行う)
   # 引数３：文字列 (板名。板のディレクトリ名)
   # 引数４：文字列 (スレID.datの.datをとったもの)
   # 引数５：文字列 (レス番号)
   # 引数６：NGハッシュ配列へのリファレント
 
   my $gnAR_TextBuf = $_[0];
   my @gnAR_info = ($_[2], $_[3], $_[4]);
   my $gnAR_NGList_ref = $_[5];
      # iter を最後に
      my $gnAR_TextBuf_iter = $gnAR_TextBuf->get_end_iter;
      # TextTagが定義されていなかったら作成
      my $gnAR_TextBuf_tagtable = $gnAR_TextBuf->get_tag_table;
      if(!($gnAR_TextBuf_tagtable->lookup("gn_name"))) {
         &gnCreateTag($gnAR_TextBuf);
      }

   my $gnAR_RepBuf = Encode::decode('cp932', $_[1], Encode::FB_DEFAULT);
      $gnAR_RepBuf =~ s/\r//;

   my @gnAR_RepBuf = split(/<>/, $gnAR_RepBuf);
        # index: 0 = 投稿者名, 1 = メールアドレス, 2 = 投稿日時, 3 = 投稿内容, 4 = null
   my %gnAR_NGList = ();
   if($gnAR_NGList_ref) {
      %gnAR_NGList = %$gnAR_NGList_ref;
   }else{
      undef(%gnAR_NGList);
   }
   
   
   # ヘッダ(レス番、名前、日付、ID)を書く
   # レス番
   my $linktgt = "resno://" . $gnAR_info[0] . "/" . $gnAR_info[1] . "/" . $gnAR_info[2];
   if(!($gnAR_TextBuf_tagtable->lookup($linktgt))) {
   $gnAR_TextBuf->insert_with_tags($gnAR_TextBuf_iter, $gnAR_info[2], &gnCreateNoLinkTag($gnAR_TextBuf, $linktgt));
   }else{
   $gnAR_TextBuf->insert_with_tags($gnAR_TextBuf_iter, $gnAR_info[2], $gnAR_TextBuf_tagtable->lookup($linktgt));
   }

   # NGリストに該当のレス番号があったら内容は記載しない
   if(exists($gnAR_NGList{$gnAR_info[2]})) {
   if($gnAR_NGList{$gnAR_info[2]} eq "0") {
       # 透明あぼ〜んの場合
       $gnAR_TextBuf->insert($gnAR_TextBuf_iter, "\n\n");
       return($gnAR_TextBuf);
   }
   if($gnAR_NGList{$gnAR_info[2]} eq "1") {
       # あぼ〜んの場合
       my $str = "　　　　　このレスはあぼ〜ん設定により非表示になっています　　　　　\n\n";
       $gnAR_TextBuf->insert_with_tags_by_name($gnAR_TextBuf_iter, $str, "gn-abon-visible");
       return($gnAR_TextBuf);
   }
   }

   # 名前
   $gnAR_TextBuf->insert($gnAR_TextBuf_iter, " 名前：");
   if($gnAR_RepBuf[1] eq '') {
      $gnAR_TextBuf->insert_with_tags_by_name($gnAR_TextBuf_iter, $gnAR_RepBuf[0], "gn-name");
   }else{
      $gnAR_TextBuf->insert_with_tags_by_name($gnAR_TextBuf_iter, $gnAR_RepBuf[0], "gn-linkname");
      $gnAR_TextBuf->insert_with_tags_by_name($gnAR_TextBuf_iter, " [", "gn-mail");
      $gnAR_TextBuf->insert_with_tags_by_name($gnAR_TextBuf_iter, $gnAR_RepBuf[1], "gn-mail");
      $gnAR_TextBuf->insert_with_tags_by_name($gnAR_TextBuf_iter, "]", "gn-mail");
   }
   # 投稿日
   $gnAR_TextBuf->insert($gnAR_TextBuf_iter, "  投稿日：");
   $gnAR_TextBuf->insert($gnAR_TextBuf_iter, $gnAR_RepBuf[2]);
   $gnAR_TextBuf->insert($gnAR_TextBuf_iter, "\n");

   # 本文
   $gnAR_RepBuf[3] =~ s/&gt;/>/g;
   $gnAR_RepBuf[3] =~ s/&lt;/</g;

     # TokeParserの初期化
     my $p = HTML::TokeParser->new(\$gnAR_RepBuf[3]);

     # Token毎に処理を行う
     while(my $token = $p->get_token) {
       my $flg = $token->[0];
       my $tag = $token->[1];
       my $brflg = FALSE;
       if(($flg eq "S") && ($tag eq "a")) {
            # <a>のタグ内に入ったら$tinflgをTRUEにして、targetのURLを取り込む
            # タグ自体は出力しない
            my($buf1, $linktgt) =  split(/read\.cgi/, $token->[2]->{'href'});
            $linktgt = &gnGetlinktgt($linktgt); #read.cgiの仕様違いを吸収
            $linktgt = "replyto://" . $linktgt;
            if(!($gnAR_TextBuf_tagtable->lookup($linktgt))) {
               $gnAR_TextBuf->insert_with_tags($gnAR_TextBuf_iter, $p->get_text, &gnCreateResLinkTag($gnAR_TextBuf, $linktgt));
            }else{
               $gnAR_TextBuf->insert_with_tags($gnAR_TextBuf_iter, $p->get_text, $gnAR_TextBuf_tagtable->lookup($linktgt));
            }
       }elsif(($flg eq "E") && ($tag eq "a")) {
          # </a>は無視
       }elsif(($flg eq "S") && ($tag eq "br")) {
            # 改行
            $gnAR_TextBuf->insert_with_tags_by_name($gnAR_TextBuf_iter, "\n", "gn-cont-normal");
            $brflg = TRUE;
       }elsif(($flg eq "E") && ($tag ne "br") && ($tag ne "a")) {
          # </a>, </br>(実際には<br>)以外のタグはそのまま記述
          # (レスの中には<チラシの裏>....</チラシの裏>とかあるし)
          $gnAR_TextBuf->insert_with_tags_by_name($gnAR_TextBuf_iter, $token->[2], "gn-cont-normal");
       }elsif(($flg eq "S") && ($tag ne "a") && ($tag ne "br")) {
          # <a>以外のタグはそのまま記述
          # (レスの中には<チラシの裏>....</チラシの裏>とかあるし)
          $gnAR_TextBuf->insert_with_tags_by_name($gnAR_TextBuf_iter, $token->[4], "gn-cont-normal");
       }else {
          my $str = $token->[1];
          if($brflg == TRUE){
          $str = substr($str, 1); # 先頭の空白を削除
          $brflg = FALSE;
          }

          # URLを含むかどうかを判断する
          my ($urlflg, $linktgt, $strBefore, $strHit, $strAfter) = &gnIsURL($str);

          if($urlflg) {
             # URLが含まれていたらリンクタグを生成し、
             # タグ付書式で描画する
             
             if (index($linktgt, "read\.cgi") > -1) {
                $linktgt = "datl\:\/\/" . $linktgt;
             }
             
             # リンクの前は通常のタグで作成
             $gnAR_TextBuf->insert_with_tags_by_name($gnAR_TextBuf_iter, $strBefore, "gn-cont-normal");
             
             if(!($gnAR_TextBuf_tagtable->lookup($linktgt))) {
                # リンク対象のタグがなかったら作成する
                $gnAR_TextBuf->insert_with_tags($gnAR_TextBuf_iter, $strHit,
                                                     &gnCreateResLinkTag($gnAR_TextBuf, $linktgt));
             }else{
                # リンク対象のタグが既にあったら再利用する
                $gnAR_TextBuf->insert_with_tags($gnAR_TextBuf_iter, $strHit,
                                                    $gnAR_TextBuf_tagtable->lookup($linktgt));
             }
             
             # リンクの後ろは通常のタグで作成
             $gnAR_TextBuf->insert_with_tags_by_name($gnAR_TextBuf_iter, $strAfter, "gn-cont-normal");
          }else{
             # コメントのリンクを判断
             my $str2 = decode_entities($str);
             my $ptn_regex = q{(?:[＞]|[\>])(?:[1-9])+(?:[0-9])*(?:[0-9])*} .
                               q{(?:(?:[-])+} .
                               q{(?:[1-9])+(?:[0-9])*(?:[0-9])*(?:[0-9])*)*};
             if ($str2 =~ /$ptn_regex/) {
                # コメントへの参照(らしきもの)があったらリンクする
                $str2 =~ /$ptn_regex/;
                my ($strBefore, $strHit, $strAfter) = ($`, $&, $'); # ` <--gedit誤認識対策用コメント
                $gnAR_TextBuf->insert_with_tags_by_name($gnAR_TextBuf_iter, $strBefore, "gn-cont-normal");
                my $linktgt = "replyto://" . $gnAR_info[0] . "/" . $gnAR_info[1] . "/" . substr($strHit, 1);
                if(!($gnAR_TextBuf_tagtable->lookup($linktgt))) {
                  $gnAR_TextBuf->insert_with_tags($gnAR_TextBuf_iter, $strHit,
                                                       &gnCreateResLinkTag($gnAR_TextBuf, $linktgt));
                }else{
                  $gnAR_TextBuf->insert_with_tags($gnAR_TextBuf_iter, $p->strHit,
                                                       $gnAR_TextBuf_tagtable->lookup($linktgt));
                }
                $gnAR_TextBuf->insert_with_tags_by_name($gnAR_TextBuf_iter, $strAfter, "gn-cont-normal");
               
                
             }else{

             # URLもコメントへのリンクも含まれていなければ普通に描画
             $gnAR_TextBuf->insert_with_tags_by_name($gnAR_TextBuf_iter, $str2, "gn-cont-normal");
             }
          }
       }
     }
     
     # 最後にレス間に改行を入れる(いちおうギコナビのやりかたに合わせ)
     $gnAR_TextBuf->insert($gnAR_TextBuf_iter, "\n\n");
     
     return($gnAR_TextBuf);
     

}

sub gnImgCacheQuery {
   # UTF-8 Compliant!
   # 指定されたURLがキャッシュテーブル上にあるかどうか確認する関数
   #
   # 引数: 文字列(対象のURL)
   # 返り値: 1: TRUE/FALSE(TRUE=キャッシュヒット,FALSE=キャッシュにはない)
   #         2: 返り値1がTRUEだった場合、キャッシュファイルへのフルパス
   #                    FALSEだった場合、NULL
   if (!($main::gnEnvArg{'Cache'}{'Enable'})) {
      return(FALSE, "");
   }elsif ($main::gnEnvArg{'Cache'}{'Enable'} == FALSE) {
      return(FALSE, "");
   }
   
   my $gnQURL = $_[0];
   my $gnQResult;
   my $gnQFN;
   my $gnQTime;
   my $gnSeparator; $gnSeparator = chr(001);
   
   if ($main::gnCacheTbl{'Cache'}{$gnQURL}) {
      ($gnQTime, $gnQFN) = split(/$gnSeparator/, $main::gnCacheTbl{'Cache'}{$gnQURL});
   }
   if ($gnQTime) {
      $gnQTime += ($main::gnEnvArg{'Cache'}{'Expire'} * 86400);
      if ($gnQTime < time) {
         $main::gnCacheTbl{'Cache'}{$gnQURL} = "-1" . chr(001) . "";
         &gnUnlink($gnQFN);
         return(FALSE, "");
      }else{
         return(TRUE, $gnQFN);
      }
   }else{
      return(FALSE, "");
   }
   
}

sub gnClearAllCache {
   # 全てのキャッシュファイルを削除しテーブルをクリアする
   #
   # 引数: なし
   # 返り値: なし
   my @gnCT_entry = keys(%{$main::gnCacheTbl{'Cache'}});
   
   foreach my $val(@gnCT_entry) {
      my $gnSplitStr = chr(001);
      my ($gnCTTime, $gnCTFN) = split(/$gnSplitStr/, $main::gnCacheTbl{'Cache'}{$val});
      if ($gnCTTime > -1) {
         &gnUnlink($gnCTFN);
      }
   }
   
   %main::gnCacheTbl = "";
   $main::gnCacheTbl{'Cache'}{'init'} = "-1" . chr(001) . "";
}

sub gnClearExpiredCache {
   # 期限切れのキャッシュエントリをクリアする
   #
   # 引数: なし
   # 返り値: なし
   my @gnCT_entry = keys(%{$main::gnCacheTbl{'Cache'}});
   
   foreach my $val(@gnCT_entry) {
      my $gnSplitStr = chr(001);
      my ($gnCTTime, $gnCTFN) = split(/$gnSplitStr/, $main::gnCacheTbl{'Cache'}{$val});
      if ($gnCTTime < 0) {
         delete($main::gnCacheTbl{'Cache'}{$val});
      }
   }
}

sub gnCacheMove {
   # キャッシュフォルダの内容を新しいキャッシュフォルダへ移動する
   #
   # 引数1: 文字列(移動前キャッシュフォルダへのフルパス)
   # 引数2: 文字列(移動先キャッシュフォルダへのフルパス)
   # 返り値: boolean(0=success, 0より小さい=大きなエラー(ユーザの操作が必要と思われる), 0より大きい=部分的なエラー(続行可能))
   my $fromdir = $_[0];
   my $todir = $_[1];
   my $fatalcnt = 0;
   my $errcnt = 0;

   my @gnCT_entry = keys(%{$main::gnCacheTbl{'Cache'}});
   
   foreach my $val(@gnCT_entry) {
      my $gnSplitStr = chr(001);
      my ($gnCTTime, $gnCTFN) = split(/$gnSplitStr/, $main::gnCacheTbl{'Cache'}{$val});
      # キャッシュファイルの存在をチェック
      if (&gnCheckPath($gnCTFN)) {
         my $retval = &gnFnMove($gnCTFN, $todir);
         if ($retval == 1) {
            # ファイルの移動に成功したらキャッシュテーブルのエントリを更新
            my $fbasen = substr($gnCTFN, rindex($gnCTFN, "\/")+1);
            $main::gnCacheTbl{'Cache'}{$val} = $gnCTTime . chr(001) . $todir . "\/" . $fbasen;
            my $msgstr = "キャッシュファイルの移動に成功しました\: ファイル名\: " . $gnCTFN;
            &gnLogger($msgstr);
         }else{
            my $errmsg = $!; chomp($errmsg);
            $errmsg = Encode::decode(&env_locale_to_encstr($ENV{'LANG'}), $errmsg);
            my $msgstr = "キャッシュファイルの移動に失敗しました\: ファイル名\: " . $gnCTFN . " 理由\: " . $errmsg;
            &gnLogger($msgstr);
            $fatalcnt += 1;
         }
      }else{
         my $msgstr = "キャッシュファイルが存在しなかったのでエントリを削除しました\: ファイル名\: " . $gnCTFN;
         &gnLogger($msgstr);
         delete($main::gnCacheTbl{'Cache'}{$val});
         $errcnt += 1;
      }
   }
   
   if($fatalcnt >0) { return(-1); }
   if($errcnt >0) {return(1); }
   
   return(0);
   
}

#--------------------------------------
# カスタム関数(OS依存、文字エンコードなど)
#--------------------------------------

sub env_gtkstr_to_gtkstr {
    # gtk2-perlだけ(かつLinuxだけ?)の問題?
    # Gtk2ウィジェットから取った文字列をそのままGtk2ウィジェットにあたえると
    # 2バイト部分がなくなってしまう問題への対処
    # 引数=文字列(utf8エンコード、utf8フラグ付きを期待)
    my $mySrcStr = $_[0];
    my $myDstStr = '';
    my $encname = '';
    $encname = guess_encoding($mySrcStr, qw/ euc-jp shiftjis 7bit-jis utf-8 /);
    $mySrcStr = Encode::encode($encname, $mySrcStr);
    $myDstStr = Encode::decode($encname, $mySrcStr);
       
    return($myDstStr);

}

sub gnInfo {
   # 情報のポップアップを出す関数
   #
   # 引数１: 文字列(ポップアップに表示する文字)
   # 引数２: Gtk2::Window(親になるウィンドウ。省略するとメインウィンドウ)
   # 返り値: なし
   my $mes = $_[0];
   my $parentW = $_[1];
   if(!($parentW)) {
      $parentW = $main::gnGUIxml->get_widget('mW');
   }
   my $pop = Gtk2::MessageDialog->new($parentW,
                                        'GTK_DIALOG_MODAL',
                                        'GTK_MESSAGE_INFO',
                                        'GTK_BUTTONS_OK',
                                        $mes,
                                         ,
                                         'GTK_BUTTONS_OK' => 'gtk-ok');
   if ($pop->run eq 'ok') {
      $pop->destroy;
   }
}

sub gnWarn {
   # ワーニングのポップアップを出す関数
   #
   # 引数１: 文字列(ポップアップに表示する文字)
   # 引数２: Gtk2::Window(親になるウィンドウ。省略するとメインウィンドウ)
   # 返り値: なし
   my $mes = $_[0];
   my $parentW = $_[1];
   if(!($parentW)) {
      $parentW = $main::gnGUIxml->get_widget('mW');
   }
   my $pop = Gtk2::MessageDialog->new($parentW,
                                        'GTK_DIALOG_MODAL',
                                        'GTK_MESSAGE_ERROR',
                                        'GTK_BUTTONS_OK',
                                        $mes,
                                         ,
                                         'GTK_BUTTONS_OK' => 'gtk-ok');
   if ($pop->run eq 'ok') {
      $pop->destroy;
   }
}

sub gnYesNo {
   # 質問のポップアップを出す関数
   #
   # 引数１: 文字列(ポップアップに表示する文字)
   # 引数２: Gtk2::Window(親になるウィンドウ。省略するとメインウィンドウ)
   # 返り値: 文字列(yes/no)
   my $mes = $_[0];
   my $parentW = $_[1];
   if(!($parentW)) {
      $parentW = $main::gnGUIxml->get_widget('mW');
   }
   my $pop = Gtk2::MessageDialog->new($parentW,
                                        'GTK_DIALOG_MODAL',
                                        'GTK_MESSAGE_INFO',
                                        'GTK_BUTTONS_YES_NO',
                                        $mes,
                                        'GTK_BUTTONS_YES' => 'gtk-yes',
                                        'GTK_BUTTONS_NO' => 'gtk-no');
   if ($pop->run eq 'yes') {
      $pop->destroy;
      return("yes");
   }else{
      $pop->destroy;
      return("no");
   }
}

sub genRandStr {
#    # http://orfeus.knmi.nl/pub/outgoing/chad/perl/randstr.perl より取得
#    # ありがとうございます
#(2009.3.23やまね様用コメント) オリジナルコードに変更しました
    # 指定された文字数のランダム文字列を生成する
    # 引数: integer(文字数)
    # 返り値：string(ランダム文字列)
    my $size = $_[0];
    my $ret = "";

#    my @chars=("0".."9","a".."z","A".."Z");

    foreach (1..$size) {
 #        $ret .= $chars[rand($#chars)];
       my $int = 0;
       for(;;) {
           $int = int(rand(122));
           if((($int>47) && ($int<58)) || (($int>64) && ($int<91)) || (($int>96) && ($int<123))) { last; }
       }
       $ret = $ret . chr($int);
    }
    return $ret;
}


1;
