#!/usr/bin/perl
#
# gnview 2ch BBS Viewer installation script
#
#=======================================================

use utf8;
use strict;
use POSIX qw/ locale_h strftime /;
use Encode qw/ encode from_to decode /;
use Encode::Guess qw/ euc-jp shiftjis /;
use File::Copy;
use File::Path;
use Data::Dumper;


#=======================================================
my $gnDebugFlag : shared = 2;       # デバッグレベル指定(0 = まったく出力しない, 1-->大きくなるほど詳細な
                                    # デバッグ出力が行われる)
my $stepflg = 1;
my @gnReqLibs = ("Compress::Zlib",  "Config",       "Data::Dumper",     "Encode",
                   "Encode::Guess", "Fcntl", "File::Basename",  "File::Copy",       "File::Path",
                   "Glib",      "Gtk2",         "Gtk2::GladeXML",   "Gtk2::Pango",
                   "HTML::Entities",    "HTML::TokeParser", "HTTP::Cookies",    "HTTP::Date",
                   "LWP::MediaTypes",   "LWP::UserAgent",   "List::Util",       "POSIX",
                   "Storable",      "Thread::Queue",    "Time::HiRes",      "Time::Local",
                   "URI::file",     "threads",      "threads::shared",  "utf8", "Fcntl");
my $gnUserLang;
my $gnPerlpath;
our $gnGnname = "gnview";       # gnviewの名前
require(".\/${gnGnname}_lowlevel.pl");

for(;;) {
# Step 1 (日本語が出力可能であることをチェック)=======================
   if($stepflg == 1) {
      $gnUserLang = $ENV{'LANG'};
      $gnUserLang = &env_locale_to_encstr($gnUserLang);
      if($gnUserLang eq "ascii") {
         print "I\'m sorry, but this script says some japanese.\n" .
                "Please set your environment variables to some japanese value.\n";
         exit(1);
      }else{
         &gnprint("==================================\n" .
                    "gnviewをインストールします\(\<Ctrl\>\+Cで中断\)\n");
         $stepflg++;
      }
   }

# Step 2 (使用するperlのパスをチェック)=============================
   if($stepflg == 2) {
      &gnprint("==================================\ngnviewで使用するperlを指定します\n");
      
      my @pl = &gnWhich(); 
      my $b=0;
      foreach my $a (@pl) {
         chomp($a);
         &gnprint("\t\[$b\] $a\n");
         $b++;
      }
      &gnprint("使用するperlを選択するか、\nperlへのパスをフルパスで入力してください\: ");
      $gnPerlpath = <STDIN>; chomp($gnPerlpath);
      my $flg1 = substr($gnPerlpath,0,1);
      if($flg1 =~ /[0-9]/) {
         my $c = $pl[$flg1];
         my @d = `$c -v`;
         $c = $d[1]; chomp($c);
         &gnprint("$c\n");
         $gnPerlpath = $pl[$flg1]; chomp($gnPerlpath);
         $stepflg++;
      }elsif($flg1 eq "\/") {
         if(-e $gnPerlpath) {
            $stepflg++;
         }else{
         &gnprint("\n\[ERROR\]指定されたパスは存在しません\n\n");
         }
      }else{
         &gnprint("\n\[ERROR\]有効ではない選択肢です\n\n");
      }
   }
   
# Step 3 (Step2で選択したperlが必要条件を満たしているかをチェック)=========
   if($stepflg == 3) {
      my $cnt3_1 = 0;

      # ithreadsサポートのチェック
      my @gnPerlopts = `$gnPerlpath -V`;
      foreach my $line (@gnPerlopts) {
         chomp($line);
         if($line =~ /useithreads=define/) {
          $cnt3_1++;
         }
      }
      if($cnt3_1 == 0) {
         &gnprint("\[ERROR\]指定されたperlはithreadsをサポートしていません\n");
         &gnprint("\[ERROR\]gnviewの動作にはithreadsに対応したperlを用意する必要があります\n");
         $stepflg--;
      }else{
      
         # ライブラリのチェック
         my $str = 'echo "foreach \$a(@INC) {print \"\$a\\n\";}"';
         my @gnINCs = `$str|$gnPerlpath`;
         my $cnt3_3 = 0;
         foreach my $eachmodule (@gnReqLibs) {
            chomp($eachmodule);
            my ${cnt3_2} = 0;
            my $modpath;
            foreach my $inc1(@gnINCs) {
               chomp($inc1);
               $modpath = $eachmodule;
               $modpath =~ s/::/\//;
               $modpath = $inc1 . "\/" . $modpath . ".pm";
               if(-e $modpath) {
                  ${cnt3_2}++;
               }
            }
            if(${cnt3_2} == 0) {
               print "\tmodules\t$eachmodule\t\tNOT FOUND\n";
            }else{
               $cnt3_3++;
            }
         
         }
         my $nummods = @gnReqLibs;
         print "required-modules: $nummods,\tfound: $cnt3_3\n";
         if($nummods == $cnt3_3) {
            &gnprint("動作に必要なモジュールが揃っていることを確認しました。次のステップに進みます\n");
            $stepflg++;
         }else{
            &gnprint("\[ERROR\]動作に必要なモジュールが足りません。\n\[ERROR\]上記の出力を参照の上で必要なモジュールを追加してください\n");
            $stepflg--;
         }
      }
   }
# Step 4 (gnviewのインストールパスを指定)=========
   # インストール先の設定
   my $binpath      = &gnGetBinPath;
   my $sharepath    = &gnGetLibPath;
   my $manpath      = $sharepath . "man\/";
   
   # インストール対象ファイルの設定
   my @instfile_bin     = ("gnview");
   my @instfile_share   = ("gnview_firstrun.pl",    "gnview_env.pl",    "gnview_lowlevel.pl",   "1pix.png",
                            "1pix_glay.png",        "gnview.png",       "gnview.glade",         "gikoNavi.ini",
                            "url.ini",              "sent.ini");
   my @instfile_desktop = ("gnview.desktop");
   my @instfile_icon    = ("gnview.png");
   my @instfile_doc     = ("AUTHORS", "COPYING", "ChangeLog", "NEWS", "README", "TODO", "THANKS");
   my @instfile_man;
   if ($^O eq "solaris") {
      @instfile_man = ("gnview.1");
   }else{
      @instfile_man = ("gnview.1.gz");
   }
   
   if($stepflg == 4) {
         for(;;) {
            &gnprint("\n以下のようにgnviewをインストールします\n");
            &gnprint("インストールパスを確認してください\(インストールパスは変更可能です\)\n");

            &gnprint("実行ファイルパス\(${binpath}\)\:\n\t");
            #&gnprint("\tgnview \(実行プログラム\)\n");
            foreach my $fn(@instfile_bin) { print "$fn "; }
            &gnprint("\(実行プログラム\)\n");

            &gnprint("共有ライブラリパス\(${sharepath}gnview\/\)\:\n\t");
            #&gnprint("\tgnview_firstrun.pl gnview_env.pl gnview_lowlevel.pl\(実行プログラム\)\n");
            #&gnprint("\t1pix.png 1pix_glay.png gnview.png \(実行プログラムで参照する画像ファイル\)\n");
            #&gnprint("\tgnview.glade gikoNavi.ini url.ini sent.ini \(実行プログラムで参照する設定ファイル\)\n");
            foreach my $fn(@instfile_share) { print "$fn "; }
            &gnprint("\(実行プログラムから参照されるファイル\)\n");

            &gnprint("システム共有パス\(${sharepath}applications\/\)\:\n\t");
            #&gnprint("\tgnview.desktop \(GUIメニュー用設定ファイル\)\n");
            foreach my $fn(@instfile_desktop) { print "$fn "; }
            &gnprint("\(GUIメニュー用設定ファイル\)\n");

            &gnprint("システム共有パス\(${sharepath}pixmaps\/\)\:\n\t");
            #&gnprint("\tgnview.png \(GUIメニュー用画像ファイル\)\n");
            foreach my $fn(@instfile_icon) { print "$fn "; }
            &gnprint("\(アイコンファイル\)\n");

            &gnprint("ドキュメントパス\(${sharepath}doc/gnview\/\)\:\n\t");
            #&gnprint("\tAUTHORS  COPYING  ChangeLog  NEWS  README  TODO \(ドキュメントファイル\)\n");
            foreach my $fn(@instfile_doc) { print "$fn "; }
            &gnprint("\(ドキュメントファイル\)\n");
            
            &gnprint("マニュアルパス\(${manpath}man1\/\)\:\n\t");
            #&gnprint("\tgnview.1.gz \(マニュアルファイル\)\n");
            foreach my $fn(@instfile_man) { print "$fn "; }
            &gnprint("\(マニュアルファイル\)\n");

            &gnprint("\n以上の内容でインストールを行います。よろしいですか？\[yes\/NO\/beforestep\] ");
            my $yesno = <STDIN>; chomp($yesno);
            $yesno = substr($yesno,0,1);
            $yesno = lc($yesno);
            if($yesno eq "y") {
               $stepflg++;
               last;
            }elsif($yesno eq "b"){
               $stepflg -= 2;
               last;
            }else{
               &gnprint("実行ファイルパスを指定してください\[${binpath}\] ");
               my ${newbinpath} = <STDIN>; chomp(${newbinpath});
               if($newbinpath ne "") {
                  $binpath = $newbinpath;
               }
               my $aaa = substr($binpath,-1,1);
               if($aaa ne "\/") { $binpath = $binpath . "\/"; }
               &gnprint("共有ライブラリパスを指定してください\[${sharepath}\] ");
               my ${newsharepath} = <STDIN>; chomp(${newsharepath});
               if($newsharepath ne "") {
                  $sharepath = $newsharepath;
               }
               $aaa = substr($sharepath,-1,1);
               if($aaa ne "\/") { $sharepath = $sharepath . "\/"; }
               &gnprint("マニュアルパスを指定してください\[${manpath}\] ");
               my ${newmanpath} = <STDIN>; chomp(${newmanpath});
               if($newmanpath ne "") {
                  $manpath = $newmanpath;
               }
               $aaa = substr($manpath,-1,1);
               if($aaa ne "\/") { $manpath = $manpath . "\/"; }
            }

            
         }
   
   }

# Step 5 (gnviewファイルをコピー)===================================
   if($stepflg == 5) {

      # bin/gnview先頭行のperlパスを指定した物に変更
      my $cnt = 0;
      open(gnMOD, ">gnview.pl.modyfied");
      open(gnBIN, "gnview");
         while(<gnBIN>) {
            my $ln = $_; #chomp($ln);
            if($cnt == 0) {
               $ln =~ s/\/usr\/bin\/perl/$gnPerlpath/;
               print gnMOD $ln;
            }else{
               print gnMOD $ln;
            }
         }
      close(gnBIN);
      close(gnMOD);
      system("mv gnview.pl.modyfied gnview");

      my $uninstinfo = $ENV{'HOME'} . "\/.gnview.uninstinfo";
      open(gnUN, ">$uninstinfo");
      my $dir;
      my $dirret;
      #my @instfile;

      # 実行ファイルのインストール
      $dir = $binpath;
      $dirret = &gnMakeDir($dir, "0755");
      if($dirret == 0) {
         &gnprint("継続不可能なエラーが発生しました。インストールを中断します\n");
         exit(1);
      }
      &gnInstall(@instfile_bin, "0755", $dir);
      foreach my $fn(@instfile_bin) {
         chomp($fn);
         print gnUN "$dir$fn\n";
      }
      
      # 共有ファイルのインストール
      $dir = "${sharepath}gnview";
      $dirret = &gnMakeDir($dir, "0755");
      if($dirret == 0) {
         &gnprint("継続不可能なエラーが発生しました。インストールを中断します\n");
         exit(1);
      }
      #@instfile = ("gnview_firstrun.pl", "gnview_env.pl", "gnview_lowlevel.pl", "1pix.png",
      #             "1pix_glay.png",      "gnview.png",    "gnview.glade",       "gikoNavi.ini",
      #             "url.ini",            "sent.ini");
      &gnInstall(@instfile_share, "0644", $dir);
      foreach my $fn(@instfile_share) {
         chomp($fn);
         print gnUN "$dir$fn\n";
      }

      # デスクトップファイルのインストール
      $dir = "${sharepath}applications";
      $dirret = &gnMakeDir($dir, "0755");
      if($dirret == 0) {
         &gnprint("継続不可能なエラーが発生しました。インストールを中断します\n");
         exit(1);
      }
      #@instfile = ("gnview.desktop");
      &gnInstall(@instfile_desktop, "0644", $dir);
      print gnUN "${sharepath}applications\/gnview.desktop\n";
      foreach my $fn(@instfile_desktop) {
         chomp($fn);
         print gnUN "$dir$fn\n";
      }

      # アイコンファイルのインストール
      $dir = "${sharepath}pixmaps";
      $dirret = &gnMakeDir($dir, "0755");
      if($dirret == 0) {
         &gnprint("継続不可能なエラーが発生しました。インストールを中断します\n");
         exit(1);
      }
      #@instfile = ("gnview.png");
      &gnInstall(@instfile_icon, "0644", $dir);
      foreach my $fn(@instfile_icon) {
         chomp($fn);
         print gnUN "$dir$fn\n";
      }

      # ドキュメントファイルのインストール
      $dir = "${sharepath}doc\/gnview";
      $dirret = &gnMakeDir($dir, "0755");
      if($dirret == 0) {
         &gnprint("継続不可能なエラーが発生しました。インストールを中断します\n");
         exit(1);
      }
      #@instfile = ("AUTHORS", "COPYING", "ChangeLog", "NEWS", "README", "TODO");
      &gnInstall(@instfile_doc, "0644", $dir);
      foreach my $fn(@instfile_doc) {
         chomp($fn);
         print gnUN "$dir$fn\n";
      }

      # マニュアルファイルのインストール
      $dir = "${manpath}man1";
      $dirret = &gnMakeDir($dir, "0755");
      if($dirret == 0) {
         &gnprint("継続不可能なエラーが発生しました。インストールを中断します\n");
         exit(1);
      }
      #if ($^O eq "solaris") {
      #   @instfile = ("gnview.1");
      #}else{
      #   @instfile = ("gnview.1.gz");
      #}
      &gnInstall(@instfile_man, "0644", $dir);
      foreach my $fn(@instfile_man) {
         chomp($fn);
         print gnUN "$dir$fn\n";
      }
      
      close(gnUN);
      
      &gnprint("\nインストールが完了しました\n");
      
      $stepflg++;
   }


   if($stepflg > 5) {
      last;
   }
}
# 内部関数 ================================================

sub gnGetBinPath {
   # 実行ファイルパスをチェック
   #
   # 引数:      なし
   # 返り値: 1: 実行ファイルへのフルパス
   my $gnBinPath;
      if($ENV{'PATH'}) {
         my @dvars = split(/:/, $ENV{'PATH'});
         foreach my $dvar(@dvars) {
            chomp($dvar);
            $gnBinPath = $dvar;
            if(&gnCheckPath($gnBinPath)) {
               return($gnBinPath);
            }
         }
      }
      my @dvars = ('/usr/local/bin/', '/usr/bin/');
      foreach my $dvar(@dvars) {
         chomp($dvar);
         $gnBinPath = $dvar;
         if(&gnCheckPath($gnBinPath)) {
            return($gnBinPath);
         }
      }
      return($gnBinPath);
}

sub gnWhich {
   # 環境変数からperlバイナリの場所を特定する関数
   # 返り値=配列(ここの要素は文字列。perlへのフルパス)
   my @path;
   my @retpath;
   my $myperl = $^X;
   
   if(-e $myperl) {
      push(@retpath, $myperl);
   }
   @path = split(/:/, $ENV{'PATH'});
   foreach my $pt(@path) {
      if(-e "$pt\/perl") {
         push(@retpath, "$pt\/perl");
      }
   }
   return(@retpath);
   
}

sub gnInstall {
    # 引数1=配列(ここの要素は文字列。コピーするファイル名が入っていると想定)
    # 引数2=文字列(Permission。ファイルをコピーしたのちにこのパーミッションを割り当てる)
    # 引数3=文字列(path。コピー先のディレクトリ)
    my @mykeys = @_;
    my $destdir = pop(@mykeys);
    my $perm = pop(@mykeys);
    foreach my $fls(@mykeys) {
       copy($fls, $destdir);
       my $uname = $ENV{'LOGNAME'};
       my ($login, $pass, $uid, $gid) = getpwnam($uname);
       chown($uid, $gid, "${destdir}\/${fls}");
       chmod(oct($perm), "${destdir}\/${fls}");
       &gnprint("${fls}\t=\> ${destdir}\/${fls}\n");
    }    
}

sub gnprint {
    # ロケール名に合わせて文字コードを変換し標準出力に出力する
    # 引数=文字列
    my $gnPrintStr = $_[0];
    $gnPrintStr = Encode::encode($gnUserLang, $gnPrintStr);
    print $gnPrintStr;
}

# gnview.plとの一時的なダブり関数 ================================================

sub gnGetLibPath {
   # ライブラリパスをチェック
   #
   # 引数:      なし
   # 返り値: 1: ライブラリへのフルパス
   
   my $gnLibPath = "";
   if ($^O eq "MSWin32") {
      # "perl -V"の"osname"がMSWin32の場合は
      # 実行環境がWindowsであると判断
      $gnLibPath = &gnGetEnvVal('APPDATA');
      if(-d $gnLibPath) {
         if($gnDebugFlag) { print "Your gnview library is $gnLibPath\/gnview\/ from APPDATA environment valiables\n";}
         return($gnLibPath);
      }
   }else{
      # Windowsでない場合はFreedesktop.org Specification準拠に従って
      # ライブラリパスを探索する。
      # ヒットした時点でreturn。
      if(&gnGetEnvVal('XDG_DATA_DIRS')) {
         my @dvars = split(/:/, &gnGetEnvVal('XDG_DATA_DIRS'));
         foreach my $dvar(@dvars) {
            chomp($dvar);
            $gnLibPath = $dvar;
            if(-d $gnLibPath) {
               if($gnDebugFlag) { print "Your gnview library is $gnLibPath\/gnview\/ from XDG_DATA_DIRS environment valiables\n";}
               return($gnLibPath);
            }
         }
      }
      my @dvars = ('/usr/local/share/', '/usr/share/');
      foreach my $dvar(@dvars) {
         chomp($dvar);
         $gnLibPath = $dvar;
         if(-d $gnLibPath) {
            if($gnDebugFlag) { print "Your gnview library is $gnLibPath\/gnview\/ from fixed path\n";}
            return($gnLibPath);
         }
      }
   }
   
   if($gnLibPath eq "") {
      print STDERR "Fatal. gnview library path not found. check installation.\n";
   }else{
      if(-d $gnLibPath) {
         if($gnDebugFlag) { print "Your gnview library is $gnLibPath\/gnview\/....but where did you point from \?\n";}
         return($gnLibPath);
      }else{
         print STDERR "Fatal. gnview library path you choiced is not found $gnLibPath\/gnview\/.\n";
      }
   }
}


sub env_locale_to_encstr {
    # ロケール名からEncodeモジュールが解釈できる
    # 文字エンコード名を返す関数
    # 引数=文字列(ロケール名)
    
    # ロケール名を取得
    my $myLocVal = $_[0];

    # Windowsでは"Japanese_Japan"という文字列が使われているので
    # 一括変換しやすいように"ja_JPと置換"
    $myLocVal =~ s/Japanese_Japan/ja_JP/g;
    
    # "ja_JP.eucJP"の"ja_JP"部はいらないので切り取る
    my @myLocStr  = split(/\./, $myLocVal);

    # 後ろの"eucJP"の部分は小文字に置き換える
    # (実際にも大文字・小文字を区別しないよう推奨されている)
    if($myLocStr[1]) {
       $myLocStr[1] = lc($myLocStr[1]);
    }else{
        # SolarisでLocaleの２番目がなかったらeucに決めうち
       if($^O eq 'solaris') {
          push(@myLocStr, "eucjp");
        }
     }
    
    # あとはパターンマッチ
    if    ($myLocStr[1] eq "932")           { return('cp932');
    }elsif($myLocStr[1] eq "pck")           { return('cp932');
    }elsif($myLocStr[1] eq "sjis")          { return('shiftjis');
    }elsif($myLocStr[1] eq "20932")     { return('euc-jp');
    }elsif($myLocStr[1] eq "eucjp")     { return('euc-jp');
    }elsif($myLocStr[1] eq "euc-jp")        { return('euc-jp');
    }elsif($myLocStr[1] eq "euc")           { return('euc-jp');
    }elsif($myLocStr[1] eq "ujis")          { return('euc-jp');
    }elsif($myLocStr[1] eq "iso-2022-jp")   { return('iso-2022-jp');
    }elsif($myLocStr[1] eq "utf-8")     { return('utf8');
    }elsif($myLocStr[1] eq "utf8")          { return('utf8');
    }else                                       { return('ascii'); # エンコードが判別できなかったらシングルバイトエンコード(単なるバイト列)として解釈する
    }

    
}

sub gnGetEnvVal {
   # 環境変数を取得して、UTF-8フラグをつけて返す関数
   #
   # 引数：文字列(環境変数のキー)
   # 返り値：文字列(環境変数の値。Encode::decodeされた値。存在しなければundefが返る)
   my $key = $_[0];
   
   my $val = Encode::decode(&env_locale_to_encstr($ENV{'LANG'}), $ENV{$key});
   return($val);

}

