require 'rexml/document'
require 'time'

class Sports_data
  attr_accessor :doc, :extended_data, :distances, :interval_value

  def initialize()
    @doc = nil;
    @extended_data = {};
    @distances ={};
    @interval_value = 0.0;
  end

  def Sports_data.load(file) 
    sports_data = new
    io = open(file, "r")
    source = io.read()
    sports_data.doc = REXML::Document.new( source )
    ary =  sports_data.doc.elements['/sportsData/extendedDataList/extendedData'].text.split(",")
    time = sports_data.doc.elements['/sportsData/runSummary/time'].text
    time = time.sub(/T/, ' ')
    time = Time.parse(time)
    
    sports_data.interval_value =  sports_data.doc.elements['/sportsData/extendedDataList/extendedData'].attribute('intervalValue').value.to_f

    time = time.to_i
    ary.each{|i| 
      sports_data.distances[time] = [i]
      time = time + sports_data.interval_value
    }

    prev = 0.0
    prev2 = 0.0
    prev3 = 0.0
    sports_data.distances.keys.sort.each{ |k|
      dx = sports_data.distances[k][0].to_f - prev
      v = dx * 60.0 * 60.0 / sports_data.interval_value
      
      dx2 = sports_data.distances[k][0].to_f - prev2
      v2 = dx2 * 60.0 * 60.0 / (sports_data.interval_value * 2)

      dx3 = sports_data.distances[k][0].to_f - prev3
      v3 = dx3 * 60.0 * 60.0 / (sports_data.interval_value * 3)
      sports_data.distances[k].push(v)
      sports_data.distances[k].push(v2)
      sports_data.distances[k].push(v3)
      prev3, prev2, prev = prev2, prev, sports_data.distances[k][0].to_f
    }
    io.close
    sports_data
  end

  def save(file)
    io = open(file, "w")
    @doc.write(io)
    
    io.close
  end

  def get_speed(time)
    tmp = 0
    @distances.keys.sort.each{ |k|
      if ((k-time)*(k-time)) < @interval_value * @interval_value
        tmp = k
      end
    }
    if @distances[tmp]
        @distances[tmp][1]
    end
  end
end
