/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___GBGRAPH_H___
#define ___GBGRAPH_H___


#include	"xllisp.h"
#include	"unit.h"


#define IABS(x)	( (x)< 0 ? -(x) : (x) )
#define IMAX(x,y) ( (x) < (y) ? (y) : (x) )


typedef float REAL1;

typedef struct i_point {
	int	x;
	int	y;
} I_POINT;

typedef struct i_rect {
	I_POINT	tl;
	I_POINT	br;
} I_RECT;


typedef struct gb_point {
	REAL1	x;	/* unit = m */
	REAL1	y;
} GB_POINT;

typedef struct gb_point3d {
	REAL1	x;
	REAL1	y;
	REAL1	z;
} GB_POINT3D;

typedef struct gb_rect {
	GB_POINT	tl;
	GB_POINT	br;
} GB_RECT;

typedef struct affen2d {
	GB_POINT	org;
	REAL1		matrix[2][2];
} AFFEN2D;

typedef struct gb_color {
	REAL1		r;
	REAL1		g;
	REAL1		b;
	REAL1		t;
} GB_COLOR;

typedef struct gb_color_int {
	unsigned long	c;
	REAL1		t;
	REAL1		rev_t;
} GB_COLOR_INT;

typedef struct gb_palette {
	GB_COLOR_INT	line_color;
	GB_COLOR_INT	padding_color;
} GB_PALETTE;

typedef struct gb_time {
	REAL1		year;
	char		month;
	char		date;
	char		day;
	char		hour;
	char		min;
	char		sec;
} GB_TIME;

typedef REAL1 MATRIX2D[2][2];
typedef REAL1 MATRIX3D[3][3];

void rect2circle(GB_POINT * center,REAL1 * radius,GB_RECT * r);
GB_POINT caffen2d(AFFEN2D*,GB_POINT);
void conv_affen2d(AFFEN2D * res,AFFEN2D * a,AFFEN2D * b);
GB_POINT p_sub(GB_POINT,GB_POINT);
GB_POINT p_add(GB_POINT,GB_POINT);
void m_mul(REAL1 res[2][2],REAL1 m1[2][2],REAL1 m2[2][2]);
GB_POINT mp_mul(REAL1 m[2][2],GB_POINT p);
GB_POINT3D mp_mul3d(REAL1 m[3][3],GB_POINT3D p);
void m_mul3d(MATRIX3D,MATRIX3D,MATRIX3D);
int get_matrix(AFFEN2D * m,
	GB_POINT s1,GB_POINT d1,
	GB_POINT s2,GB_POINT d2,
	GB_POINT s3,GB_POINT d3);
XL_SEXP * gbpoint2list(GB_POINT);
GB_POINT list2gbpoint(COORDINATE_UNIT*,XL_SEXP *);
int get_minrect(COORDINATE_UNIT * cu,GB_RECT * r,XL_SEXP * s);
int get_gbpoint(COORDINATE_UNIT * cu,GB_POINT * p,XL_SEXP * s);
int inside_triangle(GB_POINT ptp[3],GB_POINT p);
REAL1 inner(GB_POINT,GB_POINT);
REAL1 distance(GB_POINT,GB_POINT);
int i_rect_type(XL_SEXP * );
I_RECT xl_to_i_rect(XL_SEXP * s);
int lod_distance(GB_RECT * tr,GB_POINT pt);
int lod_select(int dist,int lod,int core);
void
intersection_rect(GB_RECT * r,GB_RECT * r1,GB_RECT * r2);

int
list2vector(XL_SEXP ** ret,GB_POINT * p,XL_SEXP * v,XL_FILE * file,int line,
	    char * er_func);
int
list2matrix(XL_SEXP ** ret,REAL1 mret[2][2],XL_SEXP * m,
	    XL_FILE * file,int line,char * er_func);

GB_POINT p_avg(GB_POINT,GB_POINT);
REAL1 rect_resolution(GB_RECT * r,REAL1 dist,int num);
int w3c_dtf_to_gb_time(GB_TIME *,char *);
int cmp_gb_time(GB_TIME * ,GB_TIME * );
void gb_time_format(char * ret,GB_TIME * t);

int check_fnan(REAL1);

#endif
