/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include "xl.h"
#include "gbview.h"
#include "xlerror.h"
#include "win_flame.h"

XL_SEXP * xl_gv_flame_zoom();

void
init_gv_flame_zoom(XLISP_ENV * env)
{
	set_env(env, l_string(std_cm,"gv-flame-zoom"),
			get_func_prim(xl_gv_flame_zoom,FO_APPLICATIVE,0,2,2));
}

XL_SEXP *
xl_gv_flame_zoom(
		XLISP_ENV * e,
		XL_SEXP * s,
		XLISP_ENV * a,
		XL_SYM_FIELD * sf)
{
XL_SEXP * ratio;
GBVIEW_FLAME * gf;

	gf = get_gf_from_sf(sf);

	ratio = get_el(s,1);
	if ( get_type(ratio) != XLT_FLOAT )
		goto type_missmatch;
	if ( ratio->floating.data < 0 )
		goto param_error;

	return get_integer(wf_zoom(gf,0,ratio->floating.data),0);


type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"gv-flame-zoom"),
		List(n_get_string("type missmatch"),
			-1));
param_error:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_PROTO_INV_PARAM,
		l_string(std_cm,"gv-flame-zoom"),
		List(n_get_string("invalid ratio"),
			-1));
}
