/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include "xl.h"
#include "utils.h"
#include "gbview.h"
#include "xlerror.h"
#include "win_flame.h"

XL_SEXP * xl_gv_flame_status();

void
init_gv_flame_status(XLISP_ENV * env)
{
	set_env(env, l_string(std_cm,"gv-flame-status"),
			get_func_prim(xl_gv_flame_status,FO_APPLICATIVE,0,1,1));
}

XL_SEXP *
xl_gv_flame_status(
		XLISP_ENV * e,
		XL_SEXP * s,
		XLISP_ENV * a,
		XL_SYM_FIELD * sf)
{
XL_SEXP *ret;
GBVIEW_STATUS gs;
GBVIEW_FLAME * gf;

	gf = get_gf_from_sf(sf);

	wf_status(gf,&gs);
	ret = gvstatus2list(&gs);
	wf_free_status(&gs);
	return ret;
}
