/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"xl.h"

void
freev_header(XL_SEXP_HEADER * h)
{
}

void
free_header(XL_SEXP * s)
{
	freev_header(&s->h);
	mfree(s);
}

void
free_pair(XL_SEXP * s)
{
	freev_header(&s->h);
	mfree(s);
}

void
free_symbol(XL_SEXP * s)
{
	freev_header(&s->h);
	if ( s->symbol.data )
		mfree(s->symbol.data);
	mfree(s);
}

void
free_string(XL_SEXP * s)
{
	freev_header(&s->h);
	if ( s->string.data )
		mfree(s->string.data);
	mfree(s);
}

void
free_integer(XL_SEXP * s)
{
	freev_header(&s->h);
	if ( s->integer.unit )
		mfree(s->integer.unit);
	mfree(s);
}

void
free_float(XL_SEXP * s)
{
	freev_header(&s->h);
	if ( s->floating.unit )
		mfree(s->floating.unit);
	mfree(s);
}

void
free_func(XL_SEXP * s)
{
	freev_header(&s->h);
	mfree(s);
}

void
free_ptr(XL_SEXP * s)
{
	freev_header(&s->h);
	mfree(s);
}

void
free_raw(XL_SEXP * s)
{
	freev_header(&s->h);
	if ( s->raw.data )
		mfree(s->raw.data);
	mfree(s);
}

void
free_sexp(XL_SEXP * s)
{
	if ( s == 0 )
		return;
	switch ( s->h.type ) {
	case XLT_NULL:
	case XLT_ERROR:
		free_header(s);
		break;
	case XLT_PAIR:
		free_pair(s);
		break;
	case XLT_SYMBOL:
		free_symbol(s);
		break;
	case XLT_STRING:
		free_string(s);
		break;
	case XLT_INTEGER:
		free_integer(s);
		break;
	case XLT_FLOAT:
		free_float(s);
		break;
	case XLT_FUNC:
		free_func(s);
		break;
	case XLT_PTR:
		free_ptr(s);
		break;
	case XLT_RAW:
		free_raw(s);
		break;
	default:
		er_panic("free_sexp(1)");
	}
}