/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"memory_debug.h"
#include	"xlerror.h"
#include	"xl.h"
#include	"svg2gb.h"

void gc_gb_sexp();
XL_SEXP * xl_g();

void
init_g(XLISP_ENV * env)
{
	set_env(env,l_string(std_cm,"g"),
		get_func_prim(xl_g,FO_NORMAL,0,1,-1));
}

XL_SEXP *
xl_g(XLISP_ENV * env,XL_SEXP * s,
     XLISP_ENV * a,XL_SYM_FIELD * _sf)
{
XL_SEXP *ss=NULL;
XL_SEXP *sym=NULL;
XL_SEXP * ret;
XL_SYM_FIELD *sf=NULL;
int inv_arg;
SVG2GB_CONTEXT *ctx=NULL;
SVG_LAYER *new_layer=NULL;
SVG_STYLE *new_style=NULL;
SVG_TRANSFORM_INFO *new_transform=NULL;
L_CHAR *const_id;
L_CHAR *const_style;
L_CHAR *const_transform;



	const_id = l_string(std_cm, "id");
	const_style = l_string(std_cm, "style");
	const_transform = l_string(std_cm, "transform");

	ctx = svg2gb_get_context();
	ss = car(s);
	/* char *name = n_string(std_cm, ss->symbol.data); */
	for(sf = _sf; sf; sf=sf->next){
		if(l_strcmp(sf->name, const_id)==0){
			new_layer = svg_make_layer(sf->data);
		}
		else if(l_strcmp(sf->name, const_style)==0){
			new_style = svg_str2style(sf->data);
		}
		else if(l_strcmp(sf->name, const_transform)==0){
			new_transform = svg_str2transform(sf->data);
		}
	}
	if(new_layer == NULL){
		new_layer = svg_make_layer(l_string(std_cm,""));
	}
	new_layer->styles = new_style;
	new_layer->transform = new_transform;
	svg_add_child_layer(ctx->current_layer, new_layer);
	ctx->current_layer = new_layer;

	ret = 0;
	for(s=cdr(s); get_type(s) == XLT_PAIR; s = cdr(s)){
		ss = car(s);
		gc_push(0,0,"g");
		ret = eval(env, ss);
		gc_pop(ret,gc_gb_sexp);
		if ( get_type(ret) == XLT_ERROR )
			break;
	}
	
	ctx->current_layer = new_layer->parent;
	return ret;

typemissmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"g"),
		list(n_get_string("save:type missmatch"),
			get_integer(inv_arg,0),
			0));
}
