/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"acrp.h"
#include	"memory_debug.h"

void
free_mpt_entry_dir(ACRP_DIR * d)
{
	if ( d->map )
		d_f_ree(d->map);
	if ( d->crd )
		d_f_ree(d->crd);
	d->map = 0;
	d->crd = 0;
	d->hops = -1;
}

void
free_mpt_entry(ACRP_ENTRY * e)
{
int i;
	if ( e->pri )
		d_f_ree(e->pri);
	for ( i = 0 ; i < ACRP_DIR_NOS ; i ++)
		free_mpt_entry_dir(&e->dir[i]);
}


void
free_mpt(MAP_PATH_TABLE * m)
{
MAP_PATH_TABLE * m1;
 int i;
	for ( ; m ; ) {
		m1 = m->next;
		for ( i = 0 ; i < ACRP_SUBID_NOS ; i ++ )
			free_mpt_entry(&m->ent[i]);
		d_f_ree(m);
		m = m1;
	}
}


