//
// 
//	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
// 
//	This program is free software; you can redistribute it 
//	and/or modify it under the terms of the GLOBALBASE 
//	Library General Public License (G-LGPL) as published by 
//
//	http://www.globalbase.org/
// 
//	This program is distributed in the hope that it will be 
//	useful, but WITHOUT ANY WARRANTY; without even the 
//	implied warranty of MERCHANTABILITY or FITNESS FOR A 
//	PARTICULAR PURPOSE.
//
//

extern "C" {

#include	<stdlib.h>
#include	<errno.h>
#include	"memory_debug.h"
#include	"task.h"
#include	"lock_level.h"
#include	"LSimpleThread.h"
#include	"UThread.h"
#include	"save_global.h"

void* new_block();
void free_block(void * t);
void er_panic(char*);

#define SW_HASH_SIZE	1000


SEM sw_lock;
SW_HASH * hash[SW_HASH_SIZE];

void
sw_init()
{
	sw_lock = new_lock(LL_SLEEP_WAKEUP);
	for ( int i = 0;  i < SW_HASH_SIZE;  i++ ) {
		hash[i] = NULL;
	}

	SG_TITLE;
	sg("SEM",	"sw_lock",	&sw_lock);
	sg("SW_HASH*",	"hash",		&hash);
}

void
sleep_task(unsigned int key,SEM s)
{
unsigned int kk;
SW_HASH * h;
extern void _unlock_task_f(SEM,bool);
	lock_task(sw_lock);

	kk = key%SW_HASH_SIZE;
	h = (SW_HASH *)new_block();
	h->key = key;
	h->thread = (THREAD)LThread::GetCurrentThread();
	h->next = hash[kk];
	hash[kk] = h;
	if ( s )
		 _unlock_task_f(s,false);
	_unlock_task_f(sw_lock,false);
	try {
		h->thread->Suspend();
	} catch(...) {
		er_panic("Thread Suspend Failure");
	}
}


void
wakeup_task(unsigned int key)
{
unsigned int kk;
SW_HASH *h, *hp = NULL, *hn;
THREAD	thread;


	kk = key%SW_HASH_SIZE;
	lock_task(sw_lock);
	for ( h = hash[kk];  h;  h = hn ) {
		hn = h->next;
		if ( h->key == key ) {
			if (hp)
				hp->next = hn;
			else
				hash[kk] = hn;
			thread = h->thread;
			free_block(h);
			try {
				thread->Resume();
			} catch(...) {
				printf("\a\n\n\n\n thread:%s[tid:%x] state:%d\n\n\n",
					thread->mName, thread, thread->GetState());
				er_panic("Thread Resume Failure\n");
			}
		} else {
			hp = h;
		}
	}
	unlock_task(sw_lock,"wakeup_task");
} 

} //extern "C"