/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"xl2pdb_p.h"


extern PDB_POLYGON2D * pdb_p_list;

void
print_color(GB_COLOR * cl)
{
	printf("r%f:g%f:b%f:a%f",
		cl->r,cl->g,cl->b,cl->t);
}


void
print_point(PDB_PD_POINT * ptr)
{
	printf("\t\tPOINT (%f %f)\n",ptr->p.x,ptr->p.y);
	printf("\t\t\tno = %i\n",ptr->no);
	printf("\t\t\tlod = %i-%i\n",ptr->lod_min,ptr->lod_max);
}

void
print_polygon2d(PDB_POLYGON2D * p)
{
PDB_PD_POINT * ptr;
	printf("\tPOLYGON2D %s:%s\n",
		n_string(std_cm,p->name),
		n_string(std_cm,p->subname));
	printf("\t\tdepth = %i\n",p->depth);
	printf("\t\ttype = %i\n",p->type);
	printf("\t\tminrect = (%f %f) - (%f %f)\n",
		p->minrect.tl.x,
		p->minrect.tl.y,
		p->minrect.br.x,
		p->minrect.br.y);
	printf("\t\tlod max = %i min = %i\n",
		p->lod_max,
		p->lod_min);
	printf("\t\tpadding = ");
	print_color(&p->padding);
	printf("\n\t\tline = ");
	print_color(&p->line);
	printf("\n");
	print_sexp(s_stdout,p->info,0);
	for ( ptr = p->point ; ptr ; ptr = ptr->next )
		print_point(ptr);
}

void
print_polygon(PDB_POLYGON2D * p)
{
	for (  ; p ; p = p->next ) {
		print_polygon2d(p);
		printf("\n");
	}
}

void
print_tree(PDB_PT * pt,int ind)
{
int index;
	printf("TREE (%i)\n",ind);
	printf("\t(%f %f) - (%f %f)\n",
		pt->r.tl.x,
		pt->r.tl.y,
		pt->r.br.x,
		pt->r.br.y);
	printf("\tmin %i max %i\n",
		pt->lod_min,
		pt->lod_max);
	for ( index = 0 ; index < PTR_MAX ; index ++ ) {
		switch ( pt->next[index].type ) {
		case 0:
			continue;
		case PTT_POLYGON2D:
			printf("\tNODE %x type=POLYGON\n",
				index);
			print_polygon(pt->next[index].ptr.poly);
			break;
		case PTT_PT:
			printf("\tNODE %x type=PT\n",
				index);
			print_tree(pt->next[index].ptr.pt,ind+1);
			break;
		}
	}
}
