/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#ifndef ___CACHE_H___
#define ___CACHE_H___

#include	"pdb.h"
#include	"long_char.h"

typedef struct rcache_blk {
	L_CHAR *		path;
	int			lock;
	int			tid;
	int			err;
#define RE_IDLE		0
#define RE_RUN		1
#define RE_STOP		(-1)
#define RE_DESTROY	(-2)
} RCACHE_BLK;

void
set_rcache_dir_path(L_CHAR * main_path,L_CHAR * rcache_path);
int new_rcache_blk(RCACHE_BLK * b,char * name);
L_CHAR * get_rcache_file_name(char * name);
int rlock_rcache(RCACHE_BLK *);
int wlock_rcache(RCACHE_BLK *);
int unlock_rcache(RCACHE_BLK *);
void purge_rcache(L_CHAR * url);
void enable_rcache();
void disable_rcache();

void flush_rt_cache();

#endif






