/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___PDB_INNER_H___
#define ___PDB_INNER_H___

#include	"gbgraph.h"

#define NO_PITCH	0x100
#define DF_BUF	0x2000

typedef struct acc_header {
	unsigned int	fofs;
} ACC_HEADER;

typedef struct pn_header {
	unsigned short	type;
	unsigned short	size;
} PN_HEADER;

typedef struct acc_pn_header {
	ACC_HEADER	a;
	PN_HEADER	h;
} ACC_PN_HEADER;

#define PNT_TYPE_MASK		0x00ff
#define PNT_GROUP_MASK		0xff00
#define PNT_GET_GROUP(x)	(((x)&PNT_GROUP_MASK)>>8)

#define PNT_GROUP_MAX		3

#define PNT_POLYGON_GROUP	0x0000
#define PNT_FILE_HEADER		1
#define PNT_2D_DRAW_HEADER	2
#define PNT_LOD_LIST		3
#define PNT_TREE_NODE		4
#define PNT_POLYGON2D		5
#define PNT_POLY_POINT		6	
#define PNT_POLY_END		7
#define PNT_LNO_POLY_POINT	8
#define PNT_POLY_MAX		9

#define PNT_FAVT_GROUP		1
#define PNT_FAVT_ROOT		((PNT_FAVT_GROUP<<8)|1)
#define PNT_FAVT_NODE		((PNT_FAVT_GROUP<<8)|2)
#define PNT_FREELIST_HEADER	((PNT_FAVT_GROUP<<8)|3)
#define PNT_FREELIST_NODE	((PNT_FAVT_GROUP<<8)|4)
#define PNT_DTREE_DATA		((PNT_FAVT_GROUP<<8)|5)
#define PNT_FAVT_MAX		6

#define PNT_ASSOC_GROUP		2
#define PNT_ASSOC_HEADER	((PNT_ASSOC_GROUP<<8)|1)
#define PNT_ASSOC_DATA		((PNT_ASSOC_GROUP<<8)|2)

#define PNT_PMD_GROUP		3
#define PNT_PMD_HEADER		((PNT_PMD_GROUP<<8)|1)
#define PNT_PMD_NODE		((PNT_PMD_GROUP<<8)|2)
#define PNT_PMD_MD		((PNT_PMD_GROUP<<8)|3)
#define PNT_PMD_OFSLIST		((PNT_PMD_GROUP<<8)|4)

#define PNT_RT_CACHE_GROUP	4
#define PNT_RT_CACHE_HEADER	((PNT_RT_CACHE_GROUP<<8)|1)
#define PNT_RT_CACHE_DATA	((PNT_RT_CACHE_GROUP<<8)|2)
#define PNT_RT_CACHE_LIST	((PNT_RT_CACHE_GROUP<<8)|3)

#define PNT_RS_CACHE_GROUP	5
#define PNT_RS_CACHE_HEADER	((PNT_RT_CACHE_GROUP<<8)|1)
#define RNT_RS_RES_HEADER	((PNT_RT_CACHE_GROUP<<8)|2)
#define RNT_RS_STRING		((PNT_RT_CACHE_GROUP<<8)|3)


/*******************************/


typedef struct pn_file_header {
	PN_HEADER	h;
	int		type;	/* file type */
#define FT_2D_DRAW		1	/* draw file */
#define FT_2D_MAP		2	/* map file */
#define FT_2D_COORDINATE	3	/* coordinate system definition file */
#define FT_ADDRESS_LUMP		10	/* address lump system */
#define FT_RT_CACHE		11	/* routing cache */
	char		version[8];
#define VERSION		"0.4"
#define ENCODING_SIZE	8
	char		encoding[ENCODING_SIZE];
	unsigned int	linear;
	unsigned int	linear_length;
} PN_FILE_HEADER;
#define PN_FILE_HEADER_S	sizeof(PN_FILE_HEADER)

typedef struct pn_2d_draw_header {
	PN_HEADER	h;
	int		level;
	double		resolution;
#define UNIT_SIZE	16
	char		unit[UNIT_SIZE];
	unsigned int	fofs;	/* offset to root tree node */
	GB_RECT		minrect;
#define INFO_FILENAME_SIZE	32
	char		infofile[INFO_FILENAME_SIZE];
} PN_2D_DRAW_HEADER;
#define PN_2D_DRAW_HEADER_S	sizeof(PN_2D_DRAW_HEADER)

typedef struct pn_lod_list {
	PN_HEADER	h;
	int		max;
	unsigned int	fofs[1];
} PN_LOD_LIST;
#define PN_LOD_LIST_SIZE(max)	((int)(&((PN_LOD_LIST*)0)->fofs[max]))


#define PTR_MAX	16
typedef struct pn_tree_node {
	PN_HEADER	h;
	GB_RECT	r;
	unsigned char	lod_min;
	unsigned char	lod_max;
	short	fofs_size;
	union {
		int	fofs[PTR_MAX];
		struct {
			int	index;
			int	fofs;
		}	lst[PTR_MAX/2];
	} fo;
#define TLX_L	0x01		/* top left x value is large */
#define TLX_S	0x00		/* top left x value is small */
#define TLY_L	0x02
#define TLY_S	0x00
#define BRX_L	0x04
#define BRX_S	0x00
#define BRY_L	0x08
#define BRY_S	0x00
} PN_TREE_NODE;

#define PN_TREE_NODE_S(size) \
	( (size) >= PTR_MAX/2 ?					\
		((int)(&(((PN_TREE_NODE*)0)->fo.fofs[PTR_MAX]))):\
		((int)(&(((PN_TREE_NODE*)0)->fo.lst[size]))))

/*
	r.tl.x < tree_node.r.br.x &&
	r.br.x >= tree_node.r.tl.x &&
	r.tl.y >= tree_node.r.br.y &&
	r.br.y < tree_node.r.tl.y &&
	lod = tree_node.lod
	fofs[TLX_S|TLY_L|BRX_L|BRY_S|LOD_L]
*/

typedef struct pn_polygon2d {
	PN_HEADER	h;
	GB_COLOR	line_color;
	GB_COLOR	padding_color;
	unsigned int	code;
	short		type;
#define PNT_CLOSE	1
#define PNT_OPEN	2
	unsigned char	lod_min;
	unsigned char	lod_max;
	GB_RECT		minrect;
} PN_POLYGON2D;
#define PN_POLYGON2D_S	sizeof(PN_POLYGON2D)


typedef struct pn_poly_point {
	PN_HEADER	h;
	short		no;

#define PP_FLAGS	0x8000
#define PP_NO		0x7fff
#define PP_MOVE		0x8000

	unsigned char	lod_min;
	unsigned char	lod_max;
	GB_POINT	p;
} PN_POLY_POINT;
#define PN_POLY_POINT_S		sizeof(PN_POLY_POINT)


typedef struct pn_lno_poly_point {
	PN_HEADER	h;
	int		no;
#define PP_LFLAGS	0x80000000
#define PP_LNO		0x7fffffff
#define PP_LMOVE	0x80000000
#define PP_TO_L(x)	(((x)&PP_NO)|((((int)(x))&PP_FLAGS)<<16))
	unsigned char	lod_min;
	unsigned char	lod_max;
	GB_POINT	p;
} PN_LNO_POLY_POINT;
#define PN_LNO_POLY_POINT_S		sizeof(PN_LNO_POLY_POINT)

typedef struct pn_poly_end {
	PN_HEADER	h;
} PN_POLY_END;
#define PN_POLY_END_S		sizeof(PN_POLY_END)


/*******************************/
/*
	FILE AVT 
*/
/*******************************/

typedef struct pn_favt_root {
	PN_HEADER	h;
	int		type;
#define FAST_DTREE	0x00000001
#define FAST_OTHER_TREE	0x00000000
#define FAST_DTREE_ROOT	0x00000001

#define FAT_DTREE_NODE	2

	unsigned int	node;
} PN_FAVT_ROOT;

#define PN_FAVT_ROOT_S		sizeof(PN_FAVT_ROOT)

typedef struct pn_favt_node {
	PN_HEADER	h;
	unsigned int	small;
	unsigned int	large;
	int		level;
	/* user data is followed */
} PN_FAVT_NODE;

#define PN_FVAT_NODE_S		sizeof(PN_FAVT_NODE)

typedef struct pn_freelist {
	PN_HEADER	h;
	unsigned int	next;
} PN_FREELIST;


typedef struct pn_dtree_data {
	PN_HEADER	h;
	unsigned int	data[1];
	/* two or more data are allowed */
} PN_DTREE_DATA;

#define PN_DTREE_DATA_S(x)	((int)(&((PN_DTREE_DATA*)0)->data[x]))

/*******************************/
/*
	FAVT fundamental data structure
*/
/*******************************/


typedef struct floating_index {
	unsigned int		fofs;
	REAL1			d;
} FLOATING_INDEX;

typedef struct gb_time_index {
	unsigned int		fofs;
	GB_TIME			d;
} GB_TIME_INDEX;

typedef struct string_index {
	unsigned int		fofs;
	L_CHAR			d[1];
} STRING_INDEX;

#define STRING_IX_LENGTH(x,y)	((int)&(((STRING_INDEX*)0)->d[(x)+(y)+2]))
#define STRING_IX_LENGTH_1(x)	((int)&(((STRING_INDEX*)0)->d[(x)+1]))

typedef struct timeout_index {
	unsigned int		fofs;
	unsigned int		timeout;
} TIMEOUT_INDEX;


void favt_string_endian(STRING_INDEX * ix,int len);
void favt_gb_time_endian(GB_TIME_INDEX * ix,int len);
void favt_floating_endian(FLOATING_INDEX * ix,int len);
void favt_timeout_endian(TIMEOUT_INDEX * ix,int len);

int favt_cmp_string_1(STRING_INDEX *,STRING_INDEX *);
int favt_cmp_string_2(STRING_INDEX *,STRING_INDEX *);

/*******************************/
/*
	Associate Memory
*/
/*******************************/

typedef struct assoc_index {
	unsigned int	fofs;
	short		type;
#define AIT_INTEGER	1
#define AIT_STRING	2
	short		name;
} ASSOC_INDEX;

typedef struct pn_assoc_header {
	PN_HEADER	h;
	ASSOC_INDEX	ix[1];
} PN_ASSOC_HEADER;

#define PN_ASSOC_HEADER_S(x)	((int)(&(((PN_ASSOC_HEADER*)0)->ix[x])))

typedef struct pn_assoc_data {
	PN_HEADER	h;
	char		data[1];
} PN_ASSOC_DATA;

#define PN_ASSOC_DATA_S(x)	((int)(&(((PN_ASSOC_DATA*)0)->data[x])))

/*******************************/
/*
	PMD : Plate Metadata Lump
*/
/*******************************/

#define FAT_PMD_FLOATING	0x100
#define FAT_PMD_GB_TIME		0x102
#define FAT_PMD_STRING		0x104
#define FAT_PMD_TIMEOUT		0x106

typedef struct pn_pmd_header {
	PN_HEADER	h;
	char		version[8];
#define PMD_VERSION	"0.2"

#define PMD_UNIT_LEN	200
	L_CHAR		unit_path[PMD_UNIT_LEN];

	int		flags;
#define PMDF_WRITE	1
	unsigned int	ix_tl_x;
	unsigned int	ix_tl_y;
	unsigned int	ix_br_x;
	unsigned int	ix_br_y;
	unsigned int	ix_resolution;
	unsigned int	ix_content_period_from;
	unsigned int	ix_content_period_to;
	unsigned int	ix_target;
	unsigned int	ix_timeout;
} PN_PMD_HEADER;

typedef struct pn_pmd_node {
	PN_HEADER	h;
	GB_RECT		minrect;
	REAL1		resolution;
	GB_TIME		content_period_from;
	GB_TIME		content_period_to;
	unsigned int	timeout;
	unsigned int	md_fofs;
	unsigned short	category;
/*
	unsigned short	crd == 0 ;
*/
	unsigned short	target;
	L_CHAR		str[1];
} PN_PMD_NODE;

#define PN_PMD_NODE_S(x,y) ((int)&(((PN_PMD_NODE*)0)->str[(x)+(y)+2]))

typedef struct pn_pmd_md {
	PN_HEADER	h;
	unsigned int	next_fofs;

/*
	unsigned short	namespace == 0;
*/
	unsigned short	qualifier;
	unsigned short	inherit; /* integer of no */
	unsigned short	type;
	unsigned short	data;
	L_CHAR		str[1];
} PN_PMD_MD;

#define PN_PMD_MD_S(x,y,z,w) \
	((int)&(((PN_PMD_NODE*)0)->str[(x)+(y)+(z)+(w)+4]))

typedef struct pn_pmd_ofslist {
	PN_HEADER	h;
	unsigned int	fofs[1];
} PN_PMD_OFSLIST;

#define PN_PMD_OFSLIST_S(x) \
	((int)&(((PN_PMD_OFSLIST*)0)->fofs[x]))


/*******************************/
/* 
	Linear Section for pp
 */
/*******************************/

typedef struct code_index {
	unsigned int		fofs;
	GB_RECT			minrect;
} CODE_INDEX;


/*******************************/
/* 
	Routing Cache file
 */
/*******************************/

#define FAT_RTC_URL	0x201
#define FAT_RTC_TIMER	0x202

typedef struct pn_rt_cache_header {
	PN_HEADER	h;
	char		version[8];
#define RT_CACHE_VERSION	"0.1"
	unsigned int	url_tree;
	unsigned int	timer_tree;
	int		count;
	int		flags;
#define RTC_F_WRITE	0x00000001
} PN_RT_CACHE_HEADER;
#define PN_RT_CACHEHEADER_S	sizeof(PN_RT_CACHE_HEADER)


typedef struct pn_rt_cache_data {
	PN_HEADER	h;
	int		sts;
	unsigned int	modify;
	unsigned int	update;
} PN_RT_CACHE_DATA;

typedef struct pn_rt_cache_element {
	unsigned int	data;
	unsigned int	update;
	int		flags;
#define RTC_LF_TERMINAL	0x00000001
} PN_RT_CACHE_ELEMENT;

typedef struct pn_rt_cache_list {
	PN_HEADER	h;
	unsigned int	next;
} PN_RT_CACHE_LIST;
#define PN_RT_CACHE_LIST_S(x)	\
	(sizeof(PN_RT_CACHE_LIST) + sizeof(PN_RT_CACHE_ELEMENT)*(x))


/*******************************/
/* 
	Resource Cache file
 */
/*******************************/


typedef struct pn_rs_cache_header {
	PN_HEADER		h;
	char			version[8];
#define RS_CACHE_VERSION	"0.1"
	unsigned int		url_tree;
	unsigned int		timer_tree;
	int			count;
	int			flags;
} RN_RS_CACHE_HEADER;

/*******************************/


#define CACHE_MAX	10000000

#include	"avt.h"

typedef struct fa_ring {
	struct fa_ring *	next;
	struct fa_ring *	prev;
} FA_RING;

typedef struct fa_cache {
	struct fa_cache *	next;
	int			ref;
	char *			filename;
	AVT_NODE *		records;
} FA_CACHE;

typedef struct fac_header {
	FA_RING			r;
	FA_CACHE *		file;
	unsigned int		offset;
	PN_HEADER		h;
} FAC_HEADER;

#define SIZEOF_FAC(size)	\
	(((int)(&((FAC_HEADER*)0)->h))+(size))

typedef struct pdb_request {
	struct pdb_request *	next;
	unsigned int		fofs;
	void *			option;
} PDB_REQUEST;

typedef struct pdb {
	int		fid;
	int		flags;
#define PF_PDB_MASK	0x0000ffff
#define PF_CACHE	0x00000001
	unsigned int	fofs;
	PDB_REQUEST *	request;
	PDB_REQUEST *	next_request;
	FA_CACHE *	cache;
	char		data[DF_BUF];
	int		buf_ptr;
	int		buf_len;
	unsigned int	seek_ptr;
	void *		freelist_work;
} PDB;

PDB * open_pdb(char * filename,int oflags,int mode,int flags);
void close_pdb(PDB *);
void insert_request(PDB *,unsigned int fofs,void * option);
int delete_request(PDB * p,int (*func[])(),void*);
#define E_DR_NO_REQUEST	(-1)
#define E_DR_FILE_ACCESS (-2)
#define E_DR_SEGMENT_ACCESS (-3)
#define E_DR_UNSUPPORT_SEGMENT_TYPE (-4)

#ifndef OPEN_FILESPACE
PDB * open_filespace(char * filename,int oflags,int mode,int flags,...);
#endif
#define PF_USEFREELIST	0x80000000
unsigned int fs_raw_write(PDB * p,void * d,int flags);
#define FSF_ONLYHEADER	0x00000001
#define FSF_RESERVE_SP	0x00000002


#endif

