/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___DTREE_H___
#define ___DTREE_H___

#include	"favt.h"
#include	"long_char.h"

typedef struct dtree_node {
	L_CHAR			ch;
	unsigned int		tree;
	unsigned int		data;
} DTREE_NODE;


typedef struct dtree_trace_work {
	PDB * 			p;
	int 			(*func)();
	void *			w;
	int 			(*trace)();
	L_CHAR *		target;
} DTREE_TRACE_WORK;

void dtree_endian();
FAVT_ROOT * alloc_dtree(PDB * p,int type);
unsigned int search_dtree(int * sizep,FAVT_ROOT * r,L_CHAR * str,int perfect_flag);
int dtree_trace_from_small(FAVT_ROOT * r,int (*func)(),void * work);
int dtree_trace_from_large(FAVT_ROOT * r,int (*func)(),void * work);

#endif

