/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/

#include	"task.h"
#include	"lock_level.h"
#include	"memory_debug.h"
#include	"utils.h"
#include	"rcache.h"

SEM rcache_lock;
L_CHAR * rcache_dir_path;

int rcache_flush();
int rcache_exit_flag;
void rcache_exit_tick();

void
init_rcache()
{
	rcache_lock = new_lock(LL_RCACHE);
	int_handler = rcache_flush;
	new_tick(rcache_exit_tick,1,0);
	init_rt_cache();
}

int
rcache_flush()
{
	rcache_exit_flag = 1;
	return 0;
}

void
rcache_exit_tick()
{
	if ( rcache_exit_flag == 0 )
		return;
	printf("RCACHE INTERRUPT\n");
	disable_rcache();
	exit(0);
}

void
mk_path(L_CHAR * path)
{
L_CHAR * ptr, * buf;
L_CHAR ch;
char * p;
	buf = ll_copy_str(path,332);
	if ( buf[0] == '/' )
		ptr = &buf[1];
	else	ptr = buf;
	for ( ; *ptr ; ) {
		for ( ; *ptr && *ptr != '/' ; ptr ++ );
		ch = *ptr;
		*ptr = 0;
		p = n_string(std_cm,buf);
		u_mkdir(p,0755);
		*ptr = ch;
		if ( ch == 0 )
			break;
		ptr ++;
	}
}

void
set_rcache_dir_path(L_CHAR * main_path,L_CHAR * rcache_path)
{
L_CHAR * path;
int m_len,c_len;
int cpp;
	lock_task(rcache_lock);
ss_printf("set_rcache_dir(1)\n");
	if ( main_path ) {
		m_len = l_strlen(main_path);
		c_len = l_strlen(rcache_path);
		path = d_alloc((m_len + c_len + 3)*sizeof(L_CHAR),22);
		memcpy(path,main_path,m_len * sizeof(L_CHAR));
		if ( path[m_len-1] == '/' ) {
			cpp = m_len;
		}
		else {
			path[m_len] = '/';
			cpp = m_len + 1;
		}
		memcpy(&path[cpp],rcache_path,c_len * sizeof(L_CHAR));
		cpp += c_len;
		if ( path[cpp-1] == '/' )
			path[cpp] = 0;
		else {
			path[cpp] = '/';
			path[cpp+1] = 0;
		}
		if ( rcache_dir_path )
			d_f_ree(rcache_dir_path);
		rcache_dir_path = path;
		mk_path(path);
	}
	else {
		d_f_ree(rcache_dir_path);
		rcache_dir_path = 0;
	}
	unlock_task(rcache_lock,"set_rcache_dir_path");
}

L_CHAR *
get_rcache_file_name(char * name)
{
L_CHAR * ret;
int len,n_len;
L_CHAR * _name;
	if ( rcache_dir_path == 0 )
		return 0;
	_name = l_string(std_cm,name);
	len = l_strlen(rcache_dir_path);
	n_len = l_strlen(_name);
	ret = d_alloc((len + n_len + 1)*sizeof(L_CHAR),33);
	memcpy(ret,rcache_dir_path,len * sizeof(L_CHAR));
	memcpy(&ret[len],_name,(n_len + 1)* sizeof(L_CHAR));
	return ret;
}


int
rlock_rcache(RCACHE_BLK * b)
{
int ret;
	lock_task(rcache_lock);
	if ( b->tid == get_tid() && b->lock == 2 )
		goto loc;
	for ( ; b->lock ; ) {
		sleep_task((int)b,rcache_lock);
		lock_task(rcache_lock);
	}
loc:
	b->lock = 1;
	b->tid = get_tid();
	ret = 0;
end:
	unlock_task(rcache_lock,"rlock_rcache");
	return ret;
}

int
local_lock_rcache(RCACHE_BLK * b)
{
int ret;
	lock_task(rcache_lock);
	for ( ; b->lock ; ) {
		sleep_task((int)b,rcache_lock);
		lock_task(rcache_lock);
	}
	b->lock = 2;
	b->tid = get_tid();
	ret = 0;
end:
	unlock_task(rcache_lock,"rlock_rcache");
	return ret;
}

int
wlock_rcache(RCACHE_BLK * b)
{
int ret;
	lock_task(rcache_lock);
	if ( b->tid == get_tid() && b->lock == 2 )
		goto loc;
	for ( ; b->lock ; ) {
		sleep_task((int)b,rcache_lock);
		lock_task(rcache_lock);
	}
loc:
	b->lock = -1;
	b->tid = get_tid();
	ret = 0;
end:
	unlock_task(rcache_lock,"wlock_rcache");
	return ret;
}



int
unlock_rcache(RCACHE_BLK * b)
{
int ret;
	lock_task(rcache_lock);
	if ( b->lock > 0 ) {
		b->lock = 0;
	}
	else if ( b->lock < 0 ) {
		if ( b->tid != get_tid() )
			er_panic("unlock_rcache");
		b->lock = 0;
	}
	else	er_panic("unlock_rcache");
	b->tid = 0;
	wakeup_task((int)b);
	ret = 0;
end:
	unlock_task(rcache_lock,"rlock_rcache");
	return ret;
}


int
new_rcache_blk(RCACHE_BLK * b,char * name)
{
int ret;

	if ( b->err != RE_IDLE )
		goto end;
	if ( b->path )
		d_f_ree(b->path);
	b->path = get_rcache_file_name(name);
	if ( b->path == 0 ) {
		ret = -1;
		goto end;
	}
	b->err = RE_RUN;
	ret = 0;

end:
	return ret;
}




void
purge_rcache(L_CHAR * url)
{
	purge_rt_cache(url);
}

void
enable_rcache()
{
	enable_rt_cache();
}


void
disable_rcache()
{
	disable_rt_cache();
}


