/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#ifndef ___UTILS_H___
#define ___UTILS_H___

#include	"machine/include.h"
#include	"long_char.h"
#include	"xllisp.h"

#define UTC_00_00_00_01_01_2001	978307200

#define TFMT_UNIX	1
#define TFMT_W3C_DTF	2

typedef struct url {
	L_CHAR *		proto;
	L_CHAR *		server;
	int			port;
	L_CHAR *		db;
	L_CHAR *		resource;

	L_CHAR *		user;
	L_CHAR *		passwd;
} URL;


typedef struct thread_area_header {
	struct thread_area_header *	next;
	unsigned int			tid;
} THREAD_AREA_HEADER;

typedef struct thread_area {
	struct thread_area *	next;
	void			(*close_gc)();
	int			area_size;
	int			ent_size;
	THREAD_AREA_HEADER **	ent;
} THREAD_AREA;

typedef struct div_str {
	short		term;
#define DST_TERMINATE	0
#define DST_DATA	1
	char		type;
#define DST_STRING	0
#define DST_LIST	1
	char		flags;
#define DSF_DONTFREE	0
#define DSF_FREE	1
	union {
		L_CHAR *		str;
		struct div_str *	ds;
	}		d;
} DIV_STR;

typedef struct nested_lock {
	int		tid;
	int		cnt;
} NESTED_LOCK;

typedef struct _u_stat {
	unsigned int		us_atime;
	unsigned int		us_mtime;
	unsigned int		us_ctime;
} U_STAT;

int u_stat(char * path,U_STAT * buf);

void init_thread_area(THREAD_AREA * ta,THREAD_AREA * ta_param);
void * get_my_area(THREAD_AREA *);
void close_thread_area();
int scan_ta(THREAD_AREA * ta,int (*func)(),void * work);

char * copy_str(char *);
L_CHAR * ll_copy_str(L_CHAR *,int);
L_CHAR * nl_copy_str(CODE_METHOD *,char *);
char * ln_copy_str(CODE_METHOD *,L_CHAR*);
int get_url(URL *,L_CHAR *);
int get_url2(URL *,L_CHAR *,int);
int url_cmp(URL *,URL *);
void zero_url(URL *);
void free_url(URL *);
L_CHAR * get_url_str(URL *);
L_CHAR * get_url_str2(URL *);
L_CHAR * get_url_filepath(URL *);
int get_wkp(L_CHAR *);
char* get_proto_name(int port);
void set_buffer(void *);
char * get_preference_path();
char * get_peripheral_path();
int get_field(XL_SEXP * s,...);
int launch_proc(
	char * str,
	char ** argv,
	STREAM ** stp,
	char * close_flags,
	char * ret_str_parent,
	char * ret_str_children);
void divide_string(DIV_STR * str,L_CHAR * div);
void init_tick();
void new_tick(void (*func)(),int interval,int data);
void del_tick(void (*func)());
void del_tick_with_data(void (*func)(),int);
int get_xltime();
char * get_xltime_str(unsigned int t,int fmt);
int check_pid(int,char*);
L_CHAR * compose_url(L_CHAR * path1,L_CHAR * path2);
int stabilizer();
void exit_stabilizer(char);
int cmp_part(L_CHAR * target,L_CHAR * data);
L_CHAR * url_regulation(L_CHAR *);
char * which(char*);
char * xlwhich(char*);
L_CHAR * get_script(L_CHAR *);
void set_script_path(L_CHAR * script);
char * get_locale();
int u_mkdir(char*,int);
unsigned int get_mem_size();
int b_hostcmp(char *,int,char *, int);

void http_system(char *,int,char *);
struct dirent * u_readdir(DIR * dp);

extern char * command_arg;

void u_rm(char * ,int);
#define RMF_REC		0x00000001
#define RMF_FILE	0x00000002
#define RMF_DIR		0x00000004

#define E_DB_FORMAT		(-3)
#define E_NO_DATA		(-2)
#define E_TYPE_MISSMATCH	(-1)

#define C_CANCEL	3

NESTED_LOCK * new_nlock();
void nlock_task(NESTED_LOCK *);
void unnlock_task(NESTED_LOCK *);
void destroy_nlock(NESTED_LOCK*);

STREAM *
bl_new_connection(
	int * cerr,
	char * hostname,
	int ip,
	short port,
	int (*func)(),
	void * work);

void gcv_url(URL *);

#endif
