/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___HTTP_H___
#define ___HTTP_H___

#include	<stdio.h>
#include	"server.h"
#include	"task.h"

#define POLLING_TICK_INTERVAL	3
#define HTTP_SYSTEM_UP		120

#define HTTP_PATH_MAX	50

typedef struct http_element {
	struct http_element *	next;
	char *			data;
} HTTP_ELEMENT;

typedef struct http_env {
	ACCESS_KEY *		key;
	int			flags;
#define HEF_CLOSE		0x00000001
#define HEF_KEEP		0x00000002
	char *			path;
	int			port;
	char *			host;
	int			polcnt;
	void *			work;
	char *			hostpath;
} HTTP_ENV;

typedef struct get_tbl {
	char	path[HTTP_PATH_MAX];
	int	(*action)();
} GET_TBL;

#define POL_KILL		0
#define POL_IDLE		1
#define POL_URL			2

HTTP_ELEMENT * http_parser(HTTP_ENV *);
extern SEM http_lock;
extern char * current_page;

#endif
