/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef ___ASSOCIATE_H___
#define ___ASSOCIATE_H___

#include	"pdb.h"

#define FAT_ASSOC_INTEGER	0x100
#define FAT_ASSOC_STRING	0x102

#define ASSOC_KEY_NO		10

typedef struct acc_pn_assoc_header {
	ACC_HEADER		a;
	PN_ASSOC_HEADER		d;
} ACC_PN_ASSOC_HEADER;

typedef struct acc_pn_assoc_data {
	ACC_HEADER		a;
	PN_ASSOC_DATA		d;
} ACC_PN_ASSOC_DATA;


typedef struct acc_pn_file_header {
	ACC_HEADER		a;
	PN_FILE_HEADER		d;
} ACC_PN_FILE_HEADER;

typedef struct assoc_key {
	PDB *			p;
	ACC_PN_FILE_HEADER *	fheader;
	ACC_PN_ASSOC_HEADER *	assoc;
	int			assoc_len;
} ASSOC_KEY;

typedef struct assoc_integer {
	int			data;
	unsigned int		fofs;
} ASSOC_INTEGER;

typedef struct assoc_string_opt {
	int			flags;
	int			size;
} ASSOC_STRING_OPT;

int
open_associate(
	char * filename,
	int oflags,
	int mode,
	int flags,
	int type,
	char * encoding);
int insert_associate(int key,int index,void * from,XL_SEXP * data);
XL_SEXP * search_associate(int key,int index,void * from,void * opt);
int get_index(int key,short name);
int new_index(int key,short type,short name);
int get_index_type(int key,int index);
XL_SEXP * get_assoc_all(int key,int index);

#endif

