/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/



#include	"memory_debug.h"
#include	"gbview.h"
#include	"avt.h"


int not_time,hit_time;

int cmp_obj_code();


int
draw_object(
	OBJ * o,
	DRAW_WORK * dw)
{
int tt;
int ret;
tt = clock();
	if ( o->h.type >= OT_MAX )
		er_panic("draw_object(1)");
	if ( o->h.type < 0 )
		er_panic("draw_object(2)");
	if ( cross_rect_rect(&o->h.minrect,&dw->draw_rect) == 0 )
		return 0;
	if ( object_table[o->h.type][GBF_DRAW] == 0 )
		er_panic("draw_object(3)");
	ret = (*object_table[o->h.type][GBF_DRAW])
		(o,dw);
	return ret;
}

int
get_point_object(
	RESOURCE * r,
	OBJ * o,
	GET_POINT_WORK * w)
{
	if ( o->h.type >= OT_MAX )
		er_panic("draw_object(1)");
	if ( o->h.type < 0 )
		er_panic("draw_object(2)");
	if ( object_table[o->h.type][GBF_GET_POINT] == 0 )
		er_panic("draw_object(3)");
	return (*object_table[o->h.type][GBF_GET_POINT])
		(r,o,w);
}


int
free_object(RESOURCE * r,OBJ * o)
{
AVT_NODE * a1;
	a1 = avt_delete(&r->draw_gb.obj_code_tree,o,cmp_obj_code);
	if ( a1 == 0 )
		er_panic("free_object(0)");
	delete_rect_tree(&r->draw_gb.obj_rect_tree,o);
	d_f_ree(a1);
	touch_obj_mem(-sizeof(*a1));
	if ( o->h.type >= OT_MAX )
		er_panic("free_object(1)");
	if ( o->h.type < 0 )
		er_panic("free_object(2)");
	if ( object_table[o->h.type][GBF_FREE] == 0 )
		er_panic("free_object(3)");
	return (*object_table[o->h.type][GBF_FREE])(o);
}

void
free_object_list(RESOURCE * r)
{
OBJ * o;
	for ( ; r->draw_gb.obj_code_tree ; ) {
		o = r->draw_gb.obj_code_tree->data;
		free_object(r,o);
	}
}


int
select_object(OBJ * o,SELECT_WORK *sw)
{
	if ( o->h.type >= OT_MAX )
		er_panic("select_object(1)");
	if ( o->h.type < 0 )
		er_panic("select_object(2)");
	if ( object_table[o->h.type][GBF_SELECT] == 0 )
		er_panic("select_object(3)");
	return (*object_table[o->h.type][GBF_SELECT])(o,sw);
}


int
object_list(OBJ * o,XL_SEXP ** ret)
{
	if ( o->h.type >= OT_MAX )
		er_panic("object_list(1)");
	if ( o->h.type < 0 )
		er_panic("object_list(2)");
	if ( object_table[o->h.type][GBF_OLIST] == 0 )
		er_panic("object_list(3)");
	return (*object_table[o->h.type][GBF_OLIST])(o,ret);
}


XL_SEXP *
get_object_header(OBJ * o)
{
	if ( o->h.info_org )
		return List(
			List(get_symbol(l_string(std_cm,"id")),
				get_integer(o->h.code,0),
				-1),
			o->h.info_org,
			-1);
	else	return List(
			List(get_symbol(l_string(std_cm,"id")),
				get_integer(o->h.code,0),
				-1),
			List(get_symbol(l_string(std_cm,"information")),
				-1),
			-1);
}
