/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<math.h>
#include	<string.h>
#include	"xl.h"
#include	"gbparam.h"
#include	"gbview.h"
#include	"win_flame.h"


extern GBVIEW_ENV env;


void
load_task()
{
WIN_FLAME * wf;
int exe;
XL_INTERPRETER * xli;
void _wf_redraw_pri();
int wid;
void exit_task();

printf("winflame = %i\n",get_tid());
set_cpu_thr_type(30);
	for ( ; env.display == 0 ; )
		sleep_sec(1);

set_cpu_msg(1);

	xli = new_xl_interpreter();
set_cpu_msg(10);
	xli->a_type = XLA_SELF;
set_cpu_msg(11);
	setup_i(xli);
set_cpu_msg(12);

start:
/*
	printf("load task %i\n",get_tid());
*/
set_cpu_msg(2);

	wf = touch_wf();
/*
set_cpu_msg(3);

	printf("load task start %i\n",get_tid());
*/


retry:

/*
ss_printf("****************** winflame %i %ls %x\n",get_tid(),
       get_url_str2(&wf->draw->h.entry),wf->flags);
*/

set_cpu_msg(4);

	if ( wf->flags & WFF_FREE )
		goto end;

	switch ( win_flame_redraw(wf) ) {
	case 0:
		break;
	case 2:
		lock_task(env.wf_lock);
set_cpu_msg(5);
		if ( wf->flags & WFF_FREE ) {
			unlock_task(env.wf_lock,"load_task");
			goto end;
		}
		if ( _check_exit_flame() == 0 ) {
			unlock_task(env.wf_lock,"load_task");
			goto retry;
		}
		wid = wf->id;
		wakeup_task((int)exit_task);
		_win_unlock(wf);
set_cpu_msg(6);
		for ( ; _check_exit_flame() ; ) {
			sleep_task((int)_wf_redraw_pri,env.wf_lock);
			lock_task(env.wf_lock);
			if ( _get_wf_ptr(wid) != wf ) {
				unlock_task(env.wf_lock,"load_task");
				goto start;
			}
			if ( wf->flags & WFF_FREE ) {
				unlock_task(env.wf_lock,"load_task");
				goto start;
			}
		}
set_cpu_msg(7);
		if ( _get_wf_ptr(wid) != wf ) {
			unlock_task(env.wf_lock,"load_task");
			goto start;
		}
set_cpu_msg(8);
		if ( _win_lock(wf) < 0 ) {
			unlock_task(env.wf_lock,"load_task");
			goto start;
		}
set_cpu_msg(9);
		unlock_task(env.wf_lock,"load_task");
		goto retry;
	default:
		goto retry;
	}
set_cpu_msg(10);
/*
ss_printf("****************** spiral end %i %x\n",get_tid(),wf);
*/

end:
set_cpu_msg(11);


	win_unlock(wf);
set_cpu_msg(12);

	goto start;

}


void
exit_task()
{
WIN_FLAME * wf, * wf2;
XL_INTERPRETER * xli;
int fg;
void _wf_redraw_pri();

	xli = new_xl_interpreter();
	xli->a_type = XLA_SELF;
	setup_i(xli);

set_cpu_thr_type(13);

	for ( ; ; ) {
set_cpu_msg(1);
		lock_task(env.wf_lock);
	retry:
set_cpu_msg(2);
		fg = 0;
		for ( wf = env.flame ; wf ; ) {
set_cpu_msg(3);
			wf2 = wf->next;
			_win_wlock(wf);
			_ex_lock();
			if ( wf->flags & WFF_FREE ) {

printf("EXIT TASK\n");
set_cpu_msg(14);
				exit_win_flame(wf);
				wakeup_task((int)wf);
				wakeup_task((int)exit_task);
				wakeup_task((int)_wf_redraw_pri);
if ( env.flame == 0 )
printf("EXIT NO FLAME!!!\n");
set_cpu_msg(5);
				_ex_unlock();
				fg = 1;
			}
			else {
set_cpu_msg(6);
				_ex_unlock();
				_win_unlock(wf);
			}
set_cpu_msg(7);
			wf = wf2;
		}
set_cpu_msg(8);
		if ( fg )
			goto retry;
set_cpu_msg(9);
		sleep_task((int)exit_task,env.wf_lock);
	}
}

void
change_task()
{
WIN_FLAME * wf;
int wfid;

set_cpu_thr_type(14);

	for ( ; ; ) {
		wf_check_resource();
		for ( wfid = get_next_wfid(0) ; wfid ; 
				wfid = get_next_wfid(wfid) ) {

			lock_task(env.wf_lock);
			wf = _get_wf_ptr(wfid);
			if ( _win_wlock(wf) < 0 ) {
				unlock_task(env.wf_lock,"change_task");
				continue;
			}
			unlock_task(env.wf_lock,"change_task");
			ex_lock(); 

			switch ( (wf->flags&(WFF_POLY|WFF_PLOT|WFF_LUSTER)) ) {
			case 0:
			case WFF_PLOT:
				change_win_flame(wf,0,WFT_PLOT);
				change_win_flame(wf,0,WFT_STD);
			}
			ex_unlock();
			win_unlock(wf);
		}
		sleep_sec(1);
	}
}
