/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	<stdlib.h>
#include	<string.h>
#include	<Shlobj.h>
#include	"utils.h"
#include	"memory_debug.h"

static char * preference_path;
static char * peripheral_path;
char xlpconf[] = "pxlconf\\";
char gvperipheral[] = "peripheral\\";

char * command_arg;

char *
get_preference_path()
{
	if(preference_path)
		return preference_path;
	{
		int len, len2;
		LPITEMIDLIST pIDList;
		char pszPath[MAX_PATH+1];

		if(SUCCEEDED(SHGetSpecialFolderLocation(NULL, CSIDL_PERSONAL, &pIDList))){
			SHGetPathFromIDList(pIDList, pszPath);
			CoTaskMemFree(pIDList);
		}
		
		len = strlen(pszPath);
		len2 = strlen(xlpconf);
		
		preference_path = d_alloc(len+len2+2,363);
		strcpy(preference_path,pszPath);
		if ( preference_path[len-1] != '\\' ) {
			preference_path[len] = '\\';
			preference_path[len+1] = 0;
		}
		strcat(preference_path, xlpconf);
		return preference_path;
	}
}




char *
get_peripheral_path()
{
	if ( peripheral_path )
		return peripheral_path;
	{
		char pszAppFile[MAX_PATH+1];
		char pszAppPath[MAX_PATH+1];
		char *p;
		GetModuleFileName(GetModuleHandle(NULL), pszAppFile, MAX_PATH);
		p = strrchr(pszAppFile, '\\')+1;
		strncpy(pszAppPath, pszAppFile, p-pszAppFile);
		pszAppPath[p-pszAppFile] = '\0';
		strcat(pszAppPath, gvperipheral);
		/*
		peripheral_path = d_re_alloc(peripheral_path, strlen(pszAppPath) + 11);
		*/
		peripheral_path = d_alloc(strlen(pszAppPath) + 11, 1);
		strcpy(peripheral_path, pszAppPath);
	}
	return peripheral_path;
/*
char * h;
int len,len2;
char * per;
	if ( peripheral_path )
		return peripheral_path;
	h = getenv("GV_PERIPHERAL");
	if ( h ) {
		peripheral_path = copy_str(h);
		goto ok;
	}
	per = which(command_arg);
	if ( per == 0 ) {
		peripheral_path = copy_str("./");
		goto ok;
	}
	else {
		peripheral_path = per;
		goto ok;
	}
ok:
	peripheral_path = d_re_alloc(peripheral_path,
		strlen(peripheral_path)+strlen(gvperipheral)+10);
	len = strlen(peripheral_path);
	if ( peripheral_path[len-1] != '/' ) {
		peripheral_path[len] = '/';
		peripheral_path[len+1] = 0;
	}
	if ( strcmp(&peripheral_path[len-4],"bin/") == 0 )
		peripheral_path[len-4] = 0;
	h = &peripheral_path[strlen(peripheral_path)];
	strcpy(h,gvperipheral);
	return peripheral_path;
*/
}



