/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"xlerror.h"
#include	"xl.h"

XL_SEXP * xl_DefineEval();


void
init_DefineEval(XLISP_ENV * env)
{
XL_SEXP * func;
	set_env(env,l_string(std_cm,"DefineEval"),
		func=get_func_prim(xl_DefineEval,FO_NORMAL,0,4,4));
	set_env(env,l_string(std_cm,"DE"),
		func);
}

XL_SEXP *
xl_DefineEval(XLISP_ENV * env,XL_SEXP * s,XLISP_ENV *a,XL_SYM_FIELD * sf)
{
XL_SEXP * ev;
XL_SEXP * sym;
XL_SEXP * data;
XLISP_ENV * target_env;
XL_SEXP * _eval;
XL_SEXP * _err;
	ev = eval(env,get_el(s,1));
	switch ( get_type(ev) ) {
	case XLT_ERROR:
		return ev;
	case XLT_ENV:
		target_env = ev->env.data;
		break;
	case XLT_NULL:
		target_env = 0;
		break;
	default:
		_err = get_el(s,1);
		goto type_missmatch;
	}
	sym = get_el(s,2);
	switch ( get_type(sym) ) {
	case XLT_ERROR:
		return sym;
	case XLT_SYMBOL:
		break;
	default:
		_err = get_el(s,2);
		goto type_missmatch;
	}
	data = get_el(s,3);
	if ( get_type(data) == XLT_ERROR )
		return data;
	if ( target_env ) {
		_eval = eval(target_env,sym);
		if ( get_type(_eval) == XLT_ERROR ) {
			return eval(env,data);
		}
		else {
			return eval(env,_eval);
		}
	}
	else {
		set_env(env,sym->symbol.data,data);
		return 0;
	}
type_missmatch:
	return get_error(
		s->h.file,
		s->h.line,
		XLE_SEMANTICS_TYPE_MISSMATCH,
		l_string(std_cm,"DefineEval"),
		_err);
}


