/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#define STREAM_LIB

#include	"stream.h"
#include	"task.h"
#include	"s_buf.h"
#include	"utils.h"

extern SEM stream_lock;

void (*stream_gc)();

STREAM * stream_list;


void
_xx_s_open(STREAM * s,int mode,int stream_type,char * __f,int __l)
{
	s->h.mode = mode&0xf;
	s->h.stream_type = stream_type;
	s->h.cm = std_cm;
	s->h.cm_work = (*s->h.cm->open)();
	s->h.cr_cnt = 0;
	s->h.cr_mode = 0;
	s->h.wb_flags = 0;
	init_sbuf(&s->h.write_buf,SEM_NULL);
	s->h.next = stream_list;
	s->h.interval = INITIAL_INTERVAL;
	s->h.bytes_per_interval = 0;
	s->h.last_time = get_xltime();
	s->h.avg_thput = -1;
	s->h.usec_per_byte = -1;
	s->h.pushed = 0;
	s->h.pushed_flag = 0;
	s->h.thread = 0;
	s->h.create_file = __f;
	s->h.create_line = __l;
	s->h.create_time = get_xltime();
	s->h.check_ptr = &s->h;
	s->h.w_checksum = 0;
	s->h.write_tid = 0;
	s->h.write_in_time = 0;
	s->h.write_abort_type = 0;
	s->h.write_abort_interval = 0;
	new_u_history(&s->h.u_history);
	stream_list = s;
}

void
xx_s_open(STREAM * s,int stream_type,int mode,char * __f,int __l)
{
	lock_task(stream_lock);
	_xx_s_open(s,mode,stream_type,__f,__l);
	unlock_task(stream_lock,"xx_s_open");
}


int
s_stream_nos()
{
int ret;
STREAM * s;
	ret = 0;
	lock_task(stream_lock);
	for ( s = stream_list ; s ; s = s->h.next , ret ++ );
	unlock_task(stream_lock,"s_stream_nos");
	return ret;
}

int
_s_stream_nos()
{
int ret;
STREAM * s;
	ret = 0;
	for ( s = stream_list ; s ; s = s->h.next , ret ++ );
	return ret;
}



void
_s_insert_thread(STREAM * s,S_FILE_THREAD * t)
{
	t->tid = get_tid();
	t->next = s->h.thread;
	s->h.thread = t;
}

void
_s_delete_thread(STREAM * s,S_FILE_THREAD * t)
{
S_FILE_THREAD ** tp;

	for ( tp = &s->h.thread ; *tp ; tp = &(*tp)->next )
		if ( *tp == t ) {
			*tp = t->next;
			break;
		}
	if ( s->h.tbl == 0 )
		wakeup_task((int)&s->h.thread);
}

void
s_delete_thread(STREAM * s,S_FILE_THREAD * t)
{
	lock_task(stream_lock);
	_s_delete_thread(s,t);
	unlock_task(stream_lock,"s_delete_thread");
}


void
calc_checksum(STREAM * s,void * data,int len,int flags)
{
unsigned int sum;
unsigned char * ptr;
int _len;
	if ( s->h.tbl == 0 )
		return;
	if ( s->h.tbl->checksum == 0 )
		return;

	_len = len;
	sum = s->h.w_checksum;
	for ( ptr = data ; len > 0 ; len -- , ptr ++ ) {
		sum += *ptr;
	}
	s->h.w_checksum = sum;
	switch ( flags ) {
	case 0:
		set_u_history(&s->h.u_history,_len);
		break;
	case 1:
		set_u_history(&s->h.u_history,_len*100);
		break;
	case 2:
		set_u_history(&s->h.u_history,_len*1000);
		break;
	}
}

