/**********************************************************************
 
	Copyright (C) 2003 Hirohisa MORI <joshua@nichibun.ac.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#include	"change_endian.h"
#include	"pdb64.h"
#include	"favt64.h"


void
favt64_floating_endian(FLOATING_INDEX64 * ix,INTEGER64 len)
{
	change_endian_i(ix->fofs);
	change_endian_f(ix->d);
}

void
favt64_gb_time_endian(GB_TIME_INDEX64 * ix,INTEGER64 len)
{
	change_endian(ix->fofs);
	change_endian_gb_time(&ix->d);
}


void
favt64_string_endian(STRING_INDEX64 * ix,INTEGER64 len)
{
int i;
	change_endian(ix->fofs);
	len = (len - sizeof(ix->fofs))/sizeof(L_CHAR);
	for ( i = 0 ; i < len ; i ++ ) {
		change_endian_i(ix->d[i]);
	}
}

void
favt64_timeout_endian(TIMEOUT_INDEX64 * ix,INTEGER64 len)
{
	change_endian_i(ix->fofs);
	change_endian_i(ix->timeout);
}


void
change_endian_favt64_root(PN64_FAVT_ROOT * r)
{
	change_endian_header64(&r->h);
	change_endian(r->type);
	change_endian(r->node);
}


void
change_endian_favt64_node(PN64_FAVT_NODE * n)
{
	change_endian_header64(&n->h);
	change_endian(n->small);
	change_endian(n->large);
	change_endian(n->level);
}


void (*change_endian_favt64_table_to_host[])() = {
	0,
	change_endian_favt64_root,
	change_endian_favt64_node
};





