/**********************************************************************
 
	Copyright (C) 2004 Tomohito Nakajima <nakajima@zeta.co.jp>
 
	This program is free software; you can redistribute it 
	and/or modify it under the terms of the GLOBALBASE 
	Library General Public License (G-LGPL) as published by 

	http://www.globalbase.org/
 
	This program is distributed in the hope that it will be 
	useful, but WITHOUT ANY WARRANTY; without even the 
	implied warranty of MERCHANTABILITY or FITNESS FOR A 
	PARTICULAR PURPOSE.

**********************************************************************/


#ifndef CSVPARSER___
#define CSVPARSER___

#include "stream.h"

typedef int BOOL;

#ifndef TRUE
#define TRUE (1)
#endif

#ifndef FALSE
#define FALSE (0)
#endif

typedef struct csv_cell{
	struct csv_cell *next;
	unsigned char *value;
}CSV_CELL;

typedef struct csv_record{
	struct csv_cell *head;
	struct csv_cell *tail;
}CSV_RECORD;

typedef struct {
	STREAM *input_stream;
	CSV_RECORD record;
	
	CSV_CELL *free_cells;
	
	/* buffer for 1 line */
	char *line_buff;
	int line_buff_size;
	int line_buff_index;
	
	/* buffer for 1 token */
	char *token_buff;
	int token_buff_size;
		
	int token_index;
	int unget_flag;
	char ungetc;
	BOOL is_eof;
}CSV_PARSER;

BOOL csv_parser_is_eof(CSV_PARSER *parser);

CSV_PARSER *csv_parser_new(STREAM *input_stream);
void csv_parser_delete(CSV_PARSER *parser);
CSV_RECORD *csv_parser_get_record(CSV_PARSER *parser);

#endif
